/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.blockentity;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.block.AdvancedComposterBlock;
import top.ribs.scguns.init.ModBlockEntities;
import top.ribs.scguns.init.ModTags;

public class AdvancedComposterBlockEntity
extends BlockEntity
implements WorldlyContainer {
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT_START = 1;
    private static final int OUTPUT_SLOT_COUNT = 3;
    private static final int TOTAL_SLOTS = 4;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{1, 2, 3};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0};
    private static final int MAX_COMPOST_TIME = 300;
    private int compostTime = 0;
    private boolean isComposting = false;

    public AdvancedComposterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ADVANCED_COMPOSTER.get(), pos, state);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.f_46443_ && (Integer)state.m_61143_((Property)AdvancedComposterBlock.LEVEL) == 7 && this.isComposting) {
            ++this.compostTime;
            if (this.compostTime >= 300) {
                this.completeComposting(level, pos, state);
            }
            this.m_6596_();
        }
    }

    public void startComposting() {
        if (!this.isComposting) {
            this.compostTime = 0;
            this.isComposting = true;
            this.m_6596_();
        }
    }

    private void completeComposting(Level level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AdvancedComposterBlock.LEVEL, (Comparable)Integer.valueOf(8)), 3);
        level.m_5594_(null, pos, SoundEvents.f_11766_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.isComposting = false;
        this.createOutputItems();
        this.m_6596_();
    }

    private void createOutputItems() {
        ArrayList possibleDrops = new ArrayList();
        Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(ModTags.Items.COMPOST_DROPS).forEach(possibleDrops::add);
        if (possibleDrops.isEmpty()) {
            return;
        }
        Random random = new Random();
        int totalItems = random.nextInt(3) + 1;
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (int i = 0; i < totalItems; ++i) {
            Item item = (Item)possibleDrops.get(random.nextInt(possibleDrops.size()));
            output.add(new ItemStack((ItemLike)item, 1));
        }
        for (int slot = 1; slot < 4 && !output.isEmpty(); ++slot) {
            if (!((ItemStack)this.items.get(slot)).m_41619_()) continue;
            this.items.set(slot, (Object)((ItemStack)output.remove(0)));
        }
        this.m_6596_();
    }

    public boolean extractOneItem(Player player) {
        for (int slot = 1; slot < 4; ++slot) {
            ItemStack stack = this.m_7407_(slot, 1);
            if (stack.m_41619_()) continue;
            if (player != null) {
                player.m_150109_().m_36054_(stack);
            } else {
                assert (this.f_58857_ != null);
                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_.m_7494_(), (ItemStack)stack);
            }
            this.m_6596_();
            return true;
        }
        return false;
    }

    public int getVisualLevel() {
        if (this.isOutputEmpty()) {
            return 0;
        }
        int filledSlots = (int)IntStream.range(1, 4).filter(slot -> !((ItemStack)this.items.get(slot)).m_41619_()).count();
        return Math.max(8, 11 - filledSlots);
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = ContainerHelper.m_18969_(this.items, (int)index, (int)count);
        if (!stack.m_41619_() && index >= 1) {
            this.m_6596_();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)AdvancedComposterBlock.LEVEL, (Comparable)Integer.valueOf(this.getVisualLevel())), 3);
            }
        }
        return stack;
    }

    public boolean isOutputEmpty() {
        for (int slot = 1; slot < 4; ++slot) {
            if (((ItemStack)this.items.get(slot)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public int m_6643_() {
        return 4;
    }

    public boolean m_7983_() {
        for (ItemStack item : this.items) {
            if (item.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (index == 0 && !stack.m_41619_()) {
            this.tryCompostItem(stack);
        }
        this.m_6596_();
    }

    private void tryCompostItem(ItemStack stack) {
        AdvancedComposterBlock composterBlock;
        Block block;
        BlockState state = this.m_58900_();
        int currentLevel = (Integer)state.m_61143_((Property)AdvancedComposterBlock.LEVEL);
        if (currentLevel < 7 && (block = state.m_60734_()) instanceof AdvancedComposterBlock && (composterBlock = (AdvancedComposterBlock)block).isCompostable(stack)) {
            BlockState newState = composterBlock.addItem(null, state, this.f_58857_, this.f_58858_, stack);
            this.f_58857_.m_7731_(this.f_58858_, newState, 3);
            stack.m_41774_(1);
            composterBlock.playComposterEffects(this.f_58857_, this.f_58858_, newState);
        }
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return side == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int index, ItemStack itemStack, @Nullable Direction direction) {
        return index == 0 && this.m_7013_(index, itemStack) && (Integer)this.m_58900_().m_61143_((Property)AdvancedComposterBlock.LEVEL) < 7;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index >= 1 && index < 4 && direction == Direction.DOWN && !stack.m_41619_();
    }

    public boolean m_7013_(int index, ItemStack stack) {
        AdvancedComposterBlock composterBlock;
        Block block;
        return index == 0 && (block = this.m_58900_().m_60734_()) instanceof AdvancedComposterBlock && (composterBlock = (AdvancedComposterBlock)block).isCompostable(stack);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.compostTime = nbt.m_128451_("CompostTime");
        this.isComposting = nbt.m_128471_("IsComposting");
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("CompostTime", this.compostTime);
        nbt.m_128379_("IsComposting", this.isComposting);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
    }

    public void drops() {
        for (ItemStack item : this.items) {
            assert (this.f_58857_ != null);
            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)item);
        }
    }
}

