/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.blockentity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.init.ModBlockEntities;

public class MobTrapBlockEntity
extends BlockEntity {
    private final List<EntityType<?>> storedMobs = new ArrayList();
    private static final int MAX_MOBS = 20;
    private final int radius;
    private final int heightRadius;
    private int tickCounter = 0;

    public MobTrapBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.MOB_TRAP.get(), pPos, pBlockState);
        this.radius = 10;
        this.heightRadius = 3;
    }

    public boolean addMob(EntityType<?> mobType) {
        if (this.storedMobs.size() < 20) {
            this.storedMobs.add(mobType);
            this.m_6596_();
            return true;
        }
        return false;
    }

    public void releaseMobs(ServerLevel level, BlockPos pos) {
        if (!this.storedMobs.isEmpty()) {
            for (EntityType<?> mob : this.storedMobs) {
                Entity entity = mob.m_20615_((Level)level);
                if (entity == null) continue;
                entity.m_7678_((double)pos.m_123341_() + level.f_46441_.m_188500_(), (double)pos.m_123342_(), (double)pos.m_123343_() + level.f_46441_.m_188500_(), level.f_46441_.m_188501_() * 360.0f, 0.0f);
                level.m_7967_(entity);
                for (int i = 0; i < 20; ++i) {
                    level.m_8767_((ParticleOptions)ParticleTypes.f_175834_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1, 0.1, 0.1, 0.1, 0.02);
                }
            }
            this.storedMobs.clear();
            this.m_6596_();
            level.m_46961_(pos, true);
        }
    }

    public List<EntityType<?>> getStoredMobs() {
        return this.storedMobs;
    }

    public void serverTick(Level level, BlockPos pos) {
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ++this.tickCounter;
            if (this.tickCounter >= 20) {
                this.tickCounter = 0;
                AABB detectionBox = new AABB((double)(pos.m_123341_() - this.radius), (double)(pos.m_123342_() - this.heightRadius), (double)(pos.m_123343_() - this.radius), (double)(pos.m_123341_() + this.radius), (double)(pos.m_123342_() + this.heightRadius), (double)(pos.m_123343_() + this.radius));
                List players = serverLevel.m_6443_(Player.class, detectionBox, player -> !player.m_7500_() && !player.m_5833_());
                if (!players.isEmpty()) {
                    this.releaseMobs(serverLevel, pos);
                }
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.storedMobs.clear();
        ListTag mobList = tag.m_128437_("StoredMobs", 8);
        for (int i = 0; i < mobList.size(); ++i) {
            String mobId = mobList.m_128778_(i);
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(mobId));
            if (entityType == null) continue;
            this.storedMobs.add(entityType);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag mobList = new ListTag();
        for (EntityType<?> mob : this.storedMobs) {
            mobList.add((Object)StringTag.m_129297_((String)ForgeRegistries.ENTITY_TYPES.getKey(mob).toString()));
        }
        tag.m_128365_("StoredMobs", (Tag)mobList);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }
}

