/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.blockentity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.block.PoweredMaceratorBlock;
import top.ribs.scguns.client.screen.MaceratorRecipe;
import top.ribs.scguns.client.screen.PoweredMaceratorMenu;
import top.ribs.scguns.init.ModBlockEntities;

public class PoweredMaceratorBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            PoweredMaceratorBlockEntity.this.m_6596_();
            if (!PoweredMaceratorBlockEntity.this.f_58857_.m_5776_()) {
                PoweredMaceratorBlockEntity.this.f_58857_.m_7260_(PoweredMaceratorBlockEntity.this.m_58899_(), PoweredMaceratorBlockEntity.this.m_58900_(), PoweredMaceratorBlockEntity.this.m_58900_(), 3);
                if (PoweredMaceratorBlockEntity.this.isInputSlot(slot) && !PoweredMaceratorBlockEntity.this.isRecipeValid()) {
                    PoweredMaceratorBlockEntity.this.resetProgress();
                }
            }
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final ContainerData data;
    private int progress = 0;
    private int maxProgress = 100;
    private final EnergyStorage energyStorage = new EnergyStorage(16000){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = super.receiveEnergy(maxReceive, simulate);
            if (!simulate && received > 0) {
                PoweredMaceratorBlockEntity.this.m_6596_();
                PoweredMaceratorBlockEntity.this.sync();
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = super.extractEnergy(maxExtract, simulate);
            if (!simulate && extracted > 0) {
                PoweredMaceratorBlockEntity.this.m_6596_();
                PoweredMaceratorBlockEntity.this.sync();
            }
            return extracted;
        }
    };
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    public static final int FIRST_INPUT_SLOT = 0;
    public static final int LAST_INPUT_SLOT = 3;
    public static final int OUTPUT_SLOT = 4;
    private static final float WHEEL_ROTATION_SPEED = 20.0f;

    private boolean isInputSlot(int slot) {
        return slot >= 0 && slot <= 3;
    }

    public PoweredMaceratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.POWERED_MACERATOR.get(), pos, state);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                switch (index) {
                    case 0: {
                        return PoweredMaceratorBlockEntity.this.progress;
                    }
                    case 1: {
                        return PoweredMaceratorBlockEntity.this.maxProgress;
                    }
                    case 2: {
                        return PoweredMaceratorBlockEntity.this.energyStorage.getEnergyStored();
                    }
                    case 3: {
                        return PoweredMaceratorBlockEntity.this.energyStorage.getMaxEnergyStored();
                    }
                }
                return 0;
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        PoweredMaceratorBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        PoweredMaceratorBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.powered_macerator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new PoweredMaceratorMenu(id, inv, this, this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (side == Direction.DOWN) {
                return LazyOptional.of(() -> new OutputItemHandler(this.itemHandler)).cast();
            }
            return LazyOptional.of(() -> new InputItemHandler(this.itemHandler)).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("powered_macerator.progress", this.progress);
        tag.m_128365_("Energy", this.energyStorage.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.progress = tag.m_128451_("powered_macerator.progress");
        this.energyStorage.deserializeNBT(tag.m_128423_("Energy"));
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PoweredMaceratorBlockEntity blockEntity) {
        boolean wasLit = (Boolean)state.m_61143_((Property)PoweredMaceratorBlock.LIT);
        boolean isLit = false;
        if (!level.f_46443_) {
            boolean hasValidRecipe = blockEntity.hasRecipe();
            ItemStack resultItem = blockEntity.getRecipeResult();
            if (hasValidRecipe && blockEntity.hasEnoughEnergy(50) && blockEntity.hasSpaceForOutput(resultItem)) {
                isLit = true;
                ++blockEntity.progress;
                blockEntity.consumeEnergy(50);
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.craftItem();
                    blockEntity.resetProgress();
                }
            } else if (blockEntity.progress > 0) {
                blockEntity.resetProgress();
            }
            if (wasLit != isLit) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)PoweredMaceratorBlock.LIT, (Comparable)Boolean.valueOf(isLit)), 3);
            }
        }
    }

    private ItemStack getRecipeResult() {
        SimpleContainer inventory = new SimpleContainer(4);
        for (int i = 0; i <= 3; ++i) {
            inventory.m_6836_(i - 0, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Optional match = this.f_58857_.m_7465_().m_44015_((RecipeType)MaceratorRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
        return match.map(recipe -> recipe.m_8043_(this.f_58857_.m_9598_())).orElse(ItemStack.f_41583_);
    }

    private boolean hasSpaceForOutput(ItemStack output) {
        ItemStack currentOutput = this.itemHandler.getStackInSlot(4);
        return currentOutput.m_41619_() || currentOutput.m_41720_() == output.m_41720_() && currentOutput.m_41613_() + output.m_41613_() <= currentOutput.m_41741_();
    }

    private boolean hasRecipe() {
        SimpleContainer inventory = new SimpleContainer(4);
        for (int i = 0; i <= 3; ++i) {
            inventory.m_6836_(i - 0, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Optional match = this.f_58857_.m_7465_().m_44015_((RecipeType)MaceratorRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
        return match.isPresent();
    }

    private void craftItem() {
        SimpleContainer inventory = new SimpleContainer(4);
        for (int i = 0; i <= 3; ++i) {
            inventory.m_6836_(i - 0, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Optional match = this.f_58857_.m_7465_().m_44015_((RecipeType)MaceratorRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
        if (match.isPresent()) {
            MaceratorRecipe recipe = (MaceratorRecipe)match.get();
            ItemStack resultItem = recipe.m_8043_(this.f_58857_.m_9598_());
            ItemStack outputStack = this.itemHandler.getStackInSlot(4);
            if (outputStack.m_41619_() || outputStack.m_41720_() == resultItem.m_41720_() && outputStack.m_41613_() + resultItem.m_41613_() <= outputStack.m_41741_()) {
                for (int i = 0; i <= 3; ++i) {
                    this.itemHandler.extractItem(i, 1, false);
                }
                if (outputStack.m_41619_()) {
                    this.itemHandler.setStackInSlot(4, resultItem.m_41777_());
                } else {
                    outputStack.m_41769_(resultItem.m_41613_());
                }
            }
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean isRecipeValid() {
        SimpleContainer inventory = new SimpleContainer(4);
        for (int i = 0; i <= 3; ++i) {
            inventory.m_6836_(i - 0, this.itemHandler.getStackInSlot(i));
        }
        Optional<MaceratorRecipe> currentRecipe = this.getCurrentRecipe();
        if (currentRecipe.isPresent()) {
            MaceratorRecipe recipe = currentRecipe.get();
            return recipe.matches(inventory, this.f_58857_);
        }
        return false;
    }

    private Optional<MaceratorRecipe> getCurrentRecipe() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        RecipeManager recipeManager = this.f_58857_.m_7465_();
        SimpleContainer inventory = new SimpleContainer(4);
        for (int i = 0; i <= 3; ++i) {
            inventory.m_6836_(i - 0, this.itemHandler.getStackInSlot(i));
        }
        return recipeManager.m_44013_((RecipeType)MaceratorRecipe.Type.INSTANCE).stream().filter(recipe -> recipe.matches(inventory, this.f_58857_)).findFirst();
    }

    private boolean hasEnoughEnergy(int amount) {
        return this.energyStorage.getEnergyStored() >= amount;
    }

    public void consumeEnergy(int amount) {
        this.energyStorage.extractEnergy(amount, false);
        this.m_6596_();
        this.sync();
    }

    public void addEnergy(int amount) {
        this.energyStorage.receiveEnergy(amount, false);
        this.m_6596_();
        this.sync();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    private void sync() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public float getWheelRotation(float partialTicks) {
        assert (this.f_58857_ != null);
        return ((float)this.f_58857_.m_46467_() + partialTicks) * 20.0f % 360.0f;
    }

    private record InputItemHandler(ItemStackHandler itemHandler) implements IItemHandlerModifiable
    {
        public void setStackInSlot(int slot, ItemStack stack) {
            if (slot >= 0 && slot <= 3) {
                this.itemHandler.setStackInSlot(slot, stack);
            }
        }

        public int getSlots() {
            return 4;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot >= 0 && slot < this.getSlots()) {
                return this.itemHandler.getStackInSlot(0 + slot);
            }
            return ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            int actualSlot;
            ItemStack result;
            if (slot >= 0 && slot < this.getSlots() && !(result = this.itemHandler.insertItem(actualSlot = 0 + slot, stack, simulate)).equals(stack)) {
                return result;
            }
            return this.insertIntoNextAvailableSlot(stack, simulate);
        }

        private ItemStack insertIntoNextAvailableSlot(ItemStack stack, boolean simulate) {
            ItemStack existingStack;
            int i;
            for (i = 0; i <= 3; ++i) {
                ItemStack result;
                existingStack = this.itemHandler.getStackInSlot(i);
                if (existingStack.m_41619_() || !ItemStack.m_41656_((ItemStack)existingStack, (ItemStack)stack) || (result = this.itemHandler.insertItem(i, stack, simulate)).equals(stack)) continue;
                return result;
            }
            for (i = 0; i <= 3; ++i) {
                existingStack = this.itemHandler.getStackInSlot(i);
                if (!existingStack.m_41619_()) continue;
                return this.itemHandler.insertItem(i, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            if (slot >= 0 && slot < this.getSlots()) {
                return this.itemHandler.getSlotLimit(0 + slot);
            }
            return 0;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot >= 0 && slot < this.getSlots();
        }
    }

    private record OutputItemHandler(ItemStackHandler itemHandler) implements IItemHandlerModifiable
    {
        public void setStackInSlot(int slot, ItemStack stack) {
            this.itemHandler.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.itemHandler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.itemHandler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 4) {
                return this.itemHandler.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    }
}

