/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.blockentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.block.VentBlock;
import top.ribs.scguns.block.VentCollectorBlock;
import top.ribs.scguns.client.screen.VentCollectorMenu;
import top.ribs.scguns.common.VentCollectorConfig;
import top.ribs.scguns.common.VentManager;
import top.ribs.scguns.init.ModBlockEntities;

public class VentCollectorBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final ResourceLocation DEFAULT_CONFIG_ID = new ResourceLocation("scguns", "vent_collector");
    private int pushCooldown = 0;
    private int filterProcessCooldown = 0;
    private final ItemStackHandler itemHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            VentCollectorBlockEntity.this.m_6596_();
            if (slot == 0) {
                VentCollectorBlockEntity.this.processFilterItem();
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return VentCollectorBlockEntity.this.isValidFilterItem(stack);
            }
            return slot > 0;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot == 0) {
                return super.insertItem(slot, stack, simulate);
            }
            if (slot > 0) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    private final LazyOptional<IItemHandler> itemHandlerOptional = LazyOptional.of(() -> this.itemHandler);
    private int productionCounter = 0;
    private int currentTickInterval = 100;
    private int filterCharge = 0;
    private final Random random = new Random();
    private VentCollectorConfig config;
    private final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return index == 0 ? VentCollectorBlockEntity.this.filterCharge : 0;
        }

        public void m_8050_(int index, int value) {
            if (index == 0) {
                VentCollectorBlockEntity.this.filterCharge = value;
            }
        }

        public int m_6499_() {
            return 1;
        }
    };

    public VentCollectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.VENT_COLLECTOR.get(), pos, state);
        this.reloadConfig();
    }

    public void reloadConfig() {
        this.config = VentManager.getVentCollectorConfig(DEFAULT_CONFIG_ID);
        if (this.config == null) {
            this.config = new VentCollectorConfig();
        }
    }

    public boolean isValidFilterItem(ItemStack stack) {
        if (this.config == null) {
            return false;
        }
        for (VentCollectorConfig.Filters.FilterItem filterItem : this.config.getFilters().getFilterItems()) {
            ResourceLocation itemLocation;
            Item item;
            ResourceLocation tagLocation;
            if (!(filterItem.isTag() ? stack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)(tagLocation = filterItem.getIdentifier()))) : (item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation = filterItem.getIdentifier())) != null && stack.m_150930_(item))) continue;
            return true;
        }
        return false;
    }

    public int getFilterCharge() {
        return this.filterCharge;
    }

    public int getMaxFilterCharge() {
        if (this.config == null) {
            return 64;
        }
        return this.config.getFilters().getMaxCharge();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, VentCollectorBlockEntity blockEntity) {
        if (!level.f_46443_) {
            BlockState belowState = level.m_8055_(pos.m_7495_());
            Block block = belowState.m_60734_();
            if (!(block instanceof VentBlock)) {
                return;
            }
            VentBlock ventBlock = (VentBlock)block;
            boolean isActive = (Boolean)belowState.m_61143_((Property)VentBlock.ACTIVE);
            if (!isActive) {
                return;
            }
            if (blockEntity.filterCharge <= 0) {
                return;
            }
            int ventPower = (Integer)belowState.m_61143_((Property)VentBlock.VENT_POWER);
            float speedMultiplier = blockEntity.getSpeedMultiplier(ventPower);
            blockEntity.productionCounter += (int)speedMultiplier;
            if (blockEntity.productionCounter >= blockEntity.currentTickInterval) {
                blockEntity.productionCounter = 0;
                blockEntity.currentTickInterval = blockEntity.calculateNextTickInterval(ventBlock);
                if (!ventBlock.shouldProduce(level.f_46441_)) {
                    blockEntity.m_6596_();
                    level.m_7260_(pos, state, state, 3);
                    return;
                }
                ItemStack producedItem = ventBlock.selectRandomOutput(level.f_46441_);
                if (producedItem.m_41619_()) {
                    return;
                }
                boolean produced = blockEntity.insertProducedItem(producedItem);
                if (produced && blockEntity.shouldConsumeFilter()) {
                    --blockEntity.filterCharge;
                }
                blockEntity.m_6596_();
                level.m_7260_(pos, state, state, 3);
            }
            if (blockEntity.filterProcessCooldown > 0) {
                --blockEntity.filterProcessCooldown;
            } else {
                blockEntity.processFilterItem();
                blockEntity.filterProcessCooldown = blockEntity.getFilterProcessCooldown();
            }
            if (blockEntity.pushCooldown > 0) {
                --blockEntity.pushCooldown;
            } else {
                blockEntity.pushItemsToAdjacentInventories(level, pos);
                blockEntity.pushCooldown = blockEntity.getPushCooldown();
            }
        }
    }

    private float getSpeedMultiplier(int ventPower) {
        if (this.config == null) {
            return 1.0f + (float)(ventPower - 1) * 0.35f;
        }
        float multiplier = this.config.getProcessing().getPowerSpeedMultiplier();
        return 1.0f + (float)(ventPower - 1) * multiplier;
    }

    private boolean shouldConsumeFilter() {
        if (this.config == null) {
            return this.random.nextFloat() < 0.5f;
        }
        return this.random.nextFloat() < this.config.getFilters().getConsumptionChance();
    }

    private int getFilterProcessCooldown() {
        if (this.config == null) {
            return 2;
        }
        return this.config.getFilters().getProcessCooldown();
    }

    private int getPushCooldown() {
        if (this.config == null) {
            return 5;
        }
        return this.config.getProcessing().getPushCooldown();
    }

    private int calculateNextTickInterval(VentBlock ventBlock) {
        if (ventBlock.config == null) {
            ventBlock.reloadConfig();
            if (ventBlock.config == null) {
                return 100;
            }
        }
        return ventBlock.config.getPower().getBaseTickInterval() + this.random.nextInt(ventBlock.config.getPower().getTickWiggleRoom());
    }

    private boolean insertProducedItem(ItemStack producedItem) {
        for (int i = 1; i <= 3; ++i) {
            ItemStack remaining = this.itemHandler.insertItem(i, producedItem, false);
            if (!remaining.m_41619_()) continue;
            return true;
        }
        return false;
    }

    private void processFilterItem() {
        ItemStack filterStack = this.itemHandler.getStackInSlot(0);
        if (filterStack.m_41619_() || this.config == null) {
            return;
        }
        int maxCharge = this.config.getFilters().getMaxCharge();
        if (this.filterCharge >= maxCharge) {
            return;
        }
        for (VentCollectorConfig.Filters.FilterItem filterItem : this.config.getFilters().getFilterItems()) {
            int chargeToAdd;
            int chargeNeeded;
            boolean matches = false;
            if (filterItem.isTag()) {
                ResourceLocation tagLocation = filterItem.getIdentifier();
                matches = filterStack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagLocation));
            } else {
                ResourceLocation itemLocation = filterItem.getIdentifier();
                Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
                boolean bl = matches = item != null && filterStack.m_150930_(item);
            }
            if (!matches || (chargeNeeded = maxCharge - this.filterCharge) < (chargeToAdd = filterItem.getChargeAmount())) continue;
            this.filterCharge += chargeToAdd;
            filterStack.m_41774_(1);
            this.m_6596_();
            return;
        }
    }

    private void pushItemsToAdjacentInventories(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (!(state.m_60734_() instanceof VentCollectorBlock)) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)VentCollectorBlock.FACING);
        boolean isConnected = (Boolean)state.m_61143_((Property)VentCollectorBlock.ATTACHED);
        if (!isConnected) {
            return;
        }
        BlockPos adjacentPos = pos.m_121945_(facing);
        BlockEntity adjacentEntity = level.m_7702_(adjacentPos);
        if (adjacentEntity != null) {
            IItemHandler adjacentHandler = (IItemHandler)adjacentEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, facing.m_122424_()).orElse(null);
            for (int i = 1; i <= 3; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemStack singleItem = stack.m_41777_();
                singleItem.m_41764_(1);
                ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)adjacentHandler, (ItemStack)singleItem, (boolean)false);
                if (!remaining.m_41619_()) continue;
                this.itemHandler.extractItem(i, 1, false);
                this.m_6596_();
                return;
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerOptional.invalidate();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.scguns.vent_collector");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new VentCollectorMenu(windowId, playerInventory, this, this.data);
    }

    public ContainerData getData() {
        return this.data;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("FilterCharge", this.filterCharge);
        tag.m_128405_("PushCooldown", this.pushCooldown);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.filterCharge = tag.m_128451_("FilterCharge");
        this.pushCooldown = tag.m_128451_("PushCooldown");
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }
}

