/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.handler;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.ribs.scguns.Config;
import top.ribs.scguns.ScorchedGuns;
import top.ribs.scguns.client.KeyBinds;
import top.ribs.scguns.client.handler.ControllerHandler;
import top.ribs.scguns.client.util.PropertyHelper;
import top.ribs.scguns.common.GripType;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.ReloadType;
import top.ribs.scguns.compat.PlayerReviveHelper;
import top.ribs.scguns.debug.Debug;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.animated.AnimatedGunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.C2SMessageAim;
import top.ribs.scguns.util.GunEnchantmentHelper;
import top.ribs.scguns.util.GunModifierHelper;

public class AimingHandler {
    private static AimingHandler instance;
    private static final double MAX_AIM_PROGRESS = 5.0;
    private final AimTracker localTracker = new AimTracker();
    private final Map<Player, AimTracker> aimingMap = new WeakHashMap<Player, AimTracker>();
    private double normalisedAdsProgress;
    public boolean aiming = false;
    private boolean wasKeyPressed = false;

    public static AimingHandler get() {
        if (instance == null) {
            instance = new AimingHandler();
        }
        return instance;
    }

    private AimingHandler() {
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        AimTracker tracker = this.getAimTracker(player);
        if (tracker != null) {
            tracker.handleAiming(player, player.m_21120_(InteractionHand.MAIN_HAND));
            if (!tracker.isAiming()) {
                this.aimingMap.remove(player);
            }
        }
    }

    @Nullable
    private AimTracker getAimTracker(Player player) {
        if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue() && !this.aimingMap.containsKey(player)) {
            this.aimingMap.put(player, new AimTracker());
        }
        return this.aimingMap.get(player);
    }

    public float getAimProgress(Player player, float partialTicks) {
        if (player.m_7578_()) {
            return (float)this.localTracker.getNormalProgress(partialTicks);
        }
        AimTracker tracker = this.getAimTracker(player);
        if (tracker != null) {
            return (float)tracker.getNormalProgress(partialTicks);
        }
        return 0.0f;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        boolean shouldBeAiming;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        boolean isReloading = (Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player);
        ItemStack heldItem = player.m_21205_();
        boolean inCriticalPhase = false;
        if (heldItem.m_41720_() instanceof GunItem) {
            Item item;
            CompoundTag tag = heldItem.m_41784_();
            inCriticalPhase = tag.m_128471_("InCriticalReloadPhase");
            Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
            if (!isReloading && !inCriticalPhase && (item = heldItem.m_41720_()) instanceof AnimatedGunItem) {
                AnimatedGunItem animatedGun = (AnimatedGunItem)item;
                String reloadState = tag.m_128461_("scguns:ReloadState");
                if (reloadState.equals("STOPPING") && !tag.m_128471_("scguns:IsPlayingReloadStop")) {
                    animatedGun.cleanupReloadState(tag);
                }
                if (gun.getReloads().getReloadType() == ReloadType.MANUAL && (tag.m_128471_("IsManualReload") || tag.m_128471_("InReloadLoop") || tag.m_128441_("LastReloadStateChange") || tag.m_128441_("ManualReloadInitialized"))) {
                    tag.m_128473_("IsManualReload");
                    tag.m_128473_("InReloadLoop");
                    tag.m_128473_("PendingStopTransition");
                    tag.m_128473_("PendingStopTime");
                    tag.m_128473_("LastReloadStateChange");
                    tag.m_128473_("ManualReloadInitialized");
                    tag.m_128473_("scguns:ReloadState");
                }
            }
            if (inCriticalPhase && gun.getReloads().getReloadType() != ReloadType.MANUAL) {
                this.aiming = false;
                this.wasKeyPressed = KeyBinds.getAimMapping().m_90857_();
                if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue()) {
                    ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)false);
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageAim(false));
                }
                this.localTracker.handleAiming((Player)player, player.m_21120_(InteractionHand.MAIN_HAND));
                return;
            }
        }
        if (isReloading || inCriticalPhase) {
            this.aiming = false;
            this.wasKeyPressed = KeyBinds.getAimMapping().m_90857_();
            if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue()) {
                ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)false);
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageAim(false));
            }
            this.localTracker.handleAiming((Player)player, player.m_21120_(InteractionHand.MAIN_HAND));
            return;
        }
        boolean currentKeyPressed = KeyBinds.getAimMapping().m_90857_();
        boolean toggleAdsEnabled = (Boolean)Config.COMMON.gameplay.toggleADS.get();
        if (toggleAdsEnabled) {
            if (currentKeyPressed && !this.wasKeyPressed) {
                this.aiming = !this.aiming;
            }
        } else {
            this.aiming = currentKeyPressed;
        }
        this.wasKeyPressed = currentKeyPressed;
        if (ScorchedGuns.controllableLoaded) {
            boolean controllerAiming = ControllerHandler.isAiming();
            if (toggleAdsEnabled) {
                if (controllerAiming && !this.wasKeyPressed) {
                    this.aiming = !this.aiming;
                }
            } else {
                this.aiming |= controllerAiming;
            }
        }
        if (shouldBeAiming = this.aiming) {
            if (heldItem.m_41720_() instanceof GunItem) {
                Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
                GripType gripType = gun.getGeneral().getGripType(heldItem);
                if (!gun.canAimDownSight()) {
                    shouldBeAiming = false;
                    this.aiming = false;
                } else if (gripType == GripType.ONE_HANDED && !player.m_21206_().m_41619_()) {
                    shouldBeAiming = false;
                    this.aiming = false;
                }
            } else {
                shouldBeAiming = false;
                this.aiming = false;
            }
        }
        if (shouldBeAiming) {
            if (!((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue()) {
                ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)true);
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageAim(true));
            }
        } else if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue()) {
            ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)false);
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageAim(false));
        }
        this.localTracker.handleAiming((Player)player, player.m_21120_(InteractionHand.MAIN_HAND));
    }

    public boolean isAiming() {
        CompoundTag tag;
        CompoundTag tag2;
        String reloadState;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return false;
        }
        if (mc.f_91074_.m_5833_()) {
            return false;
        }
        if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)mc.f_91074_)).booleanValue()) {
            return false;
        }
        ItemStack heldItem = mc.f_91074_.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem && !(reloadState = (tag2 = heldItem.m_41784_()).m_128461_("scguns:ReloadState")).isEmpty() && !reloadState.equals("NONE")) {
            return false;
        }
        if (Debug.isForceAim()) {
            return true;
        }
        if (mc.f_91080_ != null) {
            this.aiming = false;
            return false;
        }
        if (PlayerReviveHelper.isBleeding((Player)mc.f_91074_)) {
            this.aiming = false;
            return false;
        }
        if (!(heldItem.m_41720_() instanceof GunItem)) {
            this.aiming = false;
            return false;
        }
        Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
        if (!gun.canAimDownSight()) {
            this.aiming = false;
            return false;
        }
        if (heldItem.m_41720_() instanceof AnimatedGunItem && (tag = heldItem.m_41784_()).m_128471_("IsDrawing") && tag.m_128451_("DrawnTick") < 15) {
            this.aiming = false;
            return false;
        }
        GripType gripType = gun.getGeneral().getGripType(heldItem);
        if (gripType == GripType.ONE_HANDED && !mc.f_91074_.m_21206_().m_41619_()) {
            this.aiming = false;
            return false;
        }
        if (!this.localTracker.isAiming() && this.isLookingAtInteractableBlock()) {
            this.aiming = false;
            return false;
        }
        return this.aiming;
    }

    @SubscribeEvent
    public void onFovUpdate(ViewportEvent.ComputeFov event) {
        if (!event.usedConfiguredFov()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91074_.m_21205_().m_41619_() || mc.f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return;
        }
        ItemStack heldItem = mc.f_91074_.m_21205_();
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        if (AimingHandler.get().getNormalisedAdsProgress() == 0.0) {
            return;
        }
        if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)mc.f_91074_)).booleanValue()) {
            return;
        }
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (modifiedGun.getModules().getZoom() == null) {
            return;
        }
        double time = PropertyHelper.getSightAnimations(heldItem, modifiedGun).getFovCurve().apply(this.normalisedAdsProgress);
        float modifier = Gun.getFovModifier(heldItem, modifiedGun);
        modifier = (1.0f - modifier) * (float)time;
        event.setFOV(event.getFOV() - event.getFOV() * (double)modifier);
    }

    @SubscribeEvent
    public void onClientTick(ClientPlayerNetworkEvent.LoggingOut event) {
        this.aimingMap.clear();
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderOverlay(RenderGuiOverlayEvent event) {
        this.normalisedAdsProgress = this.localTracker.getNormalProgress(event.getPartialTick());
    }

    public boolean isZooming() {
        return this.aiming;
    }

    public boolean isLookingAtInteractableBlock() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91077_ != null && mc.f_91073_ != null) {
            HitResult hitResult = mc.f_91077_;
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult result = (BlockHitResult)hitResult;
                BlockState state = mc.f_91073_.m_8055_(result.m_82425_());
                Block block = state.m_60734_();
            } else {
                hitResult = mc.f_91077_;
                if (hitResult instanceof EntityHitResult) {
                    EntityHitResult result = (EntityHitResult)hitResult;
                    return result.m_82443_() instanceof ItemFrame;
                }
            }
        }
        return false;
    }

    public double getNormalisedAdsProgress() {
        return this.normalisedAdsProgress;
    }

    public class AimTracker {
        private double currentAim;
        private double previousAim;

        private void handleAiming(Player player, ItemStack heldItem) {
            this.previousAim = this.currentAim;
            if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue() || player.m_7578_() && AimingHandler.this.isAiming()) {
                if (this.currentAim < 5.0) {
                    double speed = GunEnchantmentHelper.getAimDownSightSpeed(heldItem);
                    speed = GunModifierHelper.getModifiedAimDownSightSpeed(heldItem, speed);
                    this.currentAim += speed;
                    if (this.currentAim > 5.0) {
                        this.currentAim = 5.0;
                    }
                }
            } else if (this.currentAim > 0.0) {
                double speed = GunEnchantmentHelper.getAimDownSightSpeed(heldItem);
                speed = GunModifierHelper.getModifiedAimDownSightSpeed(heldItem, speed);
                this.currentAim -= speed;
                if (this.currentAim < 0.0) {
                    this.currentAim = 0.0;
                }
            }
        }

        public boolean isAiming() {
            return this.currentAim != 0.0 || this.previousAim != 0.0;
        }

        public double getNormalProgress(float partialTicks) {
            return Mth.m_14008_((double)((this.previousAim + (this.currentAim - this.previousAim) * (double)partialTicks) / 5.0), (double)0.0, (double)1.0);
        }
    }
}

