/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import top.ribs.scguns.Config;
import top.ribs.scguns.cache.HotBarrelCache;
import top.ribs.scguns.common.ChargeHandler;
import top.ribs.scguns.common.FireMode;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitPowerManager;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.init.ModEnchantments;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.ammo_boxes.CreativeAmmoBoxItem;
import top.ribs.scguns.item.animated.AnimatedGunItem;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.item.exosuit.JetpackModuleItem;
import top.ribs.scguns.item.exosuit.NightVisionModuleItem;
import top.ribs.scguns.item.exosuit.TargetTrackerModuleItem;
import top.ribs.scguns.util.GunModifierHelper;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class HUDRenderHandler {
    private static final ResourceLocation CHARGE_BAR = new ResourceLocation("scguns", "textures/gui/charging_bar.png");
    private static final ResourceLocation FILL_BAR = new ResourceLocation("scguns", "textures/gui/fill_bar.png");
    private static final ResourceLocation MELEE_ATTACK_INDICATOR_PROGRESS = new ResourceLocation("scguns", "textures/gui/melee_attack_indicator_progress.png");
    private static final ResourceLocation MELEE_ATTACK_INDICATOR_BACKGROUND = new ResourceLocation("scguns", "textures/gui/melee_attack_indicator_background.png");
    public static final ResourceLocation HOT_BARREL_TEXTURE = new ResourceLocation("scguns", "textures/gui/hot_barrel.png");
    static int meleeCooldown = 0;
    static int maxMeleeCooldown = 0;
    static boolean isMeleeCooldownActive = false;
    private static boolean playingHitMarker = false;
    private static int hitMarkerTime;
    private static int prevHitMarkerTime;
    private static final int hitMarkerMaxTime = 2;
    private static boolean hitMarkerCrit;
    private static int reserveAmmo;
    private static int ammoAutoUpdateTimer;
    private static final int ammoAutoUpdateRate = 20;
    private static ItemStack cachedGunStack;
    private static Gun cachedGun;
    private static CompoundTag cachedTag;
    private static boolean cachedHasCreativeBox;
    private static int cacheValidityTimer;
    private static final int CACHE_DURATION = 10;
    private static int cachedScreenWidth;
    private static int cachedScreenHeight;
    private static int screenCacheTimer;
    private static final int SCREEN_CACHE_DURATION = 60;
    private static Component cachedAmmoText;
    private static Component cachedReserveAmmoText;
    private static Component cachedReloadingText;
    private static int lastCurrentAmmo;
    private static int lastMaxAmmo;
    private static int lastReserveAmmo;
    private static boolean lastCreativeState;
    private static boolean lastCreativeBoxState;
    private static TextureAtlasSprite cachedAmmoSprite;
    private static Item cachedAmmoItem;
    private static int hudUpdateCounter;
    private static final int HUD_UPDATE_RATE = 2;
    private static boolean hudNeedsUpdate;
    private static Component cachedPowerText;
    private static Component cachedNoPowerText;
    private static int lastEnergyPercent;
    private static ChatFormatting lastEnergyColor;

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91080_ != null) {
            return;
        }
        if (++hudUpdateCounter < 2 && !hudNeedsUpdate) {
            return;
        }
        hudUpdateCounter = 0;
        hudNeedsUpdate = false;
        HUDRenderHandler.updateScreenCache(mc);
        GuiGraphics guiGraphics = event.getGuiGraphics();
        PoseStack poseStack = guiGraphics.m_280168_();
        if (HUDRenderHandler.hasAnyExoSuitPiece((Player)player)) {
            HUDRenderHandler.renderExoSuitStatusHUD(poseStack, guiGraphics, (Player)player);
        }
        if (!((Boolean)Config.CLIENT.display.displayGunInfo.get()).booleanValue()) {
            return;
        }
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41619_() || !(heldItem.m_41720_() instanceof GunItem)) {
            return;
        }
        HUDRenderHandler.updateCache(heldItem, (Player)player);
        HUDRenderHandler.renderGunInfoHUD(heldItem, poseStack, guiGraphics, (Player)player);
        HUDRenderHandler.renderChargeBarHUD(heldItem, event.getPartialTick(), poseStack, guiGraphics, player);
        HUDRenderHandler.renderMeleeCooldownHUD(event.getPartialTick(), poseStack, guiGraphics);
        HUDRenderHandler.renderHitMarker(event.getPartialTick(), poseStack, guiGraphics);
        HUDRenderHandler.renderHotBarrelOverlay(heldItem, poseStack, guiGraphics);
    }

    private static void updateCache(ItemStack heldItem, Player player) {
        if (cacheValidityTimer <= 0 || !ItemStack.m_41728_((ItemStack)cachedGunStack, (ItemStack)heldItem)) {
            cachedGunStack = heldItem.m_41777_();
            cachedGun = ((GunItem)heldItem.m_41720_()).getGun();
            cachedTag = heldItem.m_41783_();
            HUDRenderHandler.updateCreativeBoxCache(player);
            cacheValidityTimer = 10;
            HUDRenderHandler.markHudDirty();
        } else {
            --cacheValidityTimer;
        }
    }

    private static void updateCreativeBoxCache(Player player) {
        cachedHasCreativeBox = player.m_150109_().f_35974_.stream().anyMatch(itemStack -> itemStack.m_41720_() instanceof CreativeAmmoBoxItem);
        if (!cachedHasCreativeBox) {
            AtomicBoolean hasBox = new AtomicBoolean(false);
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                IItemHandlerModifiable curios = handler.getEquippedCurios();
                for (int i = 0; i < curios.getSlots() && !hasBox.get(); ++i) {
                    ItemStack stack = curios.getStackInSlot(i);
                    if (!(stack.m_41720_() instanceof CreativeAmmoBoxItem)) continue;
                    hasBox.set(true);
                }
            });
            cachedHasCreativeBox = hasBox.get();
        }
        if (!cachedHasCreativeBox) {
            cachedHasCreativeBox = HUDRenderHandler.hasCreativeAmmoBoxInExoSuit(player);
        }
    }

    private static boolean hasCreativeAmmoBoxInExoSuit(Player player) {
        ItemStack chestplate = HUDRenderHandler.getEquippedChestplate(player);
        if (chestplate.m_41619_()) {
            return false;
        }
        ItemStack pouchUpgrade = HUDRenderHandler.findPouchUpgrade(chestplate);
        if (pouchUpgrade.m_41619_()) {
            return false;
        }
        ExoSuitUpgrade upgrade = ExoSuitUpgradeManager.getUpgradeForItem(pouchUpgrade);
        if (upgrade == null) {
            return false;
        }
        String pouchId = HUDRenderHandler.getPouchId(pouchUpgrade);
        ItemStackHandler pouchInventory = HUDRenderHandler.getPouchInventory(chestplate, pouchId, upgrade.getDisplay().getStorageSize());
        for (int i = 0; i < pouchInventory.getSlots(); ++i) {
            ItemStack stack = pouchInventory.getStackInSlot(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof CreativeAmmoBoxItem)) continue;
            return true;
        }
        return false;
    }

    private static ItemStack getEquippedChestplate(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.CHESTPLATE) continue;
            return armorStack;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack findPouchUpgrade(ItemStack chestplate) {
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(chestplate, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("pouches")) continue;
            return upgradeItem;
        }
        return ItemStack.f_41583_;
    }

    private static String getPouchId(ItemStack pouchUpgrade) {
        return pouchUpgrade.m_41720_().toString();
    }

    private static ItemStackHandler getPouchInventory(ItemStack chestplate, String pouchId, int size) {
        CompoundTag pouchData = chestplate.m_41784_().m_128469_("PouchData");
        ItemStackHandler handler = new ItemStackHandler(size);
        if (pouchData.m_128441_(pouchId)) {
            handler.deserializeNBT(pouchData.m_128469_(pouchId));
        }
        return handler;
    }

    private static void updateScreenCache(Minecraft mc) {
        if (screenCacheTimer <= 0) {
            cachedScreenWidth = mc.m_91268_().m_85445_();
            cachedScreenHeight = mc.m_91268_().m_85446_();
            screenCacheTimer = 60;
        } else {
            --screenCacheTimer;
        }
    }

    public static void renderHotBarrelOverlay(ItemStack heldItem, PoseStack poseStack, GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.HOT_BARREL.get()), (ItemStack)heldItem) <= 0) {
            return;
        }
        float chargeRatio = HotBarrelCache.getSmoothHotBarrelPercentage((Player)player, heldItem);
        if (chargeRatio <= 0.0f) {
            return;
        }
        int barWidth = 128;
        int barHeight = 8;
        float scale = 1.25f;
        int barX = (int)((float)cachedScreenWidth / 2.0f - (float)barWidth * scale / 2.0f);
        int barY = (int)((float)cachedScreenHeight - 45.0f * scale);
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)HOT_BARREL_TEXTURE);
        int scaledBarX = (int)((float)barX / scale);
        int scaledBarY = (int)((float)barY / scale);
        guiGraphics.m_280163_(HOT_BARREL_TEXTURE, scaledBarX, scaledBarY, 0.0f, 0.0f, barWidth, 5, barWidth, barHeight);
        int fillWidth = (int)((float)barWidth * chargeRatio);
        if (fillWidth > 0) {
            int fillY = scaledBarY + 1;
            guiGraphics.m_280163_(HOT_BARREL_TEXTURE, scaledBarX, fillY, 0.0f, 5.0f, fillWidth, 3, barWidth, barHeight);
        }
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private static void renderMeleeCooldownHUD(float partialTick, PoseStack poseStack, GuiGraphics guiGraphics) {
        if (!isMeleeCooldownActive) {
            return;
        }
        int barWidth = 16;
        int barHeight = 16;
        int barX = (int)((double)cachedScreenWidth * 0.87);
        int barY = (int)((double)cachedScreenHeight * 0.73);
        float cooldownRatio = meleeCooldown > 0 ? (float)meleeCooldown / (float)maxMeleeCooldown : 0.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MELEE_ATTACK_INDICATOR_BACKGROUND);
        guiGraphics.m_280163_(MELEE_ATTACK_INDICATOR_BACKGROUND, barX, barY, 0.0f, 0.0f, barWidth, barHeight, barWidth, barHeight);
        if (cooldownRatio > 0.0f) {
            int fillHeight = (int)((float)barHeight * cooldownRatio);
            int fillY = barY + (barHeight - fillHeight);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)MELEE_ATTACK_INDICATOR_PROGRESS);
            guiGraphics.m_280163_(MELEE_ATTACK_INDICATOR_PROGRESS, barX, fillY, 0.0f, (float)(barHeight - fillHeight), barWidth, fillHeight, barWidth, barHeight);
        }
        RenderSystem.disableBlend();
    }

    private static void renderGunInfoHUD(ItemStack heldItem, PoseStack poseStack, GuiGraphics guiGraphics, Player player) {
        Item item;
        if (cachedTag == null) {
            return;
        }
        if (((Boolean)Config.CLIENT.display.immersiveGunInfo.get()).booleanValue() && (item = heldItem.m_41720_()) instanceof AnimatedGunItem) {
            AnimatedGunItem animatedGun = (AnimatedGunItem)item;
            long id = GeoItem.getId((ItemStack)heldItem);
            AnimationController controller = (AnimationController)animatedGun.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
            if (controller == null || !animatedGun.isAnimationPlaying((AnimationController<GeoAnimatable>)controller, "inspect") && !animatedGun.isAnimationPlaying((AnimationController<GeoAnimatable>)controller, "carbine_inspect")) {
                return;
            }
        }
        int currentAmmo = cachedTag.m_128451_("AmmoCount");
        int maxAmmo = GunModifierHelper.getModifiedAmmoCapacity(heldItem, cachedGun);
        boolean isCreative = player.m_7500_();
        HUDRenderHandler.updateAmmoTextCache(currentAmmo, maxAmmo, isCreative);
        HUDRenderHandler.updateReserveAmmoTextCache(isCreative);
        int ammoPosX = (int)((double)cachedScreenWidth * 0.88);
        int ammoPosY = (int)((double)cachedScreenHeight * 0.8);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft mc = Minecraft.m_91087_();
        if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue() && player.m_6084_()) {
            guiGraphics.m_280430_(mc.f_91062_, cachedReloadingText, ammoPosX, ammoPosY - 10, 0xFFFF55);
        }
        int ammoColor = currentAmmo > 0 || isCreative ? 0xFFFFFF : 0xFF5555;
        guiGraphics.m_280430_(mc.f_91062_, cachedAmmoText, ammoPosX, ammoPosY, ammoColor);
        int reserveAmmoPosY = ammoPosY + 10;
        int reserveColor = reserveAmmo <= 0 && !Gun.hasUnlimitedReloads(heldItem) ? 0x555555 : 0xAAAAAA;
        guiGraphics.m_280430_(mc.f_91062_, cachedReserveAmmoText, ammoPosX, reserveAmmoPosY, reserveColor);
        ItemStack ammoItemStack = new ItemStack((ItemLike)Objects.requireNonNull(cachedGun.getProjectile().getItem()));
        HUDRenderHandler.renderAmmoTypeTexture(ammoItemStack, ammoPosX - 20, ammoPosY, guiGraphics, mc);
        RenderSystem.disableBlend();
    }

    private static void updateAmmoTextCache(int currentAmmo, int maxAmmo, boolean isCreative) {
        if (currentAmmo != lastCurrentAmmo || maxAmmo != lastMaxAmmo || isCreative != lastCreativeState) {
            cachedAmmoText = isCreative ? Component.m_237113_((String)"\u221e/ \u221e").m_130940_(ChatFormatting.BOLD) : Component.m_237113_((String)(currentAmmo + " / " + maxAmmo)).m_130940_(ChatFormatting.BOLD);
            lastCurrentAmmo = currentAmmo;
            lastMaxAmmo = maxAmmo;
            lastCreativeState = isCreative;
        }
    }

    private static void updateReserveAmmoTextCache(boolean isCreative) {
        if (reserveAmmo != lastReserveAmmo || cachedHasCreativeBox != lastCreativeBoxState || isCreative != lastCreativeState) {
            cachedReserveAmmoText = isCreative || cachedHasCreativeBox ? Component.m_237113_((String)"\u221e").m_130940_(ChatFormatting.BOLD) : Component.m_237113_((String)String.valueOf(reserveAmmo)).m_130940_(ChatFormatting.BOLD);
            lastReserveAmmo = reserveAmmo;
            lastCreativeBoxState = cachedHasCreativeBox;
        }
    }

    private static void renderAmmoTypeTexture(ItemStack ammoItemStack, int x, int y, GuiGraphics guiGraphics, Minecraft mc) {
        Item currentAmmoItem = ammoItemStack.m_41720_();
        if (cachedAmmoSprite == null || cachedAmmoItem != currentAmmoItem) {
            ResourceLocation ammoTexture = ForgeRegistries.ITEMS.getKey((Object)currentAmmoItem);
            cachedAmmoSprite = (TextureAtlasSprite)mc.m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation(ammoTexture.m_135827_(), "item/" + ammoTexture.m_135815_()));
            cachedAmmoItem = currentAmmoItem;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        int iconSize = 16;
        int zLevel = 0;
        guiGraphics.m_280159_(x, y, zLevel, iconSize, iconSize, cachedAmmoSprite);
    }

    private static void renderChargeBarHUD(ItemStack heldItem, float partialTick, PoseStack poseStack, GuiGraphics guiGraphics, LocalPlayer player) {
        Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
        if (gun.getGeneral().getFireMode() != FireMode.PULSE) {
            return;
        }
        int maxChargeTime = gun.getGeneral().getFireTimer();
        int chargeTime = ChargeHandler.getChargeTime(player.m_20148_());
        if (chargeTime <= 0) {
            return;
        }
        float chargeRatio = (float)chargeTime / (float)maxChargeTime;
        int barWidth = 16;
        int barHeight = 16;
        int barX = cachedScreenWidth / 2 - 15;
        int barY = cachedScreenHeight / 2 - barHeight / 2;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CHARGE_BAR);
        guiGraphics.m_280163_(CHARGE_BAR, barX, barY, 0.0f, 0.0f, barWidth, barHeight, barWidth, barHeight);
        if (chargeRatio > 0.0f) {
            int fillBarWidth = 16;
            int fillBarHeight = 16;
            int fillHeight = (int)((float)fillBarHeight * chargeRatio);
            int fillY = barY + (fillBarHeight - fillHeight);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)FILL_BAR);
            guiGraphics.m_280163_(FILL_BAR, barX, fillY, 0.0f, (float)(fillBarHeight - fillHeight), fillBarWidth, fillHeight, fillBarWidth, fillBarHeight);
        }
        RenderSystem.disableBlend();
    }

    private static void renderHitMarker(float partialTick, PoseStack poseStack, GuiGraphics guiGraphics) {
        if (!playingHitMarker) {
            return;
        }
        float progress = ((float)prevHitMarkerTime + (float)(hitMarkerTime - prevHitMarkerTime) * partialTick) / 2.0f;
        if (progress >= 1.0f) {
            playingHitMarker = false;
            hitMarkerTime = 0;
        }
    }

    public static void playHitMarker(boolean crit) {
        playingHitMarker = true;
        hitMarkerCrit = crit;
        hitMarkerTime = 1;
        prevHitMarkerTime = 0;
    }

    private static void fetchReserveAmmo(Player player, Gun gun) {
        reserveAmmo = Gun.getReserveAmmoCount(player, gun.getProjectile().getItem());
        ammoAutoUpdateTimer = 0;
        HUDRenderHandler.markHudDirty();
    }

    public static void stageReserveAmmoUpdate() {
        ammoAutoUpdateTimer = 20;
        HUDRenderHandler.markHudDirty();
    }

    public static void updateReserveAmmo(Player player) {
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem) {
            Gun modifiedGun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
            HUDRenderHandler.fetchReserveAmmo(player, modifiedGun);
        }
    }

    public static void markHudDirty() {
        hudNeedsUpdate = true;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        HUDRenderHandler.updateHitMarker();
        if (++ammoAutoUpdateTimer >= 20) {
            ammoAutoUpdateTimer = 0;
            HUDRenderHandler.markHudDirty();
        }
        if (isMeleeCooldownActive && --meleeCooldown <= 0) {
            isMeleeCooldownActive = false;
            meleeCooldown = 0;
        }
    }

    private static void updateHitMarker() {
        prevHitMarkerTime = hitMarkerTime++;
        if (playingHitMarker) {
            if (hitMarkerTime > 2) {
                playingHitMarker = false;
                hitMarkerTime = 0;
            }
        } else {
            hitMarkerTime = 0;
        }
    }

    public static boolean isRenderingHitMarker() {
        return playingHitMarker;
    }

    public static float getHitMarkerProgress(float partialTicks) {
        return ((float)prevHitMarkerTime + (float)(hitMarkerTime - prevHitMarkerTime) * partialTicks) / 2.0f;
    }

    public static boolean getHitMarkerCrit() {
        return hitMarkerCrit;
    }

    private static void renderExoSuitStatusHUD(PoseStack poseStack, GuiGraphics guiGraphics, Player player) {
        ItemStack boots;
        ChatFormatting statusColor;
        String statusText;
        boolean canFunction;
        ItemStack helmet;
        int hudX = 3;
        int hudY = cachedScreenHeight - 60;
        int lineHeight = 10;
        int currentY = hudY;
        Minecraft mc = Minecraft.m_91087_();
        ItemStack chestplate = HUDRenderHandler.getEquippedExoSuitChestplate(player);
        if (!chestplate.m_41619_()) {
            ItemStack powerCore = HUDRenderHandler.findPowerCoreInChestplate(chestplate);
            if (!powerCore.m_41619_()) {
                int energyStored = powerCore.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
                int maxEnergy = powerCore.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getMaxEnergyStored).orElse(0);
                if (maxEnergy > 0) {
                    int energyPercent = energyStored * 100 / maxEnergy;
                    ChatFormatting energyColor = HUDRenderHandler.getEnergyColorForHUD(energyPercent);
                    if (energyPercent != lastEnergyPercent || energyColor != lastEnergyColor) {
                        cachedPowerText = Component.m_237110_((String)"tooltip.scguns.exosuit.energy_level", (Object[])new Object[]{energyPercent}).m_130940_(energyColor);
                        lastEnergyPercent = energyPercent;
                        lastEnergyColor = energyColor;
                    }
                    guiGraphics.m_280430_(mc.f_91062_, cachedPowerText, hudX, currentY, energyColor.m_126665_() != null ? energyColor.m_126665_() : 0xFFFFFF);
                    currentY += lineHeight;
                }
            } else {
                guiGraphics.m_280430_(mc.f_91062_, cachedNoPowerText, hudX, currentY, 0xFF5555);
                currentY += lineHeight;
            }
        }
        if (!(helmet = HUDRenderHandler.getEquippedExoSuitHelmet(player)).m_41619_() && HUDRenderHandler.hasHudModule(helmet)) {
            boolean hudEnabled = ExoSuitPowerManager.isPowerEnabled(player, "hud");
            canFunction = ExoSuitPowerManager.canUpgradeFunction(player, "hud");
            String hudModuleKey = HUDRenderHandler.getHudModuleTranslationKey(helmet);
            statusText = HUDRenderHandler.getModuleStatusText(hudEnabled, canFunction);
            statusColor = HUDRenderHandler.getModuleStatusColor(hudEnabled, canFunction);
            MutableComponent helmetText = Component.m_237115_((String)hudModuleKey).m_130946_(": " + statusText).m_130940_(statusColor);
            guiGraphics.m_280430_(mc.f_91062_, (Component)helmetText, hudX, currentY, statusColor.m_126665_() != null ? statusColor.m_126665_() : 0xFFFFFF);
            currentY += lineHeight;
        }
        if (!chestplate.m_41619_() && HUDRenderHandler.hasUtilityModule(chestplate)) {
            boolean utilityEnabled = ExoSuitPowerManager.isPowerEnabled(player, "utility");
            canFunction = ExoSuitPowerManager.canUpgradeFunction(player, "utility");
            String utilityModuleKey = HUDRenderHandler.getUtilityModuleTranslationKey(chestplate);
            statusText = HUDRenderHandler.getModuleStatusText(utilityEnabled, canFunction);
            statusColor = HUDRenderHandler.getModuleStatusColor(utilityEnabled, canFunction);
            MutableComponent chestText = Component.m_237115_((String)utilityModuleKey).m_130946_(": " + statusText).m_130940_(statusColor);
            guiGraphics.m_280430_(mc.f_91062_, (Component)chestText, hudX, currentY, statusColor.m_126665_() != null ? statusColor.m_126665_() : 0xFFFFFF);
            currentY += lineHeight;
        }
        if (!(boots = HUDRenderHandler.getEquippedExoSuitBoots(player)).m_41619_() && HUDRenderHandler.hasMobilityModule(boots)) {
            boolean mobilityEnabled = ExoSuitPowerManager.isPowerEnabled(player, "mobility");
            boolean canFunction2 = ExoSuitPowerManager.canUpgradeFunction(player, "mobility");
            String mobilityModuleKey = HUDRenderHandler.getMobilityModuleTranslationKey(boots);
            String statusText2 = HUDRenderHandler.getModuleStatusText(mobilityEnabled, canFunction2);
            ChatFormatting statusColor2 = HUDRenderHandler.getModuleStatusColor(mobilityEnabled, canFunction2);
            MutableComponent bootsText = Component.m_237115_((String)mobilityModuleKey).m_130946_(": " + statusText2).m_130940_(statusColor2);
            guiGraphics.m_280430_(mc.f_91062_, (Component)bootsText, hudX, currentY, statusColor2.m_126665_() != null ? statusColor2.m_126665_() : 0xFFFFFF);
        }
    }

    private static boolean hasUtilityModule(ItemStack chestplate) {
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(chestplate, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("utility")) continue;
            return true;
        }
        return false;
    }

    private static String getUtilityModuleTranslationKey(ItemStack chestplate) {
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(chestplate, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("utility")) continue;
            if (upgradeItem.m_41720_() instanceof JetpackModuleItem) {
                return "exosuit.upgrade.jetpack";
            }
            if (upgrade.getEffects().hasFlight()) {
                return "exosuit.upgrade.jetpack";
            }
            return "exosuit.upgrade.utility";
        }
        return "exosuit.upgrade.utility";
    }

    private static boolean hasAnyExoSuitPiece(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            if (!(armorStack.m_41720_() instanceof ExoSuitItem)) continue;
            return true;
        }
        return false;
    }

    private static ItemStack getEquippedExoSuitHelmet(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.HELMET) continue;
            return armorStack;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack getEquippedExoSuitChestplate(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.CHESTPLATE) continue;
            return armorStack;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack getEquippedExoSuitBoots(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.BOOTS) continue;
            return armorStack;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack findPowerCoreInChestplate(ItemStack chestplate) {
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(chestplate, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("power_core")) continue;
            return upgradeItem;
        }
        return ItemStack.f_41583_;
    }

    private static boolean hasHudModule(ItemStack helmet) {
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(helmet, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("hud")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMobilityModule(ItemStack boots) {
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(boots, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("mobility")) continue;
            return true;
        }
        return false;
    }

    private static String getHudModuleTranslationKey(ItemStack helmet) {
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(helmet, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("hud")) continue;
            if (upgradeItem.m_41720_() instanceof NightVisionModuleItem) {
                return "exosuit.upgrade.night_vision";
            }
            if (upgradeItem.m_41720_() instanceof TargetTrackerModuleItem) {
                return "exosuit.upgrade.target_tracker";
            }
            return "exosuit.upgrade.hud";
        }
        return "exosuit.upgrade.hud";
    }

    private static String getMobilityModuleTranslationKey(ItemStack boots) {
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(boots, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("mobility")) continue;
            return "exosuit.upgrade.mobility";
        }
        return "exosuit.upgrade.mobility";
    }

    private static String getModuleStatusText(boolean enabled, boolean canFunction) {
        if (!enabled) {
            return Component.m_237115_((String)"hud.scguns.exosuit.module.disabled").getString();
        }
        if (!canFunction) {
            return Component.m_237115_((String)"hud.scguns.exosuit.module.no_power").getString();
        }
        return Component.m_237115_((String)"hud.scguns.exosuit.module.active").getString();
    }

    private static ChatFormatting getEnergyColorForHUD(int energyPercent) {
        if (energyPercent > 75) {
            return ChatFormatting.GREEN;
        }
        if (energyPercent > 50) {
            return ChatFormatting.YELLOW;
        }
        if (energyPercent > 25) {
            return ChatFormatting.GOLD;
        }
        if (energyPercent > 0) {
            return ChatFormatting.RED;
        }
        return ChatFormatting.DARK_RED;
    }

    private static ChatFormatting getModuleStatusColor(boolean enabled, boolean canFunction) {
        if (!enabled) {
            return ChatFormatting.GRAY;
        }
        if (!canFunction) {
            return ChatFormatting.RED;
        }
        return ChatFormatting.GREEN;
    }

    static {
        hitMarkerCrit = false;
        reserveAmmo = 0;
        ammoAutoUpdateTimer = 0;
        cachedGunStack = ItemStack.f_41583_;
        cachedGun = null;
        cachedTag = null;
        cachedHasCreativeBox = false;
        cacheValidityTimer = 0;
        cachedScreenWidth = -1;
        cachedScreenHeight = -1;
        screenCacheTimer = 0;
        cachedAmmoText = Component.m_237119_();
        cachedReserveAmmoText = Component.m_237119_();
        cachedReloadingText = Component.m_237113_((String)"Reloading...");
        lastCurrentAmmo = -1;
        lastMaxAmmo = -1;
        lastReserveAmmo = -1;
        lastCreativeState = false;
        lastCreativeBoxState = false;
        cachedAmmoSprite = null;
        cachedAmmoItem = null;
        hudUpdateCounter = 0;
        hudNeedsUpdate = true;
        cachedPowerText = Component.m_237119_();
        cachedNoPowerText = Component.m_237115_((String)"hud.scguns.exosuit.no_power_core").m_130940_(ChatFormatting.RED);
        lastEnergyPercent = -1;
        lastEnergyColor = null;
    }
}

