/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import top.ribs.scguns.init.ModTags;

@OnlyIn(value=Dist.CLIENT)
public class BloodParticle
extends TextureSheetParticle {
    public BloodParticle(ClientLevel world, double x, double y, double z) {
        super(world, x, y, z, 0.1, 0.1, 0.1);
        this.f_107226_ = 1.5f;
        this.f_107663_ = 0.1f;
        this.f_107225_ = (int)(12.0f / (this.f_107223_.m_188501_() * 0.9f + 0.1f));
    }

    public void setCustomColor(float r, float g, float b, float a) {
        this.m_107253_(r, g, b);
        this.f_107230_ = a;
    }

    public void setColorBasedOnEntity(EntityType<?> entityType) {
        if (entityType.m_204039_(ModTags.Entities.RED_BLOOD)) {
            this.m_107253_(0.541f, 0.027f, 0.027f);
        } else if (entityType.m_204039_(ModTags.Entities.WHITE_BLOOD)) {
            this.m_107253_(1.0f, 1.0f, 1.0f);
        } else if (entityType.m_204039_(ModTags.Entities.GREEN_BLOOD)) {
            this.m_107253_(0.0f, 1.0f, 0.0f);
        } else if (entityType.m_204039_(ModTags.Entities.BLUE_BLOOD)) {
            this.m_107253_(0.0f, 0.0f, 1.0f);
        } else if (entityType.m_204039_(ModTags.Entities.YELLOW_BLOOD)) {
            this.m_107253_(1.0f, 1.0f, 0.0f);
        } else if (entityType.m_204039_(ModTags.Entities.PURPLE_BLOOD)) {
            this.m_107253_(0.5f, 0.0f, 0.5f);
        } else if (entityType.m_204039_(ModTags.Entities.BLACK_BLOOD)) {
            this.m_107253_(0.0f, 0.0f, 0.0f);
        } else {
            this.m_107253_(0.541f, 0.027f, 0.027f);
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.f_107218_) {
            this.f_107215_ = 0.0;
            this.f_107217_ = 0.0;
            this.f_107663_ *= 0.95f;
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vec3 projectedView = renderInfo.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - projectedView.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - projectedView.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - projectedView.m_7094_());
        if (this.f_107218_) {
            y = (float)((double)y + 0.01);
        }
        Quaternionf rotation = Direction.NORTH.m_253075_();
        if (this.f_107231_ == 0.0f) {
            if (!this.f_107218_) {
                rotation = renderInfo.m_253121_();
            }
        } else {
            rotation = new Quaternionf((Quaternionfc)renderInfo.m_253121_());
            float angle = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
            rotation.mul((Quaternionfc)Axis.f_252403_.m_252961_(angle));
        }
        Vector3f[] vertices = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float scale = this.m_5902_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vertex = vertices[i];
            vertex.rotate((Quaternionfc)rotation);
            vertex.mul(scale);
            vertex.add(x, y, z);
        }
        float minU = this.m_5970_();
        float maxU = this.m_5952_();
        float minV = this.m_5951_();
        float maxV = this.m_5950_();
        int light = this.m_6355_(partialTicks);
        buffer.m_5483_((double)vertices[0].x(), (double)vertices[0].y(), (double)vertices[0].z()).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vertices[1].x(), (double)vertices[1].y(), (double)vertices[1].z()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vertices[2].x(), (double)vertices[2].y(), (double)vertices[2].z()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vertices[3].x(), (double)vertices[3].y(), (double)vertices[3].z()).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BloodParticle particle = new BloodParticle(worldIn, x, y, z);
            particle.m_107253_((float)xSpeed, (float)ySpeed, (float)zSpeed);
            particle.m_108335_(this.spriteSet);
            return particle;
        }
    }
}

