/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.ribs.scguns.blockentity.AutoTurretBlockEntity;
import top.ribs.scguns.client.SpecialModels;
import top.ribs.scguns.client.util.RenderUtil;

@OnlyIn(value=Dist.CLIENT)
public class AutoTurretRenderer
implements BlockEntityRenderer<AutoTurretBlockEntity> {
    public AutoTurretRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(AutoTurretBlockEntity turret, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        double previousYaw = turret.getPreviousYaw();
        double yaw = turret.getYaw();
        float interpolatedYaw = (float)(previousYaw + Mth.m_14175_((double)(yaw - previousYaw)) * (double)partialTicks);
        double previousPitch = turret.getPreviousPitch();
        double pitch = turret.getPitch();
        float interpolatedPitch = (float)(previousPitch + (pitch - previousPitch) * (double)partialTicks);
        this.renderTurretTop(turret, matrixStack, buffer, light, overlay, SpecialModels.AUTO_TURRET_TOP.getModel(), 0.5, 1.0, 0.5, interpolatedYaw, interpolatedPitch);
    }

    private void renderTurretTop(AutoTurretBlockEntity turret, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay, BakedModel model, double x, double y, double z, float yaw, float pitch) {
        if (model != null) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(x, y, z);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(yaw));
            float recoilPitch = pitch + turret.getRecoilPitchOffset();
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(recoilPitch));
            matrixStack.m_85837_(-x, -y, -z);
            RenderUtil.renderMaceratorWheel(model, matrixStack, buffer, light, overlay);
            matrixStack.m_85849_();
        }
    }

    public boolean shouldRenderOffScreen(AutoTurretBlockEntity p_112304_) {
        return true;
    }
}

