/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.render.gun.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.client.SpecialModels;
import top.ribs.scguns.client.render.gun.IOverrideModel;
import top.ribs.scguns.client.util.RenderUtil;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.init.ModItems;
import top.ribs.scguns.item.attachment.IAttachment;

public class BirdfeederModel
implements IOverrideModel {
    @Override
    public void render(float partialTicks, ItemDisplayContext transformType, ItemStack stack, ItemStack parent, LivingEntity entity, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        RenderUtil.renderModel(SpecialModels.BIRDFEEDER_MAIN.getModel(), stack, matrixStack, buffer, light, overlay);
        this.renderBarrelAttachments(matrixStack, buffer, stack, light, overlay);
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.STOCK)) {
            if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.WEIGHTED_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.BIRDFEEDER_WEIGHTED_STOCK.getModel(), stack, matrixStack, buffer, light, overlay);
            }
            if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.LIGHT_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.BIRDFEEDER_LIGHT_STOCK.getModel(), stack, matrixStack, buffer, light, overlay);
            }
            if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.WOODEN_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.BIRDFEEDER_WOODEN_STOCK.getModel(), stack, matrixStack, buffer, light, overlay);
            }
            if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.BUMP_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.BIRDFEEDER_WEIGHTED_STOCK.getModel(), stack, matrixStack, buffer, light, overlay);
            }
        } else {
            RenderUtil.renderModel(SpecialModels.BIRDFEEDER_STAN_GRIP.getModel(), stack, matrixStack, buffer, light, overlay);
        }
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.UNDER_BARREL)) {
            if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.VERTICAL_GRIP.get()) {
                RenderUtil.renderModel(SpecialModels.BIRDFEEDER_VERTICAL_GRIP.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.LIGHT_GRIP.get()) {
                RenderUtil.renderModel(SpecialModels.BIRDFEEDER_LIGHT_GRIP.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.IRON_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.BIRDFEEDER_IRON_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.ANTHRALITE_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.BIRDFEEDER_ANTHRALITE_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.DIAMOND_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.BIRDFEEDER_DIAMOND_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.NETHERITE_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.BIRDFEEDER_NETHERITE_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            }
        }
        float magazinePosition = this.calculateMagazinePosition(stack);
        float translationMultiplier = 0.25f;
        matrixStack.m_85836_();
        matrixStack.m_252880_(this.clampMagazinePosition(magazinePosition * translationMultiplier), 0.0f, 0.0f);
        RenderUtil.renderModel(SpecialModels.BIRDFEEDER_MAGAZINE.getModel(), stack, matrixStack, buffer, light, overlay);
        matrixStack.m_85849_();
    }

    private void renderBarrelAttachments(PoseStack matrixStack, MultiBufferSource buffer, ItemStack stack, int light, int overlay) {
        boolean hasExtendedBarrel = false;
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.BARREL)) {
            if (Gun.getAttachment(IAttachment.Type.BARREL, stack).m_41720_() == ModItems.EXTENDED_BARREL.get()) {
                RenderUtil.renderModel(SpecialModels.BIRDFEEDER_EXT_BARREL.getModel(), stack, matrixStack, buffer, light, overlay);
                hasExtendedBarrel = true;
            } else if (Gun.getAttachment(IAttachment.Type.BARREL, stack).m_41720_() == ModItems.SILENCER.get()) {
                RenderUtil.renderModel(SpecialModels.BIRDFEEDER_SILENCER.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.BARREL, stack).m_41720_() == ModItems.MUZZLE_BRAKE.get()) {
                RenderUtil.renderModel(SpecialModels.BIRDFEEDER_MUZZLE_BRAKE.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.BARREL, stack).m_41720_() == ModItems.ADVANCED_SILENCER.get()) {
                RenderUtil.renderModel(SpecialModels.BIRDFEEDER_ADVANCED_SILENCER.getModel(), stack, matrixStack, buffer, light, overlay);
            }
        }
        if (!hasExtendedBarrel) {
            RenderUtil.renderModel(SpecialModels.BIRDFEEDER_STAN_BARREL.getModel(), stack, matrixStack, buffer, light, overlay);
        }
    }

    private double ease(double x) {
        return 1.0 - Math.pow(1.0 - 2.0 * x, 4.0);
    }

    private float calculateMagazinePosition(ItemStack stack) {
        int maxAmmo = Gun.getMaxAmmo(stack);
        int currentAmmo = Gun.getAmmoCount(stack);
        return Math.min((float)(maxAmmo - currentAmmo) / (float)maxAmmo, 1.0f);
    }

    private float clampMagazinePosition(float position) {
        return Math.max(0.0f, Math.min(position, 1.0f));
    }
}

