/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.render.gun.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.client.SpecialModels;
import top.ribs.scguns.client.render.gun.IOverrideModel;
import top.ribs.scguns.client.util.RenderUtil;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.init.ModItems;
import top.ribs.scguns.item.attachment.IAttachment;

public class CogloaderModel
implements IOverrideModel {
    private float magazineRotation = 0.0f;

    @Override
    public void render(float partialTicks, ItemDisplayContext transformType, ItemStack stack, ItemStack parent, LivingEntity entity, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        RenderUtil.renderModel(SpecialModels.COGLOADER_MAIN.getModel(), stack, matrixStack, buffer, light, overlay);
        if (Gun.getScope(stack) == null) {
            RenderUtil.renderModel(SpecialModels.COGLOADER_SIGHTS.getModel(), stack, matrixStack, buffer, light, overlay);
        } else {
            RenderUtil.renderModel(SpecialModels.COGLOADER_NO_SIGHTS.getModel(), stack, matrixStack, buffer, light, overlay);
        }
        this.renderStockAttachments(matrixStack, buffer, stack, light, overlay);
        this.renderBarrelAndAttachments(matrixStack, buffer, stack, light, overlay);
        this.renderUnderBarrelAttachments(matrixStack, buffer, stack, light, overlay);
        if (entity.equals((Object)Minecraft.m_91087_().f_91074_)) {
            this.renderBoltAndMagazine(matrixStack, buffer, stack, light, overlay);
        }
    }

    private void renderStockAttachments(PoseStack matrixStack, MultiBufferSource buffer, ItemStack stack, int light, int overlay) {
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.STOCK)) {
            if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.WOODEN_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.COGLOADER_STOCK_WOODEN.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.LIGHT_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.COGLOADER_STOCK_LIGHT.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.WEIGHTED_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.COGLOADER_STOCK_HEAVY.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.BUMP_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.COGLOADER_STOCK_HEAVY.getModel(), stack, matrixStack, buffer, light, overlay);
            }
        }
    }

    private void renderBarrelAndAttachments(PoseStack matrixStack, MultiBufferSource buffer, ItemStack stack, int light, int overlay) {
        boolean hasExtendedBarrel = false;
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.BARREL)) {
            if (Gun.getAttachment(IAttachment.Type.BARREL, stack).m_41720_() == ModItems.EXTENDED_BARREL.get()) {
                RenderUtil.renderModel(SpecialModels.COGLOADER_EXT_BARREL.getModel(), stack, matrixStack, buffer, light, overlay);
                hasExtendedBarrel = true;
            } else if (Gun.getAttachment(IAttachment.Type.BARREL, stack).m_41720_() == ModItems.SILENCER.get()) {
                RenderUtil.renderModel(SpecialModels.COGLOADER_SILENCER.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.BARREL, stack).m_41720_() == ModItems.MUZZLE_BRAKE.get()) {
                RenderUtil.renderModel(SpecialModels.COGLOADER_MUZZLE_BRAKE.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.BARREL, stack).m_41720_() == ModItems.ADVANCED_SILENCER.get()) {
                RenderUtil.renderModel(SpecialModels.COGLOADER_ADVANCED_SILENCER.getModel(), stack, matrixStack, buffer, light, overlay);
            }
        }
        if (!hasExtendedBarrel) {
            RenderUtil.renderModel(SpecialModels.COGLOADER_STAN_BARREL.getModel(), stack, matrixStack, buffer, light, overlay);
        }
    }

    private void renderUnderBarrelAttachments(PoseStack matrixStack, MultiBufferSource buffer, ItemStack stack, int light, int overlay) {
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.UNDER_BARREL)) {
            if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.VERTICAL_GRIP.get()) {
                RenderUtil.renderModel(SpecialModels.COGLOADER_GRIP_VERTICAL.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.LIGHT_GRIP.get()) {
                RenderUtil.renderModel(SpecialModels.COGLOADER_GRIP_LIGHT.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.IRON_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.COGLOADER_IRON_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.ANTHRALITE_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.COGLOADER_ANTHRALITE_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.DIAMOND_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.COGLOADER_DIAMOND_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.NETHERITE_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.COGLOADER_NETHERITE_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            }
        }
    }

    private void renderBoltAndMagazine(PoseStack matrixStack, MultiBufferSource buffer, ItemStack stack, int light, int overlay) {
        assert (Minecraft.m_91087_().f_91074_ != null);
        ItemCooldowns tracker = Minecraft.m_91087_().f_91074_.m_36335_();
        float cooldown = tracker.m_41521_(stack.m_41720_(), Minecraft.m_91087_().m_91296_());
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, -0.3625, 0.0);
        if (cooldown > 0.0f) {
            matrixStack.m_252880_(0.0f, 0.0f, cooldown / 6.0f);
            this.magazineRotation += (float)(5.0 * (1.0 - (double)cooldown));
            this.magazineRotation %= 360.0f;
        }
        matrixStack.m_85837_(0.0, 0.3625, 0.0);
        RenderUtil.renderModel(SpecialModels.COGLOADER_BOLT.getModel(), stack, matrixStack, buffer, light, overlay);
        matrixStack.m_85849_();
        this.renderMagazineRotation(matrixStack, buffer, stack, light, overlay);
    }

    private void renderMagazineRotation(PoseStack matrixStack, MultiBufferSource buffer, ItemStack stack, int light, int overlay) {
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, 0.0f, 0.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(this.magazineRotation));
        matrixStack.m_252880_(0.0f, 0.0f, 0.0f);
        RenderUtil.renderModel(SpecialModels.COGLOADER_MAGAZINE.getModel(), stack, matrixStack, buffer, light, overlay);
        matrixStack.m_85849_();
    }
}

