/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.render.gun.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.client.SpecialModels;
import top.ribs.scguns.client.render.gun.IOverrideModel;
import top.ribs.scguns.client.util.RenderUtil;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.init.ModItems;
import top.ribs.scguns.item.attachment.IAttachment;

public class ScratchesModel
implements IOverrideModel {
    private float barrelRotation = 0.0f;

    @Override
    public void render(float partialTicks, ItemDisplayContext transformType, ItemStack stack, ItemStack parent, LivingEntity entity, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        RenderUtil.renderModel(SpecialModels.SCRATCHES_MAIN.getModel(), stack, matrixStack, buffer, light, overlay);
        if (entity.equals((Object)Minecraft.m_91087_().f_91074_)) {
            this.renderBarrels(matrixStack, buffer, stack, light, overlay);
        }
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.STOCK)) {
            if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.WOODEN_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.SCRATCHES_STOCK_WOODEN.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.LIGHT_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.SCRATCHES_STOCK_LIGHT.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.WEIGHTED_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.SCRATCHES_STOCK_HEAVY.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.BUMP_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.SCRATCHES_STOCK_HEAVY.getModel(), stack, matrixStack, buffer, light, overlay);
            }
        }
    }

    private void renderBarrels(PoseStack matrixStack, MultiBufferSource buffer, ItemStack stack, int light, int overlay) {
        assert (Minecraft.m_91087_().f_91074_ != null);
        ItemCooldowns tracker = Minecraft.m_91087_().f_91074_.m_36335_();
        float cooldown = tracker.m_41521_(stack.m_41720_(), Minecraft.m_91087_().m_91296_());
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, -0.0, 0.0);
        if (cooldown > 0.0f) {
            this.barrelRotation += (float)(5.0 * (1.0 - (double)cooldown));
            this.barrelRotation %= 360.0f;
        }
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(this.barrelRotation));
        matrixStack.m_85837_(0.0, 0.0, 0.0);
        RenderUtil.renderModel(SpecialModels.SCRATCHES_BARREL.getModel(), stack, matrixStack, buffer, light, overlay);
        matrixStack.m_85849_();
    }
}

