/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.render.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import top.ribs.scguns.Config;
import top.ribs.scguns.client.handler.GunRenderingHandler;
import top.ribs.scguns.client.handler.ReloadHandler;
import top.ribs.scguns.client.render.pose.AimPose;
import top.ribs.scguns.client.render.pose.LimbPose;
import top.ribs.scguns.client.render.pose.WeaponPose;
import top.ribs.scguns.client.util.RenderUtil;
import top.ribs.scguns.common.GripType;
import top.ribs.scguns.item.animated.AnimatedGunItem;

public class MiniGunPose
extends WeaponPose {
    @Override
    protected AimPose getUpPose() {
        AimPose pose = new AimPose();
        pose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(10.0f, 0.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-100.0f).setRotationAngleY(-45.0f).setRotationAngleZ(0.0f).setRotationPointY(2.0f)).setLeftArm(new LimbPose().setRotationAngleX(-150.0f).setRotationAngleY(40.0f).setRotationAngleZ(-10.0f).setRotationPointY(1.0f));
        return pose;
    }

    @Override
    protected AimPose getForwardPose() {
        AimPose pose = new AimPose();
        pose.getIdle().setRenderYawOffset(45.0f).setRightArm(new LimbPose().setRotationAngleX(-15.0f).setRotationAngleY(-45.0f).setRotationAngleZ(0.0f).setRotationPointY(2.0f)).setLeftArm(new LimbPose().setRotationAngleX(-45.0f).setRotationAngleY(30.0f).setRotationAngleZ(0.0f).setRotationPointY(2.0f));
        return pose;
    }

    @Override
    protected AimPose getDownPose() {
        AimPose pose = new AimPose();
        pose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(-50.0f, 0.0f, 0.0f)).setItemTranslate(new Vector3f(0.0f, 0.0f, 1.0f)).setRightArm(new LimbPose().setRotationAngleX(0.0f).setRotationAngleY(-45.0f).setRotationAngleZ(0.0f).setRotationPointY(1.0f)).setLeftArm(new LimbPose().setRotationAngleX(-25.0f).setRotationAngleY(30.0f).setRotationAngleZ(15.0f).setRotationPointY(4.0f));
        return pose;
    }

    @Override
    protected AimPose getMeleePose() {
        AimPose meleePose = new AimPose();
        meleePose.getIdle().setRenderYawOffset(0.0f).setItemRotation(new Vector3f(0.0f, 0.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-90.0f).setRotationAngleY(0.0f).setRotationPointX(0.0f).setRotationPointY(0.0f).setRotationPointZ(0.0f)).setLeftArm(new LimbPose().setRotationAngleX(-90.0f).setRotationAngleY(0.0f).setRotationPointX(0.0f).setRotationPointY(0.0f).setRotationPointZ(0.0f));
        meleePose.getAiming().setRenderYawOffset(0.0f).setItemRotation(new Vector3f(0.0f, 0.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-90.0f).setRotationAngleY(0.0f).setRotationPointX(0.0f).setRotationPointY(0.0f).setRotationPointZ(0.0f)).setLeftArm(new LimbPose().setRotationAngleX(-90.0f).setRotationAngleY(0.0f).setRotationPointX(0.0f).setRotationPointY(0.0f).setRotationPointZ(0.0f));
        return meleePose;
    }

    @Override
    protected AimPose getBanzaiPose() {
        AimPose banzaiPose = new AimPose();
        banzaiPose.getIdle().setRenderYawOffset(0.0f).setItemRotation(new Vector3f(0.0f, 0.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-90.0f).setRotationAngleY(0.0f).setRotationPointX(0.0f).setRotationPointY(0.0f).setRotationPointZ(0.0f)).setLeftArm(new LimbPose().setRotationAngleX(-90.0f).setRotationAngleY(0.0f).setRotationPointX(0.0f).setRotationPointY(0.0f).setRotationPointZ(0.0f));
        return banzaiPose;
    }

    @Override
    protected boolean hasAimPose() {
        return false;
    }

    @Override
    public void applyPlayerModelRotation(Player player, ModelPart rightArm, ModelPart leftArm, ModelPart head, InteractionHand hand, float aimProgress) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            boolean right = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
            ModelPart mainArm = right ? rightArm : leftArm;
            ModelPart secondaryArm = right ? leftArm : rightArm;
            mainArm.f_104203_ = (float)Math.toRadians(-15.0);
            mainArm.f_104204_ = (float)Math.toRadians(-45.0) * (right ? 1.0f : -1.0f);
            mainArm.f_104205_ = (float)Math.toRadians(0.0);
            secondaryArm.f_104203_ = (float)Math.toRadians(-45.0);
            secondaryArm.f_104204_ = (float)Math.toRadians(30.0) * (right ? 1.0f : -1.0f);
            secondaryArm.f_104205_ = (float)Math.toRadians(0.0);
        } else {
            super.applyPlayerModelRotation(player, rightArm, leftArm, head, hand, aimProgress);
        }
        if (GunRenderingHandler.get().isThirdPersonMeleeAttacking()) {
            float banzaiProgress = GunRenderingHandler.get().getThirdPersonMeleeProgress();
            this.applyBanzaiPose(rightArm, leftArm, banzaiProgress);
        }
    }

    private void applyBanzaiPose(ModelPart rightArm, ModelPart leftArm, float banzaiProgress) {
        rightArm.f_104203_ = Mth.m_14179_((float)banzaiProgress, (float)rightArm.f_104203_, (float)((float)Math.toRadians(-90.0)));
        leftArm.f_104203_ = Mth.m_14179_((float)banzaiProgress, (float)leftArm.f_104203_, (float)((float)Math.toRadians(-90.0)));
    }

    @Override
    public void applyPlayerPreRender(Player player, InteractionHand hand, float aimProgress, PoseStack poseStack, MultiBufferSource buffer) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            boolean right = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
            player.f_20884_ = player.f_19859_ + 45.0f * (right ? 1.0f : -1.0f);
            player.f_20883_ = player.m_146908_() + 45.0f * (right ? 1.0f : -1.0f);
        } else {
            super.applyPlayerPreRender(player, hand, aimProgress, poseStack, buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyHeldItemTransforms(Player player, InteractionHand hand, float aimProgress, PoseStack poseStack, MultiBufferSource buffer) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            if (hand == InteractionHand.OFF_HAND) {
                poseStack.m_252880_(0.0f, -0.625f, 0.0f);
                poseStack.m_252880_(0.0f, 0.0f, -0.125f);
            }
        } else {
            super.applyHeldItemTransforms(player, hand, aimProgress, poseStack, buffer);
        }
    }

    @Override
    public boolean applyOffhandTransforms(Player player, PlayerModel model, ItemStack stack, PoseStack poseStack, float partialTicks) {
        return GripType.applyBackTransforms(player, poseStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonArms(Player player, HumanoidArm hand, ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, float partialTicks) {
        if (stack.m_41720_() instanceof AnimatedGunItem) {
            return;
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, player.m_9236_(), (LivingEntity)player, 0);
        float translateX = model.m_7442_().f_111790_.f_111756_.x();
        int side = hand.m_20828_() == HumanoidArm.RIGHT ? 1 : -1;
        poseStack.m_252880_(translateX * (float)side, 0.0f, 0.0f);
        boolean slim = Minecraft.m_91087_().f_91074_.m_108564_().equals("slim");
        float armWidth = slim ? 3.0f : 4.0f;
        poseStack.m_85836_();
        float reloadProgress = ReloadHandler.get().getReloadProgress(partialTicks);
        poseStack.m_85837_((double)reloadProgress * 0.5, (double)(-reloadProgress), (double)(-reloadProgress) * 0.5);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_85837_(0.25 * (double)side, 0.65, 0.0);
        poseStack.m_85837_((double)armWidth / 2.0 * 0.0625 * (double)side, 0.0, 0.0);
        poseStack.m_85837_(-0.55 * (double)side, -0.1, -1.25);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(110.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(25.0f * (float)(-side)));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(25.0f * (float)(-side)));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-35.0f));
        RenderUtil.renderFirstPersonArm((LocalPlayer)player, hand.m_20828_(), poseStack, buffer, light);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.1, -0.675);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_85837_(-0.25 * (double)side, 0.0, 0.0);
        poseStack.m_85837_(-((double)armWidth / 2.0) * 0.0625 * (double)side, 0.0, 0.0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(80.0f));
        RenderUtil.renderFirstPersonArm((LocalPlayer)player, hand, poseStack, buffer, light);
        poseStack.m_85849_();
    }

    @Override
    public boolean canApplySprintingAnimation() {
        return false;
    }
}

