/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.client.screen.GunBenchRecipe;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.C2SMessageSetBlueprintRecipe;

@OnlyIn(value=Dist.CLIENT)
public class BlueprintScreen
extends Screen {
    public static final ResourceLocation BLUEPRINT_TEXTURE = new ResourceLocation("scguns", "textures/gui/blueprint.png");
    protected static final int IMAGE_WIDTH = 192;
    protected static final int IMAGE_HEIGHT = 192;
    private static final int SLOT_SIZE = 16;
    private final List<RecipeSlot> recipeSlots = new ArrayList<RecipeSlot>();
    private final InteractionHand hand;
    private final ItemStack[] recipeItems = new ItemStack[12];
    private int currentPage = 0;
    private int maxPages = 0;
    private BlueprintPageButton nextPageButton;
    private BlueprintPageButton prevPageButton;
    private final ItemStack blueprintStack;
    private final List<DisplayEntry> displayEntries = new ArrayList<DisplayEntry>();
    private static final List<String> GUN_ORDER = new ArrayList<String>(Arrays.asList("flintlock_pistol", "handcannon", "musket", "blunderbuss", "doublet", "repeating_musket", "longarm", "fencer_carabine", "fencer_thumper", "laser_musket", "plasmabuss", "pax", "winnie", "winnie_millend", "red_raydar", "callwell", "callwell_conversion", "callwell_terminal", "saketini", "saketini_ironport", "big_bore", "scrapper", "rusty_gnat", "umax_pistol", "makeshift_rifle", "boomstick", "bruiser", "llr_director", "birdfeeder", "arc_worker", "defender_pistol", "trenchur", "greaser_smg", "m3_carabine", "m3_marksman", "combat_shotgun", "venturi", "iron_javelin", "iron_spear", "auvtomag", "pulsar", "gyrojet_pistol", "brawler", "crusader", "mk43_rifle", "rocket_rifle", "ultra_knight_hawk", "floundergat", "marlin", "bomb_lance", "hullbreaker", "sequoia", "mokova", "mak_mkii", "stilleto", "railworker", "stiletto", "turnpike", "killer_23", "homemaker", "kalaskah", "basker", "tl_runner", "stigg", "whizzbanger", "krauser", "soul_drummer", "uppercut", "micina", "valora", "prush_gun", "drill", "drill_conversion", "lockewood", "rg_jigsaw", "nailer", "inertial", "mas_55", "inquisitor", "plasgun", "cyclone", "shard_culler", "m22_waltz", "waltz_conversion", "osgood_50", "grandle_og", "grandle", "cogloader", "gale", "jackhammer", "howler", "howler_conversion", "gauss_rifle", "niami", "spitfire", "gattaler", "thunderhead", "scratches", "cr4k_mining_laser", "dozier_rl", "empty_blasphemy", "blasphemy", "pyroclastic_flow", "freyr", "mangalitsa", "vulcanic_repeater", "trotters", "super_shotgun", "whispers", "echoes_2", "sculk_resonator", "forlorn_hope", "carapice", "shellurker", "weevil", "dark_matter", "lone_wonder", "raygun", "prima_materia", "rat_king_and_queen", "locust", "sterilizer", "newborn_cyst", "earths_corpse", "flayed_god", "nervepinch", "terra_incognita", "astella", "exo_suit_helmet", "exo_suit_chestplate", "exo_suit_leggings", "exo_suit_boots"));
    private static final Map<ResourceLocation, List<String>> LORE_ONLY_ITEMS = new HashMap<ResourceLocation, List<String>>();

    public static void registerGunOrder(String itemName) {
        if (!GUN_ORDER.contains(itemName)) {
            GUN_ORDER.add(itemName);
        }
    }

    public static void registerGunOrder(List<String> itemNames) {
        for (String itemName : itemNames) {
            BlueprintScreen.registerGunOrder(itemName);
        }
    }

    public static void insertGunOrder(int index, String itemName) {
        if (!GUN_ORDER.contains(itemName)) {
            GUN_ORDER.add(Math.min(index, GUN_ORDER.size()), itemName);
        }
    }

    public static void registerLoreOnlyItem(ResourceLocation blueprintId, String itemName) {
        LORE_ONLY_ITEMS.computeIfAbsent(blueprintId, k -> new ArrayList()).add(itemName);
    }

    public static void registerLoreOnlyItems(ResourceLocation blueprintId, List<String> itemNames) {
        LORE_ONLY_ITEMS.computeIfAbsent(blueprintId, k -> new ArrayList()).addAll(itemNames);
    }

    public static List<String> getGunOrder() {
        return new ArrayList<String>(GUN_ORDER);
    }

    public static List<String> getLoreOnlyItems(ResourceLocation blueprintId) {
        return new ArrayList<String>(LORE_ONLY_ITEMS.getOrDefault(blueprintId, Collections.emptyList()));
    }

    public BlueprintScreen(ItemStack blueprintStack, Player player, InteractionHand hand) {
        super((Component)Component.m_237115_((String)"screen.scguns.blueprint.title"));
        this.blueprintStack = blueprintStack;
        this.hand = hand;
        Arrays.fill(this.recipeItems, ItemStack.f_41583_);
        this.loadAvailableEntries();
        this.loadActiveRecipeAsCurrentPage();
    }

    private void loadActiveRecipeAsCurrentPage() {
        ResourceLocation activeRecipeId = BlueprintScreen.getActiveRecipe(this.blueprintStack);
        if (activeRecipeId != null) {
            for (int i = 0; i < this.displayEntries.size(); ++i) {
                DisplayEntry entry = this.displayEntries.get(i);
                if (!entry.hasRecipe || !entry.recipe.m_6423_().equals((Object)activeRecipeId)) continue;
                this.currentPage = i;
                this.loadCurrentPageRecipe();
                return;
            }
        }
        this.loadCurrentPageRecipe();
    }

    private void loadCurrentPageRecipe() {
        if (this.currentPage < this.displayEntries.size()) {
            DisplayEntry entry = this.displayEntries.get(this.currentPage);
            if (entry.hasRecipe) {
                this.loadRecipeIntoSlots(entry.recipe);
            } else {
                this.loadLoreItemIntoSlots(entry.itemStack);
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.createMenuControls();
        this.setupRecipeSlots();
    }

    private void setupRecipeSlots() {
        this.recipeSlots.clear();
        int centerX = (this.f_96543_ - 192) / 2;
        int centerY = 2;
        this.recipeSlots.add(new RecipeSlot(centerX + 26, centerY + 17, 0));
        this.recipeSlots.add(new RecipeSlot(centerX + 44, centerY + 17, 1));
        this.recipeSlots.add(new RecipeSlot(centerX + 62, centerY + 17, 2));
        this.recipeSlots.add(new RecipeSlot(centerX + 80, centerY + 17, 3));
        this.recipeSlots.add(new RecipeSlot(centerX + 26, centerY + 35, 4));
        this.recipeSlots.add(new RecipeSlot(centerX + 44, centerY + 35, 5));
        this.recipeSlots.add(new RecipeSlot(centerX + 62, centerY + 35, 6));
        this.recipeSlots.add(new RecipeSlot(centerX + 80, centerY + 35, 7));
        this.recipeSlots.add(new RecipeSlot(centerX + 26, centerY + 53, 8));
        this.recipeSlots.add(new RecipeSlot(centerX + 62, centerY + 53, 9));
        this.recipeSlots.add(new RecipeSlot(centerX + 116, centerY + 17, 11));
        this.recipeSlots.add(new RecipeSlot(centerX + 140, centerY + 44, 10));
    }

    protected void createMenuControls() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 100, 196, 200, 20).m_253136_());
        DisplayEntry currentEntry = this.currentPage < this.displayEntries.size() ? this.displayEntries.get(this.currentPage) : null;
        boolean canSetRecipe = currentEntry != null && currentEntry.hasRecipe;
        Button setRecipeButton = Button.m_253074_((Component)Component.m_237115_((String)"screen.scguns.blueprint.button.set_recipe"), button -> this.setActiveRecipe()).m_252987_(this.f_96543_ / 2 - 100, 220, 200, 20).m_253136_();
        setRecipeButton.f_93623_ = canSetRecipe;
        this.m_142416_((GuiEventListener)setRecipeButton);
        this.createPageControls();
    }

    private void setActiveRecipe() {
        if (this.currentPage < this.displayEntries.size()) {
            DisplayEntry entry = this.displayEntries.get(this.currentPage);
            if (entry.hasRecipe) {
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageSetBlueprintRecipe(this.hand, entry.recipe.m_6423_().toString()));
                this.saveActiveRecipe(this.blueprintStack, entry.recipe);
            }
        }
        this.m_7379_();
    }

    private void createPageControls() {
        int centerX = (this.f_96543_ - 192) / 2;
        int centerY = 2;
        int buttonY = centerY + 192 - 40;
        int rightSide = centerX + 192 - 35;
        this.prevPageButton = (BlueprintPageButton)this.m_142416_((GuiEventListener)new BlueprintPageButton(rightSide - 40, buttonY, (Component)Component.m_237113_((String)"<"), button -> this.previousPage()));
        this.nextPageButton = (BlueprintPageButton)this.m_142416_((GuiEventListener)new BlueprintPageButton(rightSide - 15, buttonY, (Component)Component.m_237113_((String)">"), button -> this.nextPage()));
        this.updatePageButtonStates();
    }

    private void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.loadCurrentPageRecipe();
            this.updatePageButtonStates();
        }
    }

    private void nextPage() {
        if (this.currentPage < this.maxPages - 1) {
            ++this.currentPage;
            this.loadCurrentPageRecipe();
            this.updatePageButtonStates();
        }
    }

    private void updatePageButtonStates() {
        if (this.prevPageButton != null) {
            this.prevPageButton.f_93623_ = this.currentPage > 0;
            this.prevPageButton.f_93624_ = true;
        }
        if (this.nextPageButton != null) {
            this.nextPageButton.f_93623_ = this.currentPage < this.maxPages - 1;
            this.nextPageButton.f_93624_ = true;
        }
    }

    private void loadAvailableEntries() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        this.displayEntries.clear();
        List allRecipes = level.m_7465_().m_44013_((RecipeType)GunBenchRecipe.Type.INSTANCE);
        if (this.blueprintStack.m_41619_()) {
            for (GunBenchRecipe recipe : allRecipes) {
                this.displayEntries.add(new DisplayEntry(recipe));
            }
        } else {
            List<String> loreItems;
            for (GunBenchRecipe recipe : allRecipes) {
                if (!recipe.getBlueprint().test(this.blueprintStack)) continue;
                this.displayEntries.add(new DisplayEntry(recipe));
            }
            ResourceLocation blueprintItemId = ForgeRegistries.ITEMS.getKey((Object)this.blueprintStack.m_41720_());
            if (blueprintItemId != null && (loreItems = LORE_ONLY_ITEMS.get(blueprintItemId)) != null) {
                for (String itemName : loreItems) {
                    ResourceLocation itemLocation = new ResourceLocation(blueprintItemId.m_135827_(), itemName);
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
                    if (item == null) continue;
                    this.displayEntries.add(new DisplayEntry(new ItemStack((ItemLike)item)));
                }
            }
        }
        this.sortEntriesByProgression();
        this.maxPages = Math.max(1, this.displayEntries.size());
        this.currentPage = 0;
    }

    private void sortEntriesByProgression() {
        this.displayEntries.sort((entry1, entry2) -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return 0;
            }
            String item1Name = this.getItemNameFromEntry((DisplayEntry)entry1, (Level)level);
            String item2Name = this.getItemNameFromEntry((DisplayEntry)entry2, (Level)level);
            int index1 = this.getOrderIndex(item1Name);
            int index2 = this.getOrderIndex(item2Name);
            return Integer.compare(index1, index2);
        });
    }

    private String getItemNameFromEntry(DisplayEntry entry, Level level) {
        ResourceLocation itemLocation;
        ItemStack resultItem;
        ItemStack itemStack = resultItem = entry.hasRecipe ? entry.recipe.m_8043_(level.m_9598_()) : entry.itemStack;
        if (!resultItem.m_41619_() && (itemLocation = ForgeRegistries.ITEMS.getKey((Object)resultItem.m_41720_())) != null) {
            return itemLocation.m_135815_();
        }
        return "";
    }

    private int getOrderIndex(String itemName) {
        int index = GUN_ORDER.indexOf(itemName);
        return index == -1 ? Integer.MAX_VALUE : index;
    }

    private void loadRecipeIntoSlots(GunBenchRecipe recipe) {
        ItemStack[] blueprintStacks;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        this.clearRecipeItems();
        for (int i = 0; i < recipe.m_7527_().size() && i < 10; ++i) {
            ItemStack[] stacks;
            Ingredient ingredient = (Ingredient)recipe.m_7527_().get(i);
            if (ingredient.m_43947_() || (stacks = ingredient.m_43908_()).length <= 0) continue;
            this.recipeItems[i] = stacks[0].m_41777_();
        }
        if (!recipe.getBlueprint().m_43947_() && (blueprintStacks = recipe.getBlueprint().m_43908_()).length > 0) {
            this.recipeItems[11] = blueprintStacks[0].m_41777_();
        }
        this.recipeItems[10] = recipe.m_8043_(level.m_9598_()).m_41777_();
    }

    private void loadLoreItemIntoSlots(ItemStack item) {
        this.clearRecipeItems();
        this.recipeItems[10] = item.m_41777_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        int centerX = (this.f_96543_ - 192) / 2;
        int centerY = 2;
        guiGraphics.m_280218_(BLUEPRINT_TEXTURE, centerX, centerY, 0, 0, 192, 192);
        this.renderRecipeSlots(guiGraphics, mouseX, mouseY);
        this.renderGunInfo(guiGraphics, centerX, centerY);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderItemTooltips(guiGraphics, mouseX, mouseY);
    }

    private void renderGunInfo(GuiGraphics guiGraphics, int centerX, int centerY) {
        if (this.currentPage < this.displayEntries.size()) {
            ItemStack resultItem;
            DisplayEntry entry = this.displayEntries.get(this.currentPage);
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            ItemStack itemStack = resultItem = entry.hasRecipe ? entry.recipe.m_8043_(level.m_9598_()) : entry.itemStack;
            if (!resultItem.m_41619_()) {
                String gunName = Component.m_237115_((String)resultItem.m_41778_()).getString();
                PoseStack poseStack = guiGraphics.m_280168_();
                int titleY = centerY + 77;
                poseStack.m_85836_();
                poseStack.m_85841_(1.1f, 1.1f, 1.0f);
                int scaledX = (int)((float)(centerX + 30) / 1.1f);
                int scaledY = (int)((float)titleY / 1.1f);
                guiGraphics.m_280056_(this.f_96547_, gunName, scaledX, scaledY, 2170967, false);
                poseStack.m_85849_();
                Objects.requireNonNull(this.f_96547_);
                int titleHeight = (int)(9.0f * 1.1f);
                int descriptionY = titleY + titleHeight + 6;
                String gunRegistryName = resultItem.m_41720_().toString().replace("item.scguns.", "");
                String descriptionKey = "scguns.desc." + gunRegistryName;
                String description = Component.m_237115_((String)descriptionKey).getString();
                if (description.equals(descriptionKey)) {
                    description = Component.m_237115_((String)"scguns.desc.unknown").getString();
                }
                int maxWidth = 162;
                List<String> wrappedLines = this.wrapText(description, maxWidth);
                poseStack.m_85836_();
                poseStack.m_85841_(0.9f, 0.9f, 1.0f);
                for (int i = 0; i < wrappedLines.size(); ++i) {
                    int scaledDescX = (int)((float)(centerX + 22) / 0.9f);
                    Objects.requireNonNull(this.f_96547_);
                    int scaledDescY = (int)((float)(descriptionY + i * 9) / 0.9f);
                    guiGraphics.m_280056_(this.f_96547_, wrappedLines.get(i), scaledDescX, scaledDescY, 4868459, false);
                }
                poseStack.m_85849_();
            }
        }
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.isEmpty() ? word : currentLine + " " + word;
            if (this.f_96547_.m_92895_(testLine) <= maxWidth) {
                currentLine = new StringBuilder(testLine);
                continue;
            }
            if (!currentLine.isEmpty()) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private void renderRecipeSlots(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (RecipeSlot slot : this.recipeSlots) {
            ItemStack itemStack;
            boolean isHovered = this.isMouseOverSlot(slot, mouseX, mouseY);
            if (isHovered) {
                guiGraphics.m_280509_(slot.x, slot.y, slot.x + 16, slot.y + 16, -2130706433);
            }
            if ((itemStack = this.recipeItems[slot.index]).m_41619_()) continue;
            guiGraphics.m_280480_(itemStack, slot.x, slot.y);
            guiGraphics.m_280370_(this.f_96547_, itemStack, slot.x, slot.y);
        }
    }

    private void renderItemTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (RecipeSlot slot : this.recipeSlots) {
            if (!this.isMouseOverSlot(slot, mouseX, mouseY)) continue;
            ItemStack itemStack = this.recipeItems[slot.index];
            if (itemStack.m_41619_()) break;
            guiGraphics.m_280153_(this.f_96547_, itemStack, mouseX, mouseY);
            break;
        }
    }

    private boolean isMouseOverSlot(RecipeSlot slot, int mouseX, int mouseY) {
        return mouseX >= slot.x && mouseX < slot.x + 16 && mouseY >= slot.y && mouseY < slot.y + 16;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return switch (keyCode) {
            case 266 -> {
                if (this.prevPageButton.f_93623_) {
                    this.prevPageButton.m_5691_();
                }
                yield true;
            }
            case 267 -> {
                if (this.nextPageButton.f_93623_) {
                    this.nextPageButton.m_5691_();
                }
                yield true;
            }
            default -> false;
        };
    }

    public boolean m_7043_() {
        return false;
    }

    private void clearRecipeItems() {
        Arrays.fill(this.recipeItems, ItemStack.f_41583_);
    }

    private void saveActiveRecipe(ItemStack blueprint, GunBenchRecipe recipe) {
        blueprint.m_41784_().m_128359_("ActiveRecipe", recipe.m_6423_().toString());
    }

    public static ResourceLocation getActiveRecipe(ItemStack blueprint) {
        if (blueprint.m_41782_()) {
            assert (blueprint.m_41783_() != null);
            if (blueprint.m_41783_().m_128441_("ActiveRecipe")) {
                String recipeIdString = blueprint.m_41783_().m_128461_("ActiveRecipe");
                return new ResourceLocation(recipeIdString);
            }
        }
        return null;
    }

    public static String getActiveRecipeName(ItemStack blueprint) {
        ResourceLocation recipeId = BlueprintScreen.getActiveRecipe(blueprint);
        if (recipeId == null) {
            return null;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return null;
        }
        Optional<GunBenchRecipe> recipe = level.m_7465_().m_44013_((RecipeType)GunBenchRecipe.Type.INSTANCE).stream().filter(r -> r.m_6423_().equals((Object)recipeId)).findFirst();
        return recipe.map(arg_0 -> BlueprintScreen.lambda$getActiveRecipeName$8((Level)level, arg_0)).orElse(null);
    }

    private static /* synthetic */ String lambda$getActiveRecipeName$8(Level level, GunBenchRecipe gunBenchRecipe) {
        return gunBenchRecipe.m_8043_(level.m_9598_()).m_41611_().getString();
    }

    static {
        LORE_ONLY_ITEMS.put(new ResourceLocation("scguns", "piglin_blueprint"), new ArrayList<String>(Arrays.asList("blasphemy", "super_shotgun")));
    }

    private static class DisplayEntry {
        final GunBenchRecipe recipe;
        final ItemStack itemStack;
        final boolean hasRecipe;

        DisplayEntry(GunBenchRecipe recipe) {
            this.recipe = recipe;
            this.itemStack = null;
            this.hasRecipe = true;
        }

        DisplayEntry(ItemStack itemStack) {
            this.recipe = null;
            this.itemStack = itemStack;
            this.hasRecipe = false;
        }
    }

    private record RecipeSlot(int x, int y, int index) {
    }

    public static class BlueprintPageButton
    extends Button {
        public BlueprintPageButton(int x, int y, Component text, Button.OnPress onPress) {
            super(x, y, 20, 20, text, onPress, f_252438_);
        }

        public void m_7435_(SoundManager soundManager) {
            Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11713_, 1.0f, 1.0f);
        }
    }
}

