/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.screen;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.client.screen.ModMenuTypes;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitPouchHandler;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.C2SMessageSaveExoSuitUpgrades;

public class ExoSuitMenu
extends AbstractContainerMenu {
    public static final int ARMOR_SLOT = 0;
    public static final int UPGRADE_SLOT_1 = 1;
    public static final int UPGRADE_SLOT_2 = 2;
    public static final int UPGRADE_SLOT_3 = 3;
    public static final int UPGRADE_SLOT_4 = 4;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    public static final int EXOSUIT_INVENTORY_FIRST_SLOT_INDEX = 36;
    private final Player player;
    private final InteractionHand hand;
    private final ItemStackHandler exosuitInventory = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ExoSuitMenu.this.m_6199_(null);
            if (slot >= 1 && slot <= 4) {
                ExoSuitMenu.this.saveUpgradesToServer();
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return stack.m_41720_() instanceof ExoSuitItem;
            }
            return slot >= 1 && slot <= 4;
        }
    };

    public ExoSuitMenu(int id, Inventory playerInv, FriendlyByteBuf extraData) {
        this(id, playerInv, (InteractionHand)extraData.m_130066_(InteractionHand.class));
    }

    public ExoSuitMenu(int id, Inventory playerInv, InteractionHand hand) {
        super((MenuType)ModMenuTypes.EXOSUIT_MENU.get(), id);
        this.player = playerInv.f_35978_;
        this.hand = hand;
        this.addPlayerInventory(playerInv);
        this.addPlayerHotbar(playerInv);
        this.addExoSuitSlots();
        this.moveExoSuitToArmorSlot();
        this.loadUpgradesFromArmor();
    }

    private void moveExoSuitToArmorSlot() {
        ItemStack heldStack = this.player.m_21120_(this.hand);
        if (!heldStack.m_41619_() && heldStack.m_41720_() instanceof ExoSuitItem) {
            this.exosuitInventory.setStackInSlot(0, heldStack.m_41777_());
            this.player.m_21008_(this.hand, ItemStack.f_41583_);
        }
    }

    private void loadUpgradesFromArmor() {
        CompoundTag upgradeData;
        ItemStack armorPiece = this.getArmorPiece();
        if (!armorPiece.m_41619_() && armorPiece.m_41720_() instanceof ExoSuitItem && (upgradeData = ExoSuitData.getUpgradeData(armorPiece)).m_128441_("Upgrades")) {
            ListTag upgradeList = upgradeData.m_128437_("Upgrades", 10);
            for (int i = 0; i < upgradeList.size(); ++i) {
                CompoundTag slotTag = upgradeList.m_128728_(i);
                int slot = slotTag.m_128451_("Slot");
                if (slot < 0 || slot >= 4 || !slotTag.m_128441_("Item")) continue;
                ItemStack upgradeStack = ItemStack.m_41712_((CompoundTag)slotTag.m_128469_("Item"));
                this.exosuitInventory.setStackInSlot(1 + slot, upgradeStack);
            }
        }
    }

    private void saveUpgradesToServer() {
        if (this.player.m_9236_().f_46443_) {
            ArrayList<ItemStack> upgradeStacks = new ArrayList<ItemStack>();
            for (int i = 1; i <= 4; ++i) {
                upgradeStacks.add(this.exosuitInventory.getStackInSlot(i));
            }
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageSaveExoSuitUpgrades(upgradeStacks));
        }
    }

    public void m_6877_(@NotNull Player player) {
        ItemStack armorPiece;
        super.m_6877_(player);
        if (player.m_9236_().f_46443_) {
            this.saveUpgradesToServer();
        }
        if (!(armorPiece = this.exosuitInventory.getStackInSlot(0)).m_41619_()) {
            if (player.m_21120_(this.hand).m_41619_()) {
                player.m_21008_(this.hand, armorPiece);
            } else if (!player.m_150109_().m_36054_(armorPiece)) {
                player.m_36176_(armorPiece, false);
            }
        }
    }

    private void addExoSuitSlots() {
        this.m_38897_((Slot)new ExoSuitArmorSlot((IItemHandler)this.exosuitInventory, 0, 26, 35));
        this.m_38897_((Slot)new ExoSuitUpgradeSlot((IItemHandler)this.exosuitInventory, 1, 98, 26));
        this.m_38897_((Slot)new ExoSuitUpgradeSlot((IItemHandler)this.exosuitInventory, 2, 116, 26));
        this.m_38897_((Slot)new ExoSuitUpgradeSlot((IItemHandler)this.exosuitInventory, 3, 98, 44));
        this.m_38897_((Slot)new ExoSuitUpgradeSlot((IItemHandler)this.exosuitInventory, 4, 116, 44));
    }

    public ItemStack getArmorPiece() {
        return this.exosuitInventory.getStackInSlot(0);
    }

    public int getAvailableUpgradeSlots() {
        ItemStack armor = this.getArmorPiece();
        Item item = armor.m_41720_();
        if (item instanceof ExoSuitItem) {
            ExoSuitItem exosuit = (ExoSuitItem)item;
            return exosuit.getMaxUpgradeSlots();
        }
        return 0;
    }

    public boolean isUpgradeSlotEnabled(int upgradeSlotIndex) {
        if (upgradeSlotIndex < 1 || upgradeSlotIndex > 4) {
            return false;
        }
        int slotNumber = upgradeSlotIndex - 1 + 1;
        return slotNumber <= this.getAvailableUpgradeSlots();
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index >= 36 && index < 41) {
                if (index == 36) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(itemstack1, 0, 36, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index >= 0 && index < 36) {
                if (itemstack1.m_41720_() instanceof ExoSuitItem) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(itemstack1, 37, 41, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    private boolean canUpgradeGoInSlot(ExoSuitUpgrade upgrade, int slotIndex, ArmorItem.Type armorType) {
        String upgradeType = upgrade.getType();
        if (slotIndex == 0) {
            return upgradeType.equals("plating");
        }
        return switch (armorType) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.HELMET -> {
                switch (slotIndex) {
                    case 1: {
                        yield upgradeType.equals("hud");
                    }
                    case 2: {
                        yield upgradeType.equals("breathing");
                    }
                }
                yield false;
            }
            case ArmorItem.Type.CHESTPLATE -> {
                switch (slotIndex) {
                    case 1: {
                        yield upgradeType.equals("pauldron");
                    }
                    case 2: {
                        yield upgradeType.equals("power_core");
                    }
                    case 3: {
                        if (upgradeType.equals("utility") || upgradeType.equals("pouches")) {
                            yield true;
                        }
                        yield false;
                    }
                }
                yield false;
            }
            case ArmorItem.Type.LEGGINGS -> {
                switch (slotIndex) {
                    case 1: {
                        if (upgradeType.equals("knee_guard") || upgradeType.equals("plating")) {
                            yield true;
                        }
                        yield false;
                    }
                    case 2: {
                        yield upgradeType.equals("utility");
                    }
                }
                yield false;
            }
            case ArmorItem.Type.BOOTS -> {
                switch (slotIndex) {
                    case 1: {
                        yield upgradeType.equals("mobility");
                    }
                }
                yield false;
            }
        };
    }

    private static class ExoSuitArmorSlot
    extends SlotItemHandler {
        public ExoSuitArmorSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_41720_() instanceof ExoSuitItem;
        }

        public int m_6641_() {
            return 1;
        }

        public boolean m_8010_(Player player) {
            return false;
        }

        public void m_142406_(Player player, ItemStack stack) {
            super.m_142406_(player, stack);
            player.m_6915_();
        }
    }

    private class ExoSuitUpgradeSlot
    extends SlotItemHandler {
        public ExoSuitUpgradeSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            ItemStack armorPiece;
            Item item;
            if (!ExoSuitUpgradeManager.isUpgradeItem(stack)) {
                return false;
            }
            if (!ExoSuitMenu.this.isUpgradeSlotEnabled(this.getSlotIndex())) {
                return false;
            }
            ExoSuitUpgrade upgrade = ExoSuitUpgradeManager.getUpgradeForItem(stack);
            if (upgrade != null && (item = (armorPiece = ExoSuitMenu.this.getArmorPiece()).m_41720_()) instanceof ExoSuitItem) {
                ExoSuitItem exosuit = (ExoSuitItem)item;
                return ExoSuitMenu.this.canUpgradeGoInSlot(upgrade, this.getSlotIndex() - 1, exosuit.m_266204_());
            }
            return false;
        }

        public boolean m_8010_(Player player) {
            ItemStack armorPiece;
            ItemStack currentStack = this.m_7993_();
            if (currentStack.m_41619_()) {
                return true;
            }
            ExoSuitUpgrade upgrade = ExoSuitUpgradeManager.getUpgradeForItem(currentStack);
            if (upgrade != null && upgrade.getType().equals("pouches") && !ExoSuitPouchHandler.canRemovePouch(armorPiece = ExoSuitMenu.this.getArmorPiece(), currentStack)) {
                return false;
            }
            return super.m_8010_(player);
        }

        public boolean m_6659_() {
            return ExoSuitMenu.this.isUpgradeSlotEnabled(this.getSlotIndex());
        }

        public int m_6641_() {
            return 1;
        }

        public void m_142406_(Player player, ItemStack stack) {
            super.m_142406_(player, stack);
            if (player.m_9236_().f_46443_) {
                ExoSuitMenu.this.saveUpgradesToServer();
            }
        }

        public void m_5852_(ItemStack stack) {
            super.m_5852_(stack);
            if (!stack.m_41619_() && ExoSuitMenu.this.player.m_9236_().f_46443_) {
                ExoSuitUpgradeManager.getUpgradeForItem(stack);
            }
        }
    }
}

