/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;

public class LightningBatteryRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient input;
    private final ItemStack output;
    private final int processingTime;
    private final int energyUse;

    public LightningBatteryRecipe(ResourceLocation id, Ingredient input, ItemStack output, int processingTime, int energyUse) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.processingTime = processingTime;
        this.energyUse = energyUse;
    }

    public boolean m_5818_(Container container, Level level) {
        return this.input.test(container.m_8020_(0));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getEnergyUse() {
        return this.energyUse;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<LightningBatteryRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("scguns", "lightning_battery");

        public LightningBatteryRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("ingredients").getAsJsonArray().get(0));
            ItemStack output = CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("result"), (boolean)true);
            int processingTime = json.get("processingTime").getAsInt();
            int requiredEnergy = json.get("requiredEnergy").getAsInt();
            return new LightningBatteryRecipe(recipeId, input, output, processingTime, requiredEnergy);
        }

        public LightningBatteryRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            int processingTime = buffer.readInt();
            int requiredEnergy = buffer.readInt();
            return new LightningBatteryRecipe(recipeId, input, output, processingTime, requiredEnergy);
        }

        public void toNetwork(FriendlyByteBuf buffer, LightningBatteryRecipe recipe) {
            recipe.getInput().m_43923_(buffer);
            buffer.m_130055_(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
            buffer.writeInt(recipe.getProcessingTime());
            buffer.writeInt(recipe.getEnergyUse());
        }
    }

    public static class Type
    implements RecipeType<LightningBatteryRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "lightning_battery";
    }
}

