/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.screen;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import top.ribs.scguns.blockentity.MechanicalPressBlockEntity;
import top.ribs.scguns.client.screen.MechanicalPressRecipe;
import top.ribs.scguns.client.screen.ModMenuTypes;
import top.ribs.scguns.init.ModBlocks;

public class MechanicalPressMenu
extends AbstractContainerMenu {
    public final MechanicalPressBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;

    public MechanicalPressMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(4));
    }

    public MechanicalPressMenu(int id, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.MECHANICAL_PRESS_MENU.get(), id);
        MechanicalPressMenu.m_38869_((Container)inv, (int)6);
        this.blockEntity = (MechanicalPressBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            int yLevel = 27;
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 26, yLevel));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 44, yLevel));
            this.m_38897_((Slot)new SlotItemHandler(handler, 2, 62, yLevel));
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 3, 44, 45){

                public boolean m_5857_(ItemStack stack) {
                    return true;
                }
            });
            this.m_38897_((Slot)new SlotItemHandler(handler, 4, 86, 62));
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 5, 114, 27){

                public boolean m_5857_(ItemStack stack) {
                    return false;
                }
            });
        });
        this.m_38884_(data);
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public boolean hasFuel() {
        return this.data.m_6413_(2) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        int progressArrowSize = 24;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public int getScaledFuelProgress() {
        int fuelTime = this.data.m_6413_(2);
        int maxFuelTime = this.data.m_6413_(3);
        int fuelProgressSize = 14;
        return maxFuelTime != 0 && fuelTime != 0 ? fuelTime * fuelProgressSize / maxFuelTime : 0;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            int fuelSlotIndex = 40;
            int outputSlotIndex = 41;
            int moldSlotIndex = 39;
            if (index == outputSlotIndex) {
                if (!this.m_38903_(itemstack1, 0, 36, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index >= 0 && index < 36 ? (this.isFuel(itemstack1) ? !this.m_38903_(itemstack1, fuelSlotIndex, fuelSlotIndex + 1, false) : (this.isInputItem(itemstack1) ? !this.m_38903_(itemstack1, 36, 39, false) : (this.isMoldItem(itemstack1) ? !this.m_38903_(itemstack1, moldSlotIndex, moldSlotIndex + 1, false) : (index >= 0 && index < 27 ? !this.m_38903_(itemstack1, 27, 36, false) : index >= 27 && index < 36 && !this.m_38903_(itemstack1, 0, 27, false))))) : !this.m_38903_(itemstack1, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return MechanicalPressMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)ModBlocks.MECHANICAL_PRESS.get()));
    }

    private boolean isMoldItem(ItemStack stack) {
        if (this.level == null) {
            return false;
        }
        RecipeManager recipeManager = this.level.m_7465_();
        return recipeManager.m_44013_((RecipeType)MechanicalPressRecipe.Type.INSTANCE).stream().anyMatch(recipe -> recipe.getMoldItem().test(stack));
    }

    private boolean isInputItem(ItemStack stack) {
        if (this.level == null) {
            return false;
        }
        RecipeManager recipeManager = this.level.m_7465_();
        return recipeManager.m_44013_((RecipeType)MechanicalPressRecipe.Type.INSTANCE).stream().flatMap(recipe -> recipe.m_7527_().stream()).anyMatch(ingredient -> ingredient.test(stack));
    }

    private boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

