/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.util;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;

public enum Easings implements StringRepresentable
{
    LINEAR("linear", t -> t),
    EASE_IN_QUAD("ease_in_quad", Mth::m_14207_),
    EASE_IN_CUBIC("ease_in_cubic", t -> Float.valueOf((float)Math.pow(t.floatValue(), 3.0))),
    EASE_IN_CIRC("ease_in_circ", t -> Float.valueOf(1.0f - Mth.m_14116_((float)(1.0f - Mth.m_14207_((float)t.floatValue()))))),
    EASE_OUT_QUAD("ease_out_quad", t -> Float.valueOf(1.0f - Mth.m_14207_((float)(1.0f - t.floatValue())))),
    EASE_OUT_CUBIC("ease_out_cubic", t -> Float.valueOf(1.0f - (float)Math.pow(1.0f - t.floatValue(), 3.0))),
    EASE_OUT_CIRC("ease_out_circ", t -> Float.valueOf(Mth.m_14116_((float)(1.0f - Mth.m_14207_((float)(t.floatValue() - 1.0f)))))),
    EASE_IN_OUT_QUAD("ease_in_out_quad", t -> Float.valueOf(t.floatValue() < 0.5f ? 2.0f * Mth.m_14207_((float)t.floatValue()) : 1.0f - Mth.m_14207_((float)(-2.0f * t.floatValue() + 2.0f)) / 2.0f)),
    EASE_IN_OUT_CUBIC("ease_in_out_cubic", t -> Float.valueOf(t.floatValue() < 0.5f ? 4.0f * (float)Math.pow(t.floatValue(), 3.0) : 1.0f - (float)Math.pow(-2.0f * t.floatValue() + 2.0f, 3.0) / 2.0f)),
    EASE_IN_OUT_CIRC("ease_in_out_circ", t -> Float.valueOf(t.floatValue() < 0.5f ? (1.0f - Mth.m_14116_((float)(1.0f - Mth.m_14207_((float)(2.0f * t.floatValue()))))) / 2.0f : (Mth.m_14116_((float)(1.0f - Mth.m_14207_((float)(-2.0f * t.floatValue() + 2.0f)))) + 1.0f) / 2.0f)),
    HALF_EASE_IN("half_ease_in", t -> Float.valueOf(t.floatValue() > 0.5f ? EASE_IN_QUAD.apply((t.floatValue() - 0.5f) / 0.5f) : 0.0f)),
    ZERO("zero", t -> Float.valueOf(0.0f));

    private static final Map<String, Easings> BY_NAME;
    private final String name;
    private final Function<Float, Float> function;

    private Easings(String name, Function<Float, Float> function) {
        this.name = name;
        this.function = function;
    }

    public float apply(float time) {
        return this.function.apply(Float.valueOf(time)).floatValue();
    }

    public double apply(double time) {
        return this.function.apply(Float.valueOf(Double.valueOf(time).floatValue())).floatValue();
    }

    public String getName() {
        return this.name;
    }

    public static Easings byName(String name) {
        return BY_NAME.getOrDefault(name, LINEAR);
    }

    public String m_7912_() {
        return this.name;
    }

    static {
        BY_NAME = Arrays.stream(Easings.values()).collect(Collectors.toMap(easing -> easing.name, easing -> easing));
    }
}

