/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.C2SMessageChargeSync;

public class ChargeHandler {
    private static final Map<UUID, Integer> playerChargeTime = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> playerMaxChargeTime = new HashMap<UUID, Integer>();
    private static final Map<UUID, Float> lastChargeProgress = new HashMap<UUID, Float>();

    public static int getChargeTime(UUID playerId) {
        return playerChargeTime.getOrDefault(playerId, 0);
    }

    public static void updateChargeTime(Player player, ItemStack weapon, boolean isCharging) {
        Item item = weapon.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        UUID playerId = player.m_20148_();
        Gun modifiedGun = gunItem.getModifiedGun(weapon);
        int maxChargeTime = modifiedGun.getGeneral().getFireTimer();
        playerMaxChargeTime.put(playerId, maxChargeTime);
        if (isCharging) {
            boolean hasAmmo;
            boolean bl = hasAmmo = Gun.hasAmmo(weapon) || player.m_7500_();
            if (!hasAmmo) {
                playerChargeTime.remove(playerId);
                lastChargeProgress.remove(playerId);
                if (player.m_9236_().m_5776_()) {
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageChargeSync(0.0f));
                }
            } else {
                int currentCharge = playerChargeTime.getOrDefault(playerId, 0);
                if (++currentCharge > maxChargeTime) {
                    currentCharge = maxChargeTime;
                }
                playerChargeTime.put(playerId, currentCharge);
                float progress = maxChargeTime > 0 ? Math.min(1.0f, (float)currentCharge / (float)maxChargeTime) : 0.0f;
                lastChargeProgress.put(playerId, Float.valueOf(progress));
                if (player.m_9236_().m_5776_()) {
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageChargeSync(progress));
                }
            }
        } else {
            playerChargeTime.remove(playerId);
            lastChargeProgress.remove(playerId);
            if (player.m_9236_().m_5776_()) {
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageChargeSync(0.0f));
            }
        }
    }

    public static void resetCharge(UUID playerId) {
        playerChargeTime.remove(playerId);
        playerMaxChargeTime.remove(playerId);
        lastChargeProgress.remove(playerId);
    }

    public static float getChargeProgress(@Nullable Player player, ItemStack weapon) {
        if (player == null || !(weapon.m_41720_() instanceof GunItem)) {
            return 0.0f;
        }
        UUID playerId = player.m_20148_();
        return lastChargeProgress.getOrDefault(playerId, Float.valueOf(0.0f)).floatValue();
    }

    public static void clearLastChargeProgress(UUID playerId) {
        lastChargeProgress.remove(playerId);
    }
}

