/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.ScorchedGuns;
import top.ribs.scguns.annotation.Ignored;
import top.ribs.scguns.annotation.Optional;
import top.ribs.scguns.client.ClientHandler;
import top.ribs.scguns.common.AmmoContext;
import top.ribs.scguns.common.FireMode;
import top.ribs.scguns.common.GripType;
import top.ribs.scguns.common.ReloadType;
import top.ribs.scguns.common.exosuit.ExoSuitAmmoHelper;
import top.ribs.scguns.debug.Debug;
import top.ribs.scguns.debug.IDebugWidget;
import top.ribs.scguns.debug.IEditorMenu;
import top.ribs.scguns.debug.client.screen.widget.DebugButton;
import top.ribs.scguns.debug.client.screen.widget.DebugSlider;
import top.ribs.scguns.debug.client.screen.widget.DebugToggle;
import top.ribs.scguns.init.ModEnchantments;
import top.ribs.scguns.item.AmmoBoxItem;
import top.ribs.scguns.item.ExtendedBarrelItem;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.LaserSightItem;
import top.ribs.scguns.item.ScopeItem;
import top.ribs.scguns.item.StockItem;
import top.ribs.scguns.item.attachment.IAttachment;
import top.ribs.scguns.item.attachment.impl.Scope;
import top.ribs.scguns.util.GunJsonUtil;
import top.ribs.scguns.util.SuperBuilder;
import top.theillusivec4.curios.api.CuriosApi;

public class Gun
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    protected General general = new General();
    protected Reloads reloads = new Reloads();
    protected Projectile projectile = new Projectile();
    protected Sounds sounds = new Sounds();
    protected Display display = new Display();
    protected Modules modules = new Modules();
    private final GripType baseGripType = GripType.ONE_HANDED;

    public double getIdealAttackRange() {
        return switch (this.general.getWeaponType()) {
            default -> throw new IncompatibleClassChangeError();
            case WeaponType.pistol, WeaponType.magnum, WeaponType.smg, WeaponType.shotgun, WeaponType.flamethrower -> 12.0;
            case WeaponType.rifle, WeaponType.lmg, WeaponType.plasma, WeaponType.shock, WeaponType.heavy, WeaponType.special -> 18.0;
            case WeaponType.laser, WeaponType.sniper -> 30.0;
        };
    }

    public double getMinAttackRange() {
        return switch (this.general.getWeaponType()) {
            default -> throw new IncompatibleClassChangeError();
            case WeaponType.shotgun, WeaponType.flamethrower -> 1.0;
            case WeaponType.pistol, WeaponType.magnum, WeaponType.smg -> 2.0;
            case WeaponType.rifle, WeaponType.lmg, WeaponType.plasma, WeaponType.shock, WeaponType.heavy, WeaponType.special -> 2.5;
            case WeaponType.laser, WeaponType.sniper -> 3.0;
        };
    }

    public static int getMaxAmmo(ItemStack stack) {
        return ((GunItem)stack.m_41720_()).getModifiedGun(stack).getReloads().getMaxAmmo();
    }

    public static int getAmmoCount(ItemStack stack) {
        return stack.m_41784_().m_128451_("AmmoCount");
    }

    public static boolean hasAmmo(ItemStack heldItem) {
        return Gun.getAmmoCount(heldItem) > 0;
    }

    public static boolean hasUnlimitedReloads(ItemStack heldItem) {
        return ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem).getReloads().getInfiniteAmmo();
    }

    public static int getBurstCooldown(ItemStack stack) {
        return ((GunItem)stack.m_41720_()).getModifiedGun(stack).getGeneral().getBurstCooldown();
    }

    public GripType determineGripType(ItemStack stack) {
        GunItem gunItem;
        GripType baseGripType = this.general.getBaseGripType();
        Item item = stack.m_41720_();
        if (item instanceof GunItem && (gunItem = (GunItem)item).isOneHandedCarbineCandidate(stack) && (Gun.hasExtendedBarrel(stack) || Gun.hasStock(stack))) {
            return GripType.TWO_HANDED;
        }
        return baseGripType;
    }

    public GripType getBaseGripType() {
        return this.baseGripType;
    }

    public static boolean hasExtendedBarrel(ItemStack stack) {
        for (IAttachment.Type type : IAttachment.Type.values()) {
            ItemStack attachmentStack = Gun.getAttachment(type, stack);
            if (!(attachmentStack.m_41720_() instanceof ExtendedBarrelItem)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStock(ItemStack stack) {
        for (IAttachment.Type type : IAttachment.Type.values()) {
            ItemStack attachmentStack = Gun.getAttachment(type, stack);
            if (!(attachmentStack.m_41720_() instanceof StockItem)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBurstFire(ItemStack stack) {
        return ((GunItem)stack.m_41720_()).getModifiedGun(stack).getGeneral().getFireMode() == FireMode.BURST;
    }

    public static boolean canShoot(ItemStack heldItem) {
        return !Gun.hasBurstFire(heldItem) || Gun.getFireTimer(heldItem) == 0;
    }

    public static int getBurstCount(ItemStack heldItem) {
        return ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem).getGeneral().getBurstAmount();
    }

    public General getGeneral() {
        return this.general;
    }

    public Reloads getReloads() {
        return this.reloads;
    }

    public Projectile getProjectile() {
        return this.projectile;
    }

    public Sounds getSounds() {
        return this.sounds;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Modules getModules() {
        return this.modules;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237115_((String)"Gun");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ItemStack heldItem = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_21205_();
            ItemStack scope = Gun.getScopeStack(heldItem);
            Item patt6787$temp = scope.m_41720_();
            if (patt6787$temp instanceof ScopeItem) {
                ScopeItem scopeItem = (ScopeItem)patt6787$temp;
                widgets.add(Pair.of((Object)scope.m_41720_().m_7626_(scope), () -> new DebugButton((Component)Component.m_237115_((String)"Edit"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(Debug.getScope(scopeItem))))));
            }
            widgets.add(Pair.of((Object)this.modules.getEditorLabel(), () -> new DebugButton((Component)Component.m_237115_((String)">"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(this.modules)))));
        });
    }

    public static int getFireTimer(ItemStack stack) {
        return stack.m_41784_().m_128451_("FireTimer");
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("General", (Tag)this.general.serializeNBT());
        tag.m_128365_("Reloads", (Tag)this.reloads.serializeNBT());
        tag.m_128365_("Projectile", (Tag)this.projectile.serializeNBT());
        tag.m_128365_("Sounds", (Tag)this.sounds.serializeNBT());
        tag.m_128365_("Display", (Tag)this.display.serializeNBT());
        tag.m_128365_("Modules", (Tag)this.modules.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("General", 10)) {
            this.general.deserializeNBT(tag.m_128469_("General"));
        }
        if (tag.m_128425_("Reloads", 10)) {
            this.reloads.deserializeNBT(tag.m_128469_("Reloads"));
        }
        if (tag.m_128425_("Projectile", 10)) {
            this.projectile.deserializeNBT(tag.m_128469_("Projectile"));
        }
        if (tag.m_128425_("Sounds", 10)) {
            this.sounds.deserializeNBT(tag.m_128469_("Sounds"));
        }
        if (tag.m_128425_("Display", 10)) {
            this.display.deserializeNBT(tag.m_128469_("Display"));
        }
        if (tag.m_128425_("Modules", 10)) {
            this.modules.deserializeNBT(tag.m_128469_("Modules"));
        }
    }

    public JsonObject toJsonObject() {
        JsonObject object = new JsonObject();
        object.add("general", (JsonElement)this.general.toJsonObject());
        object.add("reloads", (JsonElement)this.reloads.toJsonObject());
        object.add("projectile", (JsonElement)this.projectile.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "sounds", this.sounds.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "display", this.display.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "modules", this.modules.toJsonObject());
        return object;
    }

    public static Gun create(CompoundTag tag) {
        Gun gun = new Gun();
        gun.deserializeNBT(tag);
        if (tag.m_128425_("MeleeDamage", 99)) {
            gun.getGeneral().setMeleeDamage(tag.m_128457_("MeleeDamage"));
        }
        return gun;
    }

    public Gun copy() {
        Gun gun = new Gun();
        gun.general = this.general.copy();
        gun.reloads = this.reloads.copy();
        gun.projectile = this.projectile.copy();
        gun.sounds = this.sounds.copy();
        gun.display = this.display.copy();
        gun.modules = this.modules.copy();
        return gun;
    }

    public boolean canAttachType(@javax.annotation.Nullable IAttachment.Type type) {
        if (this.modules.attachments != null && type != null) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case IAttachment.Type.SCOPE -> {
                    if (this.modules.attachments.scope != null) {
                        yield true;
                    }
                    yield false;
                }
                case IAttachment.Type.BARREL -> {
                    if (this.modules.attachments.barrel != null) {
                        yield true;
                    }
                    yield false;
                }
                case IAttachment.Type.STOCK -> {
                    if (this.modules.attachments.stock != null) {
                        yield true;
                    }
                    yield false;
                }
                case IAttachment.Type.UNDER_BARREL -> {
                    if (this.modules.attachments.underBarrel != null) {
                        yield true;
                    }
                    yield false;
                }
                case IAttachment.Type.MAGAZINE -> this.modules.attachments.magazine != null;
            };
        }
        return false;
    }

    @javax.annotation.Nullable
    public ScaledPositioned getAttachmentPosition(IAttachment.Type type) {
        if (this.modules.attachments != null) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case IAttachment.Type.SCOPE -> this.modules.attachments.scope;
                case IAttachment.Type.BARREL -> this.modules.attachments.barrel;
                case IAttachment.Type.STOCK -> this.modules.attachments.stock;
                case IAttachment.Type.UNDER_BARREL -> this.modules.attachments.underBarrel;
                case IAttachment.Type.MAGAZINE -> this.modules.attachments.magazine;
            };
        }
        return null;
    }

    public boolean canAimDownSight() {
        return this.canAttachType(IAttachment.Type.SCOPE) || this.modules.zoom != null;
    }

    public static ItemStack getScopeStack(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Scope", 10)) {
            return ItemStack.m_41712_((CompoundTag)attachment.m_128469_("Scope"));
        }
        return ItemStack.f_41583_;
    }

    public static boolean hasAttachmentEquipped(ItemStack stack, Gun gun, IAttachment.Type type) {
        if (!gun.canAttachType(type)) {
            return false;
        }
        CompoundTag compound = stack.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10)) {
            CompoundTag attachment = compound.m_128469_("Attachments");
            return attachment.m_128425_(type.getTagKey(), 10);
        }
        return false;
    }

    public static boolean hasCustomAttachment(ItemStack stack, IAttachment.Type type, Item customAttachment) {
        CompoundTag attachment;
        CompoundTag compound = stack.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_(type.getTagKey(), 10)) {
            ItemStack attachmentStack = ItemStack.m_41712_((CompoundTag)attachment.m_128469_(type.getTagKey()));
            return attachmentStack.m_41720_() == customAttachment;
        }
        return false;
    }

    public static boolean hasAttachmentEquipped(ItemStack stack, IAttachment.Type type) {
        CompoundTag compound = stack.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10)) {
            CompoundTag attachment = compound.m_128469_("Attachments");
            return attachment.m_128425_(type.getTagKey(), 10);
        }
        return false;
    }

    public static ItemStack getAttachment(IAttachment.Type type, ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_(type.getTagKey(), 10)) {
            return ItemStack.m_41712_((CompoundTag)attachment.m_128469_(type.getTagKey()));
        }
        return ItemStack.f_41583_;
    }

    @javax.annotation.Nullable
    public static Scope getScope(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Scope", 10)) {
            ItemStack scopeStack = ItemStack.m_41712_((CompoundTag)attachment.m_128469_("Scope"));
            Scope scope = null;
            Item item = scopeStack.m_41720_();
            if (item instanceof ScopeItem) {
                ScopeItem scopeItem = (ScopeItem)item;
                if (ScorchedGuns.isDebugging()) {
                    return Debug.getScope(scopeItem);
                }
                scope = scopeItem.getProperties();
            }
            return scope;
        }
        return null;
    }

    public static boolean hasLaserSight(ItemStack gun) {
        return Gun.hasAttachmentEquipped(gun, IAttachment.Type.SCOPE) && Gun.getAttachment(IAttachment.Type.SCOPE, gun).m_41720_() instanceof LaserSightItem;
    }

    public static void removeAttachment(ItemStack gun, String attachmentStack) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_(attachmentStack, 10)) {
            attachment.m_128473_(attachmentStack);
        }
    }

    public static ItemStack removeScopeStack(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Scope", 10)) {
            attachment.m_128473_("Scope");
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack removeBarrelStack(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Barrel", 10)) {
            attachment.m_128473_("Barrel");
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack removeStockStack(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Stock", 10)) {
            attachment.m_128473_("Stock");
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack removeUnderBarrelStack(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Under_Barrel", 10)) {
            attachment.m_128473_("Under_Barrel");
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack removeMagazineStack(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Magazine", 10)) {
            attachment.m_128473_("Magazine");
        }
        return ItemStack.f_41583_;
    }

    public static float getAdditionalDamage(ItemStack gunStack) {
        CompoundTag tag = gunStack.m_41784_();
        return tag.m_128457_("AdditionalDamage");
    }

    public static AmmoContext findAmmo(Player player, Item item) {
        if (player.m_7500_()) {
            ItemStack ammo = new ItemStack((ItemLike)item, Integer.MAX_VALUE);
            return new AmmoContext(ammo, null);
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!Gun.isAmmo(stack, item)) continue;
            return new AmmoContext(stack, (Container)player.m_150109_());
        }
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            Item item2 = itemStack.m_41720_();
            if (!(item2 instanceof AmmoBoxItem)) continue;
            AmmoBoxItem pouch = (AmmoBoxItem)item2;
            List<ItemStack> contents = AmmoBoxItem.getContents(itemStack).toList();
            for (ItemStack ammoStack : contents) {
                if (!Gun.isAmmo(ammoStack, item)) continue;
                return new AmmoContext(ammoStack, null);
            }
        }
        ItemStack exoSuitAmmo = ExoSuitAmmoHelper.findAmmoInExoSuit(player, item);
        if (!exoSuitAmmo.m_41619_()) {
            return new AmmoContext(exoSuitAmmo, null);
        }
        AtomicReference<AmmoContext> ammoContextRef = new AtomicReference<AmmoContext>(AmmoContext.NONE);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            IItemHandlerModifiable curios = handler.getEquippedCurios();
            for (int i = 0; i < curios.getSlots(); ++i) {
                ItemStack stack = curios.getStackInSlot(i);
                Item patt107226$temp = stack.m_41720_();
                if (!(patt107226$temp instanceof AmmoBoxItem)) continue;
                AmmoBoxItem pouch = (AmmoBoxItem)patt107226$temp;
                List<ItemStack> contents = AmmoBoxItem.getContents(stack).toList();
                for (ItemStack ammoStack : contents) {
                    if (!Gun.isAmmo(ammoStack, item)) continue;
                    ammoContextRef.set(new AmmoContext(ammoStack, null));
                    return;
                }
            }
        });
        return ammoContextRef.get();
    }

    public static boolean isAmmo(ItemStack stack, Item item) {
        return stack != null && stack.m_41720_() == item;
    }

    public static ItemStack[] findAmmoStack(Player player, Item item) {
        if (player.m_7500_()) {
            return new ItemStack[]{new ItemStack((ItemLike)item, Integer.MAX_VALUE)};
        }
        ArrayList<ItemStack> ammoStacks = new ArrayList<ItemStack>();
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41720_() != item) continue;
            ammoStacks.add(stack);
        }
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            Item item2 = itemStack.m_41720_();
            if (!(item2 instanceof AmmoBoxItem)) continue;
            AmmoBoxItem pouch = (AmmoBoxItem)item2;
            List<ItemStack> contents = AmmoBoxItem.getContents(itemStack).toList();
            for (ItemStack ammoStack : contents) {
                if (ammoStack.m_41720_() != item) continue;
                ammoStacks.add(ammoStack);
            }
        }
        List<ItemStack> exoSuitAmmo = ExoSuitAmmoHelper.findAllAmmoInExoSuit(player, item);
        ammoStacks.addAll(exoSuitAmmo);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            IItemHandlerModifiable curios = handler.getEquippedCurios();
            for (int i = 0; i < curios.getSlots(); ++i) {
                ItemStack stack = curios.getStackInSlot(i);
                if (!(stack.m_41720_() instanceof AmmoBoxItem)) continue;
                List<ItemStack> contents = AmmoBoxItem.getContents(stack).toList();
                for (ItemStack ammoStack : contents) {
                    if (ammoStack.m_41720_() != item) continue;
                    ammoStacks.add(ammoStack);
                }
            }
        });
        return ammoStacks.toArray(new ItemStack[0]);
    }

    public static int getReserveAmmoCount(Player player, Item item) {
        if (player.m_7500_()) {
            return Integer.MAX_VALUE;
        }
        AtomicInteger ammoCount = new AtomicInteger();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!Gun.isAmmo(stack, item)) continue;
            ammoCount.addAndGet(stack.m_41613_());
        }
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            Item item2 = itemStack.m_41720_();
            if (!(item2 instanceof AmmoBoxItem)) continue;
            AmmoBoxItem pouch = (AmmoBoxItem)item2;
            List<ItemStack> contents = AmmoBoxItem.getContents(itemStack).toList();
            for (ItemStack ammoStack : contents) {
                if (!Gun.isAmmo(ammoStack, item)) continue;
                ammoCount.addAndGet(ammoStack.m_41613_());
            }
        }
        int exoSuitAmmoCount = ExoSuitAmmoHelper.getAmmoCountInExoSuit(player, item);
        ammoCount.addAndGet(exoSuitAmmoCount);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            IItemHandlerModifiable curios = handler.getEquippedCurios();
            for (int i = 0; i < curios.getSlots(); ++i) {
                ItemStack stack = curios.getStackInSlot(i);
                Item patt111322$temp = stack.m_41720_();
                if (!(patt111322$temp instanceof AmmoBoxItem)) continue;
                AmmoBoxItem pouch = (AmmoBoxItem)patt111322$temp;
                List<ItemStack> contents = AmmoBoxItem.getContents(stack).toList();
                for (ItemStack ammoStack : contents) {
                    if (!Gun.isAmmo(ammoStack, item)) continue;
                    ammoCount.addAndGet(ammoStack.m_41613_());
                }
            }
        });
        return ammoCount.get();
    }

    public static float getFovModifier(ItemStack stack, Gun modifiedGun) {
        Scope scope;
        float modifier = 0.0f;
        if (Gun.hasAttachmentEquipped(stack, modifiedGun, IAttachment.Type.SCOPE) && (scope = Gun.getScope(stack)) != null && scope.getFovModifier() < 1.0f) {
            return Mth.m_14036_((float)scope.getFovModifier(), (float)0.01f, (float)1.0f);
        }
        Modules.Zoom zoom = modifiedGun.getModules().getZoom();
        return zoom != null ? modifier + zoom.getFovModifier() : 0.0f;
    }

    public static class General
    implements INBTSerializable<CompoundTag> {
        private WeaponType weaponType = WeaponType.pistol;
        @Ignored
        private FireMode fireMode = FireMode.SEMI_AUTO;
        @Optional
        private int burstAmount;
        @Optional
        private int burstCooldown;
        private int rate;
        private int hotBarrelRate;
        @Optional
        private int fireTimer;
        @Ignored
        private GripType gripType = GripType.ONE_HANDED;
        @Ignored
        private GripType baseGripType = GripType.ONE_HANDED;
        private float recoilAngle;
        @Optional
        private float recoilKick;
        @Optional
        private float recoilDurationOffset;
        @Optional
        private float recoilAdsReduction = 0.2f;
        @Optional
        private int projectileAmount = 1;
        @Optional
        private boolean alwaysSpread;
        @Optional
        private float spread;
        @Optional
        private float restingSpread = 0.0f;
        @Optional
        private float spreadAdsReduction = 0.5f;
        @Optional
        private boolean infiniteAmmo;
        @Optional
        private float meleeDamage = 0.0f;
        @Optional
        public int meleeCooldownTicks = 15;
        @Optional
        private float meleeReach = 3.0f;
        @Optional
        private int energyUse = 0;
        @Optional
        private String beamColor;
        @Optional
        private String secondaryBeamColor;
        @Optional
        private String enchantedBeamColor;
        @Optional
        private String enchantedSecondaryBeamColor;
        @Optional
        private int beamAmmoConsumptionDelay = 1000;
        @Optional
        private int beamDamageDelay = 300;
        @Optional
        private double beamMaxDistance = 50.0;
        @Optional
        private boolean enableMining = false;
        @Optional
        private float miningSpeed = 1.0f;
        @Optional
        private boolean hasCameraShake = true;
        @Optional
        private float criticalChance = 0.0f;
        @Optional
        private boolean playerKnockBack = false;
        @Optional
        private float playerKnockBackStrength = 0.0f;
        @Optional
        private boolean isRevolver = false;
        @Optional
        private float speedModifier = 1.0f;
        @Optional
        private boolean isSilenced = false;
        @Optional
        private boolean enableGunLight = true;
        @Optional
        private boolean usesCustomMeleeAnimation = false;
        @Optional
        private float critDamageMultiplier = 1.5f;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("WeaponType", this.weaponType.toString());
            tag.m_128359_("FireMode", this.fireMode.id().toString());
            tag.m_128405_("BurstAmount", this.burstAmount);
            tag.m_128405_("BurstCooldown", this.burstCooldown);
            tag.m_128405_("Rate", this.rate);
            tag.m_128405_("HotBarrelRate", this.hotBarrelRate);
            tag.m_128405_("FireTimer", this.fireTimer);
            tag.m_128359_("GripType", this.gripType.id().toString());
            tag.m_128359_("BaseGripType", this.baseGripType.id().toString());
            tag.m_128350_("RecoilAngle", this.recoilAngle);
            tag.m_128350_("RecoilKick", this.recoilKick);
            tag.m_128350_("RecoilDurationOffset", this.recoilDurationOffset);
            tag.m_128350_("RecoilAdsReduction", this.recoilAdsReduction);
            tag.m_128405_("ProjectileAmount", this.projectileAmount);
            tag.m_128379_("AlwaysSpread", this.alwaysSpread);
            tag.m_128350_("Spread", this.spread);
            tag.m_128350_("RestingSpread", this.restingSpread);
            tag.m_128350_("MeleeDamage", this.meleeDamage);
            tag.m_128350_("MeleeCooldownTicks", (float)this.meleeCooldownTicks);
            tag.m_128350_("MeleeReach", this.meleeReach);
            tag.m_128379_("InfiniteAmmo", this.infiniteAmmo);
            tag.m_128405_("EnergyUse", this.energyUse);
            if (this.beamColor != null && !this.beamColor.isEmpty()) {
                tag.m_128359_("BeamColor", this.beamColor);
            }
            if (this.secondaryBeamColor != null && !this.secondaryBeamColor.isEmpty()) {
                tag.m_128359_("SecondaryBeamColor", this.secondaryBeamColor);
            }
            if (this.secondaryBeamColor != null && !this.secondaryBeamColor.isEmpty()) {
                tag.m_128359_("SecondaryBeamColor", this.secondaryBeamColor);
            }
            if (this.enchantedBeamColor != null && !this.enchantedBeamColor.isEmpty()) {
                tag.m_128359_("EnchantedBeamColor", this.enchantedBeamColor);
            }
            if (this.enchantedSecondaryBeamColor != null && !this.enchantedSecondaryBeamColor.isEmpty()) {
                tag.m_128359_("EnchantedSecondaryBeamColor", this.enchantedSecondaryBeamColor);
            }
            tag.m_128405_("BeamAmmoConsumptionDelay", this.beamAmmoConsumptionDelay);
            tag.m_128405_("BeamDamageDelay", this.beamDamageDelay);
            tag.m_128347_("BeamMaxDistance", this.beamMaxDistance);
            tag.m_128379_("EnableMining", this.enableMining);
            tag.m_128350_("MiningSpeed", this.miningSpeed);
            tag.m_128379_("HasCameraShake", this.hasCameraShake);
            tag.m_128350_("CriticalChance", this.criticalChance);
            tag.m_128379_("PlayerKnockBack", this.playerKnockBack);
            tag.m_128350_("PlayerKnockBackStrength", this.playerKnockBackStrength);
            tag.m_128379_("IsRevolver", this.isRevolver);
            tag.m_128350_("SpeedModifier", this.speedModifier);
            tag.m_128379_("IsSilenced", this.isSilenced);
            tag.m_128379_("EnableGunLight", this.enableGunLight);
            tag.m_128379_("UsesCustomMeleeAnimation", this.usesCustomMeleeAnimation);
            tag.m_128350_("CritDamageMultiplier", this.critDamageMultiplier);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("WeaponType", 8)) {
                this.weaponType = WeaponType.valueOf(tag.m_128461_("WeaponType"));
            }
            if (tag.m_128425_("FireMode", 8)) {
                this.fireMode = FireMode.getType(ResourceLocation.m_135820_((String)tag.m_128461_("FireMode")));
            }
            if (tag.m_128425_("BurstAmount", 99)) {
                this.burstAmount = tag.m_128451_("BurstAmount");
            }
            if (tag.m_128425_("BurstCooldown", 99)) {
                this.burstCooldown = tag.m_128451_("BurstCooldown");
            }
            if (tag.m_128425_("Rate", 99)) {
                this.rate = tag.m_128451_("Rate");
            }
            if (tag.m_128425_("HotBarrelRate", 99)) {
                this.hotBarrelRate = tag.m_128451_("HotBarrelRate");
            }
            if (tag.m_128425_("FireTimer", 99)) {
                this.fireTimer = tag.m_128451_("FireTimer");
            }
            if (tag.m_128425_("GripType", 8)) {
                this.gripType = GripType.getType(ResourceLocation.m_135820_((String)tag.m_128461_("GripType")));
            }
            if (tag.m_128425_("BaseGripType", 8)) {
                this.baseGripType = GripType.getType(ResourceLocation.m_135820_((String)tag.m_128461_("BaseGripType")));
            }
            if (tag.m_128425_("RecoilAngle", 99)) {
                this.recoilAngle = tag.m_128457_("RecoilAngle");
            }
            if (tag.m_128425_("RecoilKick", 99)) {
                this.recoilKick = tag.m_128457_("RecoilKick");
            }
            if (tag.m_128425_("RecoilDurationOffset", 99)) {
                this.recoilDurationOffset = tag.m_128457_("RecoilDurationOffset");
            }
            if (tag.m_128425_("RecoilAdsReduction", 99)) {
                this.recoilAdsReduction = tag.m_128457_("RecoilAdsReduction");
            }
            if (tag.m_128425_("ProjectileAmount", 99)) {
                this.projectileAmount = tag.m_128451_("ProjectileAmount");
            }
            if (tag.m_128425_("AlwaysSpread", 99)) {
                this.alwaysSpread = tag.m_128471_("AlwaysSpread");
            }
            if (tag.m_128425_("Spread", 99)) {
                this.spread = tag.m_128457_("Spread");
            }
            if (tag.m_128425_("RestingSpread", 99)) {
                this.restingSpread = tag.m_128457_("RestingSpread");
            }
            if (tag.m_128425_("SpreadAdsReduction", 99)) {
                this.spreadAdsReduction = tag.m_128457_("SpreadAdsReduction");
            }
            if (tag.m_128425_("MeleeDamage", 99)) {
                this.meleeDamage = tag.m_128457_("MeleeDamage");
            }
            if (tag.m_128425_("MeleeCooldownTicks", 99)) {
                this.meleeCooldownTicks = tag.m_128451_("MeleeCooldownTicks");
            }
            if (tag.m_128425_("MeleeReach", 99)) {
                this.meleeReach = tag.m_128457_("MeleeReach");
            }
            if (tag.m_128425_("InfiniteAmmo", 99)) {
                this.infiniteAmmo = tag.m_128471_("InfiniteAmmo");
            }
            if (tag.m_128425_("EnergyUse", 99)) {
                this.energyUse = tag.m_128451_("EnergyUse");
            }
            if (tag.m_128425_("BeamColor", 8)) {
                this.beamColor = tag.m_128461_("BeamColor");
            }
            if (tag.m_128425_("SecondaryBeamColor", 8)) {
                this.secondaryBeamColor = tag.m_128461_("SecondaryBeamColor");
            }
            if (tag.m_128425_("EnchantedBeamColor", 8)) {
                this.enchantedBeamColor = tag.m_128461_("EnchantedBeamColor");
            }
            if (tag.m_128425_("EnchantedSecondaryBeamColor", 8)) {
                this.enchantedSecondaryBeamColor = tag.m_128461_("EnchantedSecondaryBeamColor");
            }
            if (tag.m_128425_("BeamAmmoConsumptionDelay", 99)) {
                this.beamAmmoConsumptionDelay = tag.m_128451_("BeamAmmoConsumptionDelay");
            }
            if (tag.m_128425_("BeamDamageDelay", 99)) {
                this.beamDamageDelay = tag.m_128451_("BeamDamageDelay");
            }
            if (tag.m_128425_("BeamMaxDistance", 99)) {
                this.beamMaxDistance = tag.m_128459_("BeamMaxDistance");
            }
            if (tag.m_128425_("EnableMining", 99)) {
                this.enableMining = tag.m_128471_("EnableMining");
            }
            if (tag.m_128425_("MiningSpeed", 99)) {
                this.miningSpeed = tag.m_128457_("MiningSpeed");
            }
            if (tag.m_128425_("HasCameraShake", 99)) {
                this.hasCameraShake = tag.m_128471_("HasCameraShake");
            }
            if (tag.m_128425_("CriticalChance", 99)) {
                this.criticalChance = tag.m_128457_("CriticalChance");
            }
            if (tag.m_128425_("PlayerKnockBack", 99)) {
                this.playerKnockBack = tag.m_128471_("PlayerKnockBack");
            }
            if (tag.m_128425_("PlayerKnockBackStrength", 99)) {
                this.playerKnockBackStrength = tag.m_128457_("PlayerKnockBackStrength");
            }
            if (tag.m_128425_("IsRevolver", 99)) {
                this.isRevolver = tag.m_128471_("IsRevolver");
            }
            if (tag.m_128425_("SpeedModifier", 99)) {
                this.speedModifier = tag.m_128457_("SpeedModifier");
            }
            if (tag.m_128425_("IsSilenced", 99)) {
                this.isSilenced = tag.m_128471_("IsSilenced");
            }
            if (tag.m_128425_("EnableGunLight", 99)) {
                this.enableGunLight = tag.m_128471_("EnableGunLight");
            }
            if (tag.m_128425_("UsesCustomMeleeAnimation", 99)) {
                this.usesCustomMeleeAnimation = tag.m_128471_("UsesCustomMeleeAnimation");
            }
            if (tag.m_128425_("CritDamageMultiplier", 99)) {
                this.critDamageMultiplier = tag.m_128457_("CritDamageMultiplier");
            }
        }

        public JsonObject toJsonObject() {
            Preconditions.checkArgument((this.rate > 0 ? 1 : 0) != 0, (Object)"Rate must be more than zero");
            Preconditions.checkArgument((this.hotBarrelRate >= 0 ? 1 : 0) != 0, (Object)"Hot barrel rate must be more than or equal to zero");
            Preconditions.checkArgument((this.recoilAngle >= 0.0f ? 1 : 0) != 0, (Object)"Recoil angle must be more than or equal to zero");
            Preconditions.checkArgument((this.recoilKick >= 0.0f ? 1 : 0) != 0, (Object)"Recoil kick must be more than or equal to zero");
            Preconditions.checkArgument((this.recoilDurationOffset >= 0.0f && this.recoilDurationOffset <= 1.0f ? 1 : 0) != 0, (Object)"Recoil duration offset must be between 0.0 and 1.0");
            Preconditions.checkArgument((this.recoilAdsReduction >= 0.0f && this.recoilAdsReduction <= 1.0f ? 1 : 0) != 0, (Object)"Recoil ads reduction must be between 0.0 and 1.0");
            Preconditions.checkArgument((this.projectileAmount >= 1 ? 1 : 0) != 0, (Object)"Projectile amount must be more than or equal to one");
            Preconditions.checkArgument((this.spread >= 0.0f ? 1 : 0) != 0, (Object)"Spread must be more than or equal to zero");
            Preconditions.checkArgument((this.restingSpread >= 0.0f ? 1 : 0) != 0, (Object)"Spread must be more than or equal to zero");
            Preconditions.checkArgument((this.spreadAdsReduction >= 0.0f && this.spreadAdsReduction <= 1.0f ? 1 : 0) != 0, (Object)"Spread ADS reduction must be between 0.0 and 1.0");
            JsonObject object = new JsonObject();
            if (this.infiniteAmmo) {
                object.addProperty("infiniteAmmo", Boolean.valueOf(true));
            }
            object.addProperty("fireMode", this.fireMode.id().toString());
            object.addProperty("weaponType", this.weaponType.toString());
            if (this.burstAmount != 0) {
                object.addProperty("burstAmount", (Number)this.burstAmount);
            }
            if (this.burstCooldown != 0) {
                object.addProperty("burstCooldown", (Number)this.burstCooldown);
            }
            object.addProperty("rate", (Number)this.rate);
            if (this.fireTimer != 0) {
                object.addProperty("fireTimer", (Number)this.fireTimer);
            }
            object.addProperty("gripType", this.gripType.id().toString());
            object.addProperty("baseGripType", this.baseGripType.id().toString());
            if (this.recoilAngle != 0.0f) {
                object.addProperty("recoilAngle", (Number)Float.valueOf(this.recoilAngle));
            }
            if (this.recoilKick != 0.0f) {
                object.addProperty("recoilKick", (Number)Float.valueOf(this.recoilKick));
            }
            if (this.recoilDurationOffset != 0.0f) {
                object.addProperty("recoilDurationOffset", (Number)Float.valueOf(this.recoilDurationOffset));
            }
            if (this.recoilAdsReduction != 0.2f) {
                object.addProperty("recoilAdsReduction", (Number)Float.valueOf(this.recoilAdsReduction));
            }
            if (this.projectileAmount != 1) {
                object.addProperty("projectileAmount", (Number)this.projectileAmount);
            }
            if (this.alwaysSpread) {
                object.addProperty("alwaysSpread", Boolean.valueOf(true));
            }
            if (this.spread != 0.0f) {
                object.addProperty("spread", (Number)Float.valueOf(this.spread));
            }
            if (this.restingSpread != 0.0f) {
                object.addProperty("restingSpread", (Number)Float.valueOf(this.spread));
            }
            if (this.spreadAdsReduction != 0.5f) {
                object.addProperty("spreadAdsReduction", (Number)Float.valueOf(this.spread));
            }
            if (this.meleeDamage != 0.0f) {
                object.addProperty("meleeDamage", (Number)Float.valueOf(this.meleeDamage));
            }
            if (this.meleeCooldownTicks != 15) {
                object.addProperty("meleeCooldownTicks", (Number)this.meleeCooldownTicks);
            }
            if (this.meleeReach != 3.0f) {
                object.addProperty("meleeReach", (Number)Float.valueOf(this.meleeReach));
            }
            if (this.energyUse != 0) {
                object.addProperty("energyUse", (Number)this.energyUse);
            }
            if (this.beamColor != null && !this.beamColor.isEmpty()) {
                object.addProperty("beamColor", this.beamColor);
            }
            if (this.secondaryBeamColor != null && !this.secondaryBeamColor.isEmpty()) {
                object.addProperty("secondaryBeamColor", this.secondaryBeamColor);
            }
            if (this.enchantedBeamColor != null && !this.enchantedBeamColor.isEmpty()) {
                object.addProperty("enchantedBeamColor", this.enchantedBeamColor);
            }
            if (this.enchantedSecondaryBeamColor != null && !this.enchantedSecondaryBeamColor.isEmpty()) {
                object.addProperty("enchantedSecondaryBeamColor", this.enchantedSecondaryBeamColor);
            }
            if (this.beamAmmoConsumptionDelay != 1000) {
                object.addProperty("beamAmmoConsumptionDelay", (Number)this.beamAmmoConsumptionDelay);
            }
            if (this.beamDamageDelay != 300) {
                object.addProperty("beamDamageDelay", (Number)this.beamDamageDelay);
            }
            if (this.beamMaxDistance != 50.0) {
                object.addProperty("beamMaxDistance", (Number)this.beamMaxDistance);
            }
            if (this.miningSpeed != 1.0f) {
                object.addProperty("miningSpeed", (Number)Float.valueOf(this.miningSpeed));
            }
            if (this.enableMining) {
                object.addProperty("enableMining", Boolean.valueOf(true));
            }
            if (!this.hasCameraShake) {
                object.addProperty("hasCameraShake", Boolean.valueOf(false));
            }
            if (this.criticalChance != 0.0f) {
                object.addProperty("criticalChance", (Number)Float.valueOf(this.criticalChance));
            }
            if (this.playerKnockBack) {
                object.addProperty("playerKnockBack", Boolean.valueOf(true));
            }
            if (this.playerKnockBackStrength != 0.0f) {
                object.addProperty("playerKnockBackStrength", (Number)Float.valueOf(this.playerKnockBackStrength));
            }
            if (this.isRevolver) {
                object.addProperty("isRevolver", Boolean.valueOf(true));
            }
            if (this.speedModifier != 1.0f) {
                object.addProperty("speedModifier", (Number)Float.valueOf(this.speedModifier));
            }
            if (this.isSilenced) {
                object.addProperty("isSilenced", Boolean.valueOf(true));
            }
            if (!this.enableGunLight) {
                object.addProperty("enableGunLight", Boolean.valueOf(false));
            }
            if (this.usesCustomMeleeAnimation) {
                object.addProperty("usesCustomMeleeAnimation", Boolean.valueOf(true));
            }
            if (this.critDamageMultiplier != 1.5f) {
                object.addProperty("critDamageMultiplier", (Number)Float.valueOf(this.critDamageMultiplier));
            }
            return object;
        }

        public General copy() {
            General general = new General();
            general.weaponType = this.weaponType;
            general.fireMode = this.fireMode;
            general.burstAmount = this.burstAmount;
            general.burstCooldown = this.burstCooldown;
            general.rate = this.rate;
            general.hotBarrelRate = this.hotBarrelRate;
            general.fireTimer = this.fireTimer;
            general.gripType = this.gripType;
            general.baseGripType = this.baseGripType;
            general.recoilAngle = this.recoilAngle;
            general.recoilKick = this.recoilKick;
            general.recoilDurationOffset = this.recoilDurationOffset;
            general.recoilAdsReduction = this.recoilAdsReduction;
            general.projectileAmount = this.projectileAmount;
            general.alwaysSpread = this.alwaysSpread;
            general.spread = this.spread;
            general.restingSpread = this.restingSpread;
            general.spreadAdsReduction = this.spreadAdsReduction;
            general.infiniteAmmo = this.infiniteAmmo;
            general.meleeDamage = this.meleeDamage;
            general.meleeCooldownTicks = this.meleeCooldownTicks;
            general.meleeReach = this.meleeReach;
            general.energyUse = this.energyUse;
            general.beamMaxDistance = this.beamMaxDistance;
            general.beamAmmoConsumptionDelay = this.beamAmmoConsumptionDelay;
            general.beamDamageDelay = this.beamDamageDelay;
            general.beamColor = this.beamColor;
            general.secondaryBeamColor = this.secondaryBeamColor;
            general.enchantedBeamColor = this.enchantedBeamColor;
            general.enchantedSecondaryBeamColor = this.enchantedSecondaryBeamColor;
            general.enableMining = this.enableMining;
            general.miningSpeed = this.miningSpeed;
            general.hasCameraShake = this.hasCameraShake;
            general.criticalChance = this.criticalChance;
            general.playerKnockBack = this.playerKnockBack;
            general.playerKnockBackStrength = this.playerKnockBackStrength;
            general.isRevolver = this.isRevolver;
            general.speedModifier = this.speedModifier;
            general.isSilenced = this.isSilenced;
            general.enableGunLight = this.enableGunLight;
            general.usesCustomMeleeAnimation = this.usesCustomMeleeAnimation;
            general.critDamageMultiplier = this.critDamageMultiplier;
            return general;
        }

        public float getCritDamageMultiplier() {
            return this.critDamageMultiplier;
        }

        public boolean usesCustomMeleeAnimation() {
            return this.usesCustomMeleeAnimation;
        }

        public boolean isEnableGunLight() {
            return this.enableGunLight;
        }

        public float getSpeedModifier() {
            return this.speedModifier;
        }

        public boolean hasPlayerKnockBack() {
            return this.playerKnockBack;
        }

        public float getPlayerKnockBackStrength() {
            return this.playerKnockBackStrength;
        }

        public boolean isRevolver() {
            return this.isRevolver;
        }

        public float getCriticalChance() {
            return this.criticalChance;
        }

        public boolean hasCameraShake() {
            return this.hasCameraShake;
        }

        public boolean canMine() {
            return this.enableMining;
        }

        public float getMiningSpeed() {
            return this.miningSpeed;
        }

        public double getBeamMaxDistance() {
            return this.beamMaxDistance;
        }

        public int getBeamAmmoConsumptionDelay() {
            return this.beamAmmoConsumptionDelay;
        }

        public String getEnchantedBeamColor() {
            return this.enchantedBeamColor;
        }

        public String getEnchantedSecondaryBeamColor() {
            return this.enchantedSecondaryBeamColor;
        }

        public int getBeamDamageDelay() {
            return this.beamDamageDelay;
        }

        public int getEnergyUse() {
            return this.energyUse;
        }

        public void setEnergyUse(int energyUse) {
            this.energyUse = energyUse;
        }

        public float getMeleeDamage() {
            return this.meleeDamage;
        }

        public int getMeleeCooldownTicks() {
            return this.meleeCooldownTicks;
        }

        public void setMeleeDamage(float meleeDamage) {
            this.meleeDamage = meleeDamage;
        }

        public float getMeleeReach() {
            return this.meleeReach;
        }

        public WeaponType getWeaponType() {
            return this.weaponType;
        }

        public FireMode getFireMode() {
            return this.fireMode;
        }

        public String getBeamColor() {
            return this.beamColor;
        }

        public String getSecondaryBeamColor() {
            return this.secondaryBeamColor;
        }

        public int getRate() {
            return this.rate;
        }

        public int getHotBarrelRate() {
            return this.hotBarrelRate;
        }

        public int getFireTimer() {
            return this.fireTimer;
        }

        public GripType getGripType(ItemStack stack) {
            return this.getModifiedGun(stack).determineGripType(stack);
        }

        private Gun getModifiedGun(ItemStack stack) {
            Item item;
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof GunItem)) {
                return new Gun();
            }
            GunItem item2 = (GunItem)item;
            return item2.getModifiedGun(stack);
        }

        public float getRecoilAngle() {
            return this.recoilAngle;
        }

        public float getRecoilKick() {
            return this.recoilKick;
        }

        public float getRecoilDurationOffset() {
            return this.recoilDurationOffset;
        }

        public float getRecoilAdsReduction() {
            return this.recoilAdsReduction;
        }

        public int getProjectileAmount() {
            return this.projectileAmount;
        }

        public boolean isAlwaysSpread() {
            return this.alwaysSpread;
        }

        public float getSpread() {
            return this.spread;
        }

        public boolean isAuto() {
            return this.fireMode == FireMode.AUTOMATIC;
        }

        public boolean getInfiniteAmmo() {
            return this.infiniteAmmo;
        }

        public float getRestingSpread() {
            return this.restingSpread;
        }

        public float getSpreadAdsReduction() {
            return this.spreadAdsReduction;
        }

        public int getBurstAmount() {
            return this.burstAmount;
        }

        public int getBurstCooldown() {
            return this.burstCooldown;
        }

        public GripType getBaseGripType() {
            return this.baseGripType;
        }

        public boolean isSilenced() {
            return this.isSilenced;
        }
    }

    public static class Reloads
    implements INBTSerializable<CompoundTag> {
        @Optional
        @Ignored
        private ResourceLocation reloadItem = new ResourceLocation("scguns", "scrap");
        private int maxAmmo = 30;
        @Ignored
        private ReloadType reloadType = ReloadType.MANUAL;
        private int reloadTimer = 20;
        private int emptyMagTimer = 5;
        private int reloadAmount = 1;
        @Optional
        private boolean infiniteAmmo = false;
        @Optional
        private ResourceLocation reloadByproduct;
        @Optional
        private float byproductChance = 0.0f;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("ReloadItem", this.reloadItem.toString());
            tag.m_128405_("MaxAmmo", this.maxAmmo);
            tag.m_128359_("ReloadType", this.reloadType.id().toString());
            tag.m_128405_("ReloadTimer", this.reloadTimer);
            tag.m_128405_("EmptyMagTimer", this.emptyMagTimer);
            tag.m_128405_("ReloadAmount", this.reloadAmount);
            tag.m_128350_("ByproductChance", this.byproductChance);
            if (this.reloadByproduct != null) {
                tag.m_128359_("ReloadByproduct", this.reloadByproduct.toString());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("ReloadItem", 8)) {
                this.reloadItem = new ResourceLocation(tag.m_128461_("ReloadItem"));
            }
            if (tag.m_128425_("MaxAmmo", 99)) {
                this.maxAmmo = tag.m_128451_("MaxAmmo");
            }
            if (tag.m_128425_("ReloadType", 8)) {
                this.reloadType = ReloadType.getType(ResourceLocation.m_135820_((String)tag.m_128461_("ReloadType")));
            }
            if (tag.m_128425_("ReloadTimer", 99)) {
                this.reloadTimer = tag.m_128451_("ReloadTimer");
            }
            if (tag.m_128425_("EmptyMagTimer", 99)) {
                this.emptyMagTimer = tag.m_128451_("EmptyMagTimer");
            }
            if (tag.m_128425_("ReloadAmount", 99)) {
                this.reloadAmount = tag.m_128451_("ReloadAmount");
            }
            if (tag.m_128425_("ByproductChance", 99)) {
                this.byproductChance = tag.m_128457_("ByproductChance");
            }
            if (tag.m_128425_("ReloadByproduct", 8)) {
                this.reloadByproduct = new ResourceLocation(tag.m_128461_("ReloadByproduct"));
            }
        }

        public JsonObject toJsonObject() {
            Preconditions.checkArgument((this.maxAmmo > 0 ? 1 : 0) != 0, (Object)"Max ammo must be more than zero");
            Preconditions.checkArgument((this.reloadTimer >= 0 ? 1 : 0) != 0, (Object)"Reload timer must be more than or equal to zero");
            Preconditions.checkArgument((this.emptyMagTimer >= 0 ? 1 : 0) != 0, (Object)"Empty mag additional reload timer must be more than or equal to zero");
            Preconditions.checkArgument((this.reloadAmount >= 1 ? 1 : 0) != 0, (Object)"Reloading amount must be more than or equal to zero");
            JsonObject object = new JsonObject();
            if (this.reloadItem != null) {
                object.addProperty("reloadItem", this.reloadItem.toString());
            }
            object.addProperty("maxAmmo", (Number)this.maxAmmo);
            object.addProperty("reloadType", this.reloadType.id().toString());
            object.addProperty("reloadTimer", (Number)this.reloadTimer);
            object.addProperty("emptyMagTimer", (Number)this.emptyMagTimer);
            if (this.reloadAmount != 1) {
                object.addProperty("reloadAmount", (Number)this.reloadAmount);
            }
            if (this.byproductChance != 0.0f) {
                object.addProperty("byproductChance", (Number)Float.valueOf(this.byproductChance));
            }
            if (this.reloadByproduct != null) {
                object.addProperty("reloadByproduct", this.reloadByproduct.toString());
            }
            return object;
        }

        public Reloads copy() {
            Reloads reloads = new Reloads();
            reloads.reloadItem = this.reloadItem;
            reloads.maxAmmo = this.maxAmmo;
            reloads.reloadType = this.reloadType;
            reloads.reloadTimer = this.reloadTimer;
            reloads.emptyMagTimer = this.emptyMagTimer;
            reloads.reloadAmount = this.reloadAmount;
            reloads.byproductChance = this.byproductChance;
            reloads.reloadByproduct = this.reloadByproduct;
            return reloads;
        }

        public static boolean hasInfiniteAmmo(ItemStack gunStack) {
            CompoundTag tag = gunStack.m_41784_();
            Gun modifiedGun = ((GunItem)gunStack.m_41720_()).getModifiedGun(gunStack);
            return tag.m_128471_("IgnoreAmmo") || modifiedGun.getGeneral().getInfiniteAmmo();
        }

        @javax.annotation.Nullable
        public Item getReloadByproduct() {
            return this.reloadByproduct != null ? (Item)ForgeRegistries.ITEMS.getValue(this.reloadByproduct) : null;
        }

        public float getByproductChance() {
            return this.byproductChance;
        }

        public void setByproductChance(float chance) {
            this.byproductChance = Mth.m_14036_((float)chance, (float)0.0f, (float)1.0f);
        }

        public boolean shouldGiveByproduct(RandomSource random, ItemStack gunStack) {
            if (this.reloadByproduct == null || this.byproductChance <= 0.0f) {
                return false;
            }
            float finalChance = this.byproductChance;
            int shellCatcherLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.SHELL_CATCHER.get()), (ItemStack)gunStack);
            if (shellCatcherLevel > 0) {
                finalChance += (float)shellCatcherLevel * 0.05f;
                finalChance = Math.min(finalChance, 1.0f);
            }
            return random.m_188501_() < finalChance;
        }

        public void setReloadByproduct(ResourceLocation item) {
            this.reloadByproduct = item;
        }

        public boolean getInfiniteAmmo() {
            return this.infiniteAmmo;
        }

        public Item getReloadItem() {
            return (Item)ForgeRegistries.ITEMS.getValue(this.reloadItem);
        }

        public int getMaxAmmo() {
            return this.maxAmmo;
        }

        public ReloadType getReloadType() {
            return this.reloadType;
        }

        public int getReloadTimer() {
            return this.reloadTimer;
        }

        public int getEmptyMagTimer() {
            return this.emptyMagTimer;
        }

        public int getReloadAmount() {
            return this.reloadAmount;
        }
    }

    public static class Projectile
    implements INBTSerializable<CompoundTag> {
        public ResourceLocation item;
        public ResourceLocation casingType;
        @Optional
        private boolean ejectsCasing;
        @Optional
        private boolean visible;
        private float damage;
        @Optional
        private float armorPen;
        @Optional
        private ResourceLocation advantage = new ResourceLocation("scguns", "none");
        private float size;
        private double speed;
        private int life;
        @Optional
        private boolean gravity;
        @Optional
        private boolean damageReduceOverLife;
        @Optional
        private int trailColor = 16765577;
        @Optional
        private double trailLengthMultiplier = 1.0;
        @Optional
        private boolean hideTrail;
        @Optional
        @javax.annotation.Nullable
        private ResourceLocation casingParticle;
        @Optional
        private boolean ejectDuringReload;
        @Optional
        private boolean firesArrows = false;
        @Optional
        @javax.annotation.Nullable
        private ResourceLocation impactEffect;
        @Optional
        private int impactEffectDuration = 100;
        @Optional
        private int impactEffectAmplifier = 0;
        @Optional
        private float impactEffectChance = 1.0f;
        @Optional
        private boolean isSoulFire = false;
        @Optional
        private boolean hideProjectile = false;
        @Optional
        private double trailThickness = 1.0;
        @Optional
        private float knockbackStrength = 0.3f;
        @Optional
        private float damageFalloffStart = 0.0f;
        @Optional
        private float damageFalloffEnd = 0.0f;
        @Optional
        private float damageFalloffMinMultiplier = 1.0f;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Item", this.item.toString());
            tag.m_128379_("EjectsCasing", this.ejectsCasing);
            tag.m_128379_("Visible", this.visible);
            tag.m_128350_("Damage", this.damage);
            tag.m_128350_("ArmorPen", this.armorPen);
            tag.m_128359_("Advantage", this.advantage.toString());
            tag.m_128350_("Size", this.size);
            tag.m_128347_("Speed", this.speed);
            tag.m_128405_("Life", this.life);
            tag.m_128379_("Gravity", this.gravity);
            tag.m_128379_("DamageReduceOverLife", this.damageReduceOverLife);
            tag.m_128405_("TrailColor", this.trailColor);
            tag.m_128379_("HideTrail", this.hideTrail);
            tag.m_128347_("TrailLengthMultiplier", this.trailLengthMultiplier);
            if (this.casingType != null) {
                tag.m_128359_("CasingType", this.casingType.toString());
            }
            if (this.casingParticle != null) {
                tag.m_128359_("CasingParticle", this.casingParticle.toString());
            }
            tag.m_128379_("EjectDuringReload", this.ejectDuringReload);
            tag.m_128379_("FiresArrows", this.firesArrows);
            if (this.impactEffect != null) {
                tag.m_128359_("ImpactEffect", this.impactEffect.toString());
                tag.m_128405_("ImpactEffectDuration", this.impactEffectDuration);
                tag.m_128405_("ImpactEffectAmplifier", this.impactEffectAmplifier);
                tag.m_128350_("ImpactEffectChance", this.impactEffectChance);
            }
            tag.m_128379_("IsSoulFire", this.isSoulFire);
            tag.m_128379_("HideProjectile", this.hideProjectile);
            tag.m_128347_("TrailThickness", this.trailThickness);
            tag.m_128350_("KnockbackStrength", this.knockbackStrength);
            tag.m_128350_("DamageFalloffStart", this.damageFalloffStart);
            tag.m_128350_("DamageFalloffEnd", this.damageFalloffEnd);
            tag.m_128350_("DamageFalloffMinMultiplier", this.damageFalloffMinMultiplier);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Item", 8)) {
                this.item = new ResourceLocation(tag.m_128461_("Item"));
            }
            if (tag.m_128425_("CasingType", 8)) {
                this.casingType = new ResourceLocation(tag.m_128461_("CasingType"));
            }
            if (tag.m_128425_("EjectsCasing", 99)) {
                this.ejectsCasing = tag.m_128471_("EjectsCasing");
            }
            if (tag.m_128425_("Visible", 99)) {
                this.visible = tag.m_128471_("Visible");
            }
            if (tag.m_128425_("Damage", 99)) {
                this.damage = tag.m_128457_("Damage");
            }
            if (tag.m_128425_("ArmorPen", 99)) {
                this.armorPen = tag.m_128457_("ArmorPen");
            }
            if (tag.m_128425_("Advantage", 8)) {
                this.advantage = new ResourceLocation(tag.m_128461_("Advantage"));
            }
            if (tag.m_128425_("Size", 99)) {
                this.size = tag.m_128457_("Size");
            }
            if (tag.m_128425_("Speed", 99)) {
                this.speed = tag.m_128459_("Speed");
            }
            if (tag.m_128425_("Life", 99)) {
                this.life = tag.m_128451_("Life");
            }
            if (tag.m_128425_("Gravity", 99)) {
                this.gravity = tag.m_128471_("Gravity");
            }
            if (tag.m_128425_("HideTrail", 99)) {
                this.hideTrail = tag.m_128471_("HideTrail");
            }
            if (tag.m_128425_("DamageReduceOverLife", 99)) {
                this.damageReduceOverLife = tag.m_128471_("DamageReduceOverLife");
            }
            if (tag.m_128425_("TrailColor", 99)) {
                this.trailColor = tag.m_128451_("TrailColor");
            }
            if (tag.m_128425_("TrailLengthMultiplier", 99)) {
                this.trailLengthMultiplier = tag.m_128459_("TrailLengthMultiplier");
            }
            if (tag.m_128425_("CasingParticle", 8)) {
                this.casingParticle = new ResourceLocation(tag.m_128461_("CasingParticle"));
            }
            if (tag.m_128425_("EjectDuringReload", 99)) {
                this.ejectDuringReload = tag.m_128471_("EjectDuringReload");
            }
            if (tag.m_128425_("FiresArrows", 99)) {
                this.firesArrows = tag.m_128471_("FiresArrows");
            }
            if (tag.m_128425_("ImpactEffect", 8)) {
                this.impactEffect = new ResourceLocation(tag.m_128461_("ImpactEffect"));
                this.impactEffectDuration = tag.m_128451_("ImpactEffectDuration");
                this.impactEffectAmplifier = tag.m_128451_("ImpactEffectAmplifier");
                this.impactEffectChance = tag.m_128457_("ImpactEffectChance");
            }
            if (tag.m_128425_("IsSoulFire", 99)) {
                this.isSoulFire = tag.m_128471_("IsSoulFire");
            }
            if (tag.m_128425_("HideProjectile", 99)) {
                this.hideProjectile = tag.m_128471_("HideProjectile");
            }
            if (tag.m_128425_("TrailThickness", 99)) {
                this.trailThickness = tag.m_128459_("TrailThickness");
            }
            if (tag.m_128425_("KnockbackStrength", 99)) {
                this.knockbackStrength = tag.m_128457_("KnockbackStrength");
            }
            if (tag.m_128425_("DamageFalloffStart", 99)) {
                this.damageFalloffStart = tag.m_128457_("DamageFalloffStart");
            }
            if (tag.m_128425_("DamageFalloffEnd", 99)) {
                this.damageFalloffEnd = tag.m_128457_("DamageFalloffEnd");
            }
            if (tag.m_128425_("DamageFalloffMinMultiplier", 99)) {
                this.damageFalloffMinMultiplier = tag.m_128457_("DamageFalloffMinMultiplier");
            }
        }

        public JsonObject toJsonObject() {
            Preconditions.checkArgument((this.damage >= 0.0f ? 1 : 0) != 0, (Object)"Damage must be more than or equal to zero");
            Preconditions.checkArgument((this.size >= 0.0f ? 1 : 0) != 0, (Object)"Projectile size must be more than or equal to zero");
            Preconditions.checkArgument((this.speed >= 0.0 ? 1 : 0) != 0, (Object)"Projectile speed must be more than or equal to zero");
            Preconditions.checkArgument((this.life > 0 ? 1 : 0) != 0, (Object)"Projectile life must be more than zero");
            Preconditions.checkArgument((this.trailLengthMultiplier >= 0.0 ? 1 : 0) != 0, (Object)"Projectile trail length multiplier must be more than or equal to zero");
            JsonObject object = new JsonObject();
            object.addProperty("item", this.item.toString());
            if (this.ejectsCasing) {
                object.addProperty("ejectsCasing", Boolean.valueOf(true));
            }
            if (this.visible) {
                object.addProperty("visible", Boolean.valueOf(true));
            }
            object.addProperty("damage", (Number)Float.valueOf(this.damage));
            if (this.armorPen != 0.0f) {
                object.addProperty("armorPen", (Number)Float.valueOf(this.armorPen));
            }
            if (this.advantage != null) {
                object.addProperty("advantage", this.advantage.toString());
            }
            object.addProperty("size", (Number)Float.valueOf(this.size));
            object.addProperty("speed", (Number)this.speed);
            object.addProperty("life", (Number)this.life);
            if (this.gravity) {
                object.addProperty("gravity", Boolean.valueOf(true));
            }
            if (this.damageReduceOverLife) {
                object.addProperty("damageReduceOverLife", Boolean.valueOf(true));
            }
            if (this.trailColor != 0xFFFF00) {
                object.addProperty("trailColor", (Number)this.trailColor);
            }
            if (this.trailLengthMultiplier != 1.0) {
                object.addProperty("trailLengthMultiplier", (Number)this.trailLengthMultiplier);
            }
            if (this.casingType != null) {
                object.addProperty("casingType", this.casingType.toString());
            }
            if (this.casingParticle != null) {
                object.addProperty("casingParticle", this.casingParticle.toString());
            }
            if (this.ejectDuringReload) {
                object.addProperty("ejectDuringReload", Boolean.valueOf(true));
            }
            if (this.firesArrows) {
                object.addProperty("firesArrows", Boolean.valueOf(true));
            }
            if (this.impactEffect != null) {
                object.addProperty("impactEffect", this.impactEffect.toString());
                if (this.impactEffectDuration != 100) {
                    object.addProperty("impactEffectDuration", (Number)this.impactEffectDuration);
                }
                if (this.impactEffectAmplifier != 0) {
                    object.addProperty("impactEffectAmplifier", (Number)this.impactEffectAmplifier);
                }
                if (this.impactEffectChance != 1.0f) {
                    object.addProperty("impactEffectChance", (Number)Float.valueOf(this.impactEffectChance));
                }
            }
            if (this.isSoulFire) {
                object.addProperty("isSoulFire", Boolean.valueOf(true));
            }
            if (this.hideProjectile) {
                object.addProperty("hideProjectile", Boolean.valueOf(true));
            }
            if (this.hideTrail) {
                object.addProperty("hideTrail", Boolean.valueOf(true));
            }
            if (this.trailThickness != 1.0) {
                object.addProperty("trailThickness", (Number)this.trailThickness);
            }
            if (this.knockbackStrength != 0.3f) {
                object.addProperty("knockbackStrength", (Number)Float.valueOf(this.knockbackStrength));
            }
            if (this.damageFalloffStart != 0.0f) {
                object.addProperty("damageFalloffStart", (Number)Float.valueOf(this.damageFalloffStart));
            }
            if (this.damageFalloffEnd != 0.0f) {
                object.addProperty("damageFalloffEnd", (Number)Float.valueOf(this.damageFalloffEnd));
            }
            if (this.damageFalloffMinMultiplier != 1.0f) {
                object.addProperty("damageFalloffMinMultiplier", (Number)Float.valueOf(this.damageFalloffMinMultiplier));
            }
            return object;
        }

        public Projectile copy() {
            Projectile projectile = new Projectile();
            projectile.item = this.item;
            projectile.ejectsCasing = this.ejectsCasing;
            projectile.visible = this.visible;
            projectile.damage = this.damage;
            projectile.armorPen = this.armorPen;
            projectile.advantage = this.advantage;
            projectile.size = this.size;
            projectile.speed = this.speed;
            projectile.life = this.life;
            projectile.gravity = this.gravity;
            projectile.damageReduceOverLife = this.damageReduceOverLife;
            projectile.trailColor = this.trailColor;
            projectile.trailLengthMultiplier = this.trailLengthMultiplier;
            projectile.casingType = this.casingType;
            projectile.casingParticle = this.casingParticle;
            projectile.ejectDuringReload = this.ejectDuringReload;
            projectile.firesArrows = this.firesArrows;
            projectile.impactEffect = this.impactEffect;
            projectile.impactEffectDuration = this.impactEffectDuration;
            projectile.impactEffectAmplifier = this.impactEffectAmplifier;
            projectile.impactEffectChance = this.impactEffectChance;
            projectile.isSoulFire = this.isSoulFire;
            projectile.hideProjectile = this.hideProjectile;
            projectile.hideTrail = this.hideTrail;
            projectile.trailThickness = this.trailThickness;
            projectile.knockbackStrength = this.knockbackStrength;
            projectile.damageFalloffStart = this.damageFalloffStart;
            projectile.damageFalloffEnd = this.damageFalloffEnd;
            projectile.damageFalloffMinMultiplier = this.damageFalloffMinMultiplier;
            return projectile;
        }

        public float getKnockbackStrength() {
            return this.knockbackStrength;
        }

        public boolean shouldHideTrail() {
            return this.hideTrail;
        }

        public double getTrailThickness() {
            return this.trailThickness;
        }

        public float getArmorPen() {
            return this.armorPen;
        }

        public boolean isSoulFire() {
            return this.isSoulFire;
        }

        @javax.annotation.Nullable
        public ResourceLocation getImpactEffect() {
            return this.impactEffect;
        }

        public int getImpactEffectDuration() {
            return this.impactEffectDuration;
        }

        public int getImpactEffectAmplifier() {
            return this.impactEffectAmplifier;
        }

        public float getImpactEffectChance() {
            return this.impactEffectChance;
        }

        @Nullable
        public Item getItem() {
            return (Item)ForgeRegistries.ITEMS.getValue(this.item);
        }

        public boolean firesArrows() {
            return this.firesArrows;
        }

        public boolean ejectsCasing() {
            return this.ejectsCasing;
        }

        public void setCasingType(ResourceLocation casingType) {
            this.casingType = casingType;
        }

        public ResourceLocation getCasingType() {
            return this.casingType;
        }

        public boolean ejectDuringReload() {
            return this.ejectDuringReload;
        }

        public boolean isVisible() {
            return !this.visible;
        }

        public float getDamage() {
            return this.damage;
        }

        public ResourceLocation getAdvantage() {
            return this.advantage;
        }

        public float getSize() {
            return this.size;
        }

        public double getSpeed() {
            return this.speed;
        }

        public int getLife() {
            return this.life;
        }

        public boolean isGravity() {
            return this.gravity;
        }

        public boolean isDamageReduceOverLife() {
            return this.damageReduceOverLife;
        }

        public int getTrailColor() {
            return this.trailColor;
        }

        public boolean shouldHideProjectile() {
            return this.hideProjectile;
        }

        public double getTrailLengthMultiplier() {
            return this.trailLengthMultiplier;
        }

        public void setDamage(float v) {
            this.damage = v;
        }

        public float getSpread() {
            return 0.0f;
        }

        public ResourceLocation getCasingParticle() {
            return this.casingParticle;
        }

        public float getDamageFalloffStart() {
            return this.damageFalloffStart;
        }

        public float getDamageFalloffEnd() {
            return this.damageFalloffEnd;
        }

        public float getDamageFalloffMinMultiplier() {
            return this.damageFalloffMinMultiplier;
        }
    }

    public static class Sounds
    implements INBTSerializable<CompoundTag> {
        @Optional
        @javax.annotation.Nullable
        private ResourceLocation fire;
        @Optional
        @javax.annotation.Nullable
        private ResourceLocation reload;
        @Optional
        @javax.annotation.Nullable
        private ResourceLocation cock;
        @Optional
        @javax.annotation.Nullable
        private ResourceLocation silencedFire;
        @Optional
        @javax.annotation.Nullable
        private ResourceLocation enchantedFire;
        @Optional
        @javax.annotation.Nullable
        private ResourceLocation preFire;
        @Optional
        @javax.annotation.Nullable
        private ResourceLocation flyby;
        @Optional
        @javax.annotation.Nullable
        private ResourceLocation preReload;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.fire != null) {
                tag.m_128359_("Fire", this.fire.toString());
            }
            if (this.reload != null) {
                tag.m_128359_("Reloads", this.reload.toString());
            }
            if (this.cock != null) {
                tag.m_128359_("Cock", this.cock.toString());
            }
            if (this.silencedFire != null) {
                tag.m_128359_("SilencedFire", this.silencedFire.toString());
            }
            if (this.enchantedFire != null) {
                tag.m_128359_("EnchantedFire", this.enchantedFire.toString());
            }
            if (this.preFire != null) {
                tag.m_128359_("PreFire", this.preFire.toString());
            }
            if (this.preReload != null) {
                tag.m_128359_("PreReload", this.preReload.toString());
            }
            if (this.flyby != null) {
                tag.m_128359_("Flyby", this.flyby.toString());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Fire", 8)) {
                this.fire = this.createSound(tag, "Fire");
            }
            if (tag.m_128425_("Reloads", 8)) {
                this.reload = this.createSound(tag, "Reloads");
            }
            if (tag.m_128425_("Cock", 8)) {
                this.cock = this.createSound(tag, "Cock");
            }
            if (tag.m_128425_("SilencedFire", 8)) {
                this.silencedFire = this.createSound(tag, "SilencedFire");
            }
            if (tag.m_128425_("EnchantedFire", 8)) {
                this.enchantedFire = this.createSound(tag, "EnchantedFire");
            }
            if (tag.m_128425_("PreFire", 8)) {
                this.preFire = this.createSound(tag, "PreFire");
            }
            if (tag.m_128425_("PreReload", 8)) {
                this.preReload = this.createSound(tag, "PreReload");
            }
            if (tag.m_128425_("Flyby", 8)) {
                this.flyby = this.createSound(tag, "Flyby");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.fire != null) {
                object.addProperty("fire", this.fire.toString());
            }
            if (this.reload != null) {
                object.addProperty("reload", this.reload.toString());
            }
            if (this.cock != null) {
                object.addProperty("cock", this.cock.toString());
            }
            if (this.silencedFire != null) {
                object.addProperty("silencedFire", this.silencedFire.toString());
            }
            if (this.enchantedFire != null) {
                object.addProperty("enchantedFire", this.enchantedFire.toString());
            }
            if (this.preFire != null) {
                object.addProperty("preFire", this.preFire.toString());
            }
            if (this.preReload != null) {
                object.addProperty("preReload", this.preReload.toString());
            }
            return object;
        }

        public Sounds copy() {
            Sounds sounds = new Sounds();
            sounds.fire = this.fire;
            sounds.reload = this.reload;
            sounds.cock = this.cock;
            sounds.silencedFire = this.silencedFire;
            sounds.enchantedFire = this.enchantedFire;
            sounds.preFire = this.preFire;
            sounds.preReload = this.preReload;
            sounds.flyby = this.flyby;
            return sounds;
        }

        @javax.annotation.Nullable
        private ResourceLocation createSound(CompoundTag tag, String key) {
            String sound = tag.m_128461_(key);
            return sound.isEmpty() ? null : new ResourceLocation(sound);
        }

        @javax.annotation.Nullable
        public ResourceLocation getFire() {
            return this.fire;
        }

        @javax.annotation.Nullable
        public ResourceLocation getReload() {
            return this.reload;
        }

        @javax.annotation.Nullable
        public ResourceLocation getCock() {
            return this.cock;
        }

        @javax.annotation.Nullable
        public ResourceLocation getSilencedFire() {
            return this.silencedFire;
        }

        @javax.annotation.Nullable
        public ResourceLocation getEnchantedFire() {
            return this.enchantedFire;
        }

        @javax.annotation.Nullable
        public ResourceLocation getPreFire() {
            return this.preFire;
        }

        @javax.annotation.Nullable
        public ResourceLocation getPreReload() {
            return this.preReload;
        }

        @javax.annotation.Nullable
        public ResourceLocation getFlybySound() {
            return this.flyby;
        }
    }

    public static class Display
    implements INBTSerializable<CompoundTag> {
        @Optional
        @javax.annotation.Nullable
        protected Flash flash;
        @Optional
        @javax.annotation.Nullable
        protected BeamOrigin beamOrigin;
        @Optional
        private String muzzleFlashType;

        @javax.annotation.Nullable
        public Flash getFlash() {
            return this.flash;
        }

        public String getMuzzleFlashType() {
            return this.muzzleFlashType;
        }

        public void setMuzzleFlashType(String muzzleFlashType) {
            this.muzzleFlashType = muzzleFlashType;
        }

        @javax.annotation.Nullable
        public BeamOrigin getBeamOrigin() {
            return this.beamOrigin;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.flash != null) {
                tag.m_128365_("Flash", (Tag)this.flash.serializeNBT());
            }
            if (this.beamOrigin != null) {
                tag.m_128365_("BeamOrigin", (Tag)this.beamOrigin.serializeNBT());
            }
            if (this.muzzleFlashType != null) {
                tag.m_128359_("MuzzleFlashType", this.muzzleFlashType);
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            CompoundTag originTag;
            if (tag.m_128425_("Flash", 10)) {
                CompoundTag flashTag = tag.m_128469_("Flash");
                if (!flashTag.m_128456_()) {
                    Flash flash = new Flash();
                    flash.deserializeNBT(flashTag);
                    this.flash = flash;
                } else {
                    this.flash = null;
                }
            }
            if (tag.m_128425_("BeamOrigin", 10) && !(originTag = tag.m_128469_("BeamOrigin")).m_128456_()) {
                BeamOrigin origin = new BeamOrigin();
                origin.deserializeNBT(originTag);
                this.beamOrigin = origin;
            }
            if (tag.m_128425_("MuzzleFlashType", 8)) {
                this.muzzleFlashType = tag.m_128461_("MuzzleFlashType");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.flash != null) {
                GunJsonUtil.addObjectIfNotEmpty(object, "flash", this.flash.toJsonObject());
            }
            if (this.beamOrigin != null) {
                GunJsonUtil.addObjectIfNotEmpty(object, "beamOrigin", this.beamOrigin.toJsonObject());
            }
            if (this.muzzleFlashType != null) {
                object.addProperty("muzzleFlashType", this.muzzleFlashType);
            }
            return object;
        }

        public Display copy() {
            Display display = new Display();
            if (this.flash != null) {
                display.flash = this.flash.copy();
            }
            display.muzzleFlashType = this.muzzleFlashType;
            return display;
        }

        public static class Flash
        extends Positioned {
            private double size = 0.5;
            private String textureLocation = "muzzle_flash_1";
            private boolean spawnParticles = false;
            private boolean alternateMuzzleFlash = false;
            private Vec3 alternatePosition = Vec3.f_82478_;
            private int particleCount = 5;
            private String particleType = "minecraft:flame";
            private double particleSpread = 0.1;
            private double particleRingRadius = 0.0;

            @Override
            public Flash copy() {
                Flash flash = new Flash();
                flash.xOffset = this.xOffset;
                flash.yOffset = this.yOffset;
                flash.zOffset = this.zOffset;
                flash.size = this.size;
                flash.textureLocation = this.textureLocation;
                flash.spawnParticles = this.spawnParticles;
                flash.alternateMuzzleFlash = this.alternateMuzzleFlash;
                flash.alternatePosition = this.alternatePosition;
                flash.particleCount = this.particleCount;
                flash.particleType = this.particleType;
                flash.particleSpread = this.particleSpread;
                flash.particleRingRadius = this.particleRingRadius;
                return flash;
            }

            @Override
            public CompoundTag serializeNBT() {
                CompoundTag tag = super.serializeNBT();
                tag.m_128347_("Size", this.size);
                tag.m_128359_("TextureLocation", this.textureLocation);
                tag.m_128379_("AlternateMuzzleFlash", this.alternateMuzzleFlash);
                CompoundTag altPos = new CompoundTag();
                altPos.m_128347_("X", this.alternatePosition.f_82479_);
                altPos.m_128347_("Y", this.alternatePosition.f_82480_);
                altPos.m_128347_("Z", this.alternatePosition.f_82481_);
                tag.m_128365_("AlternatePosition", (Tag)altPos);
                tag.m_128405_("ParticleCount", this.particleCount);
                tag.m_128359_("ParticleType", this.particleType);
                tag.m_128347_("ParticleSpread", this.particleSpread);
                tag.m_128347_("ParticleRingRadius", this.particleRingRadius);
                tag.m_128379_("SpawnParticles", this.spawnParticles);
                return tag;
            }

            @Override
            public void deserializeNBT(CompoundTag tag) {
                super.deserializeNBT(tag);
                if (tag.m_128425_("Size", 99)) {
                    this.size = tag.m_128459_("Size");
                }
                if (tag.m_128425_("TextureLocation", 8)) {
                    this.textureLocation = tag.m_128461_("TextureLocation");
                }
                if (tag.m_128425_("AlternateMuzzleFlash", 99)) {
                    this.alternateMuzzleFlash = tag.m_128471_("AlternateMuzzleFlash");
                }
                if (tag.m_128425_("AlternatePosition", 10)) {
                    CompoundTag altPos = tag.m_128469_("AlternatePosition");
                    this.alternatePosition = new Vec3(altPos.m_128459_("X"), altPos.m_128459_("Y"), altPos.m_128459_("Z"));
                }
                if (tag.m_128425_("ParticleCount", 99)) {
                    this.particleCount = tag.m_128451_("ParticleCount");
                }
                if (tag.m_128425_("ParticleType", 8)) {
                    this.particleType = tag.m_128461_("ParticleType");
                }
                if (tag.m_128425_("ParticleSpread", 99)) {
                    this.particleSpread = tag.m_128459_("ParticleSpread");
                }
                if (tag.m_128425_("ParticleRingRadius", 99)) {
                    this.particleRingRadius = tag.m_128459_("ParticleRingRadius");
                }
                if (tag.m_128425_("SpawnParticles", 99)) {
                    this.spawnParticles = tag.m_128471_("SpawnParticles");
                }
            }

            @Override
            public JsonObject toJsonObject() {
                JsonObject object = super.toJsonObject();
                if (this.size != 0.5) {
                    object.addProperty("size", (Number)this.size);
                }
                object.addProperty("textureLocation", this.textureLocation);
                if (this.alternateMuzzleFlash) {
                    object.addProperty("alternateMuzzleFlash", Boolean.valueOf(true));
                    JsonObject altPos = new JsonObject();
                    altPos.addProperty("x", (Number)this.alternatePosition.f_82479_);
                    altPos.addProperty("y", (Number)this.alternatePosition.f_82480_);
                    altPos.addProperty("z", (Number)this.alternatePosition.f_82481_);
                    object.add("alternatePosition", (JsonElement)altPos);
                }
                if (this.particleCount != 5) {
                    object.addProperty("particleCount", (Number)this.particleCount);
                }
                if (!this.particleType.equals("minecraft:flame")) {
                    object.addProperty("particleType", this.particleType);
                }
                if (this.particleSpread != 0.1) {
                    object.addProperty("particleSpread", (Number)this.particleSpread);
                }
                if (this.particleRingRadius != 0.0) {
                    object.addProperty("particleRingRadius", (Number)this.particleRingRadius);
                }
                if (this.spawnParticles) {
                    object.addProperty("spawnParticles", Boolean.valueOf(true));
                }
                return object;
            }

            public SimpleParticleType getParticleType() {
                try {
                    ResourceLocation particleLocation = new ResourceLocation(this.particleType);
                    ParticleType registryType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(particleLocation);
                    if (registryType instanceof SimpleParticleType) {
                        SimpleParticleType simpleType = (SimpleParticleType)registryType;
                        return simpleType;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return ParticleTypes.f_123744_;
            }

            public boolean shouldSpawnParticles() {
                return this.spawnParticles;
            }

            public double getParticleSpread() {
                return this.particleSpread;
            }

            public double getParticleRingRadius() {
                return this.particleRingRadius;
            }

            public double getSize() {
                return this.size;
            }

            public String getTextureLocation() {
                return this.textureLocation;
            }

            public boolean hasAlternateMuzzleFlash() {
                return this.alternateMuzzleFlash;
            }

            public Vec3 getAlternatePosition() {
                return this.alternatePosition;
            }

            public int getParticleCount() {
                return this.particleCount;
            }
        }

        public static class BeamOrigin
        extends Positioned {
            private double horizontalOffset = 0.1;
            private double verticalOffset = -0.1;
            private double forwardOffset = 0.3;
            private double aimHorizontalOffset = 0.0;

            @Override
            public CompoundTag serializeNBT() {
                CompoundTag tag = super.serializeNBT();
                tag.m_128347_("HorizontalOffset", this.horizontalOffset);
                tag.m_128347_("VerticalOffset", this.verticalOffset);
                tag.m_128347_("ForwardOffset", this.forwardOffset);
                tag.m_128347_("AimHorizontalOffset", this.aimHorizontalOffset);
                return tag;
            }

            @Override
            public void deserializeNBT(CompoundTag tag) {
                super.deserializeNBT(tag);
                if (tag.m_128425_("HorizontalOffset", 99)) {
                    this.horizontalOffset = tag.m_128459_("HorizontalOffset");
                }
                if (tag.m_128425_("VerticalOffset", 99)) {
                    this.verticalOffset = tag.m_128459_("VerticalOffset");
                }
                if (tag.m_128425_("ForwardOffset", 99)) {
                    this.forwardOffset = tag.m_128459_("ForwardOffset");
                }
                if (tag.m_128425_("AimHorizontalOffset", 99)) {
                    this.aimHorizontalOffset = tag.m_128459_("AimHorizontalOffset");
                }
            }

            @Override
            public JsonObject toJsonObject() {
                JsonObject object = super.toJsonObject();
                if (this.horizontalOffset != 0.1) {
                    object.addProperty("horizontalOffset", (Number)this.horizontalOffset);
                }
                if (this.verticalOffset != -0.1) {
                    object.addProperty("verticalOffset", (Number)this.verticalOffset);
                }
                if (this.forwardOffset != 0.3) {
                    object.addProperty("forwardOffset", (Number)this.forwardOffset);
                }
                if (this.aimHorizontalOffset != 0.0) {
                    object.addProperty("aimHorizontalOffset", (Number)this.aimHorizontalOffset);
                }
                return object;
            }

            @Override
            public BeamOrigin copy() {
                BeamOrigin origin = new BeamOrigin();
                origin.horizontalOffset = this.horizontalOffset;
                origin.verticalOffset = this.verticalOffset;
                origin.forwardOffset = this.forwardOffset;
                origin.aimHorizontalOffset = this.aimHorizontalOffset;
                origin.xOffset = this.xOffset;
                origin.yOffset = this.yOffset;
                origin.zOffset = this.zOffset;
                return origin;
            }

            public double getHorizontalOffset() {
                return this.horizontalOffset;
            }

            public double getVerticalOffset() {
                return this.verticalOffset;
            }

            public double getForwardOffset() {
                return this.forwardOffset;
            }

            public double getAimHorizontalOffset() {
                return this.aimHorizontalOffset;
            }
        }
    }

    public static class Modules
    implements INBTSerializable<CompoundTag>,
    IEditorMenu {
        private transient Zoom cachedZoom;
        @Optional
        @javax.annotation.Nullable
        private Zoom zoom;
        private Attachments attachments = new Attachments();

        @javax.annotation.Nullable
        public Zoom getZoom() {
            return this.zoom;
        }

        public Attachments getAttachments() {
            return this.attachments;
        }

        @Override
        public Component getEditorLabel() {
            return Component.m_237115_((String)"Modules");
        }

        @Override
        public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                widgets.add(Pair.of((Object)Component.m_237115_((String)"Enabled Iron Sights"), () -> new DebugToggle(this.zoom != null, val -> {
                    if (val.booleanValue()) {
                        if (this.cachedZoom != null) {
                            this.zoom = this.cachedZoom;
                        } else {
                            this.cachedZoom = this.zoom = new Zoom();
                        }
                    } else {
                        this.cachedZoom = this.zoom;
                        this.zoom = null;
                    }
                })));
                widgets.add(Pair.of((Object)Component.m_237115_((String)"Adjust Iron Sights"), () -> new DebugButton((Component)Component.m_237115_((String)">"), btn -> {
                    if (btn.f_93623_ && this.zoom != null) {
                        Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(this.zoom));
                    }
                }, () -> this.zoom != null)));
            });
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.zoom != null) {
                tag.m_128365_("Zoom", (Tag)this.zoom.serializeNBT());
            }
            tag.m_128365_("Attachments", (Tag)this.attachments.serializeNBT());
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Zoom", 10)) {
                Zoom zoom = new Zoom();
                zoom.deserializeNBT(tag.m_128469_("Zoom"));
                this.zoom = zoom;
            }
            if (tag.m_128425_("Attachments", 10)) {
                this.attachments.deserializeNBT(tag.m_128469_("Attachments"));
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.zoom != null) {
                object.add("zoom", (JsonElement)this.zoom.toJsonObject());
            }
            GunJsonUtil.addObjectIfNotEmpty(object, "attachments", this.attachments.toJsonObject());
            return object;
        }

        public Modules copy() {
            Modules modules = new Modules();
            if (this.zoom != null) {
                modules.zoom = this.zoom.copy();
            }
            modules.attachments = this.attachments.copy();
            return modules;
        }

        public static class Attachments
        implements INBTSerializable<CompoundTag> {
            @Optional
            @javax.annotation.Nullable
            private ScaledPositioned scope;
            @Optional
            @javax.annotation.Nullable
            private ScaledPositioned barrel;
            @Optional
            @javax.annotation.Nullable
            private ScaledPositioned stock;
            @Optional
            @javax.annotation.Nullable
            private ScaledPositioned underBarrel;
            @Optional
            @javax.annotation.Nullable
            private ScaledPositioned magazine;

            @javax.annotation.Nullable
            public ScaledPositioned getScope() {
                return this.scope;
            }

            @javax.annotation.Nullable
            public ScaledPositioned getBarrel() {
                return this.barrel;
            }

            @javax.annotation.Nullable
            public ScaledPositioned getStock() {
                return this.stock;
            }

            @javax.annotation.Nullable
            public ScaledPositioned getUnderBarrel() {
                return this.underBarrel;
            }

            @javax.annotation.Nullable
            public ScaledPositioned getMagazine() {
                return this.magazine;
            }

            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                if (this.scope != null) {
                    tag.m_128365_("Scope", (Tag)this.scope.serializeNBT());
                }
                if (this.barrel != null) {
                    tag.m_128365_("Barrel", (Tag)this.barrel.serializeNBT());
                }
                if (this.stock != null) {
                    tag.m_128365_("Stock", (Tag)this.stock.serializeNBT());
                }
                if (this.underBarrel != null) {
                    tag.m_128365_("UnderBarrel", (Tag)this.underBarrel.serializeNBT());
                }
                if (this.magazine != null) {
                    tag.m_128365_("Magazine", (Tag)this.magazine.serializeNBT());
                }
                return tag;
            }

            public void deserializeNBT(CompoundTag tag) {
                if (tag.m_128425_("Scope", 10)) {
                    this.scope = this.createScaledPositioned(tag, "Scope");
                }
                if (tag.m_128425_("Barrel", 10)) {
                    this.barrel = this.createScaledPositioned(tag, "Barrel");
                }
                if (tag.m_128425_("Stock", 10)) {
                    this.stock = this.createScaledPositioned(tag, "Stock");
                }
                if (tag.m_128425_("UnderBarrel", 10)) {
                    this.underBarrel = this.createScaledPositioned(tag, "UnderBarrel");
                }
                if (tag.m_128425_("Magazine", 10)) {
                    this.magazine = this.createScaledPositioned(tag, "Magazine");
                }
            }

            public JsonObject toJsonObject() {
                JsonObject object = new JsonObject();
                if (this.scope != null) {
                    object.add("scope", (JsonElement)this.scope.toJsonObject());
                }
                if (this.barrel != null) {
                    object.add("barrel", (JsonElement)this.barrel.toJsonObject());
                }
                if (this.stock != null) {
                    object.add("stock", (JsonElement)this.stock.toJsonObject());
                }
                if (this.underBarrel != null) {
                    object.add("underBarrel", (JsonElement)this.underBarrel.toJsonObject());
                }
                if (this.magazine != null) {
                    object.add("magazine", (JsonElement)this.magazine.toJsonObject());
                }
                return object;
            }

            public Attachments copy() {
                Attachments attachments = new Attachments();
                if (this.scope != null) {
                    attachments.scope = this.scope.copy();
                }
                if (this.barrel != null) {
                    attachments.barrel = this.barrel.copy();
                }
                if (this.stock != null) {
                    attachments.stock = this.stock.copy();
                }
                if (this.underBarrel != null) {
                    attachments.underBarrel = this.underBarrel.copy();
                }
                if (this.magazine != null) {
                    attachments.magazine = this.magazine.copy();
                }
                return attachments;
            }

            @javax.annotation.Nullable
            private ScaledPositioned createScaledPositioned(CompoundTag tag, String key) {
                CompoundTag attachment = tag.m_128469_(key);
                return attachment.m_128456_() ? null : new ScaledPositioned(attachment);
            }
        }

        public static class Zoom
        extends Positioned
        implements IEditorMenu {
            @Optional
            private float fovModifier;

            @Override
            public CompoundTag serializeNBT() {
                CompoundTag tag = super.serializeNBT();
                tag.m_128350_("FovModifier", this.fovModifier);
                return tag;
            }

            @Override
            public void deserializeNBT(CompoundTag tag) {
                super.deserializeNBT(tag);
                if (tag.m_128425_("FovModifier", 99)) {
                    this.fovModifier = tag.m_128457_("FovModifier");
                }
            }

            @Override
            public JsonObject toJsonObject() {
                JsonObject object = super.toJsonObject();
                object.addProperty("fovModifier", (Number)Float.valueOf(this.fovModifier));
                return object;
            }

            @Override
            public Zoom copy() {
                Zoom zoom = new Zoom();
                zoom.fovModifier = this.fovModifier;
                zoom.xOffset = this.xOffset;
                zoom.yOffset = this.yOffset;
                zoom.zOffset = this.zOffset;
                return zoom;
            }

            @Override
            public Component getEditorLabel() {
                return Component.m_237115_((String)"Zoom");
            }

            @Override
            public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> widgets.add(Pair.of((Object)Component.m_237115_((String)"FOV Modifier"), () -> new DebugSlider(0.0, 1.0, this.fovModifier, 0.01, 3, val -> {
                    this.fovModifier = val.floatValue();
                }))));
            }

            public float getFovModifier() {
                return this.fovModifier;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends AbstractBuilder<Builder> {
            }

            protected static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
            extends Positioned.AbstractBuilder<T> {
                protected final Zoom zoom;

                protected AbstractBuilder() {
                    this(new Zoom());
                }

                protected AbstractBuilder(Zoom zoom) {
                    super(zoom);
                    this.zoom = zoom;
                }

                public T setFovModifier(float fovModifier) {
                    this.zoom.fovModifier = fovModifier;
                    return (T)((AbstractBuilder)this.self());
                }

                @Override
                public Zoom build() {
                    return this.zoom.copy();
                }
            }
        }
    }

    public static enum WeaponType {
        pistol,
        magnum,
        smg,
        rifle,
        lmg,
        shotgun,
        sniper,
        heavy,
        flamethrower,
        shock,
        plasma,
        laser,
        special;

    }

    public static class ScaledPositioned
    extends Positioned {
        @Optional
        protected double scale = 1.0;

        public ScaledPositioned() {
        }

        public ScaledPositioned(CompoundTag tag) {
            this.deserializeNBT(tag);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            tag.m_128347_("Scale", this.scale);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag tag) {
            super.deserializeNBT(tag);
            if (tag.m_128425_("Scale", 99)) {
                this.scale = tag.m_128459_("Scale");
            }
        }

        @Override
        public JsonObject toJsonObject() {
            JsonObject object = super.toJsonObject();
            if (this.scale != 1.0) {
                object.addProperty("scale", (Number)this.scale);
            }
            return object;
        }

        public double getScale() {
            return this.scale;
        }

        @Override
        public ScaledPositioned copy() {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.xOffset = this.xOffset;
            positioned.yOffset = this.yOffset;
            positioned.zOffset = this.zOffset;
            positioned.scale = this.scale;
            return positioned;
        }
    }

    public static class Builder {
        private final Gun gun = new Gun();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Gun build() {
            return this.gun.copy();
        }

        public Builder setFireMode(FireMode fireMode) {
            this.gun.general.fireMode = fireMode;
            return this;
        }

        public Builder setCasingType(Item item) {
            this.gun.projectile.casingType = ForgeRegistries.ITEMS.getKey((Object)item);
            return this;
        }

        public Builder setBurstAmount(int burstAmount) {
            this.gun.general.burstAmount = burstAmount;
            return this;
        }

        public Builder setFireRate(int rate) {
            this.gun.general.rate = rate;
            return this;
        }

        public Builder setFireTimer(int fireTimer) {
            this.gun.general.fireTimer = fireTimer;
            return this;
        }

        public Builder setGripType(GripType gripType) {
            this.gun.general.gripType = gripType;
            return this;
        }

        public Builder setReloadItem(Item item) {
            this.gun.reloads.reloadItem = ForgeRegistries.ITEMS.getKey((Object)item);
            return this;
        }

        public Builder setMaxAmmo(int maxAmmo) {
            this.gun.reloads.maxAmmo = maxAmmo;
            return this;
        }

        public Builder setReloadType(ReloadType reloadType) {
            this.gun.reloads.reloadType = reloadType;
            return this;
        }

        public Builder setReloadTimer(int reloadTimer) {
            this.gun.reloads.reloadTimer = reloadTimer;
            return this;
        }

        public Builder setEmptyMagTimer(int emptyMagTimer) {
            this.gun.reloads.emptyMagTimer = emptyMagTimer;
            return this;
        }

        public Builder setReloadAmount(int reloadAmount) {
            this.gun.reloads.reloadAmount = reloadAmount;
            return this;
        }

        public Builder setRecoilAngle(float recoilAngle) {
            this.gun.general.recoilAngle = recoilAngle;
            return this;
        }

        public Builder setRecoilKick(float recoilKick) {
            this.gun.general.recoilKick = recoilKick;
            return this;
        }

        public Builder setRecoilDurationOffset(float recoilDurationOffset) {
            this.gun.general.recoilDurationOffset = recoilDurationOffset;
            return this;
        }

        public Builder setRecoilAdsReduction(float recoilAdsReduction) {
            this.gun.general.recoilAdsReduction = recoilAdsReduction;
            return this;
        }

        public Builder setProjectileAmount(int projectileAmount) {
            this.gun.general.projectileAmount = projectileAmount;
            return this;
        }

        public Builder setAlwaysSpread(boolean alwaysSpread) {
            this.gun.general.alwaysSpread = alwaysSpread;
            return this;
        }

        public Builder setSpread(float spread) {
            this.gun.general.spread = spread;
            return this;
        }

        public Builder setRestingSpread(float restingSpread) {
            this.gun.general.restingSpread = restingSpread;
            return this;
        }

        public Builder setSpreadAdsReduction(float spreadAdsReduction) {
            this.gun.general.spreadAdsReduction = spreadAdsReduction;
            return this;
        }

        public Builder setAmmo(Item item) {
            this.gun.projectile.item = ForgeRegistries.ITEMS.getKey((Object)item);
            return this;
        }

        public Builder setEjectsCasing(boolean ejectsCasing) {
            this.gun.projectile.ejectsCasing = ejectsCasing;
            return this;
        }

        public Builder setProjectileVisible(boolean visible) {
            this.gun.projectile.visible = visible;
            return this;
        }

        public Builder setProjectileSize(float size) {
            this.gun.projectile.size = size;
            return this;
        }

        public Builder setProjectileSpeed(double speed) {
            this.gun.projectile.speed = speed;
            return this;
        }

        public Builder setProjectileLife(int life) {
            this.gun.projectile.life = life;
            return this;
        }

        public Builder setProjectileAffectedByGravity(boolean gravity) {
            this.gun.projectile.gravity = gravity;
            return this;
        }

        public Builder setProjectileTrailColor(int trailColor) {
            this.gun.projectile.trailColor = trailColor;
            return this;
        }

        public Builder setProjectileTrailLengthMultiplier(int trailLengthMultiplier) {
            this.gun.projectile.trailLengthMultiplier = trailLengthMultiplier;
            return this;
        }

        public Builder setDamage(float damage) {
            this.gun.projectile.damage = damage;
            return this;
        }

        public Builder setAdvantage(ResourceLocation advantage) {
            this.gun.projectile.advantage = advantage;
            return this;
        }

        public Builder setReduceDamageOverLife(boolean damageReduceOverLife) {
            this.gun.projectile.damageReduceOverLife = damageReduceOverLife;
            return this;
        }

        public Builder setFireSound(SoundEvent sound) {
            this.gun.sounds.fire = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        public Builder setReloadSound(SoundEvent sound) {
            this.gun.sounds.reload = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        public Builder setCockSound(SoundEvent sound) {
            this.gun.sounds.cock = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        public Builder setSilencedFireSound(SoundEvent sound) {
            this.gun.sounds.silencedFire = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        public Builder setEnchantedFireSound(SoundEvent sound) {
            this.gun.sounds.enchantedFire = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        public Builder setPreFireSound(SoundEvent sound) {
            this.gun.sounds.preFire = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder setMuzzleFlash(double size, double xOffset, double yOffset, double zOffset) {
            Display.Flash flash = new Display.Flash();
            flash.size = size;
            flash.xOffset = xOffset;
            flash.yOffset = yOffset;
            flash.zOffset = zOffset;
            this.gun.display.flash = flash;
            return this;
        }

        public Builder setZoom(float fovModifier, double xOffset, double yOffset, double zOffset) {
            Modules.Zoom zoom = new Modules.Zoom();
            zoom.fovModifier = fovModifier;
            zoom.xOffset = xOffset;
            zoom.yOffset = yOffset;
            zoom.zOffset = zOffset;
            this.gun.modules.zoom = zoom;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder setZoom(Modules.Zoom.Builder builder) {
            this.gun.modules.zoom = builder.build();
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder setScope(float scale, double xOffset, double yOffset, double zOffset) {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.scale = scale;
            positioned.xOffset = xOffset;
            positioned.yOffset = yOffset;
            positioned.zOffset = zOffset;
            this.gun.modules.attachments.scope = positioned;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder setBarrel(float scale, double xOffset, double yOffset, double zOffset) {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.scale = scale;
            positioned.xOffset = xOffset;
            positioned.yOffset = yOffset;
            positioned.zOffset = zOffset;
            this.gun.modules.attachments.barrel = positioned;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder setStock(float scale, double xOffset, double yOffset, double zOffset) {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.scale = scale;
            positioned.xOffset = xOffset;
            positioned.yOffset = yOffset;
            positioned.zOffset = zOffset;
            this.gun.modules.attachments.stock = positioned;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder setUnderBarrel(float scale, double xOffset, double yOffset, double zOffset) {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.scale = scale;
            positioned.xOffset = xOffset;
            positioned.yOffset = yOffset;
            positioned.zOffset = zOffset;
            this.gun.modules.attachments.underBarrel = positioned;
            return this;
        }

        public Builder setMagazine(float scale, double xOffset, double yOffset, double zOffset) {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.scale = scale;
            positioned.xOffset = xOffset;
            positioned.yOffset = yOffset;
            positioned.zOffset = zOffset;
            this.gun.modules.attachments.magazine = positioned;
            return this;
        }
    }

    public static class Positioned
    implements INBTSerializable<CompoundTag> {
        @Optional
        protected double xOffset;
        @Optional
        protected double yOffset;
        @Optional
        protected double zOffset;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128347_("XOffset", this.xOffset);
            tag.m_128347_("YOffset", this.yOffset);
            tag.m_128347_("ZOffset", this.zOffset);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("XOffset", 99)) {
                this.xOffset = tag.m_128459_("XOffset");
            }
            if (tag.m_128425_("YOffset", 99)) {
                this.yOffset = tag.m_128459_("YOffset");
            }
            if (tag.m_128425_("ZOffset", 99)) {
                this.zOffset = tag.m_128459_("ZOffset");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.xOffset != 0.0) {
                object.addProperty("xOffset", (Number)this.xOffset);
            }
            if (this.yOffset != 0.0) {
                object.addProperty("yOffset", (Number)this.yOffset);
            }
            if (this.zOffset != 0.0) {
                object.addProperty("zOffset", (Number)this.zOffset);
            }
            return object;
        }

        public double getXOffset() {
            return this.xOffset;
        }

        public double getYOffset() {
            return this.yOffset;
        }

        public double getZOffset() {
            return this.zOffset;
        }

        public Positioned copy() {
            Positioned positioned = new Positioned();
            positioned.xOffset = this.xOffset;
            positioned.yOffset = this.yOffset;
            positioned.zOffset = this.zOffset;
            return positioned;
        }

        protected static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
        extends SuperBuilder<Positioned, T> {
            private final Positioned positioned;

            private AbstractBuilder() {
                this(new Positioned());
            }

            protected AbstractBuilder(Positioned positioned) {
                this.positioned = positioned;
            }

            public T setOffset(double xOffset, double yOffset, double zOffset) {
                this.positioned.xOffset = xOffset;
                this.positioned.yOffset = yOffset;
                this.positioned.zOffset = zOffset;
                return (T)((AbstractBuilder)this.self());
            }

            public T setXOffset(double xOffset) {
                this.positioned.xOffset = xOffset;
                return (T)((AbstractBuilder)this.self());
            }

            public T setYOffset(double yOffset) {
                this.positioned.yOffset = yOffset;
                return (T)((AbstractBuilder)this.self());
            }

            public T setZOffset(double zOffset) {
                this.positioned.zOffset = zOffset;
                return (T)((AbstractBuilder)this.self());
            }

            @Override
            public Positioned build() {
                return this.positioned.copy();
            }
        }

        public static class Builder
        extends AbstractBuilder<Builder> {
        }
    }
}

