/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.annotation.Optional;

public class Turret
implements INBTSerializable<CompoundTag> {
    protected Targeting targeting = new Targeting();
    protected Combat combat = new Combat();
    protected Ammunition ammunition = new Ammunition();
    protected Behavior behavior = new Behavior();
    protected Display display = new Display();

    public Targeting getTargeting() {
        return this.targeting;
    }

    public Combat getCombat() {
        return this.combat;
    }

    public Ammunition getAmmunition() {
        return this.ammunition;
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public Display getDisplay() {
        return this.display;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Targeting", (Tag)this.targeting.serializeNBT());
        tag.m_128365_("Combat", (Tag)this.combat.serializeNBT());
        tag.m_128365_("Ammunition", (Tag)this.ammunition.serializeNBT());
        tag.m_128365_("Behavior", (Tag)this.behavior.serializeNBT());
        tag.m_128365_("Display", (Tag)this.display.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("Targeting", 10)) {
            this.targeting.deserializeNBT(tag.m_128469_("Targeting"));
        }
        if (tag.m_128425_("Combat", 10)) {
            this.combat.deserializeNBT(tag.m_128469_("Combat"));
        }
        if (tag.m_128425_("Ammunition", 10)) {
            this.ammunition.deserializeNBT(tag.m_128469_("Ammunition"));
        }
        if (tag.m_128425_("Behavior", 10)) {
            this.behavior.deserializeNBT(tag.m_128469_("Behavior"));
        }
        if (tag.m_128425_("Display", 10)) {
            this.display.deserializeNBT(tag.m_128469_("Display"));
        }
    }

    public JsonObject toJsonObject() {
        JsonObject object = new JsonObject();
        object.add("targeting", (JsonElement)this.targeting.toJsonObject());
        object.add("combat", (JsonElement)this.combat.toJsonObject());
        object.add("ammunition", (JsonElement)this.ammunition.toJsonObject());
        object.add("behavior", (JsonElement)this.behavior.toJsonObject());
        object.add("display", (JsonElement)this.display.toJsonObject());
        return object;
    }

    public static Turret create(CompoundTag tag) {
        Turret turret = new Turret();
        turret.deserializeNBT(tag);
        return turret;
    }

    public Turret copy() {
        Turret turret = new Turret();
        turret.targeting = this.targeting.copy();
        turret.combat = this.combat.copy();
        turret.ammunition = this.ammunition.copy();
        turret.behavior = this.behavior.copy();
        turret.display = this.display.copy();
        return turret;
    }

    public static class Targeting
    implements INBTSerializable<CompoundTag> {
        private double range = 12.0;
        private double verticalRange = 12.0;
        private double minFiringDistance = 1.3;
        private float rotationSpeed = 0.5f;
        private float positionSmoothing = 0.2f;
        private float maxPitch = 60.0f;
        private float minPitch = -25.0f;
        private int predictionMultiplier = 7;
        private boolean requiresLineOfSight = true;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128347_("Range", this.range);
            tag.m_128347_("VerticalRange", this.verticalRange);
            tag.m_128347_("MinFiringDistance", this.minFiringDistance);
            tag.m_128350_("RotationSpeed", this.rotationSpeed);
            tag.m_128350_("PositionSmoothing", this.positionSmoothing);
            tag.m_128350_("MaxPitch", this.maxPitch);
            tag.m_128350_("MinPitch", this.minPitch);
            tag.m_128405_("PredictionMultiplier", this.predictionMultiplier);
            tag.m_128379_("RequiresLineOfSight", this.requiresLineOfSight);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Range", 99)) {
                this.range = tag.m_128459_("Range");
            }
            if (tag.m_128425_("VerticalRange", 99)) {
                this.verticalRange = tag.m_128459_("VerticalRange");
            }
            if (tag.m_128425_("MinFiringDistance", 99)) {
                this.minFiringDistance = tag.m_128459_("MinFiringDistance");
            }
            if (tag.m_128425_("RotationSpeed", 99)) {
                this.rotationSpeed = tag.m_128457_("RotationSpeed");
            }
            if (tag.m_128425_("PositionSmoothing", 99)) {
                this.positionSmoothing = tag.m_128457_("PositionSmoothing");
            }
            if (tag.m_128425_("MaxPitch", 99)) {
                this.maxPitch = tag.m_128457_("MaxPitch");
            }
            if (tag.m_128425_("MinPitch", 99)) {
                this.minPitch = tag.m_128457_("MinPitch");
            }
            if (tag.m_128425_("PredictionMultiplier", 99)) {
                this.predictionMultiplier = tag.m_128451_("PredictionMultiplier");
            }
            if (tag.m_128425_("RequiresLineOfSight", 99)) {
                this.requiresLineOfSight = tag.m_128471_("RequiresLineOfSight");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.range != 12.0) {
                object.addProperty("range", (Number)this.range);
            }
            if (this.verticalRange != 12.0) {
                object.addProperty("verticalRange", (Number)this.verticalRange);
            }
            if (this.minFiringDistance != 1.3) {
                object.addProperty("minFiringDistance", (Number)this.minFiringDistance);
            }
            if (this.rotationSpeed != 0.5f) {
                object.addProperty("rotationSpeed", (Number)Float.valueOf(this.rotationSpeed));
            }
            if (this.positionSmoothing != 0.2f) {
                object.addProperty("positionSmoothing", (Number)Float.valueOf(this.positionSmoothing));
            }
            if (this.maxPitch != 60.0f) {
                object.addProperty("maxPitch", (Number)Float.valueOf(this.maxPitch));
            }
            if (this.minPitch != -25.0f) {
                object.addProperty("minPitch", (Number)Float.valueOf(this.minPitch));
            }
            if (this.predictionMultiplier != 7) {
                object.addProperty("predictionMultiplier", (Number)this.predictionMultiplier);
            }
            if (!this.requiresLineOfSight) {
                object.addProperty("requiresLineOfSight", Boolean.valueOf(false));
            }
            return object;
        }

        public Targeting copy() {
            Targeting targeting = new Targeting();
            targeting.range = this.range;
            targeting.verticalRange = this.verticalRange;
            targeting.minFiringDistance = this.minFiringDistance;
            targeting.rotationSpeed = this.rotationSpeed;
            targeting.positionSmoothing = this.positionSmoothing;
            targeting.maxPitch = this.maxPitch;
            targeting.minPitch = this.minPitch;
            targeting.predictionMultiplier = this.predictionMultiplier;
            targeting.requiresLineOfSight = this.requiresLineOfSight;
            return targeting;
        }

        public double getRange() {
            return this.range;
        }

        public double getVerticalRange() {
            return this.verticalRange;
        }

        public double getMinFiringDistance() {
            return this.minFiringDistance;
        }

        public float getRotationSpeed() {
            return this.rotationSpeed;
        }

        public float getPositionSmoothing() {
            return this.positionSmoothing;
        }

        public float getMaxPitch() {
            return this.maxPitch;
        }

        public float getMinPitch() {
            return this.minPitch;
        }

        public int getPredictionMultiplier() {
            return this.predictionMultiplier;
        }

        public boolean requiresLineOfSight() {
            return this.requiresLineOfSight;
        }

        public void setRange(double range) {
            this.range = range;
        }

        public void setVerticalRange(double verticalRange) {
            this.verticalRange = verticalRange;
        }

        public void setMinFiringDistance(double minFiringDistance) {
            this.minFiringDistance = minFiringDistance;
        }

        public void setRotationSpeed(float rotationSpeed) {
            this.rotationSpeed = rotationSpeed;
        }

        public void setPositionSmoothing(float positionSmoothing) {
            this.positionSmoothing = positionSmoothing;
        }

        public void setMaxPitch(float maxPitch) {
            this.maxPitch = maxPitch;
        }

        public void setMinPitch(float minPitch) {
            this.minPitch = minPitch;
        }

        public void setPredictionMultiplier(int predictionMultiplier) {
            this.predictionMultiplier = predictionMultiplier;
        }

        public void setRequiresLineOfSight(boolean requiresLineOfSight) {
            this.requiresLineOfSight = requiresLineOfSight;
        }
    }

    public static class Combat
    implements INBTSerializable<CompoundTag> {
        private int cooldown = 16;
        private float inaccuracy = 0.05f;
        @Optional
        private int pelletCount = 1;
        @Optional
        private float spreadAngle = 0.0f;
        private float recoilMax = 4.0f;
        private float recoilSpeed = 0.3f;
        @Optional
        private int damageModifier = 0;
        private double projectileSpeed = 3.0;
        @Optional
        private ResourceLocation fireSound;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("Cooldown", this.cooldown);
            tag.m_128350_("Inaccuracy", this.inaccuracy);
            tag.m_128405_("PelletCount", this.pelletCount);
            tag.m_128350_("SpreadAngle", this.spreadAngle);
            tag.m_128350_("RecoilMax", this.recoilMax);
            tag.m_128350_("RecoilSpeed", this.recoilSpeed);
            tag.m_128405_("DamageModifier", this.damageModifier);
            tag.m_128347_("ProjectileSpeed", this.projectileSpeed);
            if (this.fireSound != null) {
                tag.m_128359_("FireSound", this.fireSound.toString());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Cooldown", 99)) {
                this.cooldown = tag.m_128451_("Cooldown");
            }
            if (tag.m_128425_("Inaccuracy", 99)) {
                this.inaccuracy = tag.m_128457_("Inaccuracy");
            }
            if (tag.m_128425_("PelletCount", 99)) {
                this.pelletCount = tag.m_128451_("PelletCount");
            }
            if (tag.m_128425_("SpreadAngle", 99)) {
                this.spreadAngle = tag.m_128457_("SpreadAngle");
            }
            if (tag.m_128425_("RecoilMax", 99)) {
                this.recoilMax = tag.m_128457_("RecoilMax");
            }
            if (tag.m_128425_("RecoilSpeed", 99)) {
                this.recoilSpeed = tag.m_128457_("RecoilSpeed");
            }
            if (tag.m_128425_("DamageModifier", 99)) {
                this.damageModifier = tag.m_128451_("DamageModifier");
            }
            if (tag.m_128425_("ProjectileSpeed", 99)) {
                this.projectileSpeed = tag.m_128459_("ProjectileSpeed");
            }
            if (tag.m_128425_("FireSound", 8)) {
                this.fireSound = new ResourceLocation(tag.m_128461_("FireSound"));
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.cooldown != 16) {
                object.addProperty("cooldown", (Number)this.cooldown);
            }
            if (this.inaccuracy != 0.05f) {
                object.addProperty("inaccuracy", (Number)Float.valueOf(this.inaccuracy));
            }
            if (this.pelletCount != 1) {
                object.addProperty("pelletCount", (Number)this.pelletCount);
            }
            if (this.spreadAngle != 0.0f) {
                object.addProperty("spreadAngle", (Number)Float.valueOf(this.spreadAngle));
            }
            if (this.recoilMax != 4.0f) {
                object.addProperty("recoilMax", (Number)Float.valueOf(this.recoilMax));
            }
            if (this.recoilSpeed != 0.3f) {
                object.addProperty("recoilSpeed", (Number)Float.valueOf(this.recoilSpeed));
            }
            if (this.damageModifier != 0) {
                object.addProperty("damageModifier", (Number)this.damageModifier);
            }
            if (this.projectileSpeed != 3.0) {
                object.addProperty("projectileSpeed", (Number)this.projectileSpeed);
            }
            if (this.fireSound != null) {
                object.addProperty("fireSound", this.fireSound.toString());
            }
            return object;
        }

        public Combat copy() {
            Combat combat = new Combat();
            combat.cooldown = this.cooldown;
            combat.inaccuracy = this.inaccuracy;
            combat.pelletCount = this.pelletCount;
            combat.spreadAngle = this.spreadAngle;
            combat.recoilMax = this.recoilMax;
            combat.recoilSpeed = this.recoilSpeed;
            combat.damageModifier = this.damageModifier;
            combat.projectileSpeed = this.projectileSpeed;
            combat.fireSound = this.fireSound;
            return combat;
        }

        public int getCooldown() {
            return this.cooldown;
        }

        public float getInaccuracy() {
            return this.inaccuracy;
        }

        public int getPelletCount() {
            return this.pelletCount;
        }

        public float getSpreadAngle() {
            return this.spreadAngle;
        }

        public float getRecoilMax() {
            return this.recoilMax;
        }

        public float getRecoilSpeed() {
            return this.recoilSpeed;
        }

        public int getDamageModifier() {
            return this.damageModifier;
        }

        public double getProjectileSpeed() {
            return this.projectileSpeed;
        }

        @Nullable
        public ResourceLocation getFireSound() {
            return this.fireSound;
        }

        public void setCooldown(int cooldown) {
            this.cooldown = cooldown;
        }

        public void setInaccuracy(float inaccuracy) {
            this.inaccuracy = inaccuracy;
        }

        public void setPelletCount(int pelletCount) {
            this.pelletCount = pelletCount;
        }

        public void setSpreadAngle(float spreadAngle) {
            this.spreadAngle = spreadAngle;
        }

        public void setRecoilMax(float recoilMax) {
            this.recoilMax = recoilMax;
        }

        public void setRecoilSpeed(float recoilSpeed) {
            this.recoilSpeed = recoilSpeed;
        }

        public void setDamageModifier(int damageModifier) {
            this.damageModifier = damageModifier;
        }

        public void setProjectileSpeed(double projectileSpeed) {
            this.projectileSpeed = projectileSpeed;
        }

        public void setFireSound(ResourceLocation fireSound) {
            this.fireSound = fireSound;
        }
    }

    public static class Ammunition
    implements INBTSerializable<CompoundTag> {
        private List<AmmoType> acceptedAmmo = new ArrayList<AmmoType>();
        @Optional
        private float casingEjectChance = 0.65f;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            CompoundTag ammoTag = new CompoundTag();
            for (int i = 0; i < this.acceptedAmmo.size(); ++i) {
                ammoTag.m_128365_("Ammo" + i, (Tag)this.acceptedAmmo.get(i).serializeNBT());
            }
            tag.m_128365_("AcceptedAmmo", (Tag)ammoTag);
            tag.m_128350_("CasingEjectChance", this.casingEjectChance);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("AcceptedAmmo", 10)) {
                CompoundTag ammoTag = tag.m_128469_("AcceptedAmmo");
                this.acceptedAmmo.clear();
                int i = 0;
                while (ammoTag.m_128441_("Ammo" + i)) {
                    AmmoType ammo = new AmmoType();
                    ammo.deserializeNBT(ammoTag.m_128469_("Ammo" + i));
                    this.acceptedAmmo.add(ammo);
                    ++i;
                }
            }
            if (tag.m_128425_("CasingEjectChance", 99)) {
                this.casingEjectChance = tag.m_128457_("CasingEjectChance");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (!this.acceptedAmmo.isEmpty()) {
                JsonArray ammoArray = new JsonArray();
                for (AmmoType ammo : this.acceptedAmmo) {
                    ammoArray.add((JsonElement)ammo.toJsonObject());
                }
                object.add("acceptedAmmo", (JsonElement)ammoArray);
            }
            if (this.casingEjectChance != 0.65f) {
                object.addProperty("casingEjectChance", (Number)Float.valueOf(this.casingEjectChance));
            }
            return object;
        }

        public Ammunition copy() {
            Ammunition ammunition = new Ammunition();
            for (AmmoType ammo : this.acceptedAmmo) {
                ammunition.acceptedAmmo.add(ammo.copy());
            }
            ammunition.casingEjectChance = this.casingEjectChance;
            return ammunition;
        }

        public List<AmmoType> getAcceptedAmmo() {
            return this.acceptedAmmo;
        }

        public float getCasingEjectChance() {
            return this.casingEjectChance;
        }

        public void clearAcceptedAmmo() {
            this.acceptedAmmo.clear();
        }

        public void addAmmoType(AmmoType ammo) {
            this.acceptedAmmo.add(ammo);
        }

        public void setCasingEjectChance(float casingEjectChance) {
            this.casingEjectChance = casingEjectChance;
        }

        public static class AmmoType
        implements INBTSerializable<CompoundTag> {
            private ResourceLocation item;
            private ResourceLocation bulletType;
            @Optional
            private ResourceLocation casingType;
            private double damage = 5.0;
            @Optional
            private float armorPenetration = 0.0f;

            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("Item", this.item.toString());
                tag.m_128359_("BulletType", this.bulletType.toString());
                if (this.casingType != null) {
                    tag.m_128359_("CasingType", this.casingType.toString());
                }
                tag.m_128347_("Damage", this.damage);
                tag.m_128350_("ArmorPenetration", this.armorPenetration);
                return tag;
            }

            public void deserializeNBT(CompoundTag tag) {
                if (tag.m_128425_("Item", 8)) {
                    this.item = new ResourceLocation(tag.m_128461_("Item"));
                }
                if (tag.m_128425_("BulletType", 8)) {
                    this.bulletType = new ResourceLocation(tag.m_128461_("BulletType"));
                }
                if (tag.m_128425_("CasingType", 8)) {
                    this.casingType = new ResourceLocation(tag.m_128461_("CasingType"));
                }
                if (tag.m_128425_("Damage", 99)) {
                    this.damage = tag.m_128459_("Damage");
                }
                if (tag.m_128425_("ArmorPenetration", 99)) {
                    this.armorPenetration = tag.m_128457_("ArmorPenetration");
                }
            }

            public JsonObject toJsonObject() {
                JsonObject object = new JsonObject();
                object.addProperty("item", this.item.toString());
                object.addProperty("bulletType", this.bulletType.toString());
                if (this.casingType != null) {
                    object.addProperty("casingType", this.casingType.toString());
                }
                object.addProperty("damage", (Number)this.damage);
                if (this.armorPenetration != 0.0f) {
                    object.addProperty("armorPenetration", (Number)Float.valueOf(this.armorPenetration));
                }
                return object;
            }

            public AmmoType copy() {
                AmmoType ammo = new AmmoType();
                ammo.item = this.item;
                ammo.bulletType = this.bulletType;
                ammo.casingType = this.casingType;
                ammo.damage = this.damage;
                ammo.armorPenetration = this.armorPenetration;
                return ammo;
            }

            @Nullable
            public Item getItem() {
                return (Item)ForgeRegistries.ITEMS.getValue(this.item);
            }

            public ResourceLocation getBulletType() {
                return this.bulletType;
            }

            @Nullable
            public ResourceLocation getCasingType() {
                return this.casingType;
            }

            public double getDamage() {
                return this.damage;
            }

            public float getArmorPenetration() {
                return this.armorPenetration;
            }

            public void setItem(ResourceLocation item) {
                this.item = item;
            }

            public void setBulletType(ResourceLocation bulletType) {
                this.bulletType = bulletType;
            }

            public void setCasingType(ResourceLocation casingType) {
                this.casingType = casingType;
            }

            public void setDamage(double damage) {
                this.damage = damage;
            }

            public void setArmorPenetration(float armorPenetration) {
                this.armorPenetration = armorPenetration;
            }
        }
    }

    public static class Behavior
    implements INBTSerializable<CompoundTag> {
        private float restingYaw = 0.0f;
        private float restingPitch = -30.0f;
        private int disableTime = 200;
        @Optional
        private boolean hasOpenAnimation = false;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("RestingYaw", this.restingYaw);
            tag.m_128350_("RestingPitch", this.restingPitch);
            tag.m_128405_("DisableTime", this.disableTime);
            tag.m_128379_("HasOpenAnimation", this.hasOpenAnimation);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("RestingYaw", 99)) {
                this.restingYaw = tag.m_128457_("RestingYaw");
            }
            if (tag.m_128425_("RestingPitch", 99)) {
                this.restingPitch = tag.m_128457_("RestingPitch");
            }
            if (tag.m_128425_("DisableTime", 99)) {
                this.disableTime = tag.m_128451_("DisableTime");
            }
            if (tag.m_128425_("HasOpenAnimation", 99)) {
                this.hasOpenAnimation = tag.m_128471_("HasOpenAnimation");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.restingYaw != 0.0f) {
                object.addProperty("restingYaw", (Number)Float.valueOf(this.restingYaw));
            }
            if (this.restingPitch != -30.0f) {
                object.addProperty("restingPitch", (Number)Float.valueOf(this.restingPitch));
            }
            if (this.disableTime != 200) {
                object.addProperty("disableTime", (Number)this.disableTime);
            }
            if (this.hasOpenAnimation) {
                object.addProperty("hasOpenAnimation", Boolean.valueOf(true));
            }
            return object;
        }

        public Behavior copy() {
            Behavior behavior = new Behavior();
            behavior.restingYaw = this.restingYaw;
            behavior.restingPitch = this.restingPitch;
            behavior.disableTime = this.disableTime;
            behavior.hasOpenAnimation = this.hasOpenAnimation;
            return behavior;
        }

        public float getRestingYaw() {
            return this.restingYaw;
        }

        public float getRestingPitch() {
            return this.restingPitch;
        }

        public int getDisableTime() {
            return this.disableTime;
        }

        public boolean hasOpenAnimation() {
            return this.hasOpenAnimation;
        }

        public void setRestingYaw(float restingYaw) {
            this.restingYaw = restingYaw;
        }

        public void setRestingPitch(float restingPitch) {
            this.restingPitch = restingPitch;
        }

        public void setDisableTime(int disableTime) {
            this.disableTime = disableTime;
        }

        public void setHasOpenAnimation(boolean hasOpenAnimation) {
            this.hasOpenAnimation = hasOpenAnimation;
        }
    }

    public static class Display
    implements INBTSerializable<CompoundTag> {
        @Optional
        private double muzzleLength = 1.0;
        @Optional
        private double muzzleOffsetY = 1.4;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128347_("MuzzleLength", this.muzzleLength);
            tag.m_128347_("MuzzleOffsetY", this.muzzleOffsetY);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("MuzzleLength", 99)) {
                this.muzzleLength = tag.m_128459_("MuzzleLength");
            }
            if (tag.m_128425_("MuzzleOffsetY", 99)) {
                this.muzzleOffsetY = tag.m_128459_("MuzzleOffsetY");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.muzzleLength != 1.0) {
                object.addProperty("muzzleLength", (Number)this.muzzleLength);
            }
            if (this.muzzleOffsetY != 1.4) {
                object.addProperty("muzzleOffsetY", (Number)this.muzzleOffsetY);
            }
            return object;
        }

        public Display copy() {
            Display display = new Display();
            display.muzzleLength = this.muzzleLength;
            display.muzzleOffsetY = this.muzzleOffsetY;
            return display;
        }

        public double getMuzzleLength() {
            return this.muzzleLength;
        }

        public double getMuzzleOffsetY() {
            return this.muzzleOffsetY;
        }

        public void setMuzzleLength(double muzzleLength) {
            this.muzzleLength = muzzleLength;
        }

        public void setMuzzleOffsetY(double muzzleOffsetY) {
            this.muzzleOffsetY = muzzleOffsetY;
        }
    }
}

