/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ribs.scguns.common.Vent;
import top.ribs.scguns.common.VentCollectorConfig;

@Mod.EventBusSubscriber(modid="scguns")
public class VentManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<ResourceLocation, Vent> VENT_CONFIGS = new HashMap<ResourceLocation, Vent>();
    private static final Map<ResourceLocation, VentCollectorConfig> COLLECTOR_CONFIGS = new HashMap<ResourceLocation, VentCollectorConfig>();
    private static final String VENT_FOLDER = "vents";

    @Nullable
    public static Vent getVent(ResourceLocation id) {
        return VENT_CONFIGS.get(id);
    }

    @Nullable
    public static VentCollectorConfig getVentCollectorConfig(ResourceLocation id) {
        return COLLECTOR_CONFIGS.get(id);
    }

    public static void loadVentConfig(ResourceManager resourceManager, ResourceLocation ventId) {
        block15: {
            ResourceLocation location = new ResourceLocation(ventId.m_135827_(), "vents/" + ventId.m_135815_() + ".json");
            try {
                Resource resource = resourceManager.m_213713_(location).orElse(null);
                if (resource != null) {
                    try (InputStream stream = resource.m_215507_();
                         InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                        JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        Vent vent = VentManager.parseVent(json);
                        if (vent != null) {
                            VENT_CONFIGS.put(ventId, vent);
                            LOGGER.info("Successfully loaded vent config: {}", (Object)ventId);
                        }
                        break block15;
                    }
                }
                LOGGER.warn("No JSON found for vent: {}", (Object)ventId);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load vent config: {}", (Object)location, (Object)e);
            }
        }
    }

    public static void loadVentCollectorConfig(ResourceManager resourceManager, ResourceLocation collectorId) {
        block15: {
            ResourceLocation location = new ResourceLocation(collectorId.m_135827_(), "vents/" + collectorId.m_135815_() + ".json");
            try {
                Resource resource = resourceManager.m_213713_(location).orElse(null);
                if (resource != null) {
                    try (InputStream stream = resource.m_215507_();
                         InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                        JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        VentCollectorConfig config = VentManager.parseVentCollector(json);
                        if (config != null) {
                            COLLECTOR_CONFIGS.put(collectorId, config);
                            LOGGER.info("Successfully loaded vent collector config: {}", (Object)collectorId);
                        }
                        break block15;
                    }
                }
                LOGGER.warn("No JSON found for vent collector: {}", (Object)collectorId);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load vent collector config: {}", (Object)location, (Object)e);
            }
        }
    }

    private static Vent parseVent(JsonObject json) {
        try {
            Vent vent = new Vent();
            if (json.has("activation")) {
                VentManager.parseActivation(json.getAsJsonObject("activation"), vent.getActivation());
            }
            if (json.has("power")) {
                VentManager.parsePower(json.getAsJsonObject("power"), vent.getPower());
            }
            if (json.has("production")) {
                VentManager.parseProduction(json.getAsJsonObject("production"), vent.getProduction());
            }
            if (json.has("placement")) {
                VentManager.parsePlacement(json.getAsJsonObject("placement"), vent.getPlacement());
            }
            if (json.has("particles")) {
                VentManager.parseParticles(json.getAsJsonObject("particles"), vent.getParticles());
            }
            return vent;
        }
        catch (Exception e) {
            LOGGER.error("Error parsing vent config", (Throwable)e);
            return null;
        }
    }

    private static VentCollectorConfig parseVentCollector(JsonObject json) {
        try {
            VentCollectorConfig config = new VentCollectorConfig();
            if (json.has("filters")) {
                VentManager.parseFilters(json.getAsJsonObject("filters"), config.getFilters());
            }
            if (json.has("processing")) {
                VentManager.parseProcessing(json.getAsJsonObject("processing"), config.getProcessing());
            }
            return config;
        }
        catch (Exception e) {
            LOGGER.error("Error parsing vent collector config", (Throwable)e);
            return null;
        }
    }

    private static void parseFilters(JsonObject json, VentCollectorConfig.Filters filters) {
        if (json.has("maxCharge")) {
            filters.setMaxCharge(json.get("maxCharge").getAsInt());
        }
        if (json.has("consumptionChance")) {
            filters.setConsumptionChance(json.get("consumptionChance").getAsFloat());
        }
        if (json.has("processCooldown")) {
            filters.setProcessCooldown(json.get("processCooldown").getAsInt());
        }
        if (json.has("filterItems")) {
            filters.clearFilterItems();
            JsonArray itemsArray = json.getAsJsonArray("filterItems");
            for (JsonElement element : itemsArray) {
                JsonObject itemObj = element.getAsJsonObject();
                VentCollectorConfig.Filters.FilterItem filterItem = new VentCollectorConfig.Filters.FilterItem();
                if (itemObj.has("tag")) {
                    filterItem.setIdentifier(new ResourceLocation(itemObj.get("tag").getAsString()));
                    filterItem.setIsTag(true);
                } else if (itemObj.has("item")) {
                    filterItem.setIdentifier(new ResourceLocation(itemObj.get("item").getAsString()));
                    filterItem.setIsTag(false);
                }
                if (itemObj.has("chargeAmount")) {
                    filterItem.setChargeAmount(itemObj.get("chargeAmount").getAsInt());
                }
                filters.addFilterItem(filterItem);
            }
        }
    }

    private static void parseProcessing(JsonObject json, VentCollectorConfig.Processing processing) {
        if (json.has("powerSpeedMultiplier")) {
            processing.setPowerSpeedMultiplier(json.get("powerSpeedMultiplier").getAsFloat());
        }
        if (json.has("pushCooldown")) {
            processing.setPushCooldown(json.get("pushCooldown").getAsInt());
        }
    }

    private static void parseActivation(JsonObject json, Vent.Activation activation) {
        if (json.has("baseBlock")) {
            activation.setBaseBlock(new ResourceLocation(json.get("baseBlock").getAsString()));
        }
        if (json.has("requiresWaterlogged")) {
            activation.setRequiresWaterlogged(json.get("requiresWaterlogged").getAsBoolean());
        }
    }

    private static void parsePower(JsonObject json, Vent.Power power) {
        if (json.has("maxPower")) {
            power.setMaxPower(json.get("maxPower").getAsInt());
        }
        if (json.has("baseTickInterval")) {
            power.setBaseTickInterval(json.get("baseTickInterval").getAsInt());
        }
        if (json.has("tickWiggleRoom")) {
            power.setTickWiggleRoom(json.get("tickWiggleRoom").getAsInt());
        }
    }

    private static void parseProduction(JsonObject json, Vent.Production production) {
        if (json.has("outputs")) {
            production.clearOutputs();
            JsonArray outputsArray = json.getAsJsonArray("outputs");
            for (JsonElement element : outputsArray) {
                JsonObject outputObj = element.getAsJsonObject();
                Vent.Production.OutputItem output = new Vent.Production.OutputItem();
                if (outputObj.has("item")) {
                    output.setItem(new ResourceLocation(outputObj.get("item").getAsString()));
                }
                if (outputObj.has("weight")) {
                    output.setWeight(outputObj.get("weight").getAsInt());
                }
                production.addOutput(output);
            }
        }
        if (json.has("productionChance")) {
            production.setProductionChance(json.get("productionChance").getAsFloat());
        }
    }

    private static void parsePlacement(JsonObject json, Vent.Placement placement) {
        if (json.has("enabled")) {
            placement.setEnabled(json.get("enabled").getAsBoolean());
        }
        if (json.has("blockToPlace")) {
            placement.setBlockToPlace(new ResourceLocation(json.get("blockToPlace").getAsString()));
        }
        if (json.has("radius")) {
            placement.setRadius(json.get("radius").getAsInt());
        }
        if (json.has("placementChance")) {
            placement.setPlacementChance(json.get("placementChance").getAsFloat());
        }
    }

    private static void parseParticles(JsonObject json, Vent.Particles particles) {
        if (json.has("showActive")) {
            particles.setShowActive(json.get("showActive").getAsBoolean());
        }
        if (json.has("activeSound")) {
            particles.setActiveSound(new ResourceLocation(json.get("activeSound").getAsString()));
        }
    }

    public static void clearAll() {
        VENT_CONFIGS.clear();
        COLLECTOR_CONFIGS.clear();
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                VentManager.clearAll();
                VentManager.loadVentConfig(resourceManager, new ResourceLocation("scguns", "geothermal_vent"));
                VentManager.loadVentConfig(resourceManager, new ResourceLocation("scguns", "sulfur_vent"));
                VentManager.loadVentCollectorConfig(resourceManager, new ResourceLocation("scguns", "vent_collector"));
                VENT_CONFIGS.get(new ResourceLocation("scguns", "geothermal_vent"));
                COLLECTOR_CONFIGS.get(new ResourceLocation("scguns", "vent_collector"));
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                LOGGER.info("Loaded {} vent configurations and {} collector configurations", (Object)VENT_CONFIGS.size(), (Object)COLLECTOR_CONFIGS.size());
            }
        });
    }
}

