/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.exosuit;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitEffectsHandler;
import top.ribs.scguns.common.exosuit.ExoSuitPowerManager;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.init.ModSounds;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.C2SMessageJetpackState;
import top.ribs.scguns.network.message.C2SMessageJetpackThrust;

@Mod.EventBusSubscriber(modid="scguns")
public class ExoSuitFlightHandler {
    private static final float FLIGHT_UPWARD_SPEED = 0.8f;
    private static final float FLIGHT_DESCENT_SPEED = 0.4f;
    private static final float NATURAL_SINK_SPEED = 0.02f;
    private static final float HORIZONTAL_ACCELERATION = 0.001f;
    private static final float HORIZONTAL_DRAG = 0.85f;
    private static final float MAX_HORIZONTAL_SPEED = 0.04f;
    private static final float SPRINT_MULTIPLIER = 1.15f;
    private static final float STOP_THRESHOLD = 0.005f;
    private static final double JETPACK_OFFSET_DISTANCE = -0.5;
    private static final double JETPACK_HEIGHT_OFFSET = 0.7;
    private static final double JETPACK_SIDE_OFFSET = 0.4;
    private static final int PARTICLE_COUNT = 1;
    private static final Map<UUID, Long> lastEnergyConsumptionTime = new HashMap<UUID, Long>();
    private static final long ENERGY_CONSUMPTION_INTERVAL = 1000L;
    private static final Map<UUID, Boolean> serverJetpackStates = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> playerThrustStates = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Long> lastThrustTime = new HashMap<UUID, Long>();
    private static final long THRUST_TIMEOUT = 100L;
    private static long lastThrustSoundTime = 0L;
    private static final long THRUST_SOUND_COOLDOWN = 300L;
    private static boolean wasGamePaused = false;
    private static boolean wasJumpPressed = false;
    private static long lastJumpPressTime = 0L;
    private static final long DOUBLE_TAP_WINDOW = 300L;
    private static boolean clientJetpackActive = false;
    private static long lastLoopSoundTime = 0L;
    private static final long LOOP_SOUND_DURATION = 3000L;
    private static boolean isLoopSoundPlaying = false;
    private static boolean wasThrustingLastTick = false;
    private static boolean exoSuitFlightEnabled = false;
    private static float originalFlySpeed = 0.05f;
    private static boolean originalMayFly = false;
    private static boolean wasDescending = false;
    private static long landingProtectionTime = 0L;
    private static final long LANDING_PROTECTION_DURATION = 500L;

    public static void setJetpackActive(Player player, boolean active) {
        serverJetpackStates.put(player.m_20148_(), active);
    }

    public static void setPlayerThrusting(Player player, boolean thrusting) {
        UUID playerId = player.m_20148_();
        playerThrustStates.put(playerId, thrusting);
        if (thrusting) {
            lastThrustTime.put(playerId, System.currentTimeMillis());
        }
    }

    public static boolean isPlayerThrusting(Player player) {
        UUID playerId = player.m_20148_();
        Boolean thrusting = playerThrustStates.get(playerId);
        if (thrusting == null || !thrusting.booleanValue()) {
            return false;
        }
        Long lastThrust = lastThrustTime.get(playerId);
        if (lastThrust == null) {
            return false;
        }
        return System.currentTimeMillis() - lastThrust < 100L;
    }

    public static boolean isJetpackActiveOnServer(Player player) {
        return serverJetpackStates.getOrDefault(player.m_20148_(), false);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        if (player.f_19797_ % 10 != 0) {
            return;
        }
        ExoSuitFlightHandler.handleJetpackEnergyConsumption(player);
    }

    private static void handleJetpackEnergyConsumption(Player player) {
        boolean jetpackActive = ExoSuitFlightHandler.isJetpackActiveOnServer(player);
        if (!jetpackActive) {
            return;
        }
        if (!ExoSuitFlightHandler.hasJetpackModule(player)) {
            ExoSuitFlightHandler.setJetpackActive(player, false);
            return;
        }
        boolean utilityEnabled = ExoSuitPowerManager.isPowerEnabled(player, "utility");
        if (!utilityEnabled) {
            ExoSuitFlightHandler.setJetpackActive(player, false);
            return;
        }
        boolean canFunction = ExoSuitPowerManager.canUpgradeFunction(player, "utility");
        if (!canFunction) {
            ExoSuitFlightHandler.setJetpackActive(player, false);
            return;
        }
        boolean isThrusting = ExoSuitFlightHandler.isPlayerThrusting(player);
        if (!isThrusting) {
            return;
        }
        UUID playerId = player.m_20148_();
        long currentTime = System.currentTimeMillis();
        Long lastConsumption = lastEnergyConsumptionTime.get(playerId);
        if (lastConsumption == null || currentTime - lastConsumption >= 1000L) {
            ItemStack jetpackUpgrade = ExoSuitFlightHandler.findJetpackModuleFromPlayer(player);
            if (jetpackUpgrade.m_41619_()) {
                ExoSuitFlightHandler.setJetpackActive(player, false);
                return;
            }
            if (!ExoSuitPowerManager.consumeEnergyForUpgrade(player, "utility", jetpackUpgrade)) {
                ExoSuitFlightHandler.setJetpackActive(player, false);
                return;
            }
            lastEnergyConsumptionTime.put(playerId, currentTime);
        }
    }

    private static boolean hasJetpackModule(Player player) {
        return !ExoSuitFlightHandler.findJetpackModuleFromPlayer(player).m_41619_();
    }

    private static ItemStack findJetpackModuleFromPlayer(Player player) {
        ItemStack chestplate = ExoSuitFlightHandler.getEquippedChestplate(player);
        if (chestplate.m_41619_()) {
            return ItemStack.f_41583_;
        }
        return ExoSuitFlightHandler.findJetpackModule(chestplate);
    }

    private static ItemStack getEquippedChestplate(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.CHESTPLATE) continue;
            return armorStack;
        }
        return ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onMovementInputUpdate(MovementInputUpdateEvent event) {
        Player player = event.getEntity();
        if (ExoSuitFlightHandler.isUsingExoSuitJetpack(player) && exoSuitFlightEnabled && player.m_150110_().f_35935_ && event.getInput().f_108573_) {
            event.getInput().f_108573_ = true;
        }
    }

    private static boolean hasExoSuitJetpackSetup(Player player) {
        ItemStack chestplate = player.m_150109_().m_36052_(2);
        if (!(chestplate.m_41720_() instanceof ExoSuitItem)) {
            return false;
        }
        ItemStack jetpackUpgrade = ExoSuitFlightHandler.findJetpackModule(chestplate);
        if (jetpackUpgrade.m_41619_()) {
            return false;
        }
        ExoSuitUpgrade.Effects totalEffects = ExoSuitEffectsHandler.getTotalEffects(player);
        return totalEffects.hasFlight();
    }

    private static boolean isUsingExoSuitJetpack(Player player) {
        if (player.m_9236_().f_46443_) {
            return ExoSuitFlightHandler.hasExoSuitJetpackSetup(player) && clientJetpackActive;
        }
        return ExoSuitFlightHandler.hasExoSuitJetpackSetup(player) && ExoSuitFlightHandler.isJetpackActiveOnServer(player);
    }

    private static ItemStack findJetpackModule(ItemStack chestplate) {
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(chestplate, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("utility") || !upgrade.getEffects().hasFlight()) continue;
            return upgradeItem;
        }
        return ItemStack.f_41583_;
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (event.getSource().m_269415_().f_268677_().equals("fall")) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - landingProtectionTime < 500L) {
                event.setCanceled(true);
                return;
            }
            if (ExoSuitFlightHandler.isUsingExoSuitJetpack(player) && exoSuitFlightEnabled && wasDescending) {
                event.setCanceled(true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || !player.m_9236_().f_46443_) {
            return;
        }
        if (!ExoSuitFlightHandler.hasExoSuitJetpackSetup((Player)player)) {
            if (clientJetpackActive || exoSuitFlightEnabled) {
                ExoSuitFlightHandler.disableExoSuitFlight((Player)player);
                ExoSuitFlightHandler.stopJetpackSounds((Player)player);
            }
            return;
        }
        boolean isGamePaused = mc.m_91104_();
        if (wasGamePaused && !isGamePaused) {
            wasGamePaused = false;
            ExoSuitFlightHandler.handleJetpackFlightWithoutParticles((Player)player);
            return;
        }
        wasGamePaused = isGamePaused;
        if (isGamePaused) {
            return;
        }
        ExoSuitFlightHandler.handleJetpackFlight((Player)player);
    }

    private static void handleJetpackFlightWithoutParticles(Player player) {
        if (player.m_5833_()) {
            return;
        }
        if (!ExoSuitFlightHandler.hasExoSuitJetpackSetup(player)) {
            if (clientJetpackActive) {
                ExoSuitFlightHandler.disableExoSuitFlight(player);
            }
            return;
        }
        ExoSuitUpgrade.Effects totalEffects = ExoSuitEffectsHandler.getTotalEffects(player);
        float flightSpeed = totalEffects.getFlightSpeed();
        if (flightSpeed <= 0.0f) {
            flightSpeed = 0.1f;
        }
        if (!player.m_150110_().f_35936_ && clientJetpackActive) {
            ExoSuitFlightHandler.enableExoSuitFlight(player, flightSpeed);
        }
        Minecraft mc = Minecraft.m_91087_();
        if (clientJetpackActive && player.m_150110_().f_35936_ && player.m_150110_().f_35935_ && !player.m_7500_()) {
            ExoSuitFlightHandler.handleFlightMovement(player, mc, flightSpeed);
        }
    }

    private static void enableExoSuitFlight(Player player, float flightSpeed) {
        if (!exoSuitFlightEnabled) {
            originalMayFly = player.m_150110_().f_35936_;
            originalFlySpeed = player.m_150110_().m_35942_();
        }
        player.m_150110_().f_35936_ = true;
        player.m_150110_().m_35943_(flightSpeed);
        player.m_6885_();
        exoSuitFlightEnabled = true;
    }

    private static void disableExoSuitFlight(Player player) {
        if (exoSuitFlightEnabled) {
            player.m_150110_().f_35936_ = originalMayFly;
            player.m_150110_().f_35935_ = false;
            player.m_150110_().m_35943_(originalFlySpeed);
            player.m_6885_();
            exoSuitFlightEnabled = false;
        }
        clientJetpackActive = false;
        wasDescending = false;
        if (player.m_9236_().f_46443_) {
            ExoSuitFlightHandler.stopJetpackSounds(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleFlightMovement(Player player, Minecraft mc, float flightSpeed) {
        double newY;
        if (!player.m_150110_().f_35935_ || !clientJetpackActive || !exoSuitFlightEnabled || player.m_5833_()) {
            return;
        }
        if (!ExoSuitFlightHandler.hasExoSuitJetpackSetup(player)) {
            ExoSuitFlightHandler.disableExoSuitFlight(player);
            ExoSuitFlightHandler.stopJetpackSounds(player);
            player.m_9236_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 0.5f, 0.6f, false);
            return;
        }
        Vec3 currentVelocity = player.m_20184_();
        boolean isThrusting = false;
        boolean currentlyDescending = false;
        if (mc.f_91066_.f_92089_.m_90857_()) {
            newY = 0.8f * flightSpeed;
            isThrusting = true;
        } else if (mc.f_91066_.f_92090_.m_90857_()) {
            newY = -0.4f * flightSpeed;
            currentlyDescending = true;
            isThrusting = true;
        } else {
            newY = -0.02f;
        }
        long currentTime = System.currentTimeMillis();
        if (currentlyDescending && !player.m_20096_()) {
            wasDescending = true;
        } else if (player.m_20096_() && wasDescending) {
            landingProtectionTime = currentTime;
            wasDescending = false;
        } else if (!currentlyDescending && !player.m_20096_()) {
            wasDescending = false;
        }
        ExoSuitFlightHandler.handleJetpackSounds(player, isThrusting);
        double newX = currentVelocity.f_82479_;
        double newZ = currentVelocity.f_82481_;
        Vec3 inputVector = ExoSuitFlightHandler.getMovementInput(player, mc);
        if (inputVector.m_82556_() > 0.0) {
            double horizontalSpeed;
            double speedMultiplier = 1.0;
            if (player.m_20142_()) {
                speedMultiplier = 1.15f;
            }
            double maxSpeedForThisTick = (double)(0.04f * Math.min(flightSpeed, 1.0f)) * speedMultiplier;
            if ((horizontalSpeed = Math.sqrt((newX += inputVector.f_82479_ * (double)0.001f) * newX + (newZ += inputVector.f_82481_ * (double)0.001f) * newZ)) > maxSpeedForThisTick) {
                double ratio = maxSpeedForThisTick / horizontalSpeed;
                newX *= ratio;
                newZ *= ratio;
            }
            if (player.m_150110_().f_35935_ && !player.m_20096_()) {
                isThrusting = true;
            }
        } else {
            newX *= (double)0.85f;
            newZ *= (double)0.85f;
            if (Math.abs(newX) < (double)0.005f) {
                newX = 0.0;
            }
            if (Math.abs(newZ) < (double)0.005f) {
                newZ = 0.0;
            }
        }
        ExoSuitFlightHandler.sendThrustStateToServer(isThrusting);
        player.m_20334_(newX, newY, newZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sendThrustStateToServer(boolean thrusting) {
        PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageJetpackThrust(thrusting));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleJetpackSounds(Player player, boolean isThrusting) {
        long currentTime = System.currentTimeMillis();
        if (clientJetpackActive && (!isLoopSoundPlaying || currentTime - lastLoopSoundTime >= 3000L)) {
            player.m_9236_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.JETPACK_LOOP.get(), SoundSource.PLAYERS, 0.5f, 1.0f, false);
            lastLoopSoundTime = currentTime;
            isLoopSoundPlaying = true;
        }
        if (isThrusting && !wasThrustingLastTick && currentTime - lastThrustSoundTime >= 300L) {
            player.m_9236_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.JETPACK.get(), SoundSource.PLAYERS, 0.7f, 1.0f + (player.m_9236_().f_46441_.m_188501_() * 0.1f - 0.05f), false);
            lastThrustSoundTime = currentTime;
        }
        wasThrustingLastTick = isThrusting;
    }

    private static void handleJetpackFlight(Player player) {
        if (player.m_5833_()) {
            return;
        }
        if (!ExoSuitFlightHandler.hasExoSuitJetpackSetup(player)) {
            if (clientJetpackActive || exoSuitFlightEnabled) {
                ExoSuitFlightHandler.disableExoSuitFlight(player);
            }
            return;
        }
        if (!ExoSuitFlightHandler.canJetpackFunction(player)) {
            if (clientJetpackActive || exoSuitFlightEnabled) {
                ExoSuitFlightHandler.disableExoSuitFlight(player);
            }
            return;
        }
        ExoSuitUpgrade.Effects totalEffects = ExoSuitEffectsHandler.getTotalEffects(player);
        float flightSpeed = totalEffects.getFlightSpeed();
        if (flightSpeed <= 0.0f) {
            flightSpeed = 0.1f;
        }
        Minecraft mc = Minecraft.m_91087_();
        boolean jumpPressed = mc.f_91066_.f_92089_.m_90857_();
        long currentTime = System.currentTimeMillis();
        if (jumpPressed && !wasJumpPressed) {
            long timeSinceLastPress = currentTime - lastJumpPressTime;
            if (timeSinceLastPress <= 300L && timeSinceLastPress > 50L) {
                if (ExoSuitPowerManager.isPowerEnabled(player, "utility")) {
                    clientJetpackActive = !clientJetpackActive;
                    ExoSuitFlightHandler.sendJetpackStateToServer(clientJetpackActive);
                    if (clientJetpackActive) {
                        ExoSuitFlightHandler.enableExoSuitFlight(player, flightSpeed);
                        player.m_150110_().f_35935_ = true;
                        player.m_6885_();
                    } else {
                        ExoSuitFlightHandler.disableExoSuitFlight(player);
                    }
                }
                lastJumpPressTime = 0L;
            } else {
                lastJumpPressTime = currentTime;
            }
        }
        wasJumpPressed = jumpPressed;
        if (clientJetpackActive && exoSuitFlightEnabled && player.m_150110_().f_35936_ && player.m_150110_().f_35935_ && !player.m_7500_()) {
            ExoSuitFlightHandler.handleFlightMovement(player, mc, flightSpeed);
            ExoSuitFlightHandler.spawnJetpackParticles(player, mc);
            Minecraft mcInstance = Minecraft.m_91087_();
            boolean isThrusting = mcInstance.f_91066_.f_92089_.m_90857_();
            ExoSuitFlightHandler.handleJetpackSounds(player, isThrusting);
        }
    }

    private static boolean canJetpackFunction(Player player) {
        if (!ExoSuitPowerManager.isPowerEnabled(player, "utility")) {
            return false;
        }
        if (!ExoSuitPowerManager.canUpgradeFunction(player, "utility")) {
            return false;
        }
        return ExoSuitFlightHandler.hasJetpackModule(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sendJetpackStateToServer(boolean active) {
        PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageJetpackState(active));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void stopJetpackSounds(Player player) {
        isLoopSoundPlaying = false;
        wasThrustingLastTick = false;
        lastLoopSoundTime = 0L;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void spawnJetpackParticles(Player player, Minecraft mc) {
        Level level = player.m_9236_();
        float yaw = player.m_146908_() * ((float)Math.PI / 180);
        double backwardX = -Math.sin(yaw);
        double backwardZ = Math.cos(yaw);
        double sideX = -backwardZ;
        double baseX = player.m_20185_() + backwardX * -0.5;
        double baseY = player.m_20186_() + 0.7;
        double baseZ = player.m_20189_() + backwardZ * -0.5;
        double leftJetX = baseX + sideX * 0.4;
        double leftJetZ = baseZ + backwardX * 0.4;
        double rightJetX = baseX - sideX * 0.4;
        double rightJetZ = baseZ - backwardX * 0.4;
        ExoSuitFlightHandler.spawnJetParticles(level, leftJetX, baseY, leftJetZ, player);
        ExoSuitFlightHandler.spawnJetParticles(level, rightJetX, baseY, rightJetZ, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void spawnJetParticles(Level level, double x, double y, double z, Player player) {
        for (int i = 0; i < 1; ++i) {
            double offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            double offsetY = (level.f_46441_.m_188500_() - 0.5) * 0.1;
            double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            double velocityX = (level.f_46441_.m_188500_() - 0.5) * 0.1;
            double velocityY = -0.1 - level.f_46441_.m_188500_() * 0.2;
            double velocityZ = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + offsetX, y + offsetY, z + offsetZ, velocityX, velocityY, velocityZ);
            if (!(level.f_46441_.m_188501_() < 0.3f)) continue;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + offsetX, y + offsetY - 0.1, z + offsetZ, velocityX * 0.5, velocityY * 0.5, velocityZ * 0.5);
        }
    }

    private static Vec3 getMovementInput(Player player, Minecraft mc) {
        float forward = 0.0f;
        float strafe = 0.0f;
        if (mc.f_91066_.f_92085_.m_90857_()) {
            forward += 1.0f;
        }
        if (mc.f_91066_.f_92087_.m_90857_()) {
            forward -= 1.0f;
        }
        if (mc.f_91066_.f_92086_.m_90857_()) {
            strafe += 1.0f;
        }
        if (mc.f_91066_.f_92088_.m_90857_()) {
            strafe -= 1.0f;
        }
        if (forward != 0.0f && strafe != 0.0f) {
            forward *= 0.707f;
            strafe *= 0.707f;
        }
        if (forward == 0.0f && strafe == 0.0f) {
            return Vec3.f_82478_;
        }
        float yaw = player.m_146908_() * ((float)Math.PI / 180);
        double x = (double)strafe * Math.cos(yaw) - (double)forward * Math.sin(yaw);
        double z = (double)forward * Math.cos(yaw) + (double)strafe * Math.sin(yaw);
        return new Vec3(x, 0.0, z);
    }

    public static void onPlayerLogout(Player player) {
        UUID playerId = player.m_20148_();
        lastEnergyConsumptionTime.remove(playerId);
        serverJetpackStates.remove(playerId);
        playerThrustStates.remove(playerId);
        lastThrustTime.remove(playerId);
    }
}

