/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.exosuit;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import top.ribs.scguns.annotation.Optional;

public class ExoSuitUpgrade
implements INBTSerializable<CompoundTag> {
    protected String type = "plating";
    protected Effects effects = new Effects();
    protected Display display = new Display();

    public String getType() {
        return this.type;
    }

    public Effects getEffects() {
        return this.effects;
    }

    public Display getDisplay() {
        return this.display;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Type", this.type);
        tag.m_128365_("Effects", (Tag)this.effects.serializeNBT());
        tag.m_128365_("Display", (Tag)this.display.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("Type", 8)) {
            this.type = tag.m_128461_("Type");
        }
        if (tag.m_128441_("Effects")) {
            this.effects.deserializeNBT(tag.m_128469_("Effects"));
        }
        if (tag.m_128441_("Display")) {
            this.display.deserializeNBT(tag.m_128469_("Display"));
        }
    }

    public JsonObject toJsonObject() {
        JsonObject object = new JsonObject();
        object.addProperty("type", this.type);
        object.add("effects", (JsonElement)this.effects.toJsonObject());
        JsonObject displayObj = this.display.toJsonObject();
        if (displayObj.size() > 0) {
            object.add("display", (JsonElement)displayObj);
        }
        return object;
    }

    public ExoSuitUpgrade copy() {
        ExoSuitUpgrade upgrade = new ExoSuitUpgrade();
        upgrade.type = this.type;
        upgrade.effects = this.effects.copy();
        upgrade.display = this.display.copy();
        return upgrade;
    }

    public static class Effects
    implements INBTSerializable<CompoundTag> {
        @Optional
        float armorBonus = 0.0f;
        @Optional
        float armorToughness = 0.0f;
        @Optional
        float knockbackResistance = 0.0f;
        @Optional
        float speedModifier = 0.0f;
        @Optional
        float jumpBoost = 0.0f;
        @Optional
        float fallDamageReduction = 0.0f;
        @Optional
        boolean nightVision = false;
        @Optional
        boolean flight = false;
        @Optional
        float flightSpeed = 0.0f;
        @Optional
        float energyUse = 0.0f;
        @Optional
        float recoilAngleReduction = 0.0f;
        @Optional
        float recoilKickReduction = 0.0f;
        @Optional
        float spreadReduction = 0.0f;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("ArmorBonus", this.armorBonus);
            tag.m_128350_("ArmorToughness", this.armorToughness);
            tag.m_128350_("KnockbackResistance", this.knockbackResistance);
            tag.m_128350_("SpeedModifier", this.speedModifier);
            tag.m_128350_("JumpBoost", this.jumpBoost);
            tag.m_128350_("FallDamageReduction", this.fallDamageReduction);
            tag.m_128379_("NightVision", this.nightVision);
            tag.m_128379_("Flight", this.flight);
            tag.m_128350_("FlightSpeed", this.flightSpeed);
            tag.m_128350_("EnergyUse", this.energyUse);
            tag.m_128350_("RecoilAngleReduction", this.recoilAngleReduction);
            tag.m_128350_("RecoilKickReduction", this.recoilKickReduction);
            tag.m_128350_("SpreadReduction", this.spreadReduction);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("ArmorBonus", 99)) {
                this.armorBonus = tag.m_128457_("ArmorBonus");
            }
            if (tag.m_128425_("ArmorToughness", 99)) {
                this.armorToughness = tag.m_128457_("ArmorToughness");
            }
            if (tag.m_128425_("KnockbackResistance", 99)) {
                this.knockbackResistance = tag.m_128457_("KnockbackResistance");
            }
            if (tag.m_128425_("SpeedModifier", 99)) {
                this.speedModifier = tag.m_128457_("SpeedModifier");
            }
            if (tag.m_128425_("JumpBoost", 99)) {
                this.jumpBoost = tag.m_128457_("JumpBoost");
            }
            if (tag.m_128425_("FallDamageReduction", 99)) {
                this.fallDamageReduction = tag.m_128457_("FallDamageReduction");
            }
            if (tag.m_128425_("NightVision", 99)) {
                this.nightVision = tag.m_128471_("NightVision");
            }
            if (tag.m_128425_("Flight", 99)) {
                this.flight = tag.m_128471_("Flight");
            }
            if (tag.m_128425_("FlightSpeed", 99)) {
                this.flightSpeed = tag.m_128457_("FlightSpeed");
            }
            if (tag.m_128425_("EnergyUse", 99)) {
                this.energyUse = tag.m_128457_("EnergyUse");
            }
            if (tag.m_128425_("RecoilAngleReduction", 99)) {
                this.recoilAngleReduction = tag.m_128457_("RecoilAngleReduction");
            }
            if (tag.m_128425_("RecoilKickReduction", 99)) {
                this.recoilKickReduction = tag.m_128457_("RecoilKickReduction");
            }
            if (tag.m_128425_("SpreadReduction", 99)) {
                this.spreadReduction = tag.m_128457_("SpreadReduction");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.armorBonus != 0.0f) {
                object.addProperty("armorBonus", (Number)Float.valueOf(this.armorBonus));
            }
            if (this.armorToughness != 0.0f) {
                object.addProperty("armorToughness", (Number)Float.valueOf(this.armorToughness));
            }
            if (this.knockbackResistance != 0.0f) {
                object.addProperty("knockbackResistance", (Number)Float.valueOf(this.knockbackResistance));
            }
            if (this.speedModifier != 0.0f) {
                object.addProperty("speedModifier", (Number)Float.valueOf(this.speedModifier));
            }
            if (this.jumpBoost != 0.0f) {
                object.addProperty("jumpBoost", (Number)Float.valueOf(this.jumpBoost));
            }
            if (this.fallDamageReduction != 0.0f) {
                object.addProperty("fallDamageReduction", (Number)Float.valueOf(this.fallDamageReduction));
            }
            if (this.nightVision) {
                object.addProperty("nightVision", Boolean.valueOf(true));
            }
            if (this.flight) {
                object.addProperty("flight", Boolean.valueOf(true));
            }
            if (this.flightSpeed != 0.0f) {
                object.addProperty("flightSpeed", (Number)Float.valueOf(this.flightSpeed));
            }
            if (this.energyUse != 0.0f) {
                object.addProperty("energyUse", (Number)Float.valueOf(this.energyUse));
            }
            if (this.recoilAngleReduction != 0.0f) {
                object.addProperty("recoilAngleReduction", (Number)Float.valueOf(this.recoilAngleReduction));
            }
            if (this.recoilKickReduction != 0.0f) {
                object.addProperty("recoilKickReduction", (Number)Float.valueOf(this.recoilKickReduction));
            }
            if (this.spreadReduction != 0.0f) {
                object.addProperty("spreadReduction", (Number)Float.valueOf(this.spreadReduction));
            }
            return object;
        }

        public Effects copy() {
            Effects effects = new Effects();
            effects.armorBonus = this.armorBonus;
            effects.armorToughness = this.armorToughness;
            effects.knockbackResistance = this.knockbackResistance;
            effects.speedModifier = this.speedModifier;
            effects.jumpBoost = this.jumpBoost;
            effects.fallDamageReduction = this.fallDamageReduction;
            effects.nightVision = this.nightVision;
            effects.flight = this.flight;
            effects.flightSpeed = this.flightSpeed;
            effects.energyUse = this.energyUse;
            effects.recoilAngleReduction = this.recoilAngleReduction;
            effects.recoilKickReduction = this.recoilKickReduction;
            effects.spreadReduction = this.spreadReduction;
            return effects;
        }

        public float getArmorBonus() {
            return this.armorBonus;
        }

        public float getArmorToughness() {
            return this.armorToughness;
        }

        public float getKnockbackResistance() {
            return this.knockbackResistance;
        }

        public float getSpeedModifier() {
            return this.speedModifier;
        }

        public float getJumpBoost() {
            return this.jumpBoost;
        }

        public float getFallDamageReduction() {
            return this.fallDamageReduction;
        }

        public boolean hasNightVision() {
            return this.nightVision;
        }

        public boolean hasFlight() {
            return this.flight;
        }

        public float getFlightSpeed() {
            return this.flightSpeed;
        }

        public float getRecoilAngleReduction() {
            return this.recoilAngleReduction;
        }

        public float getRecoilKickReduction() {
            return this.recoilKickReduction;
        }

        public float getSpreadReduction() {
            return this.spreadReduction;
        }

        public float getEnergyUse() {
            return this.energyUse;
        }
    }

    public static class Display
    implements INBTSerializable<CompoundTag> {
        @Optional
        String model = "";
        @Optional
        int storageSize = 0;
        @Optional
        int gridWidth = 0;
        @Optional
        int gridHeight = 0;
        @Optional
        String containerType = "";

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Model", this.model);
            tag.m_128405_("StorageSize", this.storageSize);
            tag.m_128405_("GridWidth", this.gridWidth);
            tag.m_128405_("GridHeight", this.gridHeight);
            tag.m_128359_("ContainerType", this.containerType);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Model", 8)) {
                this.model = tag.m_128461_("Model");
            }
            if (tag.m_128425_("StorageSize", 99)) {
                this.storageSize = tag.m_128451_("StorageSize");
            }
            if (tag.m_128425_("GridWidth", 99)) {
                this.gridWidth = tag.m_128451_("GridWidth");
            }
            if (tag.m_128425_("GridHeight", 99)) {
                this.gridHeight = tag.m_128451_("GridHeight");
            }
            if (tag.m_128425_("ContainerType", 8)) {
                this.containerType = tag.m_128461_("ContainerType");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (!this.model.isEmpty()) {
                object.addProperty("model", this.model);
            }
            if (this.storageSize > 0) {
                object.addProperty("storageSize", (Number)this.storageSize);
            }
            if (this.gridWidth > 0) {
                object.addProperty("gridWidth", (Number)this.gridWidth);
            }
            if (this.gridHeight > 0) {
                object.addProperty("gridHeight", (Number)this.gridHeight);
            }
            if (!this.containerType.isEmpty()) {
                object.addProperty("containerType", this.containerType);
            }
            return object;
        }

        public Display copy() {
            Display display = new Display();
            display.model = this.model;
            display.storageSize = this.storageSize;
            display.gridWidth = this.gridWidth;
            display.gridHeight = this.gridHeight;
            display.containerType = this.containerType;
            return display;
        }

        public String getModel() {
            return this.model;
        }

        public int getStorageSize() {
            return this.storageSize;
        }

        public int getGridWidth() {
            return this.gridWidth;
        }

        public int getGridHeight() {
            return this.gridHeight;
        }

        public String getContainerType() {
            return this.containerType;
        }
    }

    public static class Builder {
        private final ExoSuitUpgrade upgrade = new ExoSuitUpgrade();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder setType(String type) {
            this.upgrade.type = type;
            return this;
        }

        public Builder setArmorBonus(float armor) {
            this.upgrade.effects.armorBonus = armor;
            return this;
        }

        public Builder setArmorToughness(float toughness) {
            this.upgrade.effects.armorToughness = toughness;
            return this;
        }

        public Builder setKnockbackResistance(float resistance) {
            this.upgrade.effects.knockbackResistance = resistance;
            return this;
        }

        public Builder setSpeedModifier(float speed) {
            this.upgrade.effects.speedModifier = speed;
            return this;
        }

        public Builder setJumpBoost(float jump) {
            this.upgrade.effects.jumpBoost = jump;
            return this;
        }

        public Builder setNightVision(boolean nightVision) {
            this.upgrade.effects.nightVision = nightVision;
            return this;
        }

        public Builder setRecoilAngleReduction(float reduction) {
            this.upgrade.effects.recoilAngleReduction = reduction;
            return this;
        }

        public Builder setRecoilKickReduction(float reduction) {
            this.upgrade.effects.recoilKickReduction = reduction;
            return this;
        }

        public Builder setSpreadReduction(float reduction) {
            this.upgrade.effects.spreadReduction = reduction;
            return this;
        }

        public Builder setModel(String model) {
            this.upgrade.display.model = model;
            return this;
        }

        public Builder setStorageSize(int size) {
            this.upgrade.display.storageSize = size;
            return this;
        }

        public Builder setGridDimensions(int width, int height) {
            this.upgrade.display.gridWidth = width;
            this.upgrade.display.gridHeight = height;
            return this;
        }

        public Builder setContainerType(String containerType) {
            this.upgrade.display.containerType = containerType;
            return this;
        }

        public ExoSuitUpgrade build() {
            return this.upgrade.copy();
        }
    }
}

