/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ribs.scguns.util.GunCurseUtil;

@Mod.EventBusSubscriber(modid="scguns")
public class EntityEquipmentConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, EquipmentData> CONFIGS = new HashMap<String, EquipmentData>();

    public static void loadConfig(ResourceManager resourceManager, String entityId) {
        block9: {
            ResourceLocation location = new ResourceLocation("scguns", "entity/equipment/" + entityId + ".json");
            try {
                Resource resource = resourceManager.m_213713_(location).orElse(null);
                if (resource != null) {
                    try (InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);){
                        Gson gson = new Gson();
                        JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                        EquipmentData data = EntityEquipmentConfig.parseEquipmentData(json);
                        if (data != null) {
                            CONFIGS.put(entityId, data);
                            LOGGER.info("Loaded equipment config for {}: {} entries", (Object)entityId, (Object)data.entries.size());
                        }
                        break block9;
                    }
                }
                LOGGER.warn("Equipment config not found: {}", (Object)location);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load equipment config: {}", (Object)location, (Object)e);
            }
        }
    }

    private static EquipmentData parseEquipmentData(JsonObject json) {
        float equipmentChance = json.has("equipment_chance") ? json.get("equipment_chance").getAsFloat() : 0.75f;
        ArrayList<EquipmentEntry> entries = new ArrayList<EquipmentEntry>();
        if (json.has("items")) {
            JsonArray itemsArray = json.getAsJsonArray("items");
            for (JsonElement element : itemsArray) {
                JsonObject itemObj = element.getAsJsonObject();
                EquipmentEntry entry = EntityEquipmentConfig.parseEntry(itemObj);
                if (entry == null) continue;
                entries.add(entry);
            }
        }
        return new EquipmentData(equipmentChance, entries);
    }

    @Nullable
    private static EquipmentEntry parseEntry(JsonObject json) {
        try {
            String itemId = json.get("item").getAsString();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
            if (item == null) {
                LOGGER.warn("Unknown item: {}", (Object)itemId);
                return null;
            }
            float spawnWeight = json.has("weight") ? json.get("weight").getAsFloat() : 1.0f;
            float dropChance = json.has("drop_chance") ? json.get("drop_chance").getAsFloat() : 0.2f;
            Float minDurability = json.has("min_durability") ? Float.valueOf(json.get("min_durability").getAsFloat()) : null;
            Float maxDurability = json.has("max_durability") ? Float.valueOf(json.get("max_durability").getAsFloat()) : null;
            return new EquipmentEntry(item, spawnWeight, dropChance, minDurability, maxDurability);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing equipment entry", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static EquipmentData getEquipmentData(String entityId) {
        return CONFIGS.get(entityId);
    }

    public static void equipEntity(Mob mob, String entityId) {
        EquipmentData data = EntityEquipmentConfig.getEquipmentData(entityId);
        if (data == null) {
            return;
        }
        if (mob.m_217043_().m_188501_() >= data.equipmentChance) {
            return;
        }
        EquipmentEntry entry = data.selectRandom(mob.m_217043_());
        if (entry == null) {
            return;
        }
        ItemStack stack = entry.createItemStack(mob.m_217043_());
        GunCurseUtil.applyCurseIfRoll(stack, mob.m_217043_());
        mob.m_8061_(EquipmentSlot.MAINHAND, stack);
        mob.m_21409_(EquipmentSlot.MAINHAND, entry.dropChance);
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                CONFIGS.clear();
                EntityEquipmentConfig.loadConfig(resourceManager, "cog_minion");
                EntityEquipmentConfig.loadConfig(resourceManager, "cog_knight");
                EntityEquipmentConfig.loadConfig(resourceManager, "adjudicator");
                EntityEquipmentConfig.loadConfig(resourceManager, "subjugator");
            }
        });
    }

    public record EquipmentData(float equipmentChance, List<EquipmentEntry> entries) {
        @Nullable
        public EquipmentEntry selectRandom(RandomSource random) {
            if (this.entries.isEmpty()) {
                return null;
            }
            float totalWeight = 0.0f;
            for (EquipmentEntry entry : this.entries) {
                totalWeight += entry.spawnWeight;
            }
            float roll = random.m_188501_() * totalWeight;
            float currentWeight = 0.0f;
            for (EquipmentEntry entry : this.entries) {
                if (!(roll < (currentWeight += entry.spawnWeight))) continue;
                return entry;
            }
            return this.entries.get(this.entries.size() - 1);
        }
    }

    public record EquipmentEntry(Item item, float spawnWeight, float dropChance, @Nullable Float minDurability, @Nullable Float maxDurability) {
        public ItemStack createItemStack(RandomSource random) {
            ItemStack stack = new ItemStack((ItemLike)this.item);
            if (stack.m_41763_() && this.minDurability != null && this.maxDurability != null) {
                float durabilityPercent = this.minDurability.floatValue() + random.m_188501_() * (this.maxDurability.floatValue() - this.minDurability.floatValue());
                int damage = (int)((float)stack.m_41776_() * (1.0f - durabilityPercent));
                stack.m_41721_(damage);
            }
            return stack;
        }
    }
}

