/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="scguns")
public class GunnerMobConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceLocation, MobGunnerData> GUNNER_MOBS = new HashMap<ResourceLocation, MobGunnerData>();
    private static final ResourceLocation CONFIG_LOCATION = new ResourceLocation("scguns", "entity/gunner_mobs.json");

    public static void loadConfig(ResourceManager resourceManager) {
        block10: {
            GUNNER_MOBS.clear();
            try {
                Resource resource = resourceManager.m_213713_(CONFIG_LOCATION).orElse(null);
                if (resource != null) {
                    try (InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);){
                        Gson gson = new Gson();
                        JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                        if (json != null && json.has("mobs")) {
                            JsonObject mobsObj = json.getAsJsonObject("mobs");
                            for (Map.Entry entry : mobsObj.entrySet()) {
                                String entityId = (String)entry.getKey();
                                JsonObject mobData = ((JsonElement)entry.getValue()).getAsJsonObject();
                                MobGunnerData gunnerData = GunnerMobConfig.parseMobData(mobData);
                                if (gunnerData == null) continue;
                                ResourceLocation entityKey = new ResourceLocation(entityId);
                                GUNNER_MOBS.put(entityKey, gunnerData);
                            }
                        }
                        LOGGER.info("Loaded gunner mob config: {} mob types configured", (Object)GUNNER_MOBS.size());
                        break block10;
                    }
                }
                LOGGER.warn("Gunner mob config not found at {}", (Object)CONFIG_LOCATION);
                GunnerMobConfig.loadDefaults();
            }
            catch (Exception e) {
                LOGGER.error("Failed to load gunner mob config at {}", (Object)CONFIG_LOCATION, (Object)e);
                GunnerMobConfig.loadDefaults();
            }
        }
    }

    private static MobGunnerData parseMobData(JsonObject mobData) {
        try {
            float spawnChance = mobData.has("spawn_chance") ? mobData.get("spawn_chance").getAsFloat() : 0.3f;
            int aiDifficulty = mobData.has("ai_difficulty") ? mobData.get("ai_difficulty").getAsInt() : 2;
            float weaponDropChance = mobData.has("weapon_drop_chance") ? mobData.get("weapon_drop_chance").getAsFloat() : 0.085f;
            ArrayList<Item> weapons = new ArrayList<Item>();
            if (mobData.has("weapons")) {
                JsonArray weaponsArray = mobData.getAsJsonArray("weapons");
                for (JsonElement weaponElement : weaponsArray) {
                    String weaponId = weaponElement.getAsString();
                    Item weapon = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(weaponId));
                    if (weapon != null) {
                        weapons.add(weapon);
                        continue;
                    }
                    LOGGER.warn("Unknown weapon item: {}", (Object)weaponId);
                }
            }
            ArrayList<ArmorPiece> armor = new ArrayList<ArmorPiece>();
            if (mobData.has("armor")) {
                JsonArray armorArray = mobData.getAsJsonArray("armor");
                for (JsonElement armorElement : armorArray) {
                    JsonObject armorObj = armorElement.getAsJsonObject();
                    String itemId = armorObj.get("item").getAsString();
                    String slot = armorObj.get("slot").getAsString();
                    float chance = armorObj.has("chance") ? armorObj.get("chance").getAsFloat() : 1.0f;
                    Item armorItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
                    if (armorItem != null) {
                        armor.add(new ArmorPiece(armorItem, slot, chance));
                        continue;
                    }
                    LOGGER.warn("Unknown armor item: {}", (Object)itemId);
                }
            }
            return new MobGunnerData(spawnChance, weapons, armor, aiDifficulty, weaponDropChance);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing mob gunner data", (Throwable)e);
            return null;
        }
    }

    private static void loadDefaults() {
        LOGGER.info("Loading default gunner mob configuration");
    }

    public static MobGunnerData getGunnerData(EntityType<?> entityType) {
        return GUNNER_MOBS.get(ForgeRegistries.ENTITY_TYPES.getKey(entityType));
    }

    public static boolean canSpawnAsGunner(EntityType<?> entityType) {
        return GUNNER_MOBS.containsKey(ForgeRegistries.ENTITY_TYPES.getKey(entityType));
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                GunnerMobConfig.loadConfig(resourceManager);
            }
        });
    }

    public record MobGunnerData(float spawnChance, List<Item> allowedWeapons, List<ArmorPiece> allowedArmor, int aiDifficulty, float weaponDropChance) {
        public Item getRandomWeapon(RandomSource random) {
            if (this.allowedWeapons.isEmpty()) {
                return null;
            }
            return this.allowedWeapons.get(random.m_188503_(this.allowedWeapons.size()));
        }
    }

    public record ArmorPiece(Item item, String slot, float spawnChance) {
    }
}

