/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.ai;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import top.ribs.scguns.entity.monster.HornlinEntity;
import top.ribs.scguns.entity.monster.ZombifiedHornlinEntity;
import top.ribs.scguns.entity.util.GoldConsumptionHelper;
import top.ribs.scguns.entity.util.IGoldConsumingEntity;
import top.ribs.scguns.init.ModItems;

public class ConsumeGoldGoal
extends Goal {
    private final Mob entity;
    private final IGoldConsumingEntity goldConsumer;
    private int goldEatingTime = 0;
    private int eatingPreparationTime = 0;
    private ItemStack heldFoodItem = ItemStack.f_41583_;
    private static final int EATING_DURATION = 40;
    private static final int PREPARATION_DURATION = 15;
    private static final float PICKUP_RANGE = 1.5f;
    private static final int COOLDOWN_AFTER_EATING = 40;
    private static final int COOLDOWN_AFTER_CANCEL = 20;
    private static final float GOLD_VALUE_FOR_SLAG = 10.0f;
    private static final float POISON_GOLD_REDUCTION = 8.0f;
    private static final int SLAG_PRODUCTION_COOLDOWN = 150;

    public ConsumeGoldGoal(Mob entity, IGoldConsumingEntity goldConsumer) {
        this.entity = entity;
        this.goldConsumer = goldConsumer;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.goldConsumer.isEatingGold() || this.goldConsumer.isPreparingToEat()) {
            return true;
        }
        if (this.goldConsumer.getGoldEatingCooldown() > 0) {
            return false;
        }
        return this.findNearbyGold() != null;
    }

    public boolean m_8045_() {
        return this.goldConsumer.isEatingGold() || this.goldConsumer.isPreparingToEat() || this.eatingPreparationTime > 0;
    }

    public void m_8056_() {
        ItemEntity nearbyGold;
        this.entity.m_21573_().m_26573_();
        if (!this.goldConsumer.isEatingGold() && !this.goldConsumer.isPreparingToEat() && (nearbyGold = this.findNearbyGold()) != null) {
            this.prepareToEat(nearbyGold);
        }
    }

    public void m_8041_() {
        if (this.goldConsumer.isEatingGold() || this.goldConsumer.isPreparingToEat()) {
            if (!this.heldFoodItem.m_41619_()) {
                this.entity.m_19983_(this.heldFoodItem);
            }
            this.setEntityState(ItemStack.f_41583_, false, false);
        }
        this.resetEatingState();
    }

    public void m_8037_() {
        if (this.eatingPreparationTime > 0) {
            --this.eatingPreparationTime;
            this.entity.m_21573_().m_26573_();
            if (this.eatingPreparationTime <= 0) {
                this.startEating();
            }
            return;
        }
        if (this.goldConsumer.isEatingGold()) {
            --this.goldEatingTime;
            if (this.goldEatingTime % 8 == 0) {
                GoldConsumptionHelper.showEatingParticles(this.entity);
            }
            if (this.goldEatingTime <= 0) {
                this.finishEating();
            }
            return;
        }
        this.handleSlagProduction();
    }

    private ItemEntity findNearbyGold() {
        AABB closeArea = new AABB(this.entity.m_20185_() - 1.5, this.entity.m_20186_() - 0.5, this.entity.m_20189_() - 1.5, this.entity.m_20185_() + 1.5, this.entity.m_20186_() + 1.5, this.entity.m_20189_() + 1.5);
        return this.entity.m_9236_().m_45976_(ItemEntity.class, closeArea).stream().filter(item -> !item.m_213877_()).filter(item -> GoldConsumptionHelper.isGoldItem(item.m_32055_())).filter(item -> this.entity.m_20270_((Entity)item) <= 1.5f).findFirst().orElse(null);
    }

    private void prepareToEat(ItemEntity goldItem) {
        this.goldConsumer.setTargetGoldItem(goldItem);
        if (goldItem == null || goldItem.m_213877_()) {
            this.cancelEating();
            return;
        }
        ItemStack groundStack = goldItem.m_32055_();
        this.heldFoodItem = groundStack.m_41777_();
        this.heldFoodItem.m_41764_(1);
        this.setEntityState(this.heldFoodItem, false, true);
        groundStack.m_41774_(1);
        if (groundStack.m_41619_()) {
            goldItem.m_146870_();
        }
        this.eatingPreparationTime = 15;
        this.entity.m_21573_().m_26573_();
        this.entity.m_5496_(SoundEvents.f_12019_, 0.8f, 1.2f + this.entity.m_217043_().m_188501_() * 0.4f);
    }

    private void startEating() {
        this.setEntityState(this.heldFoodItem, true, false);
        this.goldEatingTime = 40;
        this.entity.m_5496_(SoundEvents.f_11912_, 0.8f, 1.0f + this.entity.m_217043_().m_188501_() * 0.2f);
    }

    private void finishEating() {
        if (!this.heldFoodItem.m_41619_()) {
            this.applyFoodEffects(this.heldFoodItem);
        }
        this.entity.m_5496_(SoundEvents.f_12321_, 0.8f, 1.3f);
        this.setEntityState(ItemStack.f_41583_, false, false);
        this.resetEatingState();
        this.goldConsumer.setGoldEatingCooldown(40);
    }

    private void applyFoodEffects(ItemStack foodStack) {
        if (GoldConsumptionHelper.isPoisonItem(foodStack)) {
            GoldConsumptionHelper.applyPoisonEffects(this.entity, foodStack);
            float currentGold = this.goldConsumer.getAccumulatedGoldValue();
            this.goldConsumer.setAccumulatedGoldValue(Math.max(0.0f, currentGold - 8.0f));
        } else {
            float healthToRestore = GoldConsumptionHelper.getHealthFromGold(foodStack);
            float goldNuggetValue = GoldConsumptionHelper.getGoldNuggetValue(foodStack);
            this.entity.m_5634_(healthToRestore);
            this.goldConsumer.addAccumulatedGoldValue(goldNuggetValue);
        }
    }

    private void cancelEating() {
        if (!this.heldFoodItem.m_41619_()) {
            this.entity.m_19983_(this.heldFoodItem);
        }
        this.setEntityState(ItemStack.f_41583_, false, false);
        this.resetEatingState();
        this.goldConsumer.setGoldEatingCooldown(20);
    }

    private void resetEatingState() {
        this.eatingPreparationTime = 0;
        this.goldEatingTime = 0;
        this.heldFoodItem = ItemStack.f_41583_;
        this.goldConsumer.setTargetGoldItem(null);
    }

    private void handleSlagProduction() {
        if (this.goldConsumer.getSlagProductionCooldown() > 0 || this.goldConsumer.isEatingGold() || this.goldConsumer.isPreparingToEat()) {
            return;
        }
        if (this.goldConsumer.getAccumulatedGoldValue() >= 10.0f) {
            this.produceSlag();
        }
    }

    private void produceSlag() {
        float currentGold = this.goldConsumer.getAccumulatedGoldValue();
        this.goldConsumer.setAccumulatedGoldValue(Math.max(0.0f, currentGold - 10.0f));
        this.entity.m_5496_(SoundEvents.f_12321_, 1.2f, 0.5f + this.entity.m_217043_().m_188501_() * 0.3f);
        GoldConsumptionHelper.showSlagProductionParticles(this.entity);
        ItemStack slagStack = new ItemStack((ItemLike)ModItems.AUREOUS_SLAG.get());
        this.entity.m_19983_(slagStack);
        this.goldConsumer.setSlagProductionCooldown(150);
    }

    private void setEntityState(ItemStack heldItem, boolean eating, boolean preparing) {
        Mob mob = this.entity;
        if (mob instanceof HornlinEntity) {
            HornlinEntity hornlin = (HornlinEntity)mob;
            hornlin.setHeldFoodItem(heldItem);
            hornlin.setEatingGold(eating);
            hornlin.setPreparingToEat(preparing);
        } else {
            mob = this.entity;
            if (mob instanceof ZombifiedHornlinEntity) {
                ZombifiedHornlinEntity zombified = (ZombifiedHornlinEntity)mob;
                zombified.setHeldFoodItem(heldItem);
                zombified.setEatingGold(eating);
                zombified.setPreparingToEat(preparing);
            }
        }
    }
}

