/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.ai;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.Config;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.ai.AIGunEvent;
import top.ribs.scguns.entity.ai.AIType;
import top.ribs.scguns.event.GunEventBus;
import top.ribs.scguns.init.ModEffects;
import top.ribs.scguns.init.ModSounds;
import top.ribs.scguns.item.GunItem;

public class GunAttackGoal<T extends PathfinderMob>
extends Goal {
    protected final T shooter;
    protected final double speedModifier;
    protected int seeTime;
    protected int attackTime;
    protected final float attackRadiusSqr;
    protected double idealRange;
    protected double minRange;
    protected float accuracyModifier = 1.0f;
    protected int strafingTime = -1;
    protected boolean shouldStrafe = false;
    protected float strafeAmount = 0.0f;
    protected int burstIntervalTimer = 0;
    protected int remainingBursts = 0;
    protected int burstResetTimer = 0;
    protected int reloadTick = 0;
    protected boolean isReloading = false;
    protected boolean isPanicked = false;
    protected int panickTimer = 0;
    protected AIType aiType;
    protected Vec3 lastKnownPosition;
    protected int burstAmount = 3;
    protected int burstTimer = 15;
    protected static final float ROTATION_SPEED = 15.0f;

    public GunAttackGoal(T shooter, ItemStack gunStack, float speedModifier, AIType aiType, int difficulty) {
        this.shooter = shooter;
        this.speedModifier = speedModifier;
        this.attackTime = -1;
        this.aiType = aiType;
        shooter.m_20049_("AI_" + aiType.name());
        Item item = gunStack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            Gun gun = gunItem.getModifiedGun(gunStack);
            this.idealRange = gun.getIdealAttackRange();
            this.minRange = gun.getMinAttackRange();
        } else {
            this.idealRange = 15.0;
            this.minRange = 8.0;
        }
        this.attackRadiusSqr = (float)(this.idealRange * this.idealRange);
        if (this.shooter.m_5448_() != null) {
            this.lastKnownPosition = this.shooter.m_5448_().m_20182_();
        }
        float baseAccuracy = switch (aiType) {
            default -> throw new IncompatibleClassChangeError();
            case AIType.TACTICAL -> 2.5f;
            case AIType.DEFAULT -> 2.0f;
            case AIType.RECKLESS -> 1.2f;
            case AIType.COWARD -> 1.5f;
        };
        float difficultyBonus = 1.0f + (float)(difficulty - 1) * 0.3f;
        this.accuracyModifier = baseAccuracy * difficultyBonus;
        this.burstAmount = 2 + difficulty / 2;
        float burstDelayMultiplier = this.getBurstDelayMultiplier(shooter.m_9236_().m_46791_());
        float configBurstMultiplier = ((Double)Config.COMMON.gameplay.mobBurstDelayMultiplier.get()).floatValue();
        this.burstTimer = Math.max(1, (int)((float)(30 - difficulty * 4) * burstDelayMultiplier * configBurstMultiplier));
    }

    private float getBurstDelayMultiplier(Difficulty difficulty) {
        return switch (difficulty) {
            default -> throw new IncompatibleClassChangeError();
            case Difficulty.PEACEFUL -> 2.0f;
            case Difficulty.EASY -> 1.5f;
            case Difficulty.NORMAL -> 1.0f;
            case Difficulty.HARD -> 0.6f;
        };
    }

    public boolean m_8036_() {
        return this.shooter.m_5448_() != null && this.isHoldingGun() && !this.shooter.m_5448_().m_21224_();
    }

    protected boolean isHoldingGun() {
        return this.shooter.m_21093_(itemStack -> itemStack.m_41720_() instanceof GunItem);
    }

    public void m_8056_() {
        super.m_8056_();
        this.shooter.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.shooter.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.shooter.m_5810_();
        this.reloadTick = 0;
        this.isReloading = false;
        this.strafingTime = -1;
        this.shouldStrafe = false;
        this.shooter.m_20137_("AI_" + this.aiType.name());
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        Item item;
        LivingEntity target = this.shooter.m_5448_();
        ItemStack heldItem = this.shooter.m_21205_();
        if (this.shooter.m_21023_((MobEffect)ModEffects.BLINDED.get()) || this.shooter.m_21023_((MobEffect)ModEffects.DEAFENED.get())) {
            this.isPanicked = true;
        }
        if (target != null && (item = heldItem.m_41720_()) instanceof GunItem) {
            boolean sawTargetPreviously;
            GunItem gunItem = (GunItem)item;
            Gun gun = gunItem.getModifiedGun(heldItem);
            double distanceToTarget = this.shooter.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            boolean canSeeTarget = this.shooter.m_21574_().m_148306_((Entity)target);
            boolean bl = sawTargetPreviously = this.seeTime > 0;
            if (canSeeTarget != sawTargetPreviously) {
                this.seeTime = 0;
            }
            if (this.isReloading) {
                ++this.seeTime;
            } else if (canSeeTarget) {
                this.lastKnownPosition = new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_());
                ++this.seeTime;
            } else {
                --this.seeTime;
            }
            if (this.aiType == AIType.COWARD && (this.shooter.m_21223_() < this.shooter.m_21233_() / 3.0f || ((PathfinderMob)this.shooter).f_19802_ != 0) || this.shooter.m_21023_((MobEffect)ModEffects.BLINDED.get())) {
                this.isPanicked = true;
                this.panickTimer = 20;
            }
            if (this.isPanicked) {
                Vec3 vec3;
                if (((PathfinderMob)this.shooter).f_19797_ % 10 == 0 && (vec3 = DefaultRandomPos.m_148403_(this.shooter, (int)5, (int)4)) != null) {
                    this.shooter.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier * 1.5);
                }
                --this.panickTimer;
                if (this.panickTimer <= 0) {
                    this.isPanicked = false;
                }
                return;
            }
            if (heldItem.m_41783_().m_128451_("AmmoCount") <= 0) {
                if (!this.isReloading) {
                    if (this.aiType == AIType.TACTICAL) {
                        Vec3 coverLocation = this.findCoverLocation();
                        this.shooter.m_21573_().m_26519_(coverLocation.f_82479_, coverLocation.f_82480_, coverLocation.f_82481_, this.speedModifier);
                    }
                    this.isReloading = true;
                    this.reloadTick = gun.getReloads().getReloadTimer();
                    this.shooter.m_9236_().m_6263_(null, this.shooter.m_20185_(), this.shooter.m_20186_(), this.shooter.m_20189_(), (SoundEvent)ModSounds.ITEM_PISTOL_RELOAD.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                } else if (this.reloadTick == 0) {
                    heldItem.m_41783_().m_128405_("AmmoCount", gun.getReloads().getMaxAmmo());
                    this.shooter.m_9236_().m_6263_(null, this.shooter.m_20185_(), this.shooter.m_20186_(), this.shooter.m_20189_(), (SoundEvent)ModSounds.ITEM_PISTOL_COCK.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                    this.isReloading = false;
                } else {
                    --this.reloadTick;
                }
                return;
            }
            boolean inRange = distanceToTarget <= (double)this.attackRadiusSqr;
            boolean tooClose = distanceToTarget < this.minRange * this.minRange;
            boolean isRetreating = false;
            if (!inRange || !canSeeTarget) {
                if (((PathfinderMob)this.shooter).f_19797_ % 20 == 0 || this.shooter.m_21573_().m_26571_()) {
                    if (this.aiType == AIType.RECKLESS) {
                        this.shooter.m_21573_().m_5624_((Entity)target, this.speedModifier * 1.2);
                    } else {
                        this.shooter.m_21573_().m_5624_((Entity)target, this.speedModifier);
                    }
                }
                this.shouldStrafe = false;
                this.strafingTime = -1;
            } else if (tooClose && this.aiType != AIType.RECKLESS) {
                Vec3 awayVector = this.shooter.m_20182_().m_82546_(target.m_20182_()).m_82541_();
                Vec3 retreatPos = this.shooter.m_20182_().m_82549_(awayVector.m_82490_(2.0));
                this.shooter.m_21573_().m_26519_(retreatPos.f_82479_, retreatPos.f_82480_, retreatPos.f_82481_, this.speedModifier * 0.8);
                this.shouldStrafe = false;
                this.strafingTime = -1;
                isRetreating = true;
            } else {
                this.shooter.m_21573_().m_26573_();
                if (this.aiType != AIType.RECKLESS) {
                    if (this.strafingTime < 0) {
                        if (this.shooter.m_217043_().m_188501_() < 0.2f) {
                            this.shouldStrafe = true;
                            this.strafingTime = 20 + this.shooter.m_217043_().m_188503_(20);
                            this.strafeAmount = this.shooter.m_217043_().m_188499_() ? 0.5f : -0.5f;
                        } else {
                            this.shouldStrafe = false;
                            this.strafingTime = 40 + this.shooter.m_217043_().m_188503_(40);
                        }
                    }
                    if (this.strafingTime > 0) {
                        --this.strafingTime;
                        if (this.shouldStrafe) {
                            this.shooter.m_21566_().m_24988_(0.0f, this.strafeAmount * 0.5f);
                        }
                    }
                }
            }
            if (canSeeTarget) {
                this.updateSmoothRotation(target);
            }
            if (inRange && canSeeTarget && this.seeTime >= 5 && !isRetreating && this.shooter.m_21205_().m_41783_().m_128451_("AmmoCount") > 0 && --this.attackTime <= 0) {
                float configBurstMultiplier = ((Double)Config.COMMON.gameplay.mobBurstDelayMultiplier.get()).floatValue();
                if (this.remainingBursts <= 0 && this.burstResetTimer <= 0) {
                    this.remainingBursts = 1 + this.shooter.m_9236_().f_46441_.m_188503_(this.burstAmount);
                    this.burstIntervalTimer = 1 + this.shooter.m_9236_().f_46441_.m_188503_(this.burstTimer);
                    this.burstResetTimer = Math.max(5, (int)((float)(40 + this.shooter.m_9236_().f_46441_.m_188503_(40)) * configBurstMultiplier));
                }
                if (this.shooter.m_21023_((MobEffect)ModEffects.BLINDED.get()) && !this.aiType.equals((Object)AIType.TACTICAL)) {
                    this.burstResetTimer = 0;
                }
                if (this.remainingBursts > 0 && --this.burstIntervalTimer <= 0) {
                    this.shoot(target, gun);
                    --this.remainingBursts;
                    this.burstIntervalTimer = 2 + this.shooter.m_9236_().f_46441_.m_188503_(6);
                }
                if (this.remainingBursts <= 0) {
                    --this.burstResetTimer;
                }
            }
        }
    }

    private void updateSmoothRotation(LivingEntity target) {
        float yawDiff;
        Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() * 0.8, 0.0);
        Vec3 shooterPos = this.shooter.m_20182_().m_82520_(0.0, (double)this.shooter.m_20192_(), 0.0);
        Vec3 toTarget = targetPos.m_82546_(shooterPos);
        double horizontalDist = Math.sqrt(toTarget.f_82479_ * toTarget.f_82479_ + toTarget.f_82481_ * toTarget.f_82481_);
        float desiredYaw = (float)(Math.atan2(toTarget.f_82481_, toTarget.f_82479_) * 57.29577951308232) - 90.0f;
        float desiredPitch = (float)(-(Math.atan2(toTarget.f_82480_, horizontalDist) * 57.29577951308232));
        for (yawDiff = desiredYaw - this.shooter.m_146908_(); yawDiff > 180.0f; yawDiff -= 360.0f) {
        }
        while (yawDiff < -180.0f) {
            yawDiff += 360.0f;
        }
        float newYaw = this.shooter.m_146908_() + Math.max(-15.0f, Math.min(15.0f, yawDiff));
        float newPitch = this.shooter.m_146909_() + Math.max(-15.0f, Math.min(15.0f, desiredPitch - this.shooter.m_146909_()));
        this.shooter.m_146922_(newYaw);
        this.shooter.m_146926_(newPitch);
        ((PathfinderMob)this.shooter).f_20884_ = ((PathfinderMob)this.shooter).f_20883_ = newYaw;
        ((PathfinderMob)this.shooter).f_20886_ = ((PathfinderMob)this.shooter).f_20885_ = newYaw;
    }

    private void shoot(LivingEntity target, Gun gun) {
        ResourceLocation fireSound;
        if (this.shooter.m_21023_((MobEffect)ModEffects.BLINDED.get()) && this.shooter.m_217043_().m_188499_()) {
            return;
        }
        ItemStack heldItem = this.shooter.m_21205_();
        AIGunEvent.performGunAttack(this.shooter, target, heldItem, gun, this.accuracyModifier);
        int baseRate = gun.getGeneral().getRate();
        float configMultiplier = ((Double)Config.COMMON.gameplay.mobFireRateMultiplier.get()).floatValue();
        this.attackTime = (int)((float)baseRate * configMultiplier);
        this.consumeAmmo(heldItem);
        if (this.shooter.m_21205_().m_41720_() instanceof GunItem) {
            GunEventBus.ejectCasing(this.shooter.m_9236_(), this.shooter, false);
        }
        if ((fireSound = gun.getSounds().getFire()) != null) {
            double posX = this.shooter.m_20185_();
            double posY = this.shooter.m_20186_() + (double)this.shooter.m_20192_();
            double posZ = this.shooter.m_20189_();
            float volume = ((Integer)Config.COMMON.gameplay.mobGunfireVolume.get()).intValue();
            float pitch = 0.9f + this.shooter.m_9236_().f_46441_.m_188501_() * 0.2f;
            this.shooter.m_9236_().m_6263_(null, posX, posY, posZ, SoundEvent.m_262824_((ResourceLocation)fireSound), SoundSource.HOSTILE, volume - 0.5f, pitch);
        }
    }

    private void consumeAmmo(ItemStack itemStack) {
        itemStack.m_41783_().m_128405_("AmmoCount", itemStack.m_41783_().m_128451_("AmmoCount") - 1);
    }

    private Vec3 findCoverLocation() {
        Vec3 targetPos = new Vec3(this.shooter.m_5448_().m_20185_(), this.shooter.m_5448_().m_20186_(), this.shooter.m_5448_().m_20189_());
        Vec3 mobPos = this.shooter.m_20182_();
        return mobPos.m_82549_(mobPos.m_82546_(targetPos).m_82541_().m_82490_(3.0));
    }
}

