/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.ai;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ribs.scguns.entity.ai.AIType;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GunMobFriendlyFire {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob victim = (Mob)livingEntity;
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        if (!(attacker instanceof Mob)) {
            return;
        }
        Mob mobAttacker = (Mob)attacker;
        if (GunMobFriendlyFire.shouldPreventFriendlyFire(victim, mobAttacker)) {
            event.setCanceled(true);
            victim.m_6703_(null);
        }
    }

    @SubscribeEvent
    public static void onChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        LivingEntity newTarget = event.getNewTarget();
        if (!(newTarget instanceof Mob)) {
            return;
        }
        Mob targetMob = (Mob)newTarget;
        if (GunMobFriendlyFire.shouldPreventFriendlyFire(targetMob, mob)) {
            event.setCanceled(true);
        }
    }

    private static boolean shouldPreventFriendlyFire(Mob victim, Mob attacker) {
        if (GunMobFriendlyFire.isInSameRaid(victim, attacker)) {
            return true;
        }
        if (!victim.m_19880_().contains("MobGunner") || !attacker.m_19880_().contains("MobGunner")) {
            return false;
        }
        AIType victimAI = GunMobFriendlyFire.getAIType(victim);
        AIType attackerAI = GunMobFriendlyFire.getAIType(attacker);
        if (victimAI == AIType.RECKLESS && attackerAI == AIType.RECKLESS) {
            return false;
        }
        return victimAI == AIType.TACTICAL || victimAI == AIType.DEFAULT || attackerAI == AIType.TACTICAL || attackerAI == AIType.DEFAULT;
    }

    private static AIType getAIType(Mob mob) {
        if (mob.m_19880_().contains("AI_TACTICAL")) {
            return AIType.TACTICAL;
        }
        if (mob.m_19880_().contains("AI_DEFAULT")) {
            return AIType.DEFAULT;
        }
        if (mob.m_19880_().contains("AI_RECKLESS")) {
            return AIType.RECKLESS;
        }
        if (mob.m_19880_().contains("AI_COWARD")) {
            return AIType.COWARD;
        }
        return AIType.DEFAULT;
    }

    private static boolean isInSameRaid(Mob victim, Mob attacker) {
        for (String tag : victim.m_19880_()) {
            if (!tag.startsWith("RaidMember_") || !attacker.m_19880_().contains(tag)) continue;
            return true;
        }
        return false;
    }
}

