/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import top.ribs.scguns.entity.animations.ModAnimationDefinitions;
import top.ribs.scguns.entity.monster.TraumaUnitEntity;

public class TraumaUnitModel<T extends Entity>
extends HierarchicalModel<T>
implements ArmedModel {
    private final ModelPart main;
    private final ModelPart bone;
    private final ModelPart head;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart cog;
    private int lastAttackTimeout = 0;

    public TraumaUnitModel(ModelPart root) {
        this.main = root;
        ModelPart full = this.main.m_171324_("Full");
        ModelPart torso = full.m_171324_("Torso");
        this.head = torso.m_171324_("Head");
        this.bone = torso.m_171324_("LeftArm");
        this.leftArm = torso.m_171324_("LeftArm");
        this.rightArm = torso.m_171324_("RightArm");
        this.cog = torso.m_171324_("Cog");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Full = partdefinition.m_171599_("Full", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Torso = Full.m_171599_("Torso", CubeListBuilder.m_171558_().m_171514_(68, 69).m_171488_(-4.5f, -8.75f, -1.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-8.0f, -10.0f, -11.0f, 10.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(32, 16).m_171488_(-7.5f, 0.0f, -10.5f, 9.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(36, 37).m_171488_(-7.0f, 3.0f, -9.75f, 8.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(36, 27).m_171488_(-7.0f, -3.0f, -10.0f, 8.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(54, 44).m_171488_(-6.0f, -10.925f, -3.0f, 6.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-17.0f, (float)7.0f));
        PartDefinition cube_r1 = Torso.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(29, 0).m_171488_(8.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.5f, (float)3.05f, (float)-6.6f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = Torso.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.0f, -7.9544f, -3.5971f, 2.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.3364f, (float)-8.1293f, (float)-11.3956f, (float)-1.5708f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r3 = Torso.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(4, 16).m_171488_(-1.0f, -3.3058f, -1.4187f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.3364f, (float)-8.1293f, (float)-11.3956f, (float)-0.3927f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r4 = Torso.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(24, 18).m_171488_(-1.75f, -0.9029f, -1.9544f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(70, 42).m_171488_(-2.25f, 0.0971f, -2.3544f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(24, 16).m_171488_(-3.25f, 3.0971f, -0.3544f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.3364f, (float)-8.1293f, (float)-11.3956f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r5 = Torso.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(4, 19).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.713f, (float)-11.4526f, (float)-3.4411f, (float)-2.3562f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r6 = Torso.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(4, 16).m_171488_(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.1718f, (float)-10.1461f, (float)-2.0269f, (float)3.1416f, (float)0.0f, (float)0.3927f));
        PartDefinition Cog = Torso.m_171599_("Cog", CubeListBuilder.m_171558_().m_171514_(64, 37).m_171488_(-1.0f, -1.0f, -1.49f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(24, 63).m_171488_(-1.0f, -4.0f, -0.99f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)-7.25f, (float)0.74f));
        PartDefinition cube_r7 = Cog.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(66, 16).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.01f, (float)0.0f, (float)0.0f, (float)1.5708f));
        PartDefinition cube_r8 = Cog.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(60, 63).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-0.015f, (float)0.0f, (float)0.0f, (float)2.3562f));
        PartDefinition cube_r9 = Cog.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(52, 63).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-0.015f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition Head = Torso.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, -4.6667f, -4.8333f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 32).m_171488_(-4.5f, 0.3333f, -5.3333f, 9.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(70, 8).m_171488_(-4.5f, -2.6667f, -0.3333f, 9.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)-12.3333f, (float)-6.1667f));
        PartDefinition LeftArm = Torso.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(66, 26).m_171488_(-2.5f, 4.0f, 0.25f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(54, 54).m_171488_(-4.0f, -0.75f, -1.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(54, 9).m_171488_(-4.0f, 4.25f, -1.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 71).m_171480_().m_171488_(-4.5f, 1.3f, -0.1f, 1.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-7.5f, (float)-9.0f, (float)-7.5f));
        PartDefinition cube_r10 = LeftArm.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)1.3f, (float)0.9f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = Torso.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171488_(-0.45f, -1.4f, -2.55f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(68, 63).m_171488_(0.25f, 3.85f, -0.8f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(36, 62).m_171488_(-0.25f, 2.1f, -2.05f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(58, 0).m_171488_(-0.25f, 7.1f, -2.05f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(38, 9).m_171488_(-0.25f, 4.1f, -2.05f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 71).m_171488_(3.5f, 1.4f, -1.15f, 1.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.75f, (float)-8.85f, (float)-6.45f));
        PartDefinition cube_r11 = RightArm.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)4.0f, (float)9.65f, (float)-0.15f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLeg = Torso.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(0, 54).m_171488_(-2.0f, 9.3f, -2.7f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(12, 63).m_171488_(-2.0f, 7.3f, 2.3f, 4.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(18, 54).m_171488_(-2.0f, 0.3f, -2.7f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(40, 68).m_171488_(-1.0f, 4.3f, -1.2f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(18, 44).m_171488_(-2.0f, 4.3f, -2.7f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 71).m_171480_().m_171488_(-3.0f, -0.65f, -1.0f, 1.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-5.0f, (float)3.7f, (float)-6.6f));
        PartDefinition RightLeg = Torso.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(36, 44).m_171488_(-2.0f, 9.2f, -2.7f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 63).m_171488_(-2.0f, 7.2f, 2.3f, 4.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(36, 53).m_171488_(-2.0f, 0.2f, -2.7f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(32, 68).m_171488_(-1.0f, 4.2f, -1.2f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 44).m_171488_(-2.0f, 4.2f, -2.7f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 71).m_171488_(2.0f, -0.75f, -1.0f, 1.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)3.8f, (float)-6.6f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.animateCog(ageInTicks);
        if (entity instanceof TraumaUnitEntity) {
            TraumaUnitEntity traumaUnit = (TraumaUnitEntity)((Object)entity);
            this.m_267799_(ModAnimationDefinitions.TRAUMA_UNIT_WALK, limbSwing, limbSwingAmount, 2.0f, 2.5f);
            if (traumaUnit.isAttacking() && traumaUnit.getAttackTimeout() > 0) {
                this.animateAttackSmooth(traumaUnit.getAttackTimeout(), ageInTicks);
            }
            float clampedYaw = Mth.m_14036_((float)netHeadYaw, (float)-75.0f, (float)75.0f);
            float clampedPitch = Mth.m_14036_((float)headPitch, (float)-30.0f, (float)30.0f);
            this.head.f_104204_ = clampedYaw * ((float)Math.PI / 180);
            this.head.f_104203_ = clampedPitch * ((float)Math.PI / 180);
        }
    }

    private void animateCog(float ageInTicks) {
        float rotationSpeed = 0.08f;
        this.cog.f_104205_ = ageInTicks * rotationSpeed;
    }

    private void animateAttackSmooth(int attackTimeout, float ageInTicks) {
        float thrust;
        float sideMotion;
        if (attackTimeout <= 0) {
            this.leftArm.f_104203_ = 0.0f;
            this.leftArm.f_104204_ = 0.0f;
            this.leftArm.f_104205_ = 0.0f;
            this.rightArm.f_104203_ = 0.0f;
            this.rightArm.f_104204_ = 0.0f;
            this.rightArm.f_104205_ = 0.0f;
            this.lastAttackTimeout = 0;
            return;
        }
        float swingCurve = TraumaUnitModel.getSwingCurve(attackTimeout, ageInTicks);
        float swingIntensity = swingCurve * 1.2f;
        this.leftArm.f_104203_ = -swingIntensity;
        this.rightArm.f_104203_ = -swingIntensity;
        this.leftArm.f_104204_ = sideMotion = swingCurve * 0.2f;
        this.rightArm.f_104204_ = -sideMotion;
        this.leftArm.f_104205_ = thrust = swingCurve * 0.2f;
        this.rightArm.f_104205_ = -thrust;
        this.lastAttackTimeout = attackTimeout;
    }

    private static float getSwingCurve(int attackTimeout, float ageInTicks) {
        float attackProgress = (15.0f - (float)attackTimeout) / 15.0f;
        attackProgress = Mth.m_14036_((float)attackProgress, (float)0.0f, (float)1.0f);
        float smoothProgress = Mth.m_14031_((float)(attackProgress * (float)Math.PI));
        return smoothProgress;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.main.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.main;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
    }
}

