/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.config.EntityEquipmentConfig;
import top.ribs.scguns.entity.monster.SignalBeaconEntity;
import top.ribs.scguns.init.ModEffects;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.item.GunItem;

public class CogKnightEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(CogKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TIMEOUT = SynchedEntityData.m_135353_(CogKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(CogKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();

    public CogKnightEntity(EntityType<? extends CogKnightEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.LEFT;
    }

    public boolean m_7301_(@NotNull MobEffectInstance pPotionEffect) {
        MobEffect effect = pPotionEffect.m_19544_();
        if (effect == MobEffects.f_19614_ || effect == MobEffects.f_19615_ || effect == MobEffects.f_19612_ || effect == MobEffects.f_19605_ || effect == MobEffects.f_19618_ || effect == MobEffects.f_19604_ || effect == MobEffects.f_19610_ || effect == MobEffects.f_19613_ || effect == MobEffects.f_19597_ || effect == MobEffects.f_19599_ || effect == MobEffects.f_19602_ || effect == ModEffects.SULFUR_POISONING.get() || effect == MobEffects.f_19601_) {
            return false;
        }
        return super.m_7301_(pPotionEffect);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 34.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22285_, 0.5).m_22268_(Attributes.f_22284_, 3.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22282_, (double)0.8f).m_22268_(Attributes.f_22281_, 6.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.isAttacking() && this.getAttackTimeout() > 0) {
            LivingEntity target;
            this.setAttackTimeout(this.getAttackTimeout() - 1);
            if (this.getAttackTimeout() == 6 && (target = this.m_5448_()) != null && this.m_20280_((Entity)target) <= (double)(this.m_20205_() * 2.0f * this.m_20205_() * 2.0f + target.m_20205_())) {
                this.m_7327_((Entity)target);
            }
            if (this.getAttackTimeout() <= 0) {
                this.setAttacking(false);
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    public void m_6667_(DamageSource source) {
        float rand;
        super.m_6667_(source);
        if (!this.m_9236_().f_46443_ && source.m_7639_() instanceof Player && (rand = this.f_19796_.m_188501_()) < 0.15f) {
            SignalBeaconEntity beacon = new SignalBeaconEntity((EntityType<? extends Mob>)((EntityType)ModEntities.SIGNAL_BEACON.get()), this.m_9236_());
            beacon.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            this.m_9236_().m_7967_((Entity)beacon);
        }
    }

    private void setupAnimationStates() {
        if (!this.idleAnimationState.m_216984_()) {
            this.idleAnimationState.m_216977_(this.f_19797_);
        }
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
        if (attacking) {
            this.setAttackTimeout(12);
        }
    }

    public void setAttackTimeout(int timeout) {
        this.f_19804_.m_135381_(ATTACK_TIMEOUT, (Object)timeout);
    }

    public int getAttackTimeout() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TIMEOUT);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TIMEOUT, (Object)0);
        this.f_19804_.m_135372_(CHARGING, (Object)false);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(CHARGING, (Object)charging);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        EntityEquipmentConfig.equipEntity((Mob)this, "cog_knight");
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new ChargeAttackGoal(this, 0.8, 12.0, 80));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
                if (pDistToEnemySqr <= this.m_6639_(pEnemy) && this.m_25565_() <= 0 && !CogKnightEntity.this.isAttacking()) {
                    CogKnightEntity.this.setAttacking(true);
                    this.m_25563_();
                    this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                }
            }

            protected double m_6639_(LivingEntity pEnemy) {
                return super.m_6639_(pEnemy) * 1.5;
            }

            protected void m_25563_() {
                this.m_183277_(25);
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 30.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{CogKnightEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, player -> !((Player)player).m_7500_() && !player.m_5833_()));
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 8; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_(), this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), 0.0, 0.0, 0.0);
                }
            }
        } else {
            super.m_7822_(pId);
        }
    }

    public boolean m_6040_() {
        return true;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12008_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        double velocityThreshold = -0.5;
        if (y >= velocityThreshold) {
            this.f_19789_ = 0.0f;
        } else {
            super.m_7840_(y, onGroundIn, state, pos);
        }
    }

    public class ChargeAttackGoal
    extends Goal {
        private final CogKnightEntity mob;
        private final double speedModifier;
        private final double chargeRange;
        private final int chargeCooldown;
        private int cooldownTicks;
        private int chargeTicks;
        private LivingEntity target;
        private boolean isCharging;

        public ChargeAttackGoal(CogKnightEntity mob, double speedModifier, double chargeRange, int chargeCooldown) {
            this.mob = mob;
            this.speedModifier = speedModifier;
            this.chargeRange = chargeRange;
            this.chargeCooldown = chargeCooldown;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            ItemStack mainHandItem = this.mob.m_21205_();
            if (mainHandItem.m_41720_() instanceof GunItem || mainHandItem.m_41720_() instanceof BowItem) {
                return false;
            }
            if (this.cooldownTicks > 0) {
                --this.cooldownTicks;
                return false;
            }
            this.target = this.mob.m_5448_();
            if (this.target == null) {
                return false;
            }
            double distanceToTarget = this.mob.m_20280_((Entity)this.target);
            return distanceToTarget <= this.chargeRange * this.chargeRange && distanceToTarget > 4.0;
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_() && this.chargeTicks > 0;
        }

        public void m_8056_() {
            this.isCharging = true;
            this.chargeTicks = 20;
            this.mob.setCharging(true);
            this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)4);
        }

        public void m_8037_() {
            if (this.target == null) {
                return;
            }
            this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            if (this.chargeTicks > 0) {
                double dz;
                double dy;
                --this.chargeTicks;
                double dx = this.target.m_20185_() - this.mob.m_20185_();
                double distance = Math.sqrt(dx * dx + (dy = this.target.m_20186_() - this.mob.m_20186_()) * dy + (dz = this.target.m_20189_() - this.mob.m_20189_()) * dz);
                if (distance > 0.1) {
                    dx = dx / distance * this.speedModifier;
                    dz = dz / distance * this.speedModifier;
                    this.mob.m_20334_(dx, this.mob.m_20184_().f_82480_, dz);
                    if (this.mob.m_20280_((Entity)this.target) <= 2.0) {
                        this.performChargeAttack();
                    }
                }
            }
        }

        public void m_8041_() {
            this.isCharging = false;
            this.mob.setCharging(false);
            this.cooldownTicks = this.chargeCooldown;
            this.target = null;
            this.chargeTicks = 0;
        }

        private void performChargeAttack() {
            if (this.target != null) {
                float chargeDamage = (float)this.mob.m_21133_(Attributes.f_22281_) * 1.5f;
                this.target.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), chargeDamage);
                double knockbackStrength = 1.0;
                double dx = this.target.m_20185_() - this.mob.m_20185_();
                double dz = this.target.m_20189_() - this.mob.m_20189_();
                double distance = Math.sqrt(dx * dx + dz * dz);
                if (distance > 0.0) {
                    this.target.m_20256_(this.target.m_20184_().m_82520_(dx / distance * knockbackStrength, 0.2, dz / distance * knockbackStrength));
                }
                this.mob.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
            }
            this.chargeTicks = 0;
        }
    }
}

