/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.entity.monster.SwarmEntity;
import top.ribs.scguns.init.ModEntities;

public class HiveEntity
extends Monster {
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private int swarmSummonCooldown = 0;
    static final List<SwarmEntity> summonedSwarm = new ArrayList<SwarmEntity>();

    public HiveEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public Level getEntityLevel() {
        return this.m_9236_();
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        if (this.swarmSummonCooldown > 0) {
            --this.swarmSummonCooldown;
        }
        summonedSwarm.removeIf(swarm -> !swarm.m_6084_());
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new HiveSummonGoal(this));
    }

    public void m_6667_(@NotNull DamageSource cause) {
        super.m_6667_(cause);
        for (SwarmEntity swarm : summonedSwarm) {
            if (swarm == null) continue;
            swarm.m_146870_();
        }
        summonedSwarm.clear();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22285_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 2.0);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        boolean isHurt = super.m_6469_(source, amount);
        if (isHurt && this.swarmSummonCooldown <= 0) {
            this.summonSwarm();
        }
        return isHurt;
    }

    private boolean canSummonSwarm() {
        return summonedSwarm.isEmpty() || summonedSwarm.stream().noneMatch(SwarmEntity::isActive);
    }

    private void summonSwarm() {
        SwarmEntity swarm;
        if (this.canSummonSwarm() && (swarm = (SwarmEntity)((EntityType)ModEntities.SWARM.get()).m_20615_(this.m_9236_())) != null) {
            swarm.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            this.m_9236_().m_7967_((Entity)swarm);
            summonedSwarm.add(swarm);
            this.swarmSummonCooldown = 60;
            this.playSwarmSummonedSound();
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        this.playAdditionalSound(SoundEvents.f_11691_, 1.5f, this.m_6100_());
        return SoundEvents.f_12598_;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        this.playAdditionalSound(SoundEvents.f_11741_, 1.5f, this.m_6100_());
        return SoundEvents.f_12608_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        this.playAdditionalSound(SoundEvents.f_11740_, 1.5f, this.m_6100_());
        return SoundEvents.f_12603_;
    }

    private void playAdditionalSound(SoundEvent soundEvent, float volume, float pitch) {
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), soundEvent, SoundSource.HOSTILE, volume, pitch);
        }
    }

    private void playSwarmSummonedSound() {
        if (!this.m_9236_().m_5776_()) {
            SoundEvent soundEvent = SoundEvents.f_11696_;
            this.m_9236_().m_5594_(null, this.m_20183_(), soundEvent, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public float m_6100_() {
        return super.m_6100_() * 1.3f;
    }

    public static class HiveSummonGoal
    extends Goal {
        private final HiveEntity hiveEntity;

        public HiveSummonGoal(HiveEntity hiveEntity) {
            this.hiveEntity = hiveEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.hiveEntity.m_5448_() != null && this.hiveEntity.swarmSummonCooldown <= 0;
        }

        public void m_8056_() {
            this.hiveEntity.summonSwarm();
        }

        public void m_8037_() {
            if (this.hiveEntity.swarmSummonCooldown <= 0 && this.hiveEntity.canSummonSwarm()) {
                this.hiveEntity.summonSwarm();
            }
        }
    }
}

