/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.entity.projectile.EnemyProjectileEntity;
import top.ribs.scguns.init.ModEffects;
import top.ribs.scguns.init.ModSounds;

public class SkyCarrierEntity
extends FlyingMob
implements Enemy {
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.m_135353_(SkyCarrierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MUZZLE_FLASH_TIMER = SynchedEntityData.m_135353_(SkyCarrierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_PHASING = SynchedEntityData.m_135353_(SkyCarrierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGE_ATTACKING = SynchedEntityData.m_135353_(SkyCarrierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private int shootCooldown = 0;
    private int chargeAttackCooldown = 0;
    private Vec3 initialTargetPosition = null;
    private int phasingTimer = 0;
    private static final int MAX_PHASING_TIME = 200;

    public SkyCarrierEntity(EntityType<? extends SkyCarrierEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new SkyCarrierMoveControl(this, 5.0, 8.0, 2.0, 0.9, 0.15);
    }

    public void setInitialTarget(Vec3 targetPosition) {
        this.initialTargetPosition = targetPosition;
        this.phasingTimer = 200;
        this.setPhasing(true);
        Vec3 direction = targetPosition.m_82546_(this.m_20182_()).m_82541_();
        float targetYaw = (float)(Math.atan2(direction.f_82481_, direction.f_82479_) * 57.29577951308232 - 90.0);
        this.m_146922_(targetYaw);
        this.f_20883_ = targetYaw;
        this.f_20885_ = targetYaw;
    }

    public boolean isPhasing() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_PHASING);
    }

    public void setPhasing(boolean phasing) {
        this.f_19804_.m_135381_(DATA_IS_PHASING, (Object)phasing);
        this.f_19794_ = phasing;
    }

    public boolean isChargeAttacking() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHARGE_ATTACKING);
    }

    public void setChargeAttacking(boolean charging) {
        this.f_19804_.m_135381_(DATA_IS_CHARGE_ATTACKING, (Object)charging);
    }

    public boolean m_7301_(@NotNull MobEffectInstance pPotionEffect) {
        MobEffect effect = pPotionEffect.m_19544_();
        if (effect == MobEffects.f_19614_ || effect == MobEffects.f_19615_ || effect == MobEffects.f_19612_ || effect == MobEffects.f_19605_ || effect == MobEffects.f_19618_ || effect == MobEffects.f_19604_ || effect == MobEffects.f_19610_ || effect == MobEffects.f_19613_ || effect == MobEffects.f_19597_ || effect == MobEffects.f_19599_ || effect == MobEffects.f_19602_ || effect == ModEffects.SULFUR_POISONING.get() || effect == MobEffects.f_19601_) {
            return false;
        }
        return super.m_7301_(pPotionEffect);
    }

    public boolean m_8028_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.isPhasing()) {
            if (this.m_5448_() != null) {
                this.setPhasing(false);
                this.initialTargetPosition = null;
            } else {
                this.handlePhasing();
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
            this.spawnSmokeParticles();
        } else {
            if (this.shootCooldown > 0) {
                --this.shootCooldown;
            } else {
                LivingEntity target = this.m_5448_();
                if (target != null && this.m_20280_((Entity)target) < 625.0 && !this.isPhasing()) {
                    this.fireProjectile();
                    this.shootCooldown = 15;
                }
            }
            if (this.chargeAttackCooldown > 0) {
                --this.chargeAttackCooldown;
            }
        }
        int currentTimer = (Integer)this.f_19804_.m_135370_(MUZZLE_FLASH_TIMER);
        if (currentTimer > 0) {
            this.f_19804_.m_135381_(MUZZLE_FLASH_TIMER, (Object)(currentTimer - 1));
        }
    }

    private void handlePhasing() {
        if (this.initialTargetPosition == null) {
            this.setPhasing(false);
            return;
        }
        double distanceToTarget = this.m_20182_().m_82554_(this.initialTargetPosition);
        --this.phasingTimer;
        if (distanceToTarget < 3.0 || this.phasingTimer <= 0) {
            this.setPhasing(false);
            this.initialTargetPosition = null;
        } else {
            Vec3 direction = this.initialTargetPosition.m_82546_(this.m_20182_()).m_82541_();
            this.m_20256_(direction.m_82490_(0.3));
            float targetYaw = (float)(Math.atan2(direction.f_82481_, direction.f_82479_) * 57.29577951308232 - 90.0);
            this.m_146922_(targetYaw);
            this.f_20883_ = targetYaw;
            this.f_20885_ = targetYaw;
        }
    }

    private void spawnSmokeParticles() {
        if (this.isMuzzleFlashVisible()) {
            double offsetX = 0.0;
            double offsetY = (double)this.m_20192_() - 0.5;
            double offsetZ = 0.0;
            double posX = this.m_20185_() + offsetX;
            double posY = this.m_20186_() + offsetY;
            double posZ = this.m_20189_() + offsetZ;
            RandomSource random = this.m_217043_();
            for (int i = 0; i < 1; ++i) {
                double particleOffsetX = random.m_188583_() * 0.1;
                double particleOffsetY = random.m_188583_() * 0.1;
                double particleOffsetZ = random.m_188583_() * 0.1;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, posX, posY, posZ, particleOffsetX, particleOffsetY, particleOffsetZ);
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RandomFloatAroundGoal(this, 100));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(6, (Goal)new SkyCarrierFaceAndBackAwayFromTargetGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22276_, 32.0).m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22285_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_CHARGING, (Object)false);
        this.f_19804_.m_135372_(MUZZLE_FLASH_TIMER, (Object)0);
        this.f_19804_.m_135372_(DATA_IS_PHASING, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_CHARGE_ATTACKING, (Object)false);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11737_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12008_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    public void triggerMuzzleFlash() {
        this.f_19804_.m_135381_(MUZZLE_FLASH_TIMER, (Object)6);
    }

    public boolean isMuzzleFlashVisible() {
        return (Integer)this.f_19804_.m_135370_(MUZZLE_FLASH_TIMER) > 0;
    }

    private void fireProjectile() {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            double turretOffsetHeight = 0.4;
            double turretOffsetBack = 0.4;
            double spawnHeight = this.m_20186_() + (double)this.m_20206_() + turretOffsetHeight;
            double spawnX = this.m_20185_() - Math.sin(Math.toRadians(this.m_146908_())) * turretOffsetBack;
            double spawnZ = this.m_20189_() + Math.cos(Math.toRadians(this.m_146908_())) * turretOffsetBack;
            EnemyProjectileEntity brassBolt = new EnemyProjectileEntity(this.m_9236_(), (LivingEntity)this);
            brassBolt.m_6034_(spawnX, spawnHeight, spawnZ);
            double dx = target.m_20185_() - spawnX;
            double dy = target.m_20188_() - spawnHeight + 0.1;
            double dz = target.m_20189_() - spawnZ;
            brassBolt.m_6686_(dx, dy, dz, 3.0f, 2.0f);
            this.m_9236_().m_7967_((Entity)brassBolt);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.BRUISER_SILENCED_FIRE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            this.triggerMuzzleFlash();
        }
    }

    @NotNull
    protected PathNavigation m_6037_(Level level) {
        return new FlyingPathNavigation((Mob)this, level);
    }

    private static class SkyCarrierMoveControl
    extends MoveControl {
        private final SkyCarrierEntity skyCarrier;
        private final double minDistance;
        private final double maxDistance;
        private final double bufferZone;
        private final double maxSpeed;
        private final double backingSpeed;
        private Vec3 currentVelocity = Vec3.f_82478_;
        private float currentYaw = 0.0f;
        private float targetYaw = 0.0f;
        private int chargeTicks = 0;
        private Vec3 chargeDirection = Vec3.f_82478_;

        public SkyCarrierMoveControl(SkyCarrierEntity skyCarrier, double minDistance, double maxDistance, double bufferZone, double maxSpeed, double backingSpeed) {
            super((Mob)skyCarrier);
            this.skyCarrier = skyCarrier;
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
            this.bufferZone = bufferZone;
            this.maxSpeed = maxSpeed;
            this.backingSpeed = backingSpeed;
            this.currentYaw = skyCarrier.m_146908_();
        }

        public void m_8126_() {
            double distance;
            if (this.skyCarrier.isPhasing()) {
                return;
            }
            if (this.skyCarrier.isChargeAttacking()) {
                this.handleChargeAttack();
                return;
            }
            LivingEntity target = this.skyCarrier.m_5448_();
            Vec3 desiredVelocity = Vec3.f_82478_;
            AABB repulsionBox = this.skyCarrier.m_20191_().m_82400_(2.0);
            List nearbyCarriers = this.skyCarrier.m_9236_().m_6443_(SkyCarrierEntity.class, repulsionBox, e -> e != this.skyCarrier);
            Vec3 repulsionVector = Vec3.f_82478_;
            for (SkyCarrierEntity other : nearbyCarriers) {
                Vec3 toOther = this.skyCarrier.m_20182_().m_82546_(other.m_20182_());
                distance = toOther.m_82553_();
                if (!(distance < 2.0) || !(distance > 0.0)) continue;
                repulsionVector = repulsionVector.m_82549_(toOther.m_82541_().m_82490_(0.5 / distance));
            }
            if (target != null) {
                Vec3 ourPos;
                Vec3 targetPos = target.m_20182_();
                Vec3 directionToTarget = targetPos.m_82546_(ourPos = this.skyCarrier.m_20182_());
                distance = directionToTarget.m_82553_();
                if (distance < this.minDistance) {
                    desiredVelocity = directionToTarget.m_82541_().m_82548_().m_82490_(this.backingSpeed);
                    if (this.skyCarrier.chargeAttackCooldown <= 0 && this.skyCarrier.m_217043_().m_188501_() < 0.08f) {
                        this.initiateChargeAttack(directionToTarget.m_82541_());
                        return;
                    }
                } else if (distance > this.maxDistance + this.bufferZone) {
                    desiredVelocity = directionToTarget.m_82541_().m_82490_(this.maxSpeed);
                } else if (distance < this.minDistance - this.bufferZone) {
                    desiredVelocity = directionToTarget.m_82541_().m_82548_().m_82490_(this.backingSpeed);
                }
            } else {
                this.handleIdleMovement();
                return;
            }
            desiredVelocity = desiredVelocity.m_82549_(repulsionVector.m_82490_(0.3));
            double acceleration = 0.15;
            double deceleration = 0.88;
            this.currentVelocity = this.currentVelocity.m_82490_(deceleration);
            Vec3 accelerationVec = desiredVelocity.m_82546_(this.currentVelocity).m_82490_(acceleration);
            this.currentVelocity = this.currentVelocity.m_82549_(accelerationVec);
            double currentSpeed = this.currentVelocity.m_82553_();
            if (currentSpeed > this.maxSpeed) {
                this.currentVelocity = this.currentVelocity.m_82541_().m_82490_(this.maxSpeed);
            }
            this.skyCarrier.m_20256_(this.currentVelocity);
            double dx = target.m_20185_() - this.skyCarrier.m_20185_();
            double dz = target.m_20189_() - this.skyCarrier.m_20189_();
            this.targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232 - 90.0);
            float yawDifference = Mth.m_14177_((float)(this.targetYaw - this.currentYaw));
            float maxTurnSpeed = 9.0f;
            float turnAmount = Mth.m_14036_((float)yawDifference, (float)(-maxTurnSpeed), (float)maxTurnSpeed);
            this.currentYaw = Mth.m_14177_((float)(this.currentYaw + turnAmount));
            this.skyCarrier.m_146922_(this.currentYaw);
            this.skyCarrier.f_20883_ = this.currentYaw;
            this.skyCarrier.f_20885_ = this.currentYaw;
        }

        private void initiateChargeAttack(Vec3 direction) {
            this.skyCarrier.setChargeAttacking(true);
            this.chargeDirection = direction;
            this.chargeTicks = 15;
            this.skyCarrier.chargeAttackCooldown = 100;
            this.skyCarrier.m_9236_().m_6263_(null, this.skyCarrier.m_20185_(), this.skyCarrier.m_20186_(), this.skyCarrier.m_20189_(), SoundEvents.f_12057_, SoundSource.HOSTILE, 0.8f, 1.5f);
        }

        private void handleChargeAttack() {
            if (this.chargeTicks > 0) {
                AABB collisionBox;
                --this.chargeTicks;
                double chargeSpeed = 1.2;
                this.skyCarrier.m_20256_(this.chargeDirection.m_82490_(chargeSpeed));
                LivingEntity target = this.skyCarrier.m_5448_();
                if (target != null && (collisionBox = this.skyCarrier.m_20191_().m_82400_(0.5)).m_82381_(target.m_20191_())) {
                    this.performChargeImpact(target);
                    return;
                }
                AABB nearbyBox = this.skyCarrier.m_20191_().m_82400_(1.5);
                List nearbyEntities = this.skyCarrier.m_9236_().m_6443_(LivingEntity.class, nearbyBox, entity -> entity != this.skyCarrier && entity instanceof Player);
                for (LivingEntity entity2 : nearbyEntities) {
                    if (!this.skyCarrier.m_142582_((Entity)entity2)) continue;
                    this.performChargeImpact(entity2);
                    return;
                }
                if (this.chargeTicks <= 0) {
                    this.skyCarrier.setChargeAttacking(false);
                }
            } else {
                this.skyCarrier.setChargeAttacking(false);
            }
        }

        private void performChargeImpact(LivingEntity target) {
            float damage = 4.0f;
            target.m_6469_(this.skyCarrier.m_269291_().m_269333_((LivingEntity)this.skyCarrier), damage);
            Vec3 targetPos = target.m_20182_();
            Vec3 carrierPos = this.skyCarrier.m_20182_();
            Vec3 knockbackDir = targetPos.m_82546_(carrierPos).m_82541_();
            double knockbackStrength = 1.5;
            target.m_20334_(knockbackDir.f_82479_ * knockbackStrength, 0.4, knockbackDir.f_82481_ * knockbackStrength);
            target.f_19864_ = true;
            this.skyCarrier.m_9236_().m_6263_(null, this.skyCarrier.m_20185_(), this.skyCarrier.m_20186_(), this.skyCarrier.m_20189_(), SoundEvents.f_12058_, SoundSource.HOSTILE, 1.0f, 1.2f);
            this.skyCarrier.setChargeAttacking(false);
            this.chargeTicks = 0;
        }

        private void handleIdleMovement() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 direction = new Vec3(this.f_24975_ - this.skyCarrier.m_20185_(), this.f_24976_ - this.skyCarrier.m_20186_(), this.f_24977_ - this.skyCarrier.m_20189_());
                double distance = direction.m_82553_();
                if (distance < 1.0) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.currentVelocity = this.currentVelocity.m_82490_(0.85);
                    this.skyCarrier.m_20256_(this.currentVelocity);
                } else {
                    Vec3 desiredVelocity = direction.m_82541_().m_82490_(Math.min(this.maxSpeed * 0.7, distance * 0.2));
                    this.currentVelocity = this.currentVelocity.m_82490_(0.88).m_82549_(desiredVelocity.m_82546_(this.currentVelocity).m_82490_(0.15));
                    this.skyCarrier.m_20256_(this.currentVelocity);
                    if (this.currentVelocity.m_82556_() > 0.001) {
                        this.targetYaw = (float)(Math.atan2(this.currentVelocity.f_82481_, this.currentVelocity.f_82479_) * 57.29577951308232 - 90.0);
                        float yawDifference = Mth.m_14177_((float)(this.targetYaw - this.currentYaw));
                        this.currentYaw = Mth.m_14177_((float)(this.currentYaw + Mth.m_14036_((float)yawDifference, (float)-9.0f, (float)9.0f)));
                        this.skyCarrier.m_146922_(this.currentYaw);
                        this.skyCarrier.f_20883_ = this.currentYaw;
                        this.skyCarrier.f_20885_ = this.currentYaw;
                    }
                }
            }
        }
    }

    public static class RandomFloatAroundGoal
    extends Goal {
        private final SkyCarrierEntity skyCarrier;
        private int tickDelay;

        public RandomFloatAroundGoal(SkyCarrierEntity skyCarrier, int initialDelay) {
            this.skyCarrier = skyCarrier;
            this.tickDelay = initialDelay;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.skyCarrier.isPhasing() && --this.tickDelay <= 0;
        }

        public void m_8056_() {
            this.setNewWanderTarget();
            this.tickDelay = 100;
        }

        private void setNewWanderTarget() {
            double x = this.skyCarrier.m_20185_() + (this.skyCarrier.m_217043_().m_188500_() * 20.0 - 10.0);
            double y = this.skyCarrier.m_20186_() + (this.skyCarrier.m_217043_().m_188500_() * 20.0 - 10.0);
            double z = this.skyCarrier.m_20189_() + (this.skyCarrier.m_217043_().m_188500_() * 20.0 - 10.0);
            this.skyCarrier.m_21566_().m_6849_(x, y, z, 1.0);
        }
    }

    private static class SkyCarrierFaceAndBackAwayFromTargetGoal
    extends Goal {
        private final SkyCarrierEntity skyCarrier;
        private float currentYaw;

        public SkyCarrierFaceAndBackAwayFromTargetGoal(SkyCarrierEntity skyCarrier) {
            this.skyCarrier = skyCarrier;
            this.currentYaw = skyCarrier.m_146908_();
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return !this.skyCarrier.isPhasing() && this.skyCarrier.m_5448_() != null;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.skyCarrier.m_5448_();
            if (target != null) {
                Vec3 targetPos = new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_());
                Vec3 ourPos = new Vec3(this.skyCarrier.m_20185_(), this.skyCarrier.m_20186_(), this.skyCarrier.m_20189_());
                Vec3 vectorToTarget = targetPos.m_82546_(ourPos).m_82541_();
                float targetYaw = -((float)Math.atan2(vectorToTarget.f_82479_, vectorToTarget.f_82481_)) * 57.295776f;
                targetYaw = Mth.m_14177_((float)targetYaw);
                float yawDiff = Mth.m_14177_((float)(targetYaw - this.currentYaw));
                float turnSpeed = 4.0f;
                this.skyCarrier.f_20885_ = this.currentYaw = Mth.m_14177_((float)(this.currentYaw + Mth.m_14036_((float)yawDiff, (float)(-turnSpeed), (float)turnSpeed)));
            }
        }
    }
}

