/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.time.LocalDate;
import java.time.Month;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.client.screen.SupplyScampMenuProvider;
import top.ribs.scguns.entity.monster.SignalBeaconEntity;
import top.ribs.scguns.init.ModEffects;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModItems;
import top.ribs.scguns.init.ModSounds;

public class SupplyScampEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Boolean> PANICKING = SynchedEntityData.m_135353_(SupplyScampEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(SupplyScampEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PATROLLING = SynchedEntityData.m_135353_(SupplyScampEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MASK_COLOR = SynchedEntityData.m_135353_(SupplyScampEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<BlockPos>> PATROL_ORIGIN = SynchedEntityData.m_135353_(SupplyScampEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Boolean> WEARING_PUMPKIN = SynchedEntityData.m_135353_(SupplyScampEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int PATROL_COOLDOWN = 15;
    private int patrolCooldownTimer = 15;
    private static final int ITEM_COOLDOWN = 12;
    private int itemCooldownTimer = 12;
    private BlockPos scheduledBarrelClose = null;
    private int barrelCloseTimer = 0;
    private static final int PATROL_RADIUS = 9;
    private static final int PATROL_MOVE_INTERVAL = 100;
    private static final int PATROL_DURATION = 80;
    private static final EntityDataAccessor<Boolean> STATIONARY = SynchedEntityData.m_135353_(SupplyScampEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final double ITEM_DETECTION_RANGE = 9.0;
    private static final double ITEM_PICKUP_RANGE = 2.5;
    private int patrolTimer = 0;
    private BlockPos currentPatrolTarget = null;
    private static final int INVENTORY_SIZE = 27;
    public final SimpleContainer inventory = new SimpleContainer(27);
    private static final int ANIMATION_UPDATE_INTERVAL = 5;
    private int animationUpdateTimer = 5;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState panicAnimationState = new AnimationState();
    public final AnimationState sitAnimationState = new AnimationState();
    public int panicAnimationTimeout = 0;
    public int idleAnimationTimeout = 0;
    private static final int[] DYE_COLOR_TO_MASK_INDEX = new int[]{15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};

    public SupplyScampEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.m_21553_(true);
    }

    public boolean m_7301_(@NotNull MobEffectInstance pPotionEffect) {
        MobEffect effect = pPotionEffect.m_19544_();
        if (effect == MobEffects.f_19614_ || effect == MobEffects.f_19615_ || effect == MobEffects.f_19612_ || effect == MobEffects.f_19605_ || effect == MobEffects.f_19618_ || effect == MobEffects.f_19604_ || effect == MobEffects.f_19610_ || effect == MobEffects.f_19613_ || effect == MobEffects.f_19597_ || effect == MobEffects.f_19599_ || effect == MobEffects.f_19602_ || effect == ModEffects.SULFUR_POISONING.get()) {
            return false;
        }
        return super.m_7301_(pPotionEffect);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21824_()) {
            if (this.scheduledBarrelClose != null && this.barrelCloseTimer > 0) {
                --this.barrelCloseTimer;
                if (this.barrelCloseTimer <= 0) {
                    BlockState barrelState = this.m_9236_().m_8055_(this.scheduledBarrelClose);
                    if (barrelState.m_60734_() instanceof BarrelBlock && ((Boolean)barrelState.m_61143_((Property)BarrelBlock.f_49043_)).booleanValue()) {
                        this.m_9236_().m_7731_(this.scheduledBarrelClose, (BlockState)barrelState.m_61124_((Property)BarrelBlock.f_49043_, (Comparable)Boolean.valueOf(false)), 3);
                        this.m_5496_(SoundEvents.f_11724_, 0.5f, 1.0f);
                    }
                    this.scheduledBarrelClose = null;
                }
            }
            if (this.patrolCooldownTimer <= 0) {
                if (this.isPatrolling()) {
                    this.handlePatrolling();
                }
                this.patrolCooldownTimer = 15;
            } else {
                --this.patrolCooldownTimer;
            }
            if (this.itemCooldownTimer <= 0) {
                if (this.isPatrolling() || !this.m_21827_() && !this.isSitting()) {
                    this.checkForItems();
                }
                this.itemCooldownTimer = 12;
            } else {
                --this.itemCooldownTimer;
            }
        }
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
    }

    private void handlePatrolling() {
        ItemEntity nearestItem;
        BlockPos nearestBarrel;
        Optional<BlockPos> patrolOrigin = this.getPatrolOrigin();
        if (!patrolOrigin.isPresent()) {
            return;
        }
        int totalItems = 0;
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            totalItems += stack.m_41613_();
        }
        if (totalItems >= 3 && (nearestBarrel = this.findNearestBarrel()) != null) {
            double distanceToBarrel = this.m_20238_(Vec3.m_82512_((Vec3i)nearestBarrel));
            if (distanceToBarrel <= 9.0) {
                BlockEntity blockEntity = this.m_9236_().m_7702_(nearestBarrel);
                if (blockEntity instanceof Container) {
                    Container container = (Container)blockEntity;
                    this.depositAllItems(container);
                }
            } else {
                this.m_21573_().m_26519_((double)nearestBarrel.m_123341_() + 0.5, (double)nearestBarrel.m_123342_(), (double)nearestBarrel.m_123343_() + 0.5, 1.0);
                return;
            }
        }
        if (totalItems < 25 && (nearestItem = this.findNearestItem()) != null && this.m_20280_((Entity)nearestItem) <= 81.0) {
            if (this.m_20280_((Entity)nearestItem) > 6.25) {
                this.m_21573_().m_5624_((Entity)nearestItem, 1.0);
                return;
            }
            this.m_7581_(nearestItem);
        }
        if (this.patrolTimer <= 0) {
            if ((double)this.f_19796_.m_188501_() < 0.5) {
                this.currentPatrolTarget = patrolOrigin.get().m_7918_(this.f_19796_.m_188503_(18) - 9, 0, this.f_19796_.m_188503_(18) - 9);
                this.m_21573_().m_26519_((double)this.currentPatrolTarget.m_123341_() + 0.5, (double)this.currentPatrolTarget.m_123342_(), (double)this.currentPatrolTarget.m_123343_() + 0.5, 0.8);
                this.patrolTimer = 80;
            } else {
                this.m_21573_().m_26573_();
                this.currentPatrolTarget = null;
                this.patrolTimer = 50;
            }
        } else {
            --this.patrolTimer;
            if (this.currentPatrolTarget != null && this.m_20238_(Vec3.m_82512_((Vec3i)this.currentPatrolTarget)) < 4.0) {
                this.m_21573_().m_26573_();
                this.currentPatrolTarget = null;
                this.patrolTimer = 20;
            }
        }
        if (this.m_20238_(Vec3.m_82512_((Vec3i)((Vec3i)patrolOrigin.get()))) > 144.0) {
            this.m_21573_().m_26519_((double)patrolOrigin.get().m_123341_() + 0.5, (double)patrolOrigin.get().m_123342_(), (double)patrolOrigin.get().m_123343_() + 0.5, 1.0);
            this.currentPatrolTarget = null;
            this.patrolTimer = 40;
        }
    }

    private BlockPos findNearestBarrel() {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BlockPos nearestBarrel = null;
        double nearestDistance = Double.MAX_VALUE;
        int searchRange = 16;
        for (int x = -searchRange; x <= searchRange; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -searchRange; z <= searchRange; ++z) {
                    double distance;
                    BlockEntity blockEntity;
                    mutablePos.m_122178_(this.m_20183_().m_123341_() + x, this.m_20183_().m_123342_() + y, this.m_20183_().m_123343_() + z);
                    if (!this.m_9236_().m_8055_((BlockPos)mutablePos).m_60734_().toString().contains("barrel") || !((blockEntity = this.m_9236_().m_7702_((BlockPos)mutablePos)) instanceof Container) || !((distance = this.m_20238_(Vec3.m_82512_((Vec3i)mutablePos))) < nearestDistance)) continue;
                    nearestDistance = distance;
                    nearestBarrel = mutablePos.m_7949_();
                }
            }
        }
        return nearestBarrel;
    }

    private void depositAllItems(Container container) {
        BlockState barrelState;
        BlockPos barrelPos = null;
        for (int x = -2; x <= 2; ++x) {
            block1: for (int y = -1; y <= 1; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos checkPos = this.m_20183_().m_7918_(x, y, z);
                    BlockState blockState = this.m_9236_().m_8055_(checkPos);
                    BlockEntity blockEntity = this.m_9236_().m_7702_(checkPos);
                    if (!(blockState.m_60734_() instanceof BarrelBlock) || blockEntity != container) continue;
                    barrelPos = checkPos;
                    continue block1;
                }
            }
        }
        if (barrelPos != null && (barrelState = this.m_9236_().m_8055_(barrelPos)).m_60734_() instanceof BarrelBlock && !((Boolean)barrelState.m_61143_((Property)BarrelBlock.f_49043_)).booleanValue()) {
            this.m_9236_().m_7731_(barrelPos, (BlockState)barrelState.m_61124_((Property)BarrelBlock.f_49043_, (Comparable)Boolean.valueOf(true)), 3);
            this.scheduleBarrelClose(barrelPos);
        }
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemStack = this.inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            ItemStack remainingStack = this.tryAddItemToContainer(container, itemStack);
            this.inventory.m_6836_(i, remainingStack);
        }
        this.m_5496_(SoundEvents.f_11725_, 0.5f, 1.0f);
    }

    private void scheduleBarrelClose(BlockPos barrelPos) {
        this.scheduledBarrelClose = barrelPos;
        this.barrelCloseTimer = 40;
    }

    private ItemStack tryAddItemToContainer(Container container, ItemStack itemStack) {
        for (int j = 0; j < container.m_6643_(); ++j) {
            int maxStackSize;
            int spaceInSlot;
            ItemStack containerStack = container.m_8020_(j);
            if (containerStack.m_41619_()) {
                container.m_6836_(j, itemStack.m_41777_());
                return ItemStack.f_41583_;
            }
            if (!ItemStack.m_150942_((ItemStack)containerStack, (ItemStack)itemStack) || (spaceInSlot = (maxStackSize = containerStack.m_41741_()) - containerStack.m_41613_()) <= 0) continue;
            int transferAmount = Math.min(itemStack.m_41613_(), spaceInSlot);
            containerStack.m_41769_(transferAmount);
            itemStack.m_41774_(transferAmount);
            if (!itemStack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return itemStack;
    }

    private void checkForItems() {
        if (this.isPatrolling()) {
            return;
        }
        ItemEntity nearestItem = this.findNearestItem();
        if (nearestItem != null) {
            double distance = this.m_20280_((Entity)nearestItem);
            if (distance <= 6.25) {
                if (this.inventory.m_19183_(nearestItem.m_32055_())) {
                    ItemStack remaining = this.inventory.m_19173_(nearestItem.m_32055_());
                    if (remaining.m_41619_()) {
                        nearestItem.m_146870_();
                    } else {
                        nearestItem.m_32045_(remaining);
                    }
                    this.m_5496_(SoundEvents.f_12019_, 0.2f, ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
                }
            } else if (distance <= 81.0) {
                this.m_21573_().m_5624_((Entity)nearestItem, 1.0);
            }
        }
    }

    private ItemEntity findNearestItem() {
        List nearbyItems = this.m_9236_().m_6443_(ItemEntity.class, this.m_20191_().m_82400_(9.0), item -> this.inventory.m_19183_(item.m_32055_()));
        return nearbyItems.stream().min(Comparator.comparingDouble(arg_0 -> ((SupplyScampEntity)this).m_20280_(arg_0))).orElse(null);
    }

    public void m_7581_(ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.m_32055_();
        ItemStack remaining = this.inventory.m_19173_(itemStack);
        if (remaining.m_41619_()) {
            itemEntity.m_146870_();
        } else {
            itemEntity.m_32045_(remaining);
        }
        this.m_5496_(SoundEvents.f_12019_, 0.2f, ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
    }

    public void setStationary(boolean stationary) {
        this.f_19804_.m_135381_(STATIONARY, (Object)stationary);
    }

    public Optional<BlockPos> getPatrolOrigin() {
        return (Optional)this.f_19804_.m_135370_(PATROL_ORIGIN);
    }

    private void setupAnimationStates() {
        if (this.animationUpdateTimer > 0) {
            --this.animationUpdateTimer;
            return;
        }
        this.animationUpdateTimer = 5;
        if (this.isSitting()) {
            if (!this.sitAnimationState.m_216984_()) {
                this.sitAnimationState.m_216977_(this.f_19797_);
            }
            this.sitAnimationState.m_216974_((float)this.f_19797_, 1.0f);
            this.panicAnimationState.m_216973_();
            this.idleAnimationState.m_216973_();
            return;
        }
        this.sitAnimationState.m_216973_();
        if (this.isPanicked()) {
            if (this.panicAnimationTimeout <= 0) {
                this.panicAnimationTimeout = 50;
                this.panicAnimationState.m_216977_(this.f_19797_);
            }
            this.panicAnimationState.m_216974_((float)this.f_19797_, 1.0f);
            this.idleAnimationState.m_216973_();
            --this.panicAnimationTimeout;
        } else {
            this.panicAnimationState.m_216973_();
        }
        if (!this.isSitting() && !this.isPanicked()) {
            if (this.idleAnimationTimeout <= 0) {
                this.idleAnimationTimeout = 60;
                this.idleAnimationState.m_216977_(this.f_19797_);
            }
            this.idleAnimationState.m_216974_((float)this.f_19797_, 1.0f);
            --this.idleAnimationTimeout;
        } else {
            this.idleAnimationState.m_216973_();
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_6667_(DamageSource pCause) {
        float rand;
        super.m_6667_(pCause);
        if (!this.m_9236_().f_46443_ && (rand = this.f_19796_.m_188501_()) < 0.35f) {
            SignalBeaconEntity beacon = new SignalBeaconEntity((EntityType<? extends Mob>)((EntityType)ModEntities.SIGNAL_BEACON.get()), this.m_9236_());
            beacon.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            this.m_9236_().m_7967_((Entity)beacon);
        }
    }

    public boolean isPanicked() {
        return (Boolean)this.f_19804_.m_135370_(PANICKING);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
    }

    public int getMaskColor() {
        return (Integer)this.f_19804_.m_135370_(MASK_COLOR);
    }

    public void setMaskColor(int color) {
        this.f_19804_.m_135381_(MASK_COLOR, (Object)color);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.31).m_22268_(Attributes.f_22285_, 3.0).m_22268_(Attributes.f_22284_, 6.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SupplyScampPanicGoal(this, 2.5));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        if (this.m_21824_()) {
            this.f_21345_.m_25352_(3, (Goal)new SupplyScampFollowOwnerGoal(this, 1.3, 10.0f, 2.0f, false));
        } else {
            this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        }
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || itemstack.m_150930_((Item)ModItems.ANCIENT_BRASS.get()) && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (itemstack.m_150930_((Item)ModItems.ANCIENT_BRASS.get()) && this.m_21223_() < this.m_21233_()) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                float healAmount = 6.0f;
                this.m_5634_(healAmount);
                this.m_5496_(SoundEvents.f_11912_, 0.5f, 1.0f);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 3, 0.3, 0.3, 0.3, 0.1);
                }
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41720_() == Items.f_42574_ && this.isWearingPumpkin()) {
                if (!this.m_9236_().f_46443_) {
                    this.setWearingPumpkin(false);
                    this.m_146852_(GameEvent.f_157781_, (Entity)player);
                    itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    this.m_19998_((ItemLike)Items.f_42047_);
                    this.m_5496_(SoundEvents.f_12296_, 1.0f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if ((itemstack.m_150930_(Items.f_42047_) || itemstack.m_150930_(Items.f_42055_)) && !this.isWearingPumpkin()) {
                if (!this.m_9236_().f_46443_) {
                    this.setWearingPumpkin(true);
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (itemstack.m_41720_() instanceof DyeItem) {
                DyeColor dyeColor = ((DyeItem)itemstack.m_41720_()).m_41089_();
                this.setMaskColor(DYE_COLOR_TO_MASK_INDEX[dyeColor.m_41060_()]);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_()) {
                if (this.m_21827_()) {
                    this.m_21839_(false);
                    this.setSitting(false);
                    this.setPatrolling(true);
                    this.setPatrolOrigin(this.m_20183_());
                    this.spawnPatrolOriginParticles();
                    BlockPos nearestBarrel = this.findNearestBarrel();
                    if (nearestBarrel == null) {
                        player.m_5661_((Component)Component.m_237115_((String)"message.supply_scamp.patrolling_no_barrel"), true);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"message.supply_scamp.patrolling"), true);
                    }
                } else if (this.isPatrolling()) {
                    this.setPatrolling(false);
                    this.m_21839_(false);
                    player.m_5661_((Component)Component.m_237115_((String)"message.supply_scamp.following"), true);
                } else {
                    this.m_21839_(true);
                    this.setSitting(true);
                    this.setPatrolling(false);
                    player.m_5661_((Component)Component.m_237115_((String)"message.supply_scamp.sitting"), true);
                }
            } else {
                player.m_5893_((MenuProvider)new SupplyScampMenuProvider(this));
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)ModItems.ANCIENT_BRASS.get())) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PANICKING, (Object)false);
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(PATROLLING, (Object)false);
        this.f_19804_.m_135372_(MASK_COLOR, (Object)0);
        this.f_19804_.m_135372_(PATROL_ORIGIN, Optional.empty());
        this.f_19804_.m_135372_(STATIONARY, (Object)false);
        this.f_19804_.m_135372_(WEARING_PUMPKIN, (Object)false);
    }

    public boolean isWearingPumpkin() {
        return (Boolean)this.f_19804_.m_135370_(WEARING_PUMPKIN);
    }

    public void setWearingPumpkin(boolean wearing) {
        this.f_19804_.m_135381_(WEARING_PUMPKIN, (Object)wearing);
    }

    private static boolean isHalloweenSeason() {
        LocalDate date = LocalDate.now();
        return date.getMonth() == Month.OCTOBER;
    }

    protected void m_267689_(float partialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(partialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)ModSounds.SCAMP_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SCAMP_DIE.get();
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.KILLED) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemStack = this.inventory.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                this.m_19983_(itemStack);
            }
        }
        super.m_142687_(reason);
    }

    public void m_21530_() {
        super.m_21530_();
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        if (SupplyScampEntity.isHalloweenSeason() && this.f_19796_.m_188501_() < 0.85f) {
            this.setWearingPumpkin(true);
        }
        return spawnData;
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        compound.m_128379_("Patrolling", this.isPatrolling());
        this.getPatrolOrigin().ifPresent(pos -> {
            compound.m_128405_("PatrolOriginX", pos.m_123341_());
            compound.m_128405_("PatrolOriginY", pos.m_123342_());
            compound.m_128405_("PatrolOriginZ", pos.m_123343_());
        });
        compound.m_128365_("Items", (Tag)listnbt);
        compound.m_128405_("MaskColor", this.getMaskColor());
        compound.m_128379_("WearingPumpkin", this.isWearingPumpkin());
        if (this.scheduledBarrelClose != null) {
            compound.m_128405_("BarrelCloseX", this.scheduledBarrelClose.m_123341_());
            compound.m_128405_("BarrelCloseY", this.scheduledBarrelClose.m_123342_());
            compound.m_128405_("BarrelCloseZ", this.scheduledBarrelClose.m_123343_());
            compound.m_128405_("BarrelCloseTimer", this.barrelCloseTimer);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        ListTag listnbt = compound.m_128437_("Items", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.m_128728_(i);
            int j = compoundnbt.m_128445_("Slot") & 0xFF;
            if (j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundnbt));
        }
        this.setPatrolling(compound.m_128471_("Patrolling"));
        if (compound.m_128441_("PatrolOriginX") && compound.m_128441_("PatrolOriginY") && compound.m_128441_("PatrolOriginZ")) {
            BlockPos patrolOrigin = new BlockPos(compound.m_128451_("PatrolOriginX"), compound.m_128451_("PatrolOriginY"), compound.m_128451_("PatrolOriginZ"));
            this.setPatrolOrigin(patrolOrigin);
        }
        if (compound.m_128425_("MaskColor", 3)) {
            this.setMaskColor(compound.m_128451_("MaskColor"));
        }
        if (compound.m_128441_("WearingPumpkin")) {
            this.setWearingPumpkin(compound.m_128471_("WearingPumpkin"));
        }
        if (compound.m_128441_("BarrelCloseX")) {
            this.scheduledBarrelClose = new BlockPos(compound.m_128451_("BarrelCloseX"), compound.m_128451_("BarrelCloseY"), compound.m_128451_("BarrelCloseZ"));
            this.barrelCloseTimer = compound.m_128451_("BarrelCloseTimer");
        }
    }

    public void setPatrolOrigin(BlockPos pos) {
        if (pos != null) {
            this.f_19804_.m_135381_(PATROL_ORIGIN, Optional.of(pos));
        } else {
            this.f_19804_.m_135381_(PATROL_ORIGIN, Optional.empty());
        }
    }

    public void spawnPatrolOriginParticles() {
        if (this.m_9236_() instanceof ServerLevel) {
            BlockPos pos = this.getPatrolOrigin().orElse(this.m_20183_());
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
        }
    }

    public boolean isPatrolling() {
        return (Boolean)this.f_19804_.m_135370_(PATROLLING);
    }

    public void setPatrolling(boolean patrolling) {
        this.f_19804_.m_135381_(PATROLLING, (Object)patrolling);
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(36.0);
            this.m_21153_(36.0f);
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(8.0);
        }
        this.f_21345_.m_262460_(goal -> true);
        this.m_8099_();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.ANCIENT_BRASS.get());
    }

    public boolean m_6573_(@NotNull Player player) {
        return this.m_21824_() && super.m_6573_(player);
    }

    private void setPanicking(boolean b) {
        this.f_19804_.m_135381_(PANICKING, (Object)b);
    }

    public static class SupplyScampPanicGoal
    extends PanicGoal {
        private final SupplyScampEntity scamp;

        public SupplyScampPanicGoal(SupplyScampEntity scamp, double speedModifier) {
            super((PathfinderMob)scamp, speedModifier);
            this.scamp = scamp;
        }

        public boolean m_8036_() {
            if (this.scamp.m_21824_() && this.scamp.m_21188_() instanceof Player) {
                return false;
            }
            return super.m_8036_();
        }

        public void m_8056_() {
            this.scamp.setPanicking(true);
            super.m_8056_();
        }

        public void m_8041_() {
            this.scamp.setPanicking(false);
            super.m_8041_();
        }
    }

    public static class SupplyScampFollowOwnerGoal
    extends FollowOwnerGoal {
        private final SupplyScampEntity scamp;

        public SupplyScampFollowOwnerGoal(SupplyScampEntity scamp, double speed, float minDistance, float maxDistance, boolean leavesAllowed) {
            super((TamableAnimal)scamp, speed, minDistance, maxDistance, leavesAllowed);
            this.scamp = scamp;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.scamp.isPatrolling();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.scamp.isPatrolling();
        }

        public void m_8056_() {
            if (!this.scamp.isPatrolling()) {
                super.m_8056_();
            }
        }

        public void m_8037_() {
            if (!this.scamp.isPatrolling()) {
                super.m_8037_();
            }
        }
    }
}

