/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.item.GunItem;

public class FrogDartProjectileEntity
extends ProjectileEntity {
    private static final double UNDERWATER_SPEED_MULTIPLIER = 1.5;
    private static final double LAND_SPEED_MULTIPLIER = 0.6;
    private static final double UNDERWATER_GRAVITY_REDUCTION = 0.3;
    private static final float LAND_DAMAGE_PENALTY = 0.7f;
    private boolean wasUnderwater = false;

    public FrogDartProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public FrogDartProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
        if (this.m_20069_()) {
            Vec3 motion = this.m_20184_();
            this.m_20256_(motion.m_82490_(1.5));
            this.wasUnderwater = true;
        }
    }

    @Override
    public void m_8119_() {
        boolean currentlyUnderwater = this.m_20069_();
        if (currentlyUnderwater && !this.wasUnderwater) {
            motion = this.m_20184_();
            this.m_20256_(motion.m_82490_(2.5));
        } else if (!currentlyUnderwater && this.wasUnderwater) {
            motion = this.m_20184_();
            this.m_20256_(motion.m_82490_(0.39999999999999997));
        }
        this.wasUnderwater = currentlyUnderwater;
        super.m_8119_();
        if (currentlyUnderwater && !this.m_9236_().f_46443_ && this.f_19797_ % 3 == 0) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.05, 0.05, 0.05, 0.01);
        }
    }

    @Override
    protected void onProjectileTick() {
        Vec3 motion;
        if (this.m_20069_() && (motion = this.m_20184_()).m_82556_() > 0.001) {
            this.m_20256_(motion.m_82490_(1.02));
        }
    }

    @Override
    public double getModifiedGravity() {
        if (this.m_20069_()) {
            return super.getModifiedGravity() * 0.3;
        }
        return super.getModifiedGravity();
    }

    @Override
    public float getDamage() {
        float baseDamage = super.getDamage();
        if (!this.m_20069_()) {
            baseDamage *= 0.7f;
        }
        return baseDamage;
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        super.onHitBlock(state, pos, face, x, y, z);
        if (!this.m_9236_().f_46443_ && !this.m_20069_()) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            Vec3 hitPos = new Vec3(x, y, z);
            for (int i = 0; i < 3; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 1, (this.f_19796_.m_188500_() - 0.5) * 0.1, this.f_19796_.m_188500_() * 0.1, (this.f_19796_.m_188500_() - 0.5) * 0.1, 0.02);
            }
        }
    }
}

