/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.Config;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.effect.CustomExplosion;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.util.GunEnchantmentHelper;

public class MicroJetEntity
extends ProjectileEntity {
    public static final float EXPLOSION_DAMAGE_MULTIPLIER = 2.0f;
    private static final float MAX_DAMAGE_MULTIPLIER = 1.5f;
    private static final int TICKS_TO_MAX_SPEED = 15;
    private static final float SHIELD_DISABLE_CHANCE = 0.75f;
    private static final float SHIELD_DAMAGE_PENETRATION = 0.2f;
    private static final float HEADSHOT_EFFECT_DURATION_MULTIPLIER = 1.5f;
    private static final float AREA_EFFECT_DURATION_MULTIPLIER = 0.75f;
    private int ticksInFlight = 0;

    public MicroJetEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public MicroJetEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
    }

    @Override
    protected void onProjectileTick() {
        ++this.ticksInFlight;
        if (this.m_9236_().f_46443_) {
            for (int i = 2; i > 0; --i) {
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.ROCKET_TRAIL.get(), true, this.m_20185_() - this.m_20184_().m_7096_() / (double)i, this.m_20186_() - this.m_20184_().m_7098_() / (double)i, this.m_20189_() - this.m_20184_().m_7094_() / (double)i, 0.0, 0.0, 0.0);
            }
            if (this.m_9236_().f_46441_.m_188503_(4) == 0) {
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_175834_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public float getDamage() {
        float baseDamage = super.getDamage();
        float speedMultiplier = this.calculateSpeedMultiplier();
        return baseDamage * speedMultiplier;
    }

    private float calculateSpeedMultiplier() {
        if (this.ticksInFlight >= 15) {
            return 1.5f;
        }
        float progress = (float)this.ticksInFlight / 15.0f;
        return 1.0f + progress * 0.5f;
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        LivingEntity livingEntity;
        float damage = this.getDamage();
        if (headshot) {
            damage = (float)((double)damage * (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get());
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            damage = this.applyBlastProtection(livingTarget, damage);
        }
        boolean wasAlive = entity instanceof LivingEntity && entity.m_6084_();
        DamageSource source = ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, (LivingEntity)this.getOwner());
        boolean blocked = ProjectileEntity.ProjectileHelper.handleShieldHit(entity, this, damage, 0.75f);
        if (blocked) {
            float penetratingDamage = damage * 0.2f;
            entity.m_6469_(source, penetratingDamage);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                this.applyEffect(livingEntity2, 0.2f, headshot);
            }
        } else {
            entity.m_6469_(source, damage);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity3 = (LivingEntity)entity;
                this.applyEffect(livingEntity3, 1.0f, headshot);
            }
        }
        if (entity instanceof LivingEntity) {
            GunEnchantmentHelper.applyElementalPopEffect(this.getWeapon(), (LivingEntity)entity);
        }
        this.applyAreaEffects(hitVec);
        if (wasAlive && entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_6084_()) {
            this.checkForDiamondSteelBonus(livingEntity, hitVec);
        }
        MicroJetEntity.createMiniExplosion(this, 1.0f);
    }

    private float applyBlastProtection(LivingEntity target, float damage) {
        int protectionLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44968_, (LivingEntity)target);
        if (protectionLevel > 0) {
            float reduction = (float)protectionLevel * 0.08f;
            reduction = Math.min(reduction, 0.8f);
            damage *= 1.0f - reduction;
        }
        return damage;
    }

    private void applyEffect(LivingEntity target, float powerMultiplier, boolean headshot) {
        ResourceLocation effectLocation = this.getProjectile().getImpactEffect();
        if (effectLocation != null) {
            MobEffect effect;
            float effectChance = this.getProjectile().getImpactEffectChance() * powerMultiplier;
            if (headshot) {
                effectChance = Math.min(1.0f, effectChance * 1.25f);
            }
            if (this.f_19796_.m_188501_() < effectChance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
                int duration = this.getProjectile().getImpactEffectDuration();
                if (headshot) {
                    duration = (int)((float)duration * 1.5f);
                }
                duration = (int)((float)duration * powerMultiplier);
                target.m_7292_(new MobEffectInstance(effect, duration, this.getProjectile().getImpactEffectAmplifier()));
            }
        }
    }

    private void applyAreaEffects(Vec3 center) {
        MobEffect effect;
        ResourceLocation effectLocation;
        if (!this.m_9236_().m_5776_() && (effectLocation = this.getProjectile().getImpactEffect()) != null && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
            List nearbyEntities = this.m_9236_().m_45976_(LivingEntity.class, new AABB(center.f_82479_ - 1.0, center.f_82480_ - 1.0, center.f_82481_ - 1.0, center.f_82479_ + 1.0, center.f_82480_ + 1.0, center.f_82481_ + 1.0));
            float areaEffectChance = this.getProjectile().getImpactEffectChance() * 0.4f;
            for (LivingEntity entity : nearbyEntities) {
                if (entity == this.getShooter()) continue;
                this.applyEffect(entity, 0.3f, false);
                double distance = entity.m_20182_().m_82554_(center);
                float distanceMultiplier = (float)(1.0 - distance);
                float finalChance = areaEffectChance * Math.max(0.0f, distanceMultiplier);
                if (!(this.f_19796_.m_188501_() < finalChance)) continue;
                this.applyEffect(entity, 0.75f, false);
            }
        }
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        Vec3 hitPos = new Vec3(x, y, z);
        this.applyAreaEffects(hitPos);
        MicroJetEntity.createMiniExplosion(this, 1.0f);
    }

    @Override
    public void onExpired() {
        Vec3 pos = this.m_20182_();
        this.applyAreaEffects(pos);
        MicroJetEntity.createMiniExplosion(this, 1.0f);
    }

    public static void createMiniExplosion(Entity entity, float radius) {
        Level world = entity.m_9236_();
        if (world.f_46443_) {
            return;
        }
        CustomExplosion explosion = new CustomExplosion(world, entity, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, false, CustomExplosion.CustomBlockInteraction.NONE){};
        if (ForgeEventFactory.onExplosionStart((Level)world, (Explosion)explosion)) {
            return;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        for (ServerPlayer player : ((ServerLevel)world).m_6907_()) {
            if (!(player.m_20275_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()) < 4096.0)) continue;
            player.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(player)));
        }
    }
}

