/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.Config;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.interfaces.IDamageable;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageBlood;
import top.ribs.scguns.network.message.S2CMessageBulletTrail;
import top.ribs.scguns.network.message.S2CMessageProjectileHitBlock;
import top.ribs.scguns.network.message.S2CMessageProjectileHitEntity;
import top.ribs.scguns.util.GunEnchantmentHelper;

public class ShotballProjectileEntity
extends ProjectileEntity {
    private static final int MAX_BOUNCES = 3;
    private static final float FIRST_BOUNCE_VELOCITY_BOOST = 1.15f;
    private static final float FIRST_BOUNCE_DAMAGE_BOOST = 1.1f;
    private static final float BOUNCE_VELOCITY_RETENTION = 0.7f;
    private static final float DAMAGE_REDUCTION_PER_BOUNCE = 0.85f;
    private static final float MIN_BOUNCE_VELOCITY = 0.01f;
    private static final int RIDER_IMMUNITY_TICKS = 3;
    private int immunityTicks;
    private static final float BASE_KNOCKBACK = 3.0f;
    private static final float KNOCKBACK_MULTIPLIER_PER_BOUNCE = 0.9f;
    private static final float VERTICAL_KNOCKBACK_BOOST = 0.4f;
    private static final float SPLASH_KNOCKBACK_RADIUS = 5.0f;
    private static final float SPLASH_KNOCKBACK_FALLOFF = 0.5f;
    private static final float WOOD_BREAK_CHANCE_BASE = 0.95f;
    private static final float WOOD_BREAK_CHANCE_PER_BOUNCE = 0.25f;
    private int bouncesLeft = 3;
    private float currentDamageMultiplier = 1.0f;

    public ShotballProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public ShotballProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
        this.immunityTicks = 3;
    }

    @Override
    public void m_8119_() {
        if (this.immunityTicks > 0) {
            --this.immunityTicks;
        }
        this.updateHeading();
        this.onProjectileTick();
        if (!this.m_9236_().m_5776_()) {
            Vec3 startVec = this.m_20182_();
            Vec3 endVec = startVec.m_82549_(this.m_20184_());
            this.handleCustomCollisions(startVec, endVec);
        }
        double nextPosX = this.m_20185_() + this.m_20184_().m_7096_();
        double nextPosY = this.m_20186_() + this.m_20184_().m_7098_();
        double nextPosZ = this.m_20189_() + this.m_20184_().m_7094_();
        this.m_6034_(nextPosX, nextPosY, nextPosZ);
        if (this.projectile.isGravity()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, this.modifiedGravity, 0.0));
        }
        if (this.f_19797_ >= this.life) {
            if (this.m_6084_()) {
                this.onExpired();
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private float calculateWoodBreakChance() {
        int bouncesUsed = 3 - this.bouncesLeft;
        return 0.95f - (float)bouncesUsed * 0.25f;
    }

    private void tryBreakWoodenBlock(BlockState state, BlockPos pos) {
        if (!((Boolean)Config.COMMON.gameplay.griefing.enableGlassBreaking.get()).booleanValue()) {
            return;
        }
        if (!(state.m_204336_(BlockTags.f_13090_) || state.m_204336_(BlockTags.f_13095_) || state.m_204336_(BlockTags.f_13102_) || state.m_204336_(BlockTags.f_13098_))) {
            return;
        }
        float breakChance = this.calculateWoodBreakChance();
        if (this.f_19796_.m_188501_() < breakChance) {
            this.m_9236_().m_46961_(pos, true);
            this.m_9236_().m_5594_(null, pos, SoundEvents.f_12630_, SoundSource.BLOCKS, 1.0f, 0.8f);
        }
    }

    private void applyKnockback(Entity target, Vec3 hitPos) {
        if (!(target instanceof LivingEntity)) {
            return;
        }
        Vec3 knockbackDirection = target.m_20182_().m_82546_(this.m_20182_()).m_82541_();
        Vec3 knockbackVec = this.getVec3(knockbackDirection);
        target.m_5997_(knockbackVec.f_82479_, knockbackVec.f_82480_, knockbackVec.f_82481_);
        target.f_19864_ = true;
    }

    @NotNull
    private Vec3 getVec3(Vec3 knockbackDirection) {
        float knockbackStrength = 3.0f * this.currentDamageMultiplier;
        int bouncesUsed = 3 - this.bouncesLeft;
        return new Vec3(knockbackDirection.f_82479_ * (double)(knockbackStrength *= (float)Math.pow(0.9f, bouncesUsed)), Math.max(knockbackDirection.f_82480_ * (double)knockbackStrength, 0.0) + (double)0.4f, knockbackDirection.f_82481_ * (double)knockbackStrength);
    }

    private void applySplashKnockback(Entity primaryTarget, Vec3 hitPos, float primaryKnockbackStrength) {
        AABB searchBox = new AABB(hitPos.f_82479_ - 5.0, hitPos.f_82480_ - 5.0, hitPos.f_82481_ - 5.0, hitPos.f_82479_ + 5.0, hitPos.f_82480_ + 5.0, hitPos.f_82481_ + 5.0);
        List nearbyEntities = this.m_9236_().m_6443_(LivingEntity.class, searchBox, entity -> entity != primaryTarget && entity != this.shooter && entity.m_6084_());
        for (LivingEntity nearbyEntity : nearbyEntities) {
            double distance = nearbyEntity.m_20182_().m_82554_(hitPos);
            if (!(distance <= 5.0)) continue;
            float distanceFalloff = (float)(1.0 - distance / 5.0);
            Vec3 splashDirection = nearbyEntity.m_20182_().m_82546_(hitPos).m_82541_();
            float splashStrength = primaryKnockbackStrength * 0.5f * distanceFalloff;
            Vec3 splashKnockback = new Vec3(splashDirection.f_82479_ * (double)splashStrength, Math.max(splashDirection.f_82480_ * (double)splashStrength, 0.0) + (double)0.28f, splashDirection.f_82481_ * (double)splashStrength);
            nearbyEntity.m_5997_(splashKnockback.f_82479_, splashKnockback.f_82480_, splashKnockback.f_82481_);
            nearbyEntity.f_19864_ = true;
            if (!(distance <= 3.0)) continue;
            float splashDamage = this.getDamage() * 0.15f * distanceFalloff;
            DamageSource source = ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, this.shooter);
            nearbyEntity.m_6469_(source, splashDamage);
        }
    }

    private boolean isShooterRelatedEntity(Entity entity) {
        if (this.shooter == null) {
            return false;
        }
        if (this.immunityTicks > 0) {
            if (this.shooter.m_20159_() && this.shooter.m_20202_() == entity) {
                return true;
            }
            if (entity.m_20159_() && entity.m_20202_() == this.shooter) {
                return true;
            }
            Entity shooterVehicle = this.shooter.m_20202_();
            if (shooterVehicle != null && (shooterVehicle.m_20202_() == entity || entity.m_20202_() == shooterVehicle)) {
                return true;
            }
        }
        return false;
    }

    private void handleCustomCollisions(Vec3 startVec, Vec3 endVec) {
        BlockHitResult blockResult = this.m_9236_().m_45547_(new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        List<ProjectileEntity.EntityResult> entityResults = this.findShotballEntitiesOnPath(startVec, endVec);
        double blockDistance = Double.MAX_VALUE;
        double entityDistance = Double.MAX_VALUE;
        if (blockResult.m_6662_() != HitResult.Type.MISS) {
            blockDistance = startVec.m_82557_(blockResult.m_82450_());
        }
        ProjectileEntity.EntityResult closestEntity = null;
        if (!entityResults.isEmpty()) {
            for (ProjectileEntity.EntityResult entityResult : entityResults) {
                double dist = startVec.m_82557_(entityResult.getHitPos());
                if (!(dist < entityDistance)) continue;
                entityDistance = dist;
                closestEntity = entityResult;
            }
        }
        if (blockDistance < entityDistance && blockResult.m_6662_() != HitResult.Type.MISS) {
            this.handleBlockCollision(blockResult);
        } else if (closestEntity != null) {
            this.handleEntityCollision(closestEntity);
        }
    }

    private List<ProjectileEntity.EntityResult> findShotballEntitiesOnPath(Vec3 startVec, Vec3 endVec) {
        ArrayList<ProjectileEntity.EntityResult> hitEntities = new ArrayList<ProjectileEntity.EntityResult>();
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        for (Entity entity : entities) {
            ProjectileEntity.EntityResult result;
            if (this.isShooterRelatedEntity(entity) || (result = this.getHitResult(entity, startVec, endVec)) == null) continue;
            hitEntities.add(result);
        }
        return hitEntities;
    }

    private void handleBlockCollision(BlockHitResult result) {
        Vec3 hitVec = result.m_82450_();
        BlockPos pos = result.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        Direction face = result.m_82434_();
        this.tryBreakWoodenBlock(state, pos);
        Block block = state.m_60734_();
        if (block instanceof IDamageable) {
            IDamageable damageable = (IDamageable)block;
            damageable.onBlockDamaged(this.m_9236_(), state, pos, this, this.getDamage() * this.currentDamageMultiplier, (int)Math.ceil((double)(this.getDamage() * this.currentDamageMultiplier) / 2.0) + 1);
        }
        if (this.bouncesLeft > 0 && this.canBounce() && !state.m_247087_()) {
            this.bounce(face, hitVec);
            --this.bouncesLeft;
            this.currentDamageMultiplier = this.bouncesLeft == 1 ? (this.currentDamageMultiplier *= 1.1f) : (this.currentDamageMultiplier *= 0.85f);
            if (this.m_9236_() instanceof ServerLevel && this.projectile.isVisible()) {
                this.sendBounceTrailUpdate();
            }
            this.m_9236_().m_6263_(null, hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, SoundEvents.f_12446_, SoundSource.NEUTRAL, 0.8f, 1.2f + (this.f_19796_.m_188501_() - 0.5f) * 0.4f);
            this.spawnBounceParticles(hitVec);
        } else {
            PacketHandler.getPlayChannel().sendToTrackingChunk(() -> this.m_9236_().m_46745_(pos), (IMessage)new S2CMessageProjectileHitBlock(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, pos, face));
            this.spawnDeathParticles(this.m_20182_());
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void handleEntityCollision(ProjectileEntity.EntityResult entityResult) {
        float newDamage;
        Entity entity = entityResult.getEntity();
        Vec3 hitVec = entityResult.getHitPos();
        boolean headshot = entityResult.isHeadshot();
        float damage = this.getDamage() * this.currentDamageMultiplier;
        boolean critical = damage != (newDamage = this.getCriticalDamage(this.getWeapon(), this.f_19796_, damage));
        damage = newDamage;
        damage *= this.advantageMultiplier(entity);
        if (headshot) {
            damage = (float)((double)damage * (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get());
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            damage = this.applyProjectileProtection(livingTarget, damage);
            damage = this.calculateArmorBypassDamage(livingTarget, damage);
        }
        DamageSource source = ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, this.shooter);
        boolean blocked = ProjectileEntity.ProjectileHelper.handleShieldHit(entity, this, damage);
        if (!(blocked || entity.m_6095_().m_204039_(ModTags.Entities.GHOST) && !this.getProjectile().getAdvantage().equals((Object)ModTags.Entities.UNDEAD.f_203868_()))) {
            if (damage > 0.0f) {
                entity.m_6469_(source, damage);
                float knockbackStrength = 3.0f * this.currentDamageMultiplier;
                int bouncesUsed = 3 - this.bouncesLeft;
                this.applyKnockback(entity, hitVec);
                this.applySplashKnockback(entity, hitVec, knockbackStrength *= (float)Math.pow(0.9f, bouncesUsed));
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                ResourceLocation effectLocation = this.projectile.getImpactEffect();
                if (effectLocation != null) {
                    MobEffect effect;
                    float effectChance = this.projectile.getImpactEffectChance();
                    if (this.f_19796_.m_188501_() < effectChance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
                        livingEntity.m_7292_(new MobEffectInstance(effect, this.projectile.getImpactEffectDuration(), this.projectile.getImpactEffectAmplifier()));
                    }
                }
            }
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            GunEnchantmentHelper.applyElementalPopEffect(this.getWeapon(), livingEntity);
        }
        if (this.shooter instanceof Player) {
            int hitType = critical ? 2 : (headshot ? 1 : 0);
            PacketHandler.getPlayChannel().sendToPlayer(() -> (ServerPlayer)this.shooter, (IMessage)new S2CMessageProjectileHitEntity(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, hitType, entity instanceof Player));
        }
        PacketHandler.getPlayChannel().sendToTracking(() -> entity, (IMessage)new S2CMessageBlood(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, entity.m_6095_()));
        if (this.bouncesLeft > 0 && this.canBounce()) {
            this.bounceOffEntity(entity, hitVec);
            --this.bouncesLeft;
            this.currentDamageMultiplier = this.bouncesLeft == 1 ? (this.currentDamageMultiplier *= 1.1f) : (this.currentDamageMultiplier *= 0.85f);
            this.m_9236_().m_6263_(null, hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, SoundEvents.f_12391_, SoundSource.NEUTRAL, 0.6f, 1.0f + (this.f_19796_.m_188501_() - 0.5f) * 0.4f);
            this.spawnBounceParticles(hitVec);
        } else {
            this.spawnDeathParticles(this.m_20182_());
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        entity.f_19802_ = 0;
    }

    private void bounce(Direction face, Vec3 hitPos) {
        Vec3 velocity = this.m_20184_();
        Vec3 newVelocity = switch (face.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vec3(-velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
            case Direction.Axis.Y -> new Vec3(velocity.f_82479_, -velocity.f_82480_, velocity.f_82481_);
            case Direction.Axis.Z -> new Vec3(velocity.f_82479_, velocity.f_82480_, -velocity.f_82481_);
        };
        newVelocity = newVelocity.m_82490_((double)0.7f);
        if (this.bouncesLeft == 2) {
            newVelocity = newVelocity.m_82490_((double)1.15f);
        }
        newVelocity = newVelocity.m_82520_((this.f_19796_.m_188500_() - 0.5) * 0.05, (this.f_19796_.m_188500_() - 0.5) * 0.05, (this.f_19796_.m_188500_() - 0.5) * 0.05);
        this.m_20256_(newVelocity);
        Vec3 offset = Vec3.m_82528_((Vec3i)face.m_122436_()).m_82490_(0.2);
        this.m_146884_(hitPos.m_82549_(offset));
    }

    private void bounceOffEntity(Entity entity, Vec3 hitPos) {
        Vec3 velocity = this.m_20184_();
        Vec3 entityCenter = entity.m_20191_().m_82399_();
        Vec3 bounceDirection = this.m_20182_().m_82546_(entityCenter).m_82541_();
        Vec3 newVelocity = bounceDirection.m_82490_(velocity.m_82553_() * (double)0.7f);
        if (this.bouncesLeft == 2) {
            newVelocity = newVelocity.m_82490_((double)1.15f);
        }
        newVelocity = newVelocity.m_82520_((this.f_19796_.m_188500_() - 0.5) * 0.1, (this.f_19796_.m_188500_() - 0.5) * 0.1, (this.f_19796_.m_188500_() - 0.5) * 0.1);
        this.m_20256_(newVelocity);
        this.m_146884_(hitPos.m_82549_(bounceDirection.m_82490_(0.3)));
    }

    private boolean canBounce() {
        double currentSpeed = this.m_20184_().m_82553_();
        return currentSpeed > (double)0.01f;
    }

    private void spawnBounceParticles(Vec3 position) {
        if (!this.m_9236_().f_46443_) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            for (int i = 0; i < 8; ++i) {
                double velocityX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double velocityY = this.f_19796_.m_188500_() * 0.5;
                double velocityZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, position.f_82479_, position.f_82480_, position.f_82481_, 1, velocityX, velocityY, velocityZ, 0.1);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, position.f_82479_, position.f_82480_, position.f_82481_, 1, velocityX, velocityY, velocityZ, 0.05);
            }
        }
    }

    private void spawnDeathParticles(Vec3 position) {
        if (!this.m_9236_().f_46443_) {
            double velocityZ;
            double velocityY;
            double velocityX;
            int i;
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            for (i = 0; i < 5; ++i) {
                velocityX = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                velocityY = this.f_19796_.m_188500_() * 0.4 + 0.1;
                velocityZ = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, position.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 0.2, position.f_82480_ + (this.f_19796_.m_188500_() - 0.5) * 0.15, position.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 0.2, 1, velocityX, velocityY, velocityZ, 0.02);
            }
            for (i = 0; i < 3; ++i) {
                velocityX = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                velocityY = this.f_19796_.m_188500_() * 0.3 + 0.05;
                velocityZ = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, position.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 0.3, position.f_82480_ + (this.f_19796_.m_188500_() - 0.5) * 0.2, position.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 0.3, 1, velocityX, velocityY, velocityZ, 0.01);
            }
            this.m_9236_().m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, SoundEvents.f_11937_, SoundSource.NEUTRAL, 0.2f, 2.0f + (this.f_19796_.m_188501_() - 0.5f) * 0.3f);
        }
    }

    private void sendBounceTrailUpdate() {
        LivingEntity livingEntity = this.shooter;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            Gun.Projectile projectileProps = this.getProjectile();
            ProjectileEntity[] bounceArray = new ProjectileEntity[]{this};
            ParticleOptions data = GunEnchantmentHelper.getParticle(player.m_21205_());
            S2CMessageBulletTrail messageBulletTrail = new S2CMessageBulletTrail(bounceArray, projectileProps, player.m_19879_(), data, true);
            double radius = (Double)Config.COMMON.network.projectileTrackingRange.get();
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)radius), (IMessage)messageBulletTrail);
        }
    }

    @Override
    protected void onExpired() {
        this.spawnDeathParticles(this.m_20182_());
    }

    @Override
    public float getDamage() {
        return super.getDamage() * this.currentDamageMultiplier;
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
    }

    @Override
    public void onHit(HitResult result, Vec3 startVec, Vec3 endVec) {
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("BouncesLeft", this.bouncesLeft);
        compound.m_128350_("CurrentDamageMultiplier", this.currentDamageMultiplier);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.bouncesLeft = compound.m_128451_("BouncesLeft");
        this.currentDamageMultiplier = compound.m_128457_("CurrentDamageMultiplier");
    }

    @Override
    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(this.bouncesLeft);
        buffer.writeFloat(this.currentDamageMultiplier);
    }

    @Override
    public void readSpawnData(FriendlyByteBuf buffer) {
        super.readSpawnData(buffer);
        this.bouncesLeft = buffer.readInt();
        this.currentDamageMultiplier = buffer.readFloat();
    }
}

