/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import java.util.Comparator;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.item.GunItem;

public class ShulkshotProjectileEntity
extends ProjectileEntity {
    private static final int DEFAULT_HOMING_DELAY = 10;
    private static final double INITIAL_SPEED = 1.5;
    private static final double MAX_SPEED = 2.5;
    private static final double ACCELERATION = 0.05;
    private static final double TURN_SPEED = 0.08;
    private static final double PREDICTION_FACTOR = 0.7;
    private Mob target;
    private Vec3 lastTargetPos;
    private Vec3 targetVelocity = Vec3.f_82478_;
    private int homingDelay = 10;
    private Vec3 currentDirection;

    public ShulkshotProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public ShulkshotProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
        Vec3 shooterDirection = shooter.m_20154_();
        if (modifiedGun.getGeneral().getProjectileAmount() > 1) {
            float spread = modifiedGun.getGeneral().getSpread();
            float yawSpread = (this.f_19796_.m_188501_() - 0.5f) * spread;
            float pitchSpread = (this.f_19796_.m_188501_() - 0.5f) * spread;
            shooterDirection = this.applySpread(shooterDirection, yawSpread, pitchSpread);
        }
        this.currentDirection = shooterDirection.m_82541_();
        double offsetDistance = 1.5;
        this.m_6034_(shooter.m_20185_() + shooterDirection.f_82479_ * offsetDistance, shooter.m_20188_() - 0.1 + shooterDirection.f_82480_ * offsetDistance, shooter.m_20189_() + shooterDirection.f_82481_ * offsetDistance);
        this.m_20256_(shooterDirection.m_82490_(1.5));
    }

    private Vec3 applySpread(Vec3 direction, float yawSpread, float pitchSpread) {
        double currentYaw = Math.atan2(-direction.f_82479_, direction.f_82481_);
        double currentPitch = Math.asin(-direction.f_82480_);
        double newYaw = currentYaw + Math.toRadians(yawSpread);
        double newPitch = currentPitch + Math.toRadians(pitchSpread);
        double cosYaw = Math.cos(newYaw);
        double sinYaw = Math.sin(newYaw);
        double cosPitch = Math.cos(newPitch);
        double sinPitch = Math.sin(newPitch);
        return new Vec3(-sinYaw * cosPitch, -sinPitch, cosYaw * cosPitch);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.homingDelay > 0) {
                --this.homingDelay;
            } else {
                if (this.target == null || !this.target.m_6084_()) {
                    this.findNewTarget();
                }
                if (this.target != null) {
                    this.updateTargetVelocity();
                    this.updateHomingMovement();
                }
            }
        }
        if (this.m_9236_().f_46443_) {
            this.addTrailingParticles();
        }
        this.updateHeading();
    }

    private void updateTargetVelocity() {
        Vec3 currentTargetPos = new Vec3(this.target.m_20185_(), this.target.m_20186_() + (double)this.target.m_20206_() * 0.5, this.target.m_20189_());
        if (this.lastTargetPos != null) {
            this.targetVelocity = currentTargetPos.m_82546_(this.lastTargetPos);
        }
        this.lastTargetPos = currentTargetPos;
    }

    private Vec3 getPredictedTargetPosition() {
        if (this.target == null) {
            return null;
        }
        Vec3 projectilePos = this.m_20182_();
        Vec3 targetPos = new Vec3(this.target.m_20185_(), this.target.m_20186_() + (double)this.target.m_20206_() * 0.5, this.target.m_20189_());
        double distance = projectilePos.m_82554_(targetPos);
        double currentSpeed = this.m_20184_().m_82553_();
        double timeToIntercept = distance / currentSpeed;
        Vec3 predictedPos = targetPos.m_82549_(this.targetVelocity.m_82490_(timeToIntercept * 0.7));
        double leadMultiplier = Math.min(distance / 10.0, 2.0);
        return predictedPos.m_82549_(this.targetVelocity.m_82490_(leadMultiplier));
    }

    private void updateHomingMovement() {
        Vec3 currentVelocity = this.m_20184_();
        double currentSpeed = currentVelocity.m_82553_();
        Vec3 predictedTargetPos = this.getPredictedTargetPosition();
        if (predictedTargetPos == null) {
            return;
        }
        Vec3 toTarget = predictedTargetPos.m_82546_(this.m_20182_()).m_82541_();
        Vec3 currentDirectionNorm = currentVelocity.m_82541_();
        this.currentDirection = currentDirectionNorm.m_82549_(toTarget.m_82490_(0.08)).m_82541_();
        double targetSpeed = Math.min(2.5, currentSpeed + 0.05);
        double newSpeed = currentSpeed + (targetSpeed > currentSpeed ? 0.05 : -0.05);
        newSpeed = Mth.m_14008_((double)newSpeed, (double)0.0, (double)targetSpeed);
        this.m_20256_(this.currentDirection.m_82490_(newSpeed));
    }

    private void addTrailingParticles() {
        for (int i = 0; i < 2; ++i) {
            double offset = 0.1;
            Vec3 particlePos = this.m_20182_().m_82520_(this.f_19796_.m_188583_() * offset, this.f_19796_.m_188583_() * offset, this.f_19796_.m_188583_() * offset);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
        }
        Vec3 currentVel = this.m_20184_();
        if (this.target != null && currentVel.m_82553_() > 0.5) {
            Vec3 toTarget = this.target.m_20182_().m_82546_(this.m_20182_()).m_82541_();
            double turnAngle = Math.acos(currentVel.m_82541_().m_82526_(toTarget));
            if (turnAngle > 0.7853981633974483) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void findNewTarget() {
        double searchRadius = 16.0;
        List potentialTargets = this.m_9236_().m_6443_(Mob.class, this.m_20191_().m_82400_(searchRadius), entity -> entity.m_6084_() && !entity.m_5833_() && entity != this.getShooter() && this.hasLineOfSight((Entity)entity));
        if (!potentialTargets.isEmpty()) {
            potentialTargets.sort(Comparator.comparingDouble(entity -> entity.m_20275_(this.m_20185_(), this.m_20186_(), this.m_20189_())));
            this.target = (Mob)potentialTargets.get(0);
            this.lastTargetPos = this.target.m_20182_();
        }
    }

    private boolean hasLineOfSight(Entity target) {
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_());
        Vec3 vec31 = new Vec3(target.m_20185_(), target.m_20186_() + (double)target.m_20192_(), target.m_20189_());
        return this.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    @Override
    public void updateHeading() {
        Vec3 motion = this.m_20184_();
        double horizontalDistance = motion.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.29577951308232));
        this.m_146926_((float)(Mth.m_14136_((double)motion.f_82480_, (double)horizontalDistance) * 57.29577951308232));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }
}

