/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.throwable;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.entity.monster.SignalBeaconEntity;
import top.ribs.scguns.entity.throwable.ThrowableGrenadeEntity;
import top.ribs.scguns.entity.throwable.ThrowableItemEntity;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModItems;

public class ThrowableBeaconGrenadeEntity
extends ThrowableGrenadeEntity {
    public float rotation;
    public float prevRotation;

    public ThrowableBeaconGrenadeEntity(EntityType<? extends ThrowableGrenadeEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public ThrowableBeaconGrenadeEntity(Level world, LivingEntity entity, int timeLeft) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.THROWABLE_BEACON_GRENADE.get()), world, entity);
        this.setShouldBounce(true);
        this.setGravityVelocity(0.025f);
        this.setItem(new ItemStack((ItemLike)ModItems.BEACON_GRENADE.get()));
        this.setMaxLife(timeLeft);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevRotation = this.rotation;
    }

    @Override
    public void particleTick() {
    }

    @Override
    protected void m_6532_(HitResult result) {
        switch (result.m_6662_()) {
            case BLOCK: {
                BlockHitResult blockResult = (BlockHitResult)result;
                if (this.shouldBounce) {
                    BlockState state = this.m_9236_().m_8055_(blockResult.m_82425_());
                    double speed = this.m_20184_().m_82553_();
                    if (speed > 0.1) {
                        this.m_9236_().m_6263_(null, blockResult.m_82450_().f_82479_, blockResult.m_82450_().f_82480_, blockResult.m_82450_().f_82481_, state.m_60734_().getSoundType(state, (LevelReader)this.m_9236_(), blockResult.m_82425_(), (Entity)this).m_56776_(), SoundSource.AMBIENT, 1.0f, 1.0f);
                    }
                    this.bounce(blockResult.m_82434_());
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
                this.onDeath();
                break;
            }
            case ENTITY: {
                EntityHitResult entityResult = (EntityHitResult)result;
                Entity entity = entityResult.m_82443_();
                if (this.shouldBounce) {
                    double speed = this.m_20184_().m_82553_();
                    if (speed > 0.1) {
                        entity.m_6469_(entity.m_269291_().m_269390_((Entity)this, this.m_19749_()), 1.0f);
                    }
                    this.bounce(Direction.m_122366_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7098_(), (double)this.m_20184_().m_7094_()).m_122424_());
                    this.m_20256_(this.m_20184_().m_82542_(0.25, 1.0, 0.25));
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
                this.onDeath();
                break;
            }
        }
    }

    @Override
    public void onDeath() {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11736_, SoundSource.BLOCKS, 2.0f, 1.0f);
            Vec3 pos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            BlockPos blockPos = new BlockPos((int)Math.floor(pos.f_82479_), (int)Math.floor(pos.f_82480_), (int)Math.floor(pos.f_82481_));
            while (!this.m_9236_().m_8055_(blockPos).m_60795_() && pos.f_82480_ < this.m_20186_() + 1.0) {
                pos = pos.m_82520_(0.0, 0.1, 0.0);
                blockPos = new BlockPos((int)Math.floor(pos.f_82479_), (int)Math.floor(pos.f_82480_), (int)Math.floor(pos.f_82481_));
            }
            SignalBeaconEntity beacon = new SignalBeaconEntity((EntityType<? extends Mob>)((EntityType)ModEntities.SIGNAL_BEACON.get()), this.m_9236_());
            beacon.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, this.f_19796_.m_188501_() * 360.0f, 0.0f);
            boolean bl = this.m_9236_().m_7967_((Entity)beacon);
        }
    }
}

