/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.throwable;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.common.SulfurGasCloud;
import top.ribs.scguns.entity.throwable.ThrowableGrenadeEntity;
import top.ribs.scguns.entity.throwable.ThrowableItemEntity;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModItems;

public class ThrowableGasGrenadeEntity
extends ThrowableGrenadeEntity {
    private final float explosionRadius;
    private int remainingTicks;
    private final int delayTicks;

    public ThrowableGasGrenadeEntity(EntityType<? extends ThrowableGrenadeEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.explosionRadius = 6.0f;
        this.remainingTicks = 800;
        this.delayTicks = 30;
    }

    public ThrowableGasGrenadeEntity(Level world, LivingEntity entity, int timeLeft, float radius) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.THROWABLE_GAS_GRENADE.get()), world, entity);
        this.setShouldBounce(true);
        this.setItem(new ItemStack((ItemLike)ModItems.GAS_GRENADE.get()));
        this.setMaxLife(60);
        this.explosionRadius = radius;
        this.remainingTicks = 800;
        this.delayTicks = 20;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.remainingTicks > 0) {
            if (this.remainingTicks <= 800 - this.delayTicks) {
                this.emitGasCloudParticles();
                this.applyGasEffects();
                if (!this.m_9236_().f_46443_) {
                    Vec3 center = this.m_20182_();
                    SulfurGasCloud.checkAndHandleFireExplosion(this.m_9236_(), center, this.explosionRadius);
                }
            }
            --this.remainingTicks;
        } else {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void emitGasCloudParticles() {
        Vec3 center = this.m_20182_();
        float intensity = 0.8f;
        if (!this.m_9236_().f_46443_) {
            SulfurGasCloud.spawnEnhancedGasCloud(this.m_9236_(), center, this.explosionRadius, intensity, this.f_19796_);
        }
    }

    private void applyGasEffects() {
        if (!this.m_9236_().f_46443_) {
            Vec3 center = this.m_20182_();
            SulfurGasCloud.applyGasEffects(this.m_9236_(), center, (double)this.explosionRadius, 500, 2);
        }
    }

    @Override
    public void onDeath() {
        double y = this.m_20186_() + (double)this.m_6095_().m_20680_().f_20378_ * 0.5;
        this.m_9236_().m_6263_(null, this.m_20185_(), y, this.m_20189_(), SoundEvents.f_11789_, SoundSource.BLOCKS, 2.0f, 1.0f);
    }
}

