/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.throwable;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public abstract class ThrowableItemEntity
extends ThrowableProjectile
implements IEntityAdditionalSpawnData {
    private ItemStack item = ItemStack.f_41583_;
    boolean shouldBounce;
    private float gravityVelocity = 0.03f;
    private int maxLife = 200;

    public ThrowableItemEntity(EntityType<? extends ThrowableItemEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public ThrowableItemEntity(EntityType<? extends ThrowableItemEntity> entityType, Level world, LivingEntity player) {
        super(entityType, player, world);
    }

    public ThrowableItemEntity(EntityType<? extends ThrowableItemEntity> entityType, Level world, double x, double y, double z) {
        super(entityType, x, y, z, world);
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public ItemStack getItem() {
        return this.item;
    }

    protected void setShouldBounce(boolean shouldBounce) {
        this.shouldBounce = shouldBounce;
    }

    protected void setGravityVelocity(float gravity) {
        this.gravityVelocity = gravity;
    }

    protected float m_7139_() {
        return this.gravityVelocity;
    }

    public void setMaxLife(int maxLife) {
        this.maxLife = maxLife;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.shouldBounce && this.f_19797_ >= this.maxLife) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.onDeath();
        }
    }

    public void onDeath() {
    }

    protected void m_6532_(HitResult result) {
        switch (result.m_6662_()) {
            case BLOCK: {
                BlockHitResult blockResult = (BlockHitResult)result;
                if (this.shouldBounce) {
                    BlockPos resultPos = blockResult.m_82425_();
                    BlockState state = this.m_9236_().m_8055_(resultPos);
                    SoundEvent event = state.m_60734_().getSoundType(state, (LevelReader)this.m_9236_(), resultPos, (Entity)this).m_56776_();
                    double speed = this.m_20184_().m_82553_();
                    if (speed > 0.1) {
                        this.m_9236_().m_6263_(null, result.m_82450_().f_82479_, result.m_82450_().f_82480_, result.m_82450_().f_82481_, event, SoundSource.AMBIENT, 1.0f, 1.0f);
                    }
                    this.bounce(blockResult.m_82434_());
                    break;
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
                this.onDeath();
                break;
            }
            case ENTITY: {
                EntityHitResult entityResult = (EntityHitResult)result;
                Entity entity = entityResult.m_82443_();
                if (this.shouldBounce) {
                    double speed = this.m_20184_().m_82553_();
                    if (speed > 0.1) {
                        entity.m_6469_(entity.m_269291_().m_269390_((Entity)this, this.m_19749_()), 1.0f);
                    }
                    this.bounce(Direction.m_122366_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7098_(), (double)this.m_20184_().m_7094_()).m_122424_());
                    this.m_20256_(this.m_20184_().m_82542_(0.25, 1.0, 0.25));
                    break;
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
                this.onDeath();
                break;
            }
        }
    }

    void bounce(Direction direction) {
        switch (direction.m_122434_()) {
            case X: {
                this.m_20256_(this.m_20184_().m_82542_(-0.5, 0.75, 0.75));
                break;
            }
            case Y: {
                this.m_20256_(this.m_20184_().m_82542_(0.75, -0.25, 0.75));
                if (!(this.m_20184_().m_7098_() < (double)this.m_7139_())) break;
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
                break;
            }
            case Z: {
                this.m_20256_(this.m_20184_().m_82542_(0.75, 0.75, -0.5));
            }
        }
    }

    public boolean m_20068_() {
        return false;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.shouldBounce);
        buffer.writeFloat(this.gravityVelocity);
        buffer.m_130055_(this.item);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.shouldBounce = buffer.readBoolean();
        this.gravityVelocity = buffer.readFloat();
        this.item = buffer.m_130267_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

