/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.event;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.init.ModBlocks;
import top.ribs.scguns.init.ModItems;

@Mod.EventBusSubscriber(modid="scguns")
public class BatPoopEvent {
    private static final String WELL_FED_TAG = "scguns:well_fed";
    private static final String WELL_FED_TIMER_TAG = "scguns:well_fed_timer";
    private static final String LAST_POOP_TIME_TAG = "scguns:last_poop_time";
    private static final int POOP_COOLDOWN = 800;
    private static final float BASE_POOP_CHANCE = 7.5E-4f;
    private static final float WELL_FED_MULTIPLIER = 5.0f;
    private static final int WELL_FED_DURATION = 2000;
    private static final int MAX_CHECK_DEPTH = 48;

    @SubscribeEvent
    public static void onBatTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Bat)) {
            return;
        }
        Bat bat = (Bat)livingEntity;
        if (bat.m_9236_().m_5776_()) {
            return;
        }
        BatPoopEvent.updateWellFedStatus(bat);
        if (!bat.m_27452_()) {
            return;
        }
        int lastPoopTime = bat.getPersistentData().m_128451_(LAST_POOP_TIME_TAG);
        if (bat.f_19797_ - lastPoopTime < 800) {
            return;
        }
        float poopChance = 7.5E-4f;
        if (BatPoopEvent.isWellFed(bat)) {
            poopChance *= 5.0f;
        }
        if (bat.m_217043_().m_188501_() < poopChance && !BatPoopEvent.hasFullGuanoLayerBelow(bat)) {
            BatPoopEvent.dropGuano(bat);
            bat.getPersistentData().m_128405_(LAST_POOP_TIME_TAG, bat.f_19797_);
        }
    }

    private static boolean hasFullGuanoLayerBelow(Bat bat) {
        BlockPos startPos = bat.m_20183_().m_7495_();
        for (int i = 0; i < 48; ++i) {
            BlockPos checkPos = startPos.m_6625_(i);
            BlockState state = bat.m_9236_().m_8055_(checkPos);
            if (state.m_60795_()) continue;
            if (state.m_60713_((Block)ModBlocks.BAT_GUANO_LAYER.get())) {
                int layers = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
                return layers >= 8;
            }
            return false;
        }
        return false;
    }

    private static void dropGuano(Bat bat) {
        ItemStack guanoStack = new ItemStack((ItemLike)ModItems.BAT_GUANO.get());
        ItemEntity guanoEntity = new ItemEntity(bat.m_9236_(), bat.m_20185_(), bat.m_20186_() - 0.3, bat.m_20189_(), guanoStack);
        guanoEntity.m_20334_((bat.m_217043_().m_188500_() - 0.5) * 0.02, -0.1, (bat.m_217043_().m_188500_() - 0.5) * 0.02);
        bat.m_9236_().m_7967_((Entity)guanoEntity);
    }

    public static void setWellFed(Bat bat) {
        bat.getPersistentData().m_128379_(WELL_FED_TAG, true);
        bat.getPersistentData().m_128405_(WELL_FED_TIMER_TAG, 2000);
    }

    public static boolean isWellFed(Bat bat) {
        return bat.getPersistentData().m_128471_(WELL_FED_TAG);
    }

    private static void updateWellFedStatus(Bat bat) {
        if (!BatPoopEvent.isWellFed(bat)) {
            return;
        }
        int timer = bat.getPersistentData().m_128451_(WELL_FED_TIMER_TAG);
        if (--timer <= 0) {
            bat.getPersistentData().m_128379_(WELL_FED_TAG, false);
            bat.getPersistentData().m_128473_(WELL_FED_TIMER_TAG);
        } else {
            bat.getPersistentData().m_128405_(WELL_FED_TIMER_TAG, timer);
        }
    }
}

