/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.event;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.ribs.scguns.item.ammo_boxes.DishesPouch;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DishesEventHandler {
    @SubscribeEvent
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        ItemStack resultStack = event.getResultStack();
        if (DishesEventHandler.isDishItem(resultStack) && DishesEventHandler.addDishToPouch(player, resultStack)) {
            event.setResultStack(ItemStack.f_41583_);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityItemPickup(EntityItemPickupEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = event.getEntity();
        ItemStack pickedItem = event.getItem().m_32055_();
        if (DishesEventHandler.isDishItem(pickedItem) && DishesEventHandler.addDishToPouch(player, pickedItem)) {
            event.setCanceled(true);
            event.getItem().m_32045_(ItemStack.f_41583_);
        }
    }

    private static boolean isDishItem(ItemStack stack) {
        return stack.m_150930_(Items.f_42399_) || stack.m_150930_(Items.f_42590_) || stack.m_41720_().m_41469_() == Items.f_42399_ || stack.m_41720_().m_41469_() == Items.f_42590_;
    }

    private static boolean addDishToPouch(Player player, ItemStack dishStack) {
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            int insertedItems;
            if (!(itemStack.m_41720_() instanceof DishesPouch) || (insertedItems = DishesPouch.add(itemStack, dishStack)) <= 0) continue;
            dishStack.m_41774_(insertedItems);
            return true;
        }
        AtomicBoolean result = new AtomicBoolean(false);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            IItemHandlerModifiable curios = handler.getEquippedCurios();
            for (int i = 0; i < curios.getSlots(); ++i) {
                int insertedItems;
                ItemStack stack = curios.getStackInSlot(i);
                if (!(stack.m_41720_() instanceof DishesPouch) || (insertedItems = DishesPouch.add(stack, dishStack)) <= 0) continue;
                dishStack.m_41774_(insertedItems);
                result.set(true);
                break;
            }
        });
        return result.get();
    }
}

