/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.event;

import com.mrcrayfish.framework.network.message.IMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import top.ribs.scguns.Config;
import top.ribs.scguns.ScorchedGuns;
import top.ribs.scguns.cache.HotBarrelCache;
import top.ribs.scguns.client.handler.MeleeAttackHandler;
import top.ribs.scguns.common.BeamHandlerCommon;
import top.ribs.scguns.common.FireMode;
import top.ribs.scguns.common.GripType;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.GunModifiers;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.common.network.ServerPlayHandler;
import top.ribs.scguns.event.GunFireEvent;
import top.ribs.scguns.event.TemporaryLightManager;
import top.ribs.scguns.init.ModEnchantments;
import top.ribs.scguns.init.ModSounds;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.interfaces.IAirGun;
import top.ribs.scguns.interfaces.IEnergyGun;
import top.ribs.scguns.interfaces.IGunModifier;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.NonUnderwaterGunItem;
import top.ribs.scguns.item.UnderwaterGunItem;
import top.ribs.scguns.item.ammo_boxes.EmptyCasingPouchItem;
import top.ribs.scguns.item.animated.AnimatedDualWieldGunItem;
import top.ribs.scguns.item.animated.AnimatedGunItem;
import top.ribs.scguns.item.animated.AnimatedUnderWaterGunItem;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.item.animated.NonUnderwaterAnimatedGunItem;
import top.ribs.scguns.item.attachment.IAttachment;
import top.ribs.scguns.item.attachment.impl.Attachment;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.C2SMessageReload;
import top.ribs.scguns.network.message.S2CMessageHotBarrelSync;
import top.ribs.scguns.util.AirSourceHelper;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GunEventBus {
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server;
        if (event.phase == TickEvent.Phase.END && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            for (ServerLevel world : server.m_129785_()) {
                BeamHandlerCommon.BeamMiningManager.tickMiningProgress((Level)world);
            }
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        MinecraftServer server = event.getServer();
        for (ServerLevel world : server.m_129785_()) {
            TemporaryLightManager.emergencyCleanup((Level)world);
        }
    }

    @SubscribeEvent
    public static void preShoot(GunFireEvent.Pre event) {
        Item e2;
        Item item;
        Player player = event.getEntity();
        Level level = event.getEntity().m_9236_();
        ItemStack heldItem = player.m_21205_();
        CompoundTag tag = heldItem.m_41783_();
        if (MeleeAttackHandler.isBanzaiActive()) {
            MeleeAttackHandler.stopBanzai();
        }
        if (level.m_5776_() && (item = heldItem.m_41720_()) instanceof AnimatedGunItem) {
            AnimatedGunItem animatedGunItem = (AnimatedGunItem)item;
            try {
                long id = GeoItem.getId((ItemStack)heldItem);
                AnimationController animationController = (AnimationController)animatedGunItem.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
                if (animationController != null) {
                    if (heldItem.m_41763_() && heldItem.m_41773_() >= heldItem.m_41776_() - 1) {
                        player.m_5661_((Component)Component.m_237115_((String)"message.scguns.gun_broken").m_130940_(ChatFormatting.RED), true);
                        event.setCanceled(true);
                        return;
                    }
                    if (animatedGunItem.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "reload_stop")) {
                        event.setCanceled(true);
                        return;
                    }
                    if (tag != null && tag.m_128471_("scguns:IsReloading")) {
                        if (animatedGunItem.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "reload_loop") || animatedGunItem.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "reload_start")) {
                            tag.m_128379_("scguns:ReloadComplete", true);
                            animationController.tryTriggerAnimation("reload_stop");
                            tag.m_128473_("scguns:IsReloading");
                            ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageReload(false));
                        }
                        event.setCanceled(true);
                        return;
                    }
                }
            }
            catch (Exception e2) {
                ScorchedGuns.LOGGER.error("Error in preShoot animation handling: " + e2.getMessage());
            }
        }
        if ((e2 = heldItem.m_41720_()) instanceof GunItem) {
            GunItem gunItem = (GunItem)e2;
            Gun gun = gunItem.getModifiedGun(heldItem);
            GripType gripType = gun.determineGripType(heldItem);
            if (player.m_6117_() && player.m_21206_().m_41720_() == Items.f_42740_ && (gripType == GripType.ONE_HANDED || gripType == GripType.ONE_HANDED_2)) {
                event.setCanceled(true);
                return;
            }
            if (heldItem.m_41783_() != null && tag != null && tag.m_128441_("DrawnTick") && tag.m_128451_("DrawnTick") < 15) {
                event.setCanceled(true);
                return;
            }
            int energyUse = gun.getGeneral().getEnergyUse();
            if (!player.m_7500_()) {
                float airCostPerShot;
                if (heldItem.m_41720_() instanceof IEnergyGun) {
                    IEnergyStorage energyStorage = (IEnergyStorage)heldItem.getCapability(ForgeCapabilities.ENERGY).orElseThrow(IllegalStateException::new);
                    if (energyStorage.getEnergyStored() >= energyUse) {
                        energyStorage.extractEnergy(energyUse, false);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"message.energy_gun.no_energy").m_130940_(ChatFormatting.RED), true);
                        event.setCanceled(true);
                        return;
                    }
                }
                if (heldItem.m_41720_() instanceof IAirGun && !AirSourceHelper.consumeAir(player, airCostPerShot = GunEventBus.calculateAirCostPerShot(gun))) {
                    AirSourceHelper.AirSource airSource = AirSourceHelper.getBestAirSource(player);
                    if (airSource.getType() == AirSourceHelper.AirSource.Type.NONE) {
                        if (ScorchedGuns.createLoaded) {
                            player.m_5661_((Component)Component.m_237115_((String)"message.airgun.no_air_source").m_130940_(ChatFormatting.RED), true);
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"message.airgun.requires_canister").m_130940_(ChatFormatting.RED), true);
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"message.airgun.no_air").m_130940_(ChatFormatting.RED), true);
                    }
                    event.setCanceled(true);
                    return;
                }
            }
            if ((heldItem.m_41720_() instanceof NonUnderwaterGunItem || heldItem.m_41720_() instanceof NonUnderwaterAnimatedGunItem) && player.m_5842_()) {
                event.setCanceled(true);
                return;
            }
            if (heldItem.m_41763_() && tag != null) {
                if (heldItem.m_41773_() == heldItem.m_41776_() - 1) {
                    level.m_5594_(null, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.m_5661_((Component)Component.m_237115_((String)"message.scguns.gun_broken").m_130940_(ChatFormatting.RED), true);
                    event.getEntity().m_36335_().m_41524_(event.getStack().m_41720_(), gun.getGeneral().getRate());
                    event.setCanceled(true);
                    return;
                }
                int maxDamage = heldItem.m_41776_();
                int currentDamage = heldItem.m_41773_();
                int gunRustLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.GUN_RUST.get()), (ItemStack)heldItem);
                double jamChance = 0.0;
                if (gunRustLevel > 0) {
                    jamChance = 0.1 + (double)gunRustLevel * 0.05;
                }
                if ((double)currentDamage >= (double)maxDamage * 0.8) {
                    jamChance += 0.025;
                }
                if (jamChance > 0.0 && Math.random() < jamChance) {
                    event.getEntity().m_5496_((SoundEvent)ModSounds.ITEM_PISTOL_COCK.get(), 1.0f, 1.0f);
                    player.m_5661_((Component)Component.m_237115_((String)"message.scguns.gun_jammed").m_130940_(ChatFormatting.YELLOW), true);
                    int coolDown = gun.getGeneral().getRate() * 10;
                    if (coolDown > 30) {
                        coolDown = 30;
                    }
                    event.getEntity().m_36335_().m_41524_(event.getStack().m_41720_(), coolDown);
                    event.setCanceled(true);
                    return;
                }
                if (tag.m_128451_("AmmoCount") >= 1) {
                    GunEventBus.broken(heldItem, level, player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void postShoot(GunFireEvent.Post event) {
        Object gun;
        GunItem gunItem;
        Player player = event.getEntity();
        Level level = event.getEntity().m_9236_();
        ItemStack heldItem = player.m_21205_();
        CompoundTag tag = heldItem.m_41784_();
        Item item = heldItem.m_41720_();
        if (item instanceof AnimatedGunItem) {
            gunItem = (AnimatedGunItem)item;
            gun = gunItem.getModifiedGun(heldItem);
            if (((Gun)gun).getGeneral().isRevolver()) {
                ((AnimatedGunItem)heldItem.m_41720_()).getRotationHandler().incrementCylinderRotation(30.0f);
            }
            if (heldItem.m_41720_().toString().contains("cogloader")) {
                ((AnimatedGunItem)heldItem.m_41720_()).getRotationHandler().incrementMagazineRotation(15.0f);
            }
            if (heldItem.m_41720_().toString().contains("scrapper")) {
                float maxAmmo = Gun.getMaxAmmo(heldItem);
                float currentAmmo = Gun.getAmmoCount(heldItem);
                float slidePosition = Math.min((maxAmmo - currentAmmo) / maxAmmo, 1.0f);
                tag.m_128350_("MagazinePosition", slidePosition);
            }
            long id = GeoItem.getId((ItemStack)heldItem);
            AnimationController controller = (AnimationController)((AnimatedGunItem)gunItem).getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
            controller.forceAnimationReset();
            boolean isCarbine = ((AnimatedGunItem)gunItem).isInCarbineMode(heldItem);
            if (gunItem instanceof AnimatedDualWieldGunItem) {
                ServerPlayHandler.RatKingAndQueenModel.GunFireEventRatHandler.incrementShotCount();
                boolean useAlternate = ServerPlayHandler.RatKingAndQueenModel.GunFireEventRatHandler.shouldUseAlternateAnimation();
                if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue()) {
                    controller.tryTriggerAnimation(useAlternate ? "aim_shoot1" : "aim_shoot");
                } else {
                    controller.tryTriggerAnimation(useAlternate ? "shoot1" : "shoot");
                }
            } else if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue()) {
                controller.tryTriggerAnimation(isCarbine ? "carbine_aim_shoot" : "aim_shoot");
            } else {
                controller.tryTriggerAnimation(isCarbine ? "carbine_shoot" : "shoot");
            }
        }
        if ((gun = heldItem.m_41720_()) instanceof GunItem) {
            boolean mirror;
            gunItem = (GunItem)gun;
            gun = gunItem.getModifiedGun(heldItem);
            int hotBarrelLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.HOT_BARREL.get()), (ItemStack)heldItem);
            if (((Gun)gun).getGeneral().hasPlayerKnockBack()) {
                GunEventBus.applyGunKnockback(player, (Gun)gun);
            }
            if (hotBarrelLevel > 0) {
                int hotBarrelFillRate = ((Gun)gun).getGeneral().getHotBarrelRate();
                HotBarrelCache.increaseHotBarrel(player, heldItem, hotBarrelFillRate);
                if (!level.m_5776_() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    int newLevel = HotBarrelCache.getHotBarrelLevel(player, heldItem);
                    PacketHandler.getPlayChannel().sendToPlayer(() -> serverPlayer, (IMessage)new S2CMessageHotBarrelSync(newLevel, heldItem.m_41720_().m_5524_()));
                }
            }
            if (((Gun)gun).getGeneral().isEnableGunLight()) {
                Vec3 lookVec = player.m_20154_();
                BlockPos lightPos = player.m_20183_().m_7918_((int)(lookVec.f_82479_ * 2.0), 2, (int)(lookVec.f_82481_ * 2.0));
                boolean isBeamWeapon = ((Gun)gun).getGeneral().getFireMode() == FireMode.BEAM;
                TemporaryLightManager.addTemporaryLight(level, lightPos, isBeamWeapon);
            }
            int shotCount = ServerPlayHandler.RatKingAndQueenModel.GunFireEventRatHandler.getShotCount();
            boolean bl = mirror = heldItem.m_41720_() instanceof AnimatedDualWieldGunItem && shotCount % 2 == 1;
            if (((Boolean)Config.COMMON.gameplay.spawnCasings.get()).booleanValue() && ((Gun)gun).getProjectile().ejectsCasing() && !((Gun)gun).getProjectile().ejectDuringReload() && (tag.m_128451_("AmmoCount") >= 1 || player.m_150110_().f_35937_)) {
                GunEventBus.ejectCasing(level, (LivingEntity)player, mirror);
            }
            if (heldItem.m_41763_() && (double)heldItem.m_41773_() >= (double)heldItem.m_41776_() / 1.5 && Math.random() < 0.15) {
                level.m_5594_(player, player.m_20183_(), (SoundEvent)ModSounds.COPPER_GUN_JAM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    private static void applyGunKnockback(Player player, Gun gun) {
        Vec3 lookVec = player.m_20154_();
        float baseStrength = gun.getGeneral().getPlayerKnockBackStrength();
        float totalKnockbackResistance = 0.0f;
        totalKnockbackResistance += (float)player.m_21133_(Attributes.f_22278_) * 0.5f;
        for (ItemStack armorPiece : player.m_6168_()) {
            ArmorItem armor;
            Item item = armorPiece.m_41720_();
            if (!(item instanceof ArmorItem) || !((armor = (ArmorItem)item).m_40401_() instanceof ArmorMaterial)) continue;
            ArmorMaterial material = armor.m_40401_();
            totalKnockbackResistance += material.m_6649_() * 0.25f;
        }
        float effectiveStrength = baseStrength * (1.0f - (totalKnockbackResistance = Math.min(0.75f, totalKnockbackResistance)));
        if (effectiveStrength > 0.0f) {
            double verticalBoost = lookVec.f_82480_ < -0.5 && !player.m_20096_() && player.m_20184_().f_82480_ > 0.0 ? (double)effectiveStrength * 1.25 : 0.1 * (double)effectiveStrength;
            player.m_20256_(player.m_20184_().m_82520_(-lookVec.f_82479_ * (double)effectiveStrength, verticalBoost, -lookVec.f_82481_ * (double)effectiveStrength));
            if (verticalBoost > 0.5) {
                player.f_19789_ = 0.0f;
            }
            if (player instanceof ServerPlayer) {
                ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem && EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.HOT_BARREL.get()), (ItemStack)heldItem) > 0) {
            int levelBefore = HotBarrelCache.getHotBarrelLevel(player, heldItem);
            if (levelBefore > 0) {
                // empty if block
            }
            HotBarrelCache.tickHotBarrel(player, heldItem);
        } else {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack itemStack = player.m_150109_().m_8020_(i);
                if (!(itemStack.m_41720_() instanceof GunItem) || EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.HOT_BARREL.get()), (ItemStack)itemStack) <= 0 || HotBarrelCache.getHotBarrelLevel(player, itemStack) <= 0) continue;
                HotBarrelCache.clearHotBarrel(player, itemStack);
            }
        }
        if (player.f_19797_ % 1200 == 0) {
            HotBarrelCache.cleanupOldEntries();
        }
    }

    private static float calculateAirCostPerShot(Gun gun) {
        return gun.getGeneral().getEnergyUse();
    }

    public static void broken(ItemStack stack, Level level, Player player) {
        int maxDamage = stack.m_41776_();
        int currentDamage = stack.m_41773_();
        if (currentDamage >= maxDamage - 2) {
            level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void damageGun(ItemStack stack, Level level, Player player) {
        if (!player.m_150110_().f_35937_ && ((Boolean)Config.COMMON.gameplay.enableGunDamage.get()).booleanValue() && stack.m_41763_()) {
            Item extraWearChance2;
            int maxDamage = stack.m_41776_();
            int currentDamage = stack.m_41773_();
            boolean isUnderwater = player.m_5842_();
            boolean isUnderwaterGun = stack.m_41720_() instanceof UnderwaterGunItem || stack.m_41720_() instanceof AnimatedUnderWaterGunItem;
            int damageAmount = 1;
            int waterProofLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.WATER_PROOF.get()), (ItemStack)stack);
            int acceleratorLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.ACCELERATOR.get()), (ItemStack)stack);
            if (isUnderwater) {
                if (isUnderwaterGun) {
                    if (waterProofLevel > 0 && Math.random() < 0.25) {
                        damageAmount = 0;
                    }
                } else if (waterProofLevel <= 0) {
                    damageAmount = 3;
                }
            }
            if (acceleratorLevel > 0 && damageAmount > 0) {
                float catastrophicChance = 0.07f * (float)acceleratorLevel;
                if (Math.random() < (double)catastrophicChance) {
                    damageAmount *= 8;
                } else {
                    float extraWearChance2 = 0.25f * (float)acceleratorLevel;
                    if (Math.random() < (double)extraWearChance2) {
                        damageAmount *= 2;
                    }
                }
            }
            if ((extraWearChance2 = stack.m_41720_()) instanceof GunItem) {
                IGunModifier[] iGunModifierArray;
                GunItem gunItem = (GunItem)extraWearChance2;
                ItemStack stockStack = Gun.getAttachment(IAttachment.Type.STOCK, stack);
                if (!stockStack.m_41619_() && (iGunModifierArray = stockStack.m_41720_()) instanceof IAttachment) {
                    IAttachment attachment = (IAttachment)iGunModifierArray;
                    for (IGunModifier modifier : ((Attachment)attachment.getProperties()).getModifiers()) {
                        if (modifier != GunModifiers.BUMP_STOCK_MODIFIER || damageAmount <= 0) continue;
                        if (!(Math.random() < 0.3)) break;
                        damageAmount *= 2;
                        break;
                    }
                }
            }
            if (currentDamage >= maxDamage - damageAmount) {
                if (currentDamage >= maxDamage - damageAmount - 1) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else {
                stack.m_41622_(damageAmount, (LivingEntity)player, null);
            }
        }
    }

    public static void damageAttachments(ItemStack stack, Level level, Player player) {
        if (!player.m_150110_().f_35937_ && ((Boolean)Config.COMMON.gameplay.enableAttachmentDamage.get()).booleanValue() && stack.m_41720_() instanceof GunItem) {
            ItemStack scopeStack = Gun.getAttachment(IAttachment.Type.SCOPE, stack);
            if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.SCOPE) && scopeStack.m_41763_()) {
                int maxDamage = scopeStack.m_41776_();
                int currentDamage = scopeStack.m_41773_();
                if (currentDamage == maxDamage - 1) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    Gun.removeAttachment(stack, "Scope");
                } else {
                    scopeStack.m_41622_(1, (LivingEntity)player, null);
                }
            }
            ItemStack barrelStack = Gun.getAttachment(IAttachment.Type.BARREL, stack);
            if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.BARREL) && barrelStack.m_41763_()) {
                int maxDamage = barrelStack.m_41776_();
                int currentDamage = barrelStack.m_41773_();
                if (currentDamage == maxDamage - 1) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    Gun.removeAttachment(stack, "Barrel");
                } else {
                    barrelStack.m_41622_(1, (LivingEntity)player, null);
                }
            }
            ItemStack stockStack = Gun.getAttachment(IAttachment.Type.STOCK, stack);
            if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.STOCK) && stockStack.m_41763_()) {
                int maxDamage = stockStack.m_41776_();
                int currentDamage = stockStack.m_41773_();
                if (currentDamage == maxDamage - 1) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    Gun.removeAttachment(stack, "Stock");
                } else {
                    stockStack.m_41622_(1, (LivingEntity)player, null);
                }
            }
            ItemStack magazineStack = Gun.getAttachment(IAttachment.Type.MAGAZINE, stack);
            if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.MAGAZINE) && magazineStack.m_41763_()) {
                int maxDamage = magazineStack.m_41776_();
                int currentDamage = magazineStack.m_41773_();
                if (currentDamage == maxDamage - 1) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    Gun.removeAttachment(stack, "Magazine");
                } else {
                    magazineStack.m_41622_(1, (LivingEntity)player, null);
                }
            }
            ItemStack underBarrelStack = Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack);
            if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.UNDER_BARREL) && underBarrelStack.m_41763_()) {
                int maxDamage = underBarrelStack.m_41776_();
                int currentDamage = underBarrelStack.m_41773_();
                if (currentDamage == maxDamage - 1) {
                    level.m_5594_(player, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    Gun.removeAttachment(stack, "Under_Barrel");
                } else {
                    underBarrelStack.m_41622_(1, (LivingEntity)player, null);
                }
            }
        }
    }

    public static void ejectCasing(Level level, LivingEntity livingEntity, boolean mirror) {
        ParticleType particleType;
        if (!level.m_5776_()) {
            return;
        }
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player playerEntity = (Player)livingEntity;
        ItemStack heldItem = playerEntity.m_21205_();
        Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
        Vec3 lookVec = playerEntity.m_20154_();
        Vec3 rightVec = new Vec3(-lookVec.f_82481_, 0.0, lookVec.f_82479_).m_82541_();
        Vec3 forwardVec = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_).m_82541_();
        double offsetX = (mirror ? -rightVec.f_82479_ : rightVec.f_82479_) * 0.5 + forwardVec.f_82479_ * 0.5;
        double offsetY = (double)playerEntity.m_20192_() - 0.4;
        double offsetZ = (mirror ? -rightVec.f_82481_ : rightVec.f_82481_) * 0.5 + forwardVec.f_82481_ * 0.5;
        Vec3 particlePos = playerEntity.m_20318_(1.0f).m_82520_(offsetX, offsetY, offsetZ);
        ResourceLocation particleLocation = gun.getProjectile().getCasingParticle();
        if (particleLocation != null && (particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(particleLocation)) instanceof SimpleParticleType) {
            SimpleParticleType simpleParticleType = (SimpleParticleType)particleType;
            level.m_7106_((ParticleOptions)simpleParticleType, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnCasingInWorld(Level level, Player player, ItemStack casingStack) {
        ItemEntity casingEntity = new ItemEntity(level, player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_(), casingStack);
        casingEntity.m_32010_(40);
        casingEntity.m_20334_(0.0, 0.2, 0.0);
        level.m_7967_((Entity)casingEntity);
    }

    public static boolean addCasingToPouch(Player player, ItemStack casingStack) {
        ItemStack casingCopy = casingStack.m_41777_();
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            int insertedItems;
            if (!(itemStack.m_41720_() instanceof EmptyCasingPouchItem) || (insertedItems = EmptyCasingPouchItem.add(itemStack, casingCopy)) <= 0) continue;
            return true;
        }
        if (GunEventBus.addCasingToExoSuitPouches(player, casingCopy)) {
            return true;
        }
        boolean[] result = new boolean[]{false};
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            IItemHandlerModifiable curios = handler.getEquippedCurios();
            for (int i = 0; i < curios.getSlots(); ++i) {
                int insertedItems;
                ItemStack stack = curios.getStackInSlot(i);
                if (!(stack.m_41720_() instanceof EmptyCasingPouchItem) || (insertedItems = EmptyCasingPouchItem.add(stack, casingCopy)) <= 0) continue;
                result[0] = true;
                return;
            }
        });
        return result[0];
    }

    private static boolean addCasingToExoSuitPouches(Player player, ItemStack casingStack) {
        ItemStack chestplate = GunEventBus.getEquippedChestplate(player);
        if (chestplate.m_41619_()) {
            return false;
        }
        ItemStack pouchUpgrade = GunEventBus.findPouchUpgrade(chestplate);
        if (pouchUpgrade.m_41619_()) {
            return false;
        }
        ExoSuitUpgrade upgrade = ExoSuitUpgradeManager.getUpgradeForItem(pouchUpgrade);
        if (upgrade == null) {
            return false;
        }
        String pouchId = GunEventBus.getPouchId(pouchUpgrade);
        ItemStackHandler pouchInventory = GunEventBus.getPouchInventory(chestplate, pouchId, upgrade.getDisplay().getStorageSize());
        for (int i = 0; i < pouchInventory.getSlots(); ++i) {
            int insertedItems;
            ItemStack stack = pouchInventory.getStackInSlot(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof EmptyCasingPouchItem) || (insertedItems = EmptyCasingPouchItem.add(stack, casingStack)) <= 0) continue;
            GunEventBus.savePouchInventory(chestplate, pouchId, pouchInventory);
            return true;
        }
        return false;
    }

    private static ItemStack getEquippedChestplate(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.CHESTPLATE) continue;
            return armorStack;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack findPouchUpgrade(ItemStack chestplate) {
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(chestplate, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("pouches")) continue;
            return upgradeItem;
        }
        return ItemStack.f_41583_;
    }

    private static String getPouchId(ItemStack pouchUpgrade) {
        return pouchUpgrade.m_41720_().toString();
    }

    private static ItemStackHandler getPouchInventory(ItemStack chestplate, String pouchId, int size) {
        CompoundTag pouchData = chestplate.m_41784_().m_128469_("PouchData");
        ItemStackHandler handler = new ItemStackHandler(size);
        if (pouchData.m_128441_(pouchId)) {
            handler.deserializeNBT(pouchData.m_128469_(pouchId));
        }
        return handler;
    }

    private static void savePouchInventory(ItemStack chestplate, String pouchId, ItemStackHandler handler) {
        CompoundTag pouchData = chestplate.m_41784_().m_128469_("PouchData");
        pouchData.m_128365_(pouchId, (Tag)handler.serializeNBT());
        chestplate.m_41784_().m_128365_("PouchData", (Tag)pouchData);
    }
}

