/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.event;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.config.RaidConfig;
import top.ribs.scguns.entity.player.GunTier;
import top.ribs.scguns.entity.player.PlayerGunProgression;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GunProgressionEventHandler {
    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        PlayerGunProgression progression;
        Player player = event.getEntity();
        ItemStack stack = event.getItem().m_32055_();
        if (!player.m_9236_().f_46443_ && (progression = PlayerGunProgression.get(player)).checkAndUpdateFromItem(stack)) {
            PlayerGunProgression.save(player, progression);
            GunProgressionEventHandler.sendTierUnlockedMessage(player, progression.getCurrentTier());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            Player oldPlayer = event.getOriginal();
            Player newPlayer = event.getEntity();
            oldPlayer.reviveCaps();
            PlayerGunProgression oldProgression = PlayerGunProgression.get(oldPlayer);
            PlayerGunProgression.save(newPlayer, oldProgression);
            oldPlayer.invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        PlayerGunProgression progression;
        Player player = event.getEntity();
        ItemStack stack = event.getCrafting();
        if (!player.m_9236_().f_46443_ && (progression = PlayerGunProgression.get(player)).checkAndUpdateFromItem(stack)) {
            PlayerGunProgression.save(player, progression);
            GunProgressionEventHandler.sendTierUnlockedMessage(player, progression.getCurrentTier());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!player.m_9236_().f_46443_) {
            PlayerGunProgression progression = PlayerGunProgression.get(player);
            boolean updated = false;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!progression.checkAndUpdateFromItem(stack)) continue;
                updated = true;
            }
            if (updated) {
                PlayerGunProgression.save(player, progression);
            }
        }
    }

    public static void sendTierUnlockedMessage(Player player, GunTier tier) {
        if (tier == null || tier.getLevel() == 0) {
            return;
        }
        MutableComponent tierName = Component.m_237115_((String)("gun_tier.scguns." + tier.getId())).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
        MutableComponent message = Component.m_237110_((String)"progression.scguns.tier_unlocked", (Object[])new Object[]{tierName}).m_130940_(ChatFormatting.YELLOW);
        player.m_213846_((Component)message);
        List<GunTier> availableTiers = tier.getAvailableMobTiers();
        if (!availableTiers.isEmpty()) {
            MutableComponent mobMessage = Component.m_237115_((String)"progression.scguns.enemies_can_spawn").m_130940_(ChatFormatting.GRAY);
            for (int i = 0; i < availableTiers.size(); ++i) {
                GunTier mobTier = availableTiers.get(i);
                MutableComponent tierComponent = Component.m_237115_((String)("gun_tier.scguns." + mobTier.getId())).m_130940_(ChatFormatting.RED);
                mobMessage = mobMessage.m_6881_().m_7220_((Component)tierComponent);
                if (i >= availableTiers.size() - 1) continue;
                mobMessage = mobMessage.m_6881_().m_7220_((Component)Component.m_237113_((String)", ").m_130940_(ChatFormatting.GRAY));
            }
            player.m_213846_((Component)mobMessage);
        }
        GunProgressionEventHandler.sendRaidUnlockedMessage(player, tier);
    }

    private static void sendRaidUnlockedMessage(Player player, GunTier tier) {
        int raidLevel = tier.getRaidLevel();
        if (raidLevel <= 0) {
            return;
        }
        List<RaidConfig.RaidData> availableRaids = RaidConfig.getRaidsForLevel(raidLevel);
        if (availableRaids.isEmpty()) {
            return;
        }
        MutableComponent raidMessage = Component.m_237115_((String)"progression.scguns.raids_can_spawn").m_130940_(ChatFormatting.DARK_GRAY);
        for (int i = 0; i < availableRaids.size(); ++i) {
            RaidConfig.RaidData raid = availableRaids.get(i);
            MutableComponent raidComponent = Component.m_237115_((String)("raid.scguns." + raid.raidId())).m_130940_(ChatFormatting.DARK_RED);
            raidMessage = raidMessage.m_6881_().m_7220_((Component)raidComponent);
            if (i >= availableRaids.size() - 1) continue;
            raidMessage = raidMessage.m_6881_().m_7220_((Component)Component.m_237113_((String)", ").m_130940_(ChatFormatting.DARK_GRAY));
        }
        player.m_213846_((Component)raidMessage);
    }
}

