/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.client.screen.BlueprintScreen;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.C2SMessageClearBlueprintRecipe;

public class BlueprintItem
extends Item {
    public BlueprintItem(Item.Properties properties) {
        this(properties, "");
    }

    public BlueprintItem(Item.Properties properties, String blueprintType) {
        super(properties);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return stack.m_41777_();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (level.f_46443_) {
            if (player.m_6144_()) {
                this.clearBlueprintRecipe(hand);
            } else {
                this.openBlueprintScreen(itemstack, player, hand);
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openBlueprintScreen(ItemStack blueprintStack, Player player, InteractionHand hand) {
        Minecraft.m_91087_().m_91152_((Screen)new BlueprintScreen(blueprintStack, player, hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clearBlueprintRecipe(InteractionHand hand) {
        PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageClearBlueprintRecipe(hand));
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        String activeRecipeName;
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"item.scguns.blueprint.tooltip.right_click").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        if (pLevel != null && pLevel.f_46443_ && (activeRecipeName = BlueprintScreen.getActiveRecipeName(pStack)) != null) {
            pTooltipComponents.add((Component)Component.m_237110_((String)"item.scguns.blueprint.tooltip.active_recipe", (Object[])new Object[]{activeRecipeName}).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.ITALIC}));
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.scguns.blueprint.tooltip.shift_right_click_clear").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
        }
    }
}

