/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.Config;
import top.ribs.scguns.client.GunItemStackRenderer;
import top.ribs.scguns.client.KeyBinds;
import top.ribs.scguns.common.FireMode;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.NetworkGunManager;
import top.ribs.scguns.common.ReloadType;
import top.ribs.scguns.enchantment.EnchantmentTypes;
import top.ribs.scguns.init.ModEnchantments;
import top.ribs.scguns.init.ModItems;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.item.BayonetItem;
import top.ribs.scguns.item.ExtendedBarrelItem;
import top.ribs.scguns.item.IColored;
import top.ribs.scguns.item.IMeta;
import top.ribs.scguns.item.attachment.IAttachment;
import top.ribs.scguns.util.GunEnchantmentHelper;
import top.ribs.scguns.util.GunModifierHelper;

public class GunItem
extends Item
implements IColored,
IMeta {
    private final WeakHashMap<CompoundTag, Gun> modifiedGunCache = new WeakHashMap();
    private Gun gun = new Gun();

    public GunItem(Item.Properties properties) {
        super(properties);
    }

    public void setGun(NetworkGunManager.Supplier supplier) {
        this.gun = supplier.getGun();
    }

    public Gun getGun() {
        return this.gun;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        Gun.WeaponType weaponType;
        MobEffect effect;
        ResourceLocation effectLocation;
        float totalMeleeDamage;
        Gun modifiedGun = this.getModifiedGun(stack);
        ResourceLocation advantage = modifiedGun.getProjectile().getAdvantage();
        float baseDamage = modifiedGun.getProjectile().getDamage();
        baseDamage = GunModifierHelper.getModifiedProjectileDamage(stack, baseDamage);
        baseDamage = GunEnchantmentHelper.getAcceleratorDamage(stack, baseDamage);
        baseDamage = GunEnchantmentHelper.getHeavyShotDamage(stack, baseDamage);
        baseDamage *= ((Double)Config.COMMON.gameplay.globalDamageMultiplier.get()).floatValue();
        Object additionalDamageText = "";
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null && tagCompound.m_128425_("AdditionalDamage", 99)) {
            float additionalDamage = tagCompound.m_128457_("AdditionalDamage");
            if ((additionalDamage += GunModifierHelper.getAdditionalDamage(stack, false)) > 0.0f) {
                additionalDamageText = ChatFormatting.GREEN + " +" + ItemStack.f_41584_.format(additionalDamage);
            } else if (additionalDamage < 0.0f) {
                additionalDamageText = ChatFormatting.RED + " " + ItemStack.f_41584_.format(additionalDamage);
            }
        }
        tooltip.add((Component)Component.m_237115_((String)"info.scguns.damage").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(ItemStack.f_41584_.format(baseDamage) + (String)additionalDamageText)).m_130940_(ChatFormatting.WHITE)));
        float baseArmorPen = modifiedGun.getProjectile().getArmorPen();
        float puncturingPen = GunEnchantmentHelper.getPuncturingArmorBypass(stack);
        float totalArmorPen = baseArmorPen + puncturingPen;
        if (totalArmorPen > 0.0f) {
            String armorPenText = ItemStack.f_41584_.format(totalArmorPen);
            tooltip.add((Component)Component.m_237115_((String)"info.scguns.armor_penetration").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)armorPenText).m_130940_(ChatFormatting.YELLOW)));
        }
        if (!advantage.equals((Object)ModTags.Entities.NONE.f_203868_())) {
            tooltip.add((Component)Component.m_237115_((String)"info.scguns.advantage").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("advantage." + advantage)).m_130940_(ChatFormatting.GOLD)));
        }
        String fireMode = modifiedGun.getGeneral().getFireMode().id().toString();
        tooltip.add((Component)Component.m_237115_((String)"info.scguns.fire_mode").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("fire_mode." + fireMode)).m_130940_(ChatFormatting.WHITE)));
        Item ammo = modifiedGun.getProjectile().getItem();
        Item reloadItem = modifiedGun.getReloads().getReloadItem();
        if (modifiedGun.getReloads().getReloadType() == ReloadType.SINGLE_ITEM) {
            ammo = reloadItem;
        }
        if (ammo != null) {
            tooltip.add((Component)Component.m_237110_((String)"info.scguns.ammo_type", (Object[])new Object[]{Component.m_237115_((String)ammo.m_5524_()).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
        }
        if (tagCompound != null) {
            if (tagCompound.m_128471_("IgnoreAmmo")) {
                tooltip.add((Component)Component.m_237115_((String)"info.scguns.ignore_ammo").m_130940_(ChatFormatting.AQUA));
            } else {
                int ammoCount = tagCompound.m_128451_("AmmoCount");
                tooltip.add((Component)Component.m_237115_((String)"info.scguns.ammo").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(ammoCount + "/" + GunModifierHelper.getModifiedAmmoCapacity(stack, modifiedGun))).m_130940_(ChatFormatting.WHITE)));
            }
        }
        if ((totalMeleeDamage = this.getTotalMeleeDamage(stack)) > 0.0f) {
            String meleeDamageText = (double)totalMeleeDamage % 1.0 == 0.0 ? String.format("%d", (int)totalMeleeDamage) : String.format("%.1f", Float.valueOf(totalMeleeDamage));
            tooltip.add((Component)Component.m_237115_((String)"info.scguns.melee_damage").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)meleeDamageText).m_130940_(ChatFormatting.WHITE)));
        }
        if ((effectLocation = modifiedGun.getProjectile().getImpactEffect()) != null && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
            tooltip.add((Component)Component.m_237115_((String)"info.scguns.impact_effect").m_130940_(ChatFormatting.GRAY).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)effect.m_19481_()).m_130940_(ChatFormatting.BLUE)));
        }
        if ((weaponType = modifiedGun.getGeneral().getWeaponType()) != null) {
            String weaponTypeKey = "desc.scguns." + weaponType.name().toLowerCase();
            tooltip.add((Component)Component.m_237115_((String)"info.scguns.weapon_type").m_130940_(ChatFormatting.GRAY).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)weaponTypeKey).m_130940_(ChatFormatting.AQUA)));
        }
        tooltip.add((Component)Component.m_237110_((String)"info.scguns.attachment_help", (Object[])new Object[]{KeyBinds.KEY_ATTACHMENTS.m_90863_().getString().toUpperCase(Locale.ENGLISH)}).m_130940_(ChatFormatting.YELLOW));
    }

    public float getBayonetAdditionalDamage(ItemStack gunStack) {
        float additionalDamage = 0.0f;
        for (IAttachment.Type type : IAttachment.Type.values()) {
            ItemStack attachmentStack = Gun.getAttachment(type, gunStack);
            if (attachmentStack == null || !(attachmentStack.m_41720_() instanceof BayonetItem)) continue;
            additionalDamage += ((BayonetItem)attachmentStack.m_41720_()).getAdditionalDamage();
        }
        return additionalDamage;
    }

    public float getTotalMeleeDamage(ItemStack stack) {
        Gun gun = this.getModifiedGun(stack);
        float baseMeleeDamage = gun.getGeneral().getMeleeDamage();
        float bayonetDamage = this.getBayonetAdditionalDamage(stack);
        return baseMeleeDamage + bayonetDamage;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public int m_8105_(ItemStack stack) {
        Gun gun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
        return gun.getGeneral().getRate() * 4;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41768_();
    }

    public int m_142158_(ItemStack stack) {
        stack.m_41784_();
        this.getModifiedGun(stack);
        return Math.round(13.0f - (float)stack.m_41773_() * 13.0f / (float)this.getMaxDamage(stack));
    }

    public int m_142159_(ItemStack stack) {
        if (stack.m_41773_() >= stack.m_41776_() - 1) {
            return 0x808080;
        }
        if ((double)stack.m_41773_() >= (double)stack.m_41776_() / 1.5) {
            return Objects.requireNonNull(ChatFormatting.RED.m_126665_());
        }
        float stackMaxDamage = this.getMaxDamage(stack);
        float f = Math.max(0.0f, (stackMaxDamage - (float)stack.m_41773_()) / stackMaxDamage);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public Gun getModifiedGun(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null && tagCompound.m_128425_("Gun", 10)) {
            return this.modifiedGunCache.computeIfAbsent(tagCompound, item -> {
                if (tagCompound.m_128471_("Custom")) {
                    return Gun.create(tagCompound.m_128469_("Gun"));
                }
                Gun gunCopy = this.gun.copy();
                gunCopy.deserializeNBT(tagCompound.m_128469_("Gun"));
                return gunCopy;
            });
        }
        return this.gun;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.f_44672_ == EnchantmentTypes.SEMI_AUTO_GUN) {
            Gun modifiedGun = this.getModifiedGun(stack);
            return modifiedGun.getGeneral().getFireMode() != FireMode.AUTOMATIC;
        }
        if (stack.m_204117_(ModTags.Items.MINING_GUN) && (enchantment == Enchantments.f_44987_ || enchantment == Enchantments.f_44985_)) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getMaxStackSize(stack) == 1;
    }

    public int m_6473_() {
        return 13;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new GunItemStackRenderer();
            }
        });
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public boolean m_6832_(ItemStack pToRepair, ItemStack pRepair) {
        return pRepair.m_150930_((Item)ModItems.REPAIR_KIT.get());
    }

    public ItemStack getAttachment(ItemStack heldItem, IAttachment.Type type) {
        return Gun.getAttachment(type, heldItem);
    }

    public boolean hasBayonet(ItemStack gunStack) {
        if (this.isBuiltInBayonetGun(gunStack)) {
            return true;
        }
        for (IAttachment.Type type : IAttachment.Type.values()) {
            ItemStack attachmentStack = Gun.getAttachment(type, gunStack);
            if (attachmentStack == null || !(attachmentStack.m_41720_() instanceof BayonetItem)) continue;
            return true;
        }
        return false;
    }

    public boolean isBuiltInBayonetGun(ItemStack gunStack) {
        return gunStack.m_204117_(ModTags.Items.BUILT_IN_BAYONET);
    }

    public boolean hasExtendedBarrel(ItemStack gunStack) {
        for (IAttachment.Type type : IAttachment.Type.values()) {
            ItemStack attachmentStack = Gun.getAttachment(type, gunStack);
            if (attachmentStack == null || !(attachmentStack.m_41720_() instanceof ExtendedBarrelItem)) continue;
            return true;
        }
        return false;
    }

    public boolean isOneHandedCarbineCandidate(ItemStack gunStack) {
        return gunStack.m_204117_(ModTags.Items.ONE_HANDED_CARBINE);
    }

    public void onAttachmentChanged(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("AttachmentChanged", true);
    }

    public int getBayonetBanzaiLevel(ItemStack gunStack) {
        for (IAttachment.Type type : IAttachment.Type.values()) {
            Map enchantments;
            ItemStack attachmentStack = Gun.getAttachment(type, gunStack);
            if (attachmentStack == null || !(attachmentStack.m_41720_() instanceof BayonetItem) || !(enchantments = EnchantmentHelper.m_44831_((ItemStack)attachmentStack)).containsKey(ModEnchantments.BANZAI.get())) continue;
            return (Integer)enchantments.get(ModEnchantments.BANZAI.get());
        }
        return 0;
    }

    public Gun getGunProperties() {
        return this.gun;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        if (stack.m_204117_(ModTags.Items.MINING_GUN)) {
            return true;
        }
        return super.isBookEnchantable(stack, book);
    }
}

