/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.mixin.client;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.ribs.scguns.item.GunItem;

@Mixin(value={HumanoidModel.class})
public abstract class MixinHumanoidModel {
    @Shadow
    public ModelPart f_102811_;
    @Shadow
    public ModelPart f_102812_;
    @Shadow
    public ModelPart f_102808_;
    @Shadow
    public boolean f_102817_;

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="TAIL")})
    private void overrideGunPose(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        ItemStack mainHand = mob.m_21205_();
        if (!(mainHand.m_41720_() instanceof GunItem)) {
            return;
        }
        if (entity instanceof Zombie || entity instanceof AbstractIllager) {
            return;
        }
        this.applyGunHoldingPose(mob);
    }

    private void applyGunHoldingPose(Mob mob) {
        HumanoidArm mainArm = mob.m_5737_();
        boolean rightHanded = mainArm == HumanoidArm.RIGHT;
        this.f_102811_.f_104203_ = 0.0f;
        this.f_102811_.f_104204_ = 0.0f;
        this.f_102811_.f_104205_ = 0.0f;
        this.f_102812_.f_104203_ = 0.0f;
        this.f_102812_.f_104204_ = 0.0f;
        this.f_102812_.f_104205_ = 0.0f;
        this.f_102811_.f_104207_ = true;
        this.f_102812_.f_104207_ = true;
        if (mob instanceof AbstractSkeleton) {
            this.applySkeletonGunPose(rightHanded);
        } else if (mob instanceof AbstractPiglin) {
            this.applyPiglinGunPose(rightHanded);
        } else if (mob instanceof Witch) {
            this.applyWitchGunPose(rightHanded);
        } else {
            this.applyDefaultGunPose(rightHanded);
        }
        if (this.f_102817_) {
            this.f_102811_.f_104203_ += 0.4f;
            this.f_102812_.f_104203_ += 0.4f;
        }
    }

    private void applyDefaultGunPose(boolean rightHanded) {
        if (rightHanded) {
            this.f_102811_.f_104203_ = (float)Math.toRadians(-90.0);
            this.f_102811_.f_104204_ = (float)Math.toRadians(-5.0);
            this.f_102811_.f_104205_ = 0.0f;
            this.f_102812_.f_104203_ = (float)Math.toRadians(-85.0);
            this.f_102812_.f_104204_ = (float)Math.toRadians(30.0);
            this.f_102812_.f_104205_ = 0.0f;
        } else {
            this.f_102812_.f_104203_ = (float)Math.toRadians(-90.0);
            this.f_102812_.f_104204_ = (float)Math.toRadians(5.0);
            this.f_102812_.f_104205_ = 0.0f;
            this.f_102811_.f_104203_ = (float)Math.toRadians(-85.0);
            this.f_102811_.f_104204_ = (float)Math.toRadians(-30.0);
            this.f_102811_.f_104205_ = 0.0f;
        }
    }

    private void applySkeletonGunPose(boolean rightHanded) {
        if (rightHanded) {
            this.f_102811_.f_104203_ = (float)Math.toRadians(-90.0);
            this.f_102811_.f_104204_ = (float)Math.toRadians(-8.0);
            this.f_102811_.f_104205_ = 0.0f;
            this.f_102812_.f_104203_ = (float)Math.toRadians(-85.0);
            this.f_102812_.f_104204_ = (float)Math.toRadians(35.0);
            this.f_102812_.f_104205_ = (float)Math.toRadians(-5.0);
        } else {
            this.f_102812_.f_104203_ = (float)Math.toRadians(-90.0);
            this.f_102812_.f_104204_ = (float)Math.toRadians(8.0);
            this.f_102812_.f_104205_ = 0.0f;
            this.f_102811_.f_104203_ = (float)Math.toRadians(-85.0);
            this.f_102811_.f_104204_ = (float)Math.toRadians(-35.0);
            this.f_102811_.f_104205_ = (float)Math.toRadians(5.0);
        }
    }

    private void applyPiglinGunPose(boolean rightHanded) {
        if (rightHanded) {
            this.f_102811_.f_104203_ = (float)Math.toRadians(-90.0);
            this.f_102811_.f_104204_ = (float)Math.toRadians(-5.0);
            this.f_102811_.f_104205_ = 0.0f;
            this.f_102812_.f_104203_ = (float)Math.toRadians(-87.0);
            this.f_102812_.f_104204_ = (float)Math.toRadians(28.0);
            this.f_102812_.f_104205_ = 0.0f;
        } else {
            this.f_102812_.f_104203_ = (float)Math.toRadians(-90.0);
            this.f_102812_.f_104204_ = (float)Math.toRadians(5.0);
            this.f_102812_.f_104205_ = 0.0f;
            this.f_102811_.f_104203_ = (float)Math.toRadians(-87.0);
            this.f_102811_.f_104204_ = (float)Math.toRadians(-28.0);
            this.f_102811_.f_104205_ = 0.0f;
        }
    }

    private void applyWitchGunPose(boolean rightHanded) {
        if (rightHanded) {
            this.f_102811_.f_104203_ = (float)Math.toRadians(-90.0);
            this.f_102811_.f_104204_ = (float)Math.toRadians(-7.0);
            this.f_102811_.f_104205_ = 0.0f;
            this.f_102812_.f_104203_ = (float)Math.toRadians(-85.0);
            this.f_102812_.f_104204_ = (float)Math.toRadians(30.0);
            this.f_102812_.f_104205_ = 0.0f;
        } else {
            this.f_102812_.f_104203_ = (float)Math.toRadians(-90.0);
            this.f_102812_.f_104204_ = (float)Math.toRadians(7.0);
            this.f_102812_.f_104205_ = 0.0f;
            this.f_102811_.f_104203_ = (float)Math.toRadians(-85.0);
            this.f_102811_.f_104204_ = (float)Math.toRadians(-30.0);
            this.f_102811_.f_104205_ = 0.0f;
        }
    }
}

