/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.mixin.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.ribs.scguns.client.handler.AimingHandler;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.item.GunItem;

@Mixin(value={PlayerModel.class})
public class PlayerModelMixin<T extends LivingEntity> {
    @Inject(method={"setupAnim*"}, at={@At(value="TAIL")})
    private void setupAnimTail(T entity, float animationPos, float animationSpeed, float animationBob, float deltaHeadYaw, float headPitch, CallbackInfo ci) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        PlayerModel model = (PlayerModel)this;
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            if (player.m_7578_() && animationPos == 0.0f) {
                model.f_102811_.f_104203_ = 0.0f;
                model.f_102811_.f_104204_ = 0.0f;
                model.f_102811_.f_104205_ = 0.0f;
                model.f_102812_.f_104203_ = 0.0f;
                model.f_102812_.f_104204_ = 0.0f;
                model.f_102812_.f_104205_ = 0.0f;
                PlayerModelMixin.copyModelAngles(model.f_102811_, model.f_103375_);
                PlayerModelMixin.copyModelAngles(model.f_102812_, model.f_103374_);
                return;
            }
            if (player.m_6069_() || player.m_21255_() || player.m_6067_()) {
                this.applySwimmingGunPose(player, model, gunItem, heldItem);
                return;
            }
            Gun gun = gunItem.getModifiedGun(heldItem);
            gun.getGeneral().getGripType(heldItem).heldAnimation().applyPlayerModelRotation(player, model.f_102811_, model.f_102812_, model.f_102808_, InteractionHand.MAIN_HAND, AimingHandler.get().getAimProgress(player, Minecraft.m_91087_().m_91296_()));
            PlayerModelMixin.copyModelAngles(model.f_102811_, model.f_103375_);
            PlayerModelMixin.copyModelAngles(model.f_102812_, model.f_103374_);
            PlayerModelMixin.copyModelAngles(model.f_102808_, model.f_102809_);
        }
    }

    private void applySwimmingGunPose(Player player, PlayerModel<T> model, GunItem gunItem, ItemStack heldItem) {
        float aimProgress = 0.0f;
        if (player.m_7578_()) {
            aimProgress = AimingHandler.get().getAimProgress(player, Minecraft.m_91087_().m_91296_());
        }
        model.f_102811_.f_104203_ = (float)Math.toRadians(-160.0f + aimProgress * 10.0f);
        model.f_102811_.f_104204_ = (float)Math.toRadians(-15.0);
        model.f_102811_.f_104205_ = (float)Math.toRadians(10.0);
        model.f_102812_.f_104203_ = (float)Math.toRadians(-140.0);
        model.f_102812_.f_104204_ = (float)Math.toRadians(20.0);
        model.f_102812_.f_104205_ = (float)Math.toRadians(-15.0);
        PlayerModelMixin.copyModelAngles(model.f_102811_, model.f_103375_);
        PlayerModelMixin.copyModelAngles(model.f_102812_, model.f_103374_);
    }

    private static void copyModelAngles(ModelPart source, ModelPart target) {
        target.f_104203_ = source.f_104203_;
        target.f_104204_ = source.f_104204_;
        target.f_104205_ = source.f_104205_;
    }
}

