/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.client.handler.MeleeAttackHandler;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageMeleeAttack;

public class C2SMessageMeleeAttack
extends PlayMessage<C2SMessageMeleeAttack> {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final int BANZAI_CHECK_INTERVAL_MS = 50;

    public void encode(C2SMessageMeleeAttack message, FriendlyByteBuf buffer) {
    }

    public C2SMessageMeleeAttack decode(FriendlyByteBuf buffer) {
        return new C2SMessageMeleeAttack();
    }

    public void handle(C2SMessageMeleeAttack message, MessageContext context) {
        context.execute(() -> {
            ServerPlayer player = context.getPlayer();
            if (player == null || player.m_5833_()) {
                return;
            }
            if (MeleeAttackHandler.isBanzaiActive()) {
                MeleeAttackHandler.stopBanzai();
            } else if (player.m_20142_()) {
                ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
                Item patt1777$temp = heldItem.m_41720_();
                if (!(patt1777$temp instanceof GunItem)) {
                    return;
                }
                GunItem gunItem = (GunItem)patt1777$temp;
                if (gunItem.hasBayonet(heldItem)) {
                    MeleeAttackHandler.startBanzai(player);
                    scheduler.scheduleAtFixedRate(() -> {
                        if (!MeleeAttackHandler.isBanzaiActive()) {
                            return;
                        }
                        if (player.m_213877_() || !player.m_6084_()) {
                            MeleeAttackHandler.stopBanzai();
                            return;
                        }
                        if (!player.m_20142_()) {
                            MeleeAttackHandler.stopBanzai();
                            return;
                        }
                        MeleeAttackHandler.handleBanzaiMode(player);
                    }, 0L, 50L, TimeUnit.MILLISECONDS);
                } else {
                    MeleeAttackHandler.performNormalMeleeAttack(player);
                }
            } else {
                this.handleNormalMeleeAttack(player);
            }
        });
        context.setHandled(true);
    }

    private void handleNormalMeleeAttack(ServerPlayer player) {
        if (((Boolean)ModSyncedDataKeys.MELEE.getValue((Entity)player)).booleanValue() || player.m_36335_().m_41519_(player.m_21205_().m_41720_())) {
            return;
        }
        ModSyncedDataKeys.MELEE.setValue((Entity)player, (Object)true);
        MeleeAttackHandler.performMeleeAttack(player);
        PacketHandler.getPlayChannel().sendToPlayer(() -> player, (IMessage)new S2CMessageMeleeAttack(player.m_21120_(InteractionHand.MAIN_HAND)));
        scheduler.schedule(() -> ModSyncedDataKeys.MELEE.setValue((Entity)player, (Object)false), 400L, TimeUnit.MILLISECONDS);
    }
}

