/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.cache.HotBarrelCache;

public class S2CMessageHotBarrelSync
extends PlayMessage<S2CMessageHotBarrelSync> {
    private int hotBarrelLevel;
    private String weaponDescriptionId;

    public S2CMessageHotBarrelSync() {
    }

    public S2CMessageHotBarrelSync(int hotBarrelLevel, String weaponDescriptionId) {
        this.hotBarrelLevel = hotBarrelLevel;
        this.weaponDescriptionId = weaponDescriptionId;
    }

    public void encode(S2CMessageHotBarrelSync message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.hotBarrelLevel);
        buffer.m_130070_(message.weaponDescriptionId);
    }

    public S2CMessageHotBarrelSync decode(FriendlyByteBuf buffer) {
        return new S2CMessageHotBarrelSync(buffer.readInt(), buffer.m_130277_());
    }

    public void handle(S2CMessageHotBarrelSync message, MessageContext context) {
        context.execute(() -> {
            ItemStack heldItem;
            ServerPlayer player = context.getPlayer();
            if (player != null && (heldItem = player.m_21205_()).m_41720_().m_5524_().equals(message.weaponDescriptionId)) {
                HotBarrelCache.setHotBarrelLevel((Player)player, heldItem, message.hotBarrelLevel);
            }
        });
        context.setHandled(true);
    }
}

